/*
 * Decompiled with CFR 0.152.
 */
package faye;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.hippo.HippoConfig;
import com.hippo.constant.FuguAppConstant;
import com.hippo.model.FuguFileDetails;
import com.hippo.utils.b;
import com.hippo.utils.e;
import faye.ConnectionError;
import faye.FayeAgentListener;
import faye.FayeClientListener;
import faye.FayeServiceListener;
import faye.MetaMessage;
import faye.WebSocket;
import java.net.Socket;
import java.net.URI;
import java.nio.channels.NotYetConnectedException;
import java.util.Date;
import java.util.HashSet;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.java_websocket.c;
import org.java_websocket.exceptions.WebsocketNotConnectedException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FayeClient
implements FuguAppConstant {
    private static final String LOG_TAG = FayeClient.class.getSimpleName();
    private WebSocket mWebSocket = null;
    private FayeClientListener mConnectionListener = null;
    private FayeServiceListener serviceListener = null;
    private FayeAgentListener mAgentListener = null;
    private HashSet<String> mChannels;
    private String mServerUrl = "";
    private boolean mFayeConnected = false;
    private boolean mIsConnectedServer = false;
    private MetaMessage mMetaMessage;
    private Handler mMessageHandler;

    public FayeClient(String string2, MetaMessage metaMessage) {
        HandlerThread handlerThread = new HandlerThread("FayeHandler");
        handlerThread.start();
        this.mMessageHandler = new Handler(handlerThread.getLooper()){

            public void handleMessage(Message message) {
                super.handleMessage(message);
                switch (message.what) {
                    case 1: {
                        e.a(LOG_TAG, "onOpen() executed");
                        FayeClient.this.mIsConnectedServer = true;
                        FayeClient.this.handShake();
                        break;
                    }
                    case 2: {
                        e.a(LOG_TAG, "onClosed() executed");
                        FayeClient.this.mIsConnectedServer = false;
                        FayeClient.this.mFayeConnected = false;
                        if (FayeClient.this.mAgentListener != null) {
                            FayeClient.this.mAgentListener.onDisconnectedServer(FayeClient.this);
                        }
                        if (FayeClient.this.mConnectionListener == null) break;
                        FayeClient.this.mConnectionListener.onDisconnectedServer(FayeClient.this);
                        break;
                    }
                    case 3: {
                        try {
                            e.a(LOG_TAG, "onMessage executed");
                            FayeClient.this.handleFayeMessage((String)message.obj);
                        }
                        catch (NotYetConnectedException notYetConnectedException) {
                            notYetConnectedException.printStackTrace();
                        }
                        break;
                    }
                    case 5: {
                        if (FayeClient.this.mAgentListener != null) {
                            FayeClient.this.mAgentListener.onPongReceived();
                        }
                        if (FayeClient.this.mConnectionListener == null) break;
                        FayeClient.this.mConnectionListener.onPongReceived();
                        break;
                    }
                    case 6: {
                        if (FayeClient.this.mConnectionListener == null) break;
                        FayeClient.this.mConnectionListener.onNotConnected();
                    }
                }
            }
        };
        this.mServerUrl = string2;
        e.c("TAG", "faye url = " + string2);
        this.mMetaMessage = metaMessage;
        this.mChannels = new HashSet();
    }

    private void sendLocalBroadcast(int n2) {
        block3: {
            try {
                if (HippoConfig.getInstance().getContext() != null) {
                    Intent intent = new Intent("fugu_listener_null");
                    intent.putExtra("status", n2);
                    LocalBroadcastManager.getInstance((Context)HippoConfig.getInstance().getContext()).sendBroadcast(intent);
                }
            }
            catch (Exception exception) {
                if (!HippoConfig.DEBUG) break block3;
                exception.printStackTrace();
            }
        }
    }

    public FayeClientListener getmConnectionListener() {
        return this.mConnectionListener;
    }

    public void setmConnectionListener(FayeClientListener fayeClientListener) {
        this.mConnectionListener = fayeClientListener;
    }

    public FayeServiceListener getServiceListener() {
        return this.serviceListener;
    }

    public void setServiceListener(FayeServiceListener fayeServiceListener) {
        this.serviceListener = fayeServiceListener;
    }

    public FayeAgentListener getAgentListener() {
        return this.mAgentListener;
    }

    public void setAgentListener(FayeAgentListener fayeAgentListener) {
        this.mAgentListener = fayeAgentListener;
    }

    public void addChannel(String string2) {
        this.mChannels.add(string2);
    }

    public HashSet<String> getmChannels() {
        return this.mChannels;
    }

    public boolean isConnectedServer() {
        return this.mIsConnectedServer;
    }

    public boolean isFayeConnected() {
        return this.mFayeConnected;
    }

    public void connectServer() {
        this.openWebSocketConnection();
    }

    public void disconnectServer() {
        for (String string2 : this.mChannels) {
            this.unsubscribe(string2);
        }
        this.mChannels.clear();
        this.disconnect();
    }

    public void subscribeChannel(String string2) {
        this.mChannels.add(string2);
        this.subscribe(string2);
        e.d("channel------>>>>>>>>>>--------------", string2);
    }

    public void subscribeToChannels(String ... stringArray) {
        for (String string2 : stringArray) {
            this.mChannels.add(string2);
            this.subscribe(string2);
        }
    }

    public void unsubscribeChannel(String string2) {
        if (this.mChannels.contains(string2)) {
            this.unsubscribe(string2);
            this.mChannels.remove(string2);
        }
    }

    public void unsubscribeChannels(String ... stringArray) {
        for (String string2 : stringArray) {
            this.unsubscribe(string2);
        }
    }

    public void unsubscribeAll() {
        for (String string2 : this.mChannels) {
            this.unsubscribe(string2);
        }
    }

    public void publish(String string2, int n2, String string3, String string4, FuguFileDetails fuguFileDetails, int n3, String string5, int n4, String string6, Long l2, String string7, Long l3, int n5) {
        JSONObject jSONObject = new JSONObject();
        String string8 = b.a(new Date());
        try {
            if (n3 == 6) {
                jSONObject.put("notification_type", n3);
                jSONObject.put("channel_id", (Object)l3);
            } else {
                jSONObject.put("full_name", (Object)string7);
                jSONObject.put("message", (Object)string2);
                jSONObject.put("message_type", n2);
                jSONObject.put("date_time", (Object)b.a().c(string8));
                if (n4 == 0) {
                    jSONObject.put("message_index", n4);
                } else {
                    jSONObject.put("message_index", n4);
                }
                jSONObject.put("UUID", (Object)string5);
                if (n2 == 10 && !string3.trim().isEmpty() && !string4.trim().isEmpty()) {
                    jSONObject.put("image_url", (Object)string3);
                    jSONObject.put("thumbnail_url", (Object)string4);
                }
                if (n2 == 11 && !string3.trim().isEmpty()) {
                    jSONObject.put("url", (Object)string3);
                    jSONObject.put("file_name", (Object)fuguFileDetails.getFileName());
                    jSONObject.put("file_size", (Object)fuguFileDetails.getFileSize());
                }
                if (n2 == 1) {
                    jSONObject.put("is_typing", n5);
                } else {
                    jSONObject.put("is_typing", 0);
                }
                jSONObject.put("message_status", 4);
            }
            jSONObject.put("user_id", (Object)String.valueOf(l2));
            jSONObject.put("user_type", 1);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        this.publish(string6, jSONObject, null, null);
    }

    public void publish(String string2, JSONObject jSONObject) {
        this.publish(string2, jSONObject, null, null);
    }

    public void publish(String string2, JSONObject jSONObject, String string3, String string4) {
        try {
            e.c("@@@@@@@@", string2 + "%%%%%%%%%%%%%%%%%%%%%%% " + jSONObject);
            String string5 = this.mMetaMessage.publish(string2, jSONObject, string3, string4);
            this.mWebSocket.send(string5);
        }
        catch (Exception exception) {
            e.c(LOG_TAG, "Build publish message to JSON error" + exception);
            this.connectServer();
        }
    }

    public void publish(String string2, JSONObject jSONObject, ConnectionError connectionError) {
        block2: {
            try {
                e.c("@@@@@@@@", "%%%%%%%%%%%%%%%%%%%%%%% " + jSONObject);
                String string3 = this.mMetaMessage.publish(string2, jSONObject, null, null);
                this.mWebSocket.send(string3);
            }
            catch (Exception exception) {
                e.c(LOG_TAG, "Build publish message to JSON error" + exception);
                if (connectionError == null) break block2;
                connectionError.onError(jSONObject);
            }
        }
    }

    private Socket getSSLWebSocket() {
        SSLContext sSLContext = null;
        try {
            sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(null, null, null);
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            return sSLSocketFactory.createSocket();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void openWebSocketConnection() {
        c.b = false;
        if (this.mWebSocket != null) {
            this.mWebSocket.close();
        }
        try {
            URI uRI = new URI(this.mServerUrl);
            this.mWebSocket = new WebSocket(uRI, this.mMessageHandler);
            this.mWebSocket.setConnectionLostTimeout(60);
            e.c("uri.getScheme()", "==" + uRI.getScheme());
            if (uRI.getScheme().equals("https") || uRI.getScheme().equals("wss")) {
                this.mWebSocket.setSocket(this.getSSLWebSocket());
            }
            this.mWebSocket.connect();
        }
        catch (Exception exception) {
            e.c(LOG_TAG, "Server URL error" + exception);
        }
    }

    private void closeWebSocketConnection() {
        if (this.mWebSocket != null) {
            this.mWebSocket.close();
        }
    }

    private void handShake() {
        block2: {
            try {
                String string2 = this.mMetaMessage.handShake();
                this.mWebSocket.send(string2);
            }
            catch (Exception exception) {
                e.c(LOG_TAG, "HandShake message error" + exception);
                if (this.mConnectionListener == null) break block2;
                this.mConnectionListener.onWebSocketError();
            }
        }
    }

    private void subscribe(String string2) {
        try {
            String string3 = this.mMetaMessage.subscribe(string2);
            this.mWebSocket.send(string3);
            System.out.println(string3);
        }
        catch (WebsocketNotConnectedException websocketNotConnectedException) {
            if (this.mConnectionListener != null) {
                this.mConnectionListener.onWebSocketError();
            }
            if (this.mAgentListener != null) {
                this.mAgentListener.onWebSocketError();
            }
            this.mFayeConnected = false;
            websocketNotConnectedException.printStackTrace();
            e.c(LOG_TAG, "Subscribe message error" + websocketNotConnectedException);
        }
        catch (Exception exception) {
            e.c(LOG_TAG, "Subscribe message error" + exception);
        }
    }

    private void unsubscribe(String string2) {
        try {
            String string3 = this.mMetaMessage.unsubscribe(string2);
            this.mWebSocket.send(string3);
            e.a(LOG_TAG, "UnSubscribe:" + string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            e.c(LOG_TAG, "Unsubscribe message error: " + exception);
        }
    }

    private void connect() {
        try {
            String string2 = this.mMetaMessage.connect();
            this.mWebSocket.send(string2);
            this.mWebSocket.setConnectionLostTimeout(10);
        }
        catch (Exception exception) {
            e.c(LOG_TAG, "Connect message error" + exception);
        }
    }

    private void disconnect() {
        try {
            String string2 = this.mMetaMessage.disconnect();
            this.mWebSocket.send(string2);
        }
        catch (Exception exception) {
            e.c(LOG_TAG, "Disconnect message error" + exception);
        }
    }

    public boolean hasSubscribed(String string2) {
        return !this.mChannels.contains(string2);
    }

    private void handleFayeMessage(String string2) {
        e.d("handleFayeMessage", "handleFayeMessage = " + string2);
        JSONArray jSONArray = null;
        try {
            jSONArray = new JSONArray(string2);
        }
        catch (Exception exception) {
            e.c(LOG_TAG, "Unknown message type: " + string2 + exception);
        }
        int n2 = jSONArray.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            JSONObject jSONObject = jSONArray.optJSONObject(i2);
            if (jSONObject == null) continue;
            String string3 = jSONObject.optString("channel");
            boolean bl = jSONObject.optBoolean("successful");
            if (string3.equals("/meta/handshake")) {
                if (bl) {
                    this.mMetaMessage.setClient(jSONObject.optString("clientId"));
                    if (this.mConnectionListener != null) {
                        this.mConnectionListener.onConnectedServer(this);
                    }
                    if (this.serviceListener != null) {
                        this.serviceListener.onConnectedServer(this);
                    }
                    if (this.mAgentListener != null) {
                        this.mAgentListener.onConnectedServer(this);
                    }
                    this.connect();
                } else {
                    e.c(LOG_TAG, "Handshake Error: " + jSONObject.toString());
                }
                return;
            }
            if (string3.equals("/meta/connect")) {
                if (bl) {
                    this.mFayeConnected = true;
                    this.connect();
                } else {
                    String string4 = jSONObject.optString("error", "");
                    if (this.mConnectionListener != null && string4.contains("401:")) {
                        this.mConnectionListener.onSubscriptionError();
                        e.c(LOG_TAG, "Connecting Error with listener: " + jSONObject.toString());
                    } else {
                        e.c(LOG_TAG, "Connecting Error: " + jSONObject.toString());
                    }
                }
                return;
            }
            if (string3.equals("/meta/disconnect")) {
                if (bl) {
                    if (this.mConnectionListener != null) {
                        this.mConnectionListener.onDisconnectedServer(this);
                    }
                    if (this.mAgentListener != null) {
                        this.mAgentListener.onDisconnectedServer(this);
                    }
                    if (this.serviceListener != null) {
                        this.serviceListener.onDisconnectedServer(this);
                    }
                    this.mFayeConnected = false;
                    this.closeWebSocketConnection();
                } else {
                    e.c(LOG_TAG, "Disconnecting Error: " + jSONObject.toString());
                }
                return;
            }
            if (string3.equals("/meta/subscribe")) {
                String string5 = jSONObject.optString("subscription");
                if (bl) {
                    this.mFayeConnected = true;
                    e.a(LOG_TAG, "Subscribed channel " + string5);
                } else {
                    e.c(LOG_TAG, "Subscribing channel " + string5 + " Error: " + jSONObject.toString());
                }
                return;
            }
            if (string3.equals("/meta/unsubscribe")) {
                String string6 = jSONObject.optString("subscription");
                if (bl) {
                    e.a(LOG_TAG, "Unsubscribed channel " + string6);
                } else {
                    e.c(LOG_TAG, "Unsubscribing channel " + string6 + " Error: " + jSONObject.toString());
                }
                return;
            }
            if (this.mChannels.contains(string3)) {
                String string7 = jSONObject.optString("data", null);
                e.c("data", "data in faye = " + string7);
                if (string7 != null) {
                    if (this.mConnectionListener != null) {
                        this.mConnectionListener.onReceivedMessage(this, string7, string3);
                    }
                    if (this.mAgentListener != null) {
                        this.mAgentListener.onReceivedMessage(this, string7, string3);
                    }
                    if (this.serviceListener != null) {
                        this.serviceListener.onReceivedMessage(this, string7, string3);
                    }
                } else {
                    try {
                        if (jSONObject.has("error")) {
                            if (this.serviceListener != null) {
                                this.serviceListener.onErrorReceived(this, jSONObject.getString("error"), string3);
                            }
                            if (this.mConnectionListener != null) {
                                this.mConnectionListener.onErrorReceived(this, jSONObject.getString("error"), string3);
                            }
                        }
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                }
            } else {
                e.c(LOG_TAG, "Cannot handle this message: " + jSONObject.toString());
                String string8 = jSONObject.optString("data", null);
                if (string8 != null) {
                    if (this.mConnectionListener != null) {
                        this.mConnectionListener.onReceivedMessage(this, string8, string3);
                    }
                    if (this.mAgentListener != null) {
                        this.mAgentListener.onReceivedMessage(this, string8, string3);
                    }
                    if (this.serviceListener != null) {
                        this.serviceListener.onReceivedMessage(this, string8, string3);
                    }
                }
                try {
                    if (jSONObject.has("error")) {
                        if (this.serviceListener != null) {
                            this.serviceListener.onErrorReceived(this, jSONObject.getString("error"), string3);
                        }
                        if (this.mConnectionListener != null) {
                            this.mConnectionListener.onErrorReceived(this, jSONObject.getString("error"), string3);
                        }
                    }
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
            return;
        }
    }

    public boolean isOpened() {
        return this.mWebSocket != null && this.mWebSocket.isOpen() && this.mWebSocket.getSocket().isConnected();
    }
}

