/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.showmoretextview;

import android.annotation.TargetApi;
import android.os.Build;
import android.text.TextUtils;
import android.util.SparseBooleanArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class ExpandableTextView
extends LinearLayout
implements View.OnClickListener {
    private static final String c = ExpandableTextView.class.getSimpleName();
    protected TextView a;
    protected View b;
    private boolean d;
    private boolean e;
    private int f;
    private int g;
    private int h;
    private int i;
    private ExpandIndicatorController j;
    private int k;
    private float l;
    private boolean m;
    @IdRes
    private int n;
    @IdRes
    private int o;
    private boolean p;
    private OnExpandStateChangeListener q;
    private SparseBooleanArray r;
    private int s;

    public void setOrientation(int n2) {
        if (0 == n2) {
            throw new IllegalArgumentException("ExpandableTextView only supports Vertical Orientation.");
        }
        super.setOrientation(n2);
    }

    public void onClick(View view) {
        if (this.b.getVisibility() != 0) {
            return;
        }
        this.e = !this.e;
        this.j.changeState(this.e);
        if (this.r != null) {
            this.r.put(this.s, this.e);
        }
        this.m = true;
        a a2 = this.e ? new a((View)this, this.getHeight(), this.f) : new a((View)this, this.getHeight(), this.getHeight() + this.g - this.a.getHeight());
        a2.setFillAfter(true);
        a2.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                ExpandableTextView.b((View)ExpandableTextView.this.a, ExpandableTextView.this.l);
            }

            public void onAnimationEnd(Animation animation) {
                ExpandableTextView.this.clearAnimation();
                ExpandableTextView.this.m = false;
                if (ExpandableTextView.this.q != null) {
                    ExpandableTextView.this.q.onExpandStateChanged(ExpandableTextView.this.a, !ExpandableTextView.this.e);
                }
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.clearAnimation();
        this.startAnimation(a2);
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        return this.m;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.a();
    }

    protected void onMeasure(int n2, int n3) {
        if (this.getVisibility() == 8) {
            super.onMeasure(n2, n3);
            return;
        }
        this.d = false;
        this.b.setVisibility(8);
        this.a.setMaxLines(Integer.MAX_VALUE);
        super.onMeasure(n2, n3);
        if (this.a.getLineCount() <= this.h) {
            return;
        }
        this.g = ExpandableTextView.a(this.a);
        if (this.e) {
            this.a.setMaxLines(this.h);
        }
        this.b.setVisibility(0);
        super.onMeasure(n2, n3);
        if (this.e) {
            this.a.post(new Runnable(){

                @Override
                public void run() {
                    ExpandableTextView.this.i = ExpandableTextView.this.getHeight() - ExpandableTextView.this.a.getHeight();
                }
            });
            this.f = this.getMeasuredHeight();
        }
    }

    public void setOnExpandStateChangeListener(@Nullable OnExpandStateChangeListener onExpandStateChangeListener) {
        this.q = onExpandStateChangeListener;
    }

    public void setText(@Nullable CharSequence charSequence) {
        this.d = true;
        this.a.setText(charSequence);
        this.setVisibility(TextUtils.isEmpty((CharSequence)charSequence) ? 8 : 0);
        this.clearAnimation();
        this.getLayoutParams().height = -2;
        this.requestLayout();
    }

    @Nullable
    public CharSequence getText() {
        if (this.a == null) {
            return "";
        }
        return this.a.getText();
    }

    private void a() {
        this.a = (TextView)this.findViewById(this.n);
        if (this.p) {
            this.a.setOnClickListener((View.OnClickListener)this);
        } else {
            this.a.setOnClickListener(null);
        }
        this.b = this.findViewById(this.o);
        this.j.setView(this.b);
        this.j.changeState(this.e);
        this.b.setOnClickListener((View.OnClickListener)this);
    }

    private static boolean b() {
        return Build.VERSION.SDK_INT >= 11;
    }

    @TargetApi(value=11)
    private static void b(View view, float f2) {
        if (ExpandableTextView.b()) {
            view.setAlpha(f2);
        } else {
            AlphaAnimation alphaAnimation = new AlphaAnimation(f2, f2);
            alphaAnimation.setDuration(0L);
            alphaAnimation.setFillAfter(true);
            view.startAnimation((Animation)alphaAnimation);
        }
    }

    private static int a(@NonNull TextView textView) {
        int n2 = textView.getLayout().getLineTop(textView.getLineCount());
        int n3 = textView.getCompoundPaddingTop() + textView.getCompoundPaddingBottom();
        return n2 + n3;
    }

    static interface ExpandIndicatorController {
        public void changeState(boolean var1);

        public void setView(View var1);
    }

    public static interface OnExpandStateChangeListener {
        public void onExpandStateChanged(TextView var1, boolean var2);
    }

    class a
    extends Animation {
        private final View b;
        private final int c;
        private final int d;

        public a(View view, int n2, int n3) {
            this.b = view;
            this.c = n2;
            this.d = n3;
            this.setDuration(ExpandableTextView.this.k);
        }

        protected void applyTransformation(float f2, Transformation transformation) {
            int n2 = (int)((float)(this.d - this.c) * f2 + (float)this.c);
            ExpandableTextView.this.a.setMaxHeight(n2 - ExpandableTextView.this.i);
            if (Float.compare(ExpandableTextView.this.l, 1.0f) != 0) {
                ExpandableTextView.b((View)ExpandableTextView.this.a, ExpandableTextView.this.l + f2 * (1.0f - ExpandableTextView.this.l));
            }
            this.b.getLayoutParams().height = n2;
            this.b.requestLayout();
        }

        public void initialize(int n2, int n3, int n4, int n5) {
            super.initialize(n2, n3, n4, n5);
        }

        public boolean willChangeBounds() {
            return true;
        }
    }
}

