/*
 * Decompiled with CFR 0.152.
 */
package com.hippo;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.media.AudioAttributes;
import android.media.RingtoneManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.text.Html;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.target.CustomTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.google.gson.Gson;
import com.hippo.CallData;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.activity.CampaignActivity;
import com.hippo.activity.FuguChannelsActivity;
import com.hippo.activity.FuguChatActivity;
import com.hippo.agent.AgentChatActivity;
import com.hippo.agent.AgentListActivity;
import com.hippo.agent.Util.FragmentType;
import com.hippo.agent.model.d.a;
import com.hippo.constant.FuguAppConstant;
import com.hippo.f;
import com.hippo.helper.d;
import com.hippo.model.FuguConversation;
import com.hippo.model.UnreadCountModel;
import com.hippo.service.FuguPushIntentService;
import com.hippo.utils.b;
import com.hippo.utils.e;
import io.paperdb.Paper;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class HippoNotificationConfig
implements FuguAppConstant {
    private static final String TAG = HippoNotificationConfig.class.getSimpleName();
    public static final String CHANNEL_ONE_ID = "com.hippo.ONE";
    public static Long pushChannelId = -1L;
    public static Long pushLabelId = -1L;
    public static Long agentPushChannelId = -1L;
    public static boolean isChannelActivityOnPause = false;
    public static final String CHANNEL_ONE_NAME = "Default notification";
    private boolean notificationSoundEnabled = true;
    private int smallIcon = -1;
    private int largeIcon;
    private int priority;
    private static NotificationManager notificationManager;

    public void setNotificationSoundEnabled(boolean bl) {
        this.notificationSoundEnabled = bl;
    }

    public void setSmallIcon(int n2) {
        this.smallIcon = n2;
    }

    public void setLargeIcon(int n2) {
        this.largeIcon = n2;
    }

    public void setPriority(int n2) {
        this.priority = n2;
    }

    public boolean isHippoNotification(Map<String, String> map) {
        return map.containsKey("push_source") && map.get("push_source").equalsIgnoreCase("FUGU");
    }

    public boolean isHippoCallNotification(Context context, Map<String, String> map) {
        try {
            Paper.init((Context)context);
            JSONObject jSONObject = new JSONObject(map.get("message"));
            try {
                if (this.isCallEnabled(context, jSONObject.optString("call_type")) && jSONObject.optInt("notification_type") == 14 && (jSONObject.optString("video_call_type").equalsIgnoreCase("START_CALL") || jSONObject.optString("video_call_type").equalsIgnoreCase("CALL_HUNG_UP"))) {
                    return true;
                }
                if (jSONObject.optInt("notification_type") == 14) {
                    return false;
                }
                if (jSONObject.optInt("notification_type") == 20) {
                    return true;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    private boolean isCallEnabled(Context context, String string2) {
        Paper.init((Context)context);
        if (string2.equalsIgnoreCase("AUDIO")) {
            if (com.hippo.agent.database.a.c()) {
                return com.hippo.agent.database.a.q();
            }
            return com.hippo.database.a.M();
        }
        if (com.hippo.agent.database.a.c()) {
            return com.hippo.agent.database.a.p();
        }
        return com.hippo.database.a.L();
    }

    public static void handleHippoPushNotification(final Context context, final Bundle bundle) {
        if (bundle == null) {
            return;
        }
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (bundle.containsKey("is_announcement_push") && bundle.getBoolean("is_announcement_push")) {
                    Intent intent = new Intent(context, CampaignActivity.class);
                    context.startActivity(intent);
                } else if (com.hippo.agent.database.a.c()) {
                    a a2 = (a)new Gson().fromJson(bundle.getString("conversation"), a.class);
                    if (a2 != null && HippoConfig.getInstance() != null) {
                        Intent intent = new Intent(context, AgentChatActivity.class);
                        if (a2.j() < 0L) {
                            intent = new Intent(context, AgentListActivity.class);
                        }
                        intent.putExtra("fragment_type", FragmentType.MY_CHAT.getOrdinal());
                        intent.putExtra("conversation", new Gson().toJson((Object)a2, a.class));
                        context.startActivity(intent);
                    }
                } else {
                    FuguConversation fuguConversation = (FuguConversation)new Gson().fromJson(bundle.getString("conversation"), FuguConversation.class);
                    if (fuguConversation != null && fuguConversation.isStartChannelsActivity() && HippoConfig.getInstance() != null) {
                        e.c(TAG, "conversation: " + new Gson().toJson((Object)fuguConversation));
                        Intent intent = new Intent(context, FuguChatActivity.class);
                        if (fuguConversation.getChannelId() < 0L && fuguConversation.getLabelId() < 0L) {
                            intent = new Intent(context, FuguChannelsActivity.class);
                        }
                        intent.putExtra("conversation", new Gson().toJson((Object)fuguConversation, FuguConversation.class));
                        context.startActivity(intent);
                    }
                }
            }
        }, 1000L);
    }

    public static void cancelNotification(Context context, int n2) {
        String string2 = "notification";
        NotificationManager notificationManager = (NotificationManager)context.getSystemService(string2);
        notificationManager.cancel(n2);
    }

    public void showNotification(Context context, Map<String, String> map) {
        try {
            Paper.init((Context)context);
            if (com.hippo.agent.database.a.c()) {
                this.showAgentNotification(context, map);
            } else {
                e.c("showing", "showing push");
                this.showUserNotification(context, map);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void showAgentNotification(Context context, Map<String, String> map) {
        AudioAttributes audioAttributes;
        JSONObject jSONObject;
        e.c(TAG, "Init time: " + new Date());
        try {
            int n7;
            jSONObject = new JSONObject(map.get("message"));
            e.c(TAG, "Push message: " + map.get("message"));
            try {
                if (jSONObject.optInt("notification_type") == 14 && (jSONObject.optString("video_call_type").equalsIgnoreCase("START_CALL") || jSONObject.optString("video_call_type").equalsIgnoreCase("CALL_HUNG_UP"))) {
                    if (HippoConfig.getInstance().getCallData() != null) {
                        HippoConfig.getInstance().getCallData().onNotificationReceived(context, jSONObject);
                    } else {
                        String string2 = new Gson().toJson((Object)jSONObject);
                        Intent intent = new Intent();
                        intent.putExtra("FUGU_CUSTOM_ACTION_PAYLOAD", string2);
                        intent.setAction("hippo_call_notification_data");
                        context.sendBroadcast(intent);
                    }
                    return;
                }
                if (jSONObject.optInt("notification_type") == 14) {
                    return;
                }
                if (jSONObject.optInt("notification_type") == 20) {
                    if (HippoConfig.getInstance().getCallData() != null) {
                        HippoConfig.getInstance().getCallData().onConfNotificationReceived(context, jSONObject);
                    } else {
                        String string3 = new Gson().toJson((Object)jSONObject);
                        Intent intent = new Intent();
                        intent.putExtra("FUGU_CUSTOM_ACTION_PAYLOAD", string3);
                        intent.setAction("hippo_call_notification_data");
                        context.sendBroadcast(intent);
                    }
                    return;
                }
                if (jSONObject.optInt("notification_type") == 23) {
                    new d().a(context, jSONObject, this.smallIcon == -1 ? R.drawable.hippo_default_notif_icon : this.smallIcon);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            audioAttributes = new Intent("notification_received");
            Bundle bundle = new Bundle();
            for (String object2 : map.keySet()) {
                bundle.putString(object2, map.get(object2));
            }
            audioAttributes.putExtras(bundle);
            LocalBroadcastManager.getInstance((Context)context).sendBroadcast((Intent)audioAttributes);
            int n3 = jSONObject.optInt("disable_reply", 0);
            Long l2 = jSONObject.optLong("channel_id", -1L);
            String string2 = jSONObject.optString("label", "");
            int n2 = jSONObject.optInt("channel_type", 0);
            if (l2 > 0L && agentPushChannelId.compareTo(l2) == 0 && !isChannelActivityOnPause) {
                return;
            }
            Intent intent = new Intent(context, FuguPushIntentService.class);
            intent.putExtra("channelId", (Serializable)l2);
            intent.putExtra("label", string2);
            intent.putExtra("userId", (Serializable)com.hippo.agent.database.a.b().e());
            intent.putExtra("is_from_push", true);
            intent.putExtra("disable_reply", n3);
            intent.putExtra("channel_type", n2);
            Bundle bundle2 = new Bundle();
            for (String n5 : map.keySet()) {
                bundle2.putString(n5, map.get(n5));
            }
            intent.putExtra("data", bundle2);
            if (com.hippo.database.a.c() != -1) {
                intent.setFlags(com.hippo.database.a.c());
            }
            PendingIntent pendingIntent = PendingIntent.getService((Context)context, (int)l2.intValue(), (Intent)intent, (int)0);
            int n4 = -1;
            if (!this.notificationSoundEnabled) {
                n4 = 4;
            }
            String string3 = jSONObject.optString("date_time", "");
            String string4 = "com.hippo.ONE." + l2;
            String string5 = CHANNEL_ONE_NAME + l2;
            NotificationCompat.Builder builder = new NotificationCompat.Builder(context, string4);
            builder.setAutoCancel(true);
            builder.setContentTitle((CharSequence)jSONObject.getString("title"));
            builder.setContentIntent(pendingIntent);
            builder.setDefaults(1);
            builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)Html.fromHtml((String)jSONObject.getString("new_message"))));
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                builder.setWhen(HippoNotificationConfig.getTimeMilliSec(b.a().a(string3)));
            }
            builder.setSmallIcon(this.smallIcon == -1 ? R.drawable.hippo_default_notif_icon : this.smallIcon);
            builder.setLargeIcon(BitmapFactory.decodeResource((Resources)context.getResources(), (int)this.largeIcon));
            builder.setContentText((CharSequence)Html.fromHtml((String)jSONObject.getString("new_message")));
            builder.setPriority(this.getPriority());
            builder.setAutoCancel(true);
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            if (Build.VERSION.SDK_INT >= 26) {
                int notification = 4;
                NotificationChannel n22 = new NotificationChannel(string4, (CharSequence)string5, notification);
                n22.enableLights(true);
                n22.setLightColor(-65536);
                n22.enableVibration(true);
                n22.setVibrationPattern(new long[]{100L, 200L, 300L, 400L, 500L, 400L, 300L, 200L, 400L});
                assert (notificationManager != null);
                builder.setChannelId(string4);
                notificationManager.createNotificationChannel(n22);
            }
            Notification notification = builder.build();
            if (Build.VERSION.SDK_INT >= 21 && (n7 = context.getResources().getIdentifier("right_icon", "id", "android")) != 0) {
                if (notification.headsUpContentView != null) {
                    notification.headsUpContentView.setViewVisibility(n7, 4);
                }
                if (notification.bigContentView != null) {
                    notification.bigContentView.setViewVisibility(n7, 4);
                }
            }
            notificationManager = (NotificationManager)context.getSystemService("notification");
            int n5 = (int)System.currentTimeMillis();
            notificationManager.notify(n5, notification);
            com.hippo.agent.database.a.a(l2, (Integer)n5);
            try {
                if (l2 != 0L && agentPushChannelId != l2) {
                    if (!TextUtils.isEmpty((CharSequence)jSONObject.optString("user_unique_key", ""))) {
                        f.a().pushUpdateCount(jSONObject.optString("user_unique_key", ""), true);
                    }
                    if (HippoConfig.getInstance() != null && !HippoConfig.getInstance().isChannelActivity()) {
                        f.a().addTotalPushUnread(jSONObject.getInt("channel_id"));
                    }
                }
            }
            catch (Exception exception) {}
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (Build.VERSION.SDK_INT >= 26) {
            jSONObject = new NotificationChannel(CHANNEL_ONE_ID, (CharSequence)CHANNEL_ONE_NAME, 4);
            audioAttributes = new AudioAttributes.Builder().setContentType(4).setUsage(4).build();
            jSONObject.setSound(RingtoneManager.getDefaultUri((int)2), audioAttributes);
            if (notificationManager != null) {
                notificationManager.createNotificationChannel((NotificationChannel)jSONObject);
            }
        }
        e.c(TAG, "Creation at: " + new Date());
    }

    private int getPriority() {
        if (Build.VERSION.SDK_INT >= 24) {
            return 5;
        }
        return 2;
    }

    private void showUserNotification(Context context, Map<String, String> map) throws Exception {
        block36: {
            com.hippo.database.a.b(true);
            if (com.hippo.database.a.d() != null && com.hippo.database.a.d().size() <= 0) {
                com.hippo.database.a.c(true);
            }
            try {
                int n2;
                Bundle bundle;
                Intent intent;
                JSONObject jSONObject = new JSONObject(map.get("message"));
                try {
                    if (com.hippo.database.a.L() && jSONObject.optInt("notification_type") == 14 && (jSONObject.optString("video_call_type").equalsIgnoreCase("START_CALL") || jSONObject.optString("video_call_type").equalsIgnoreCase("CALL_HUNG_UP"))) {
                        if (HippoConfig.getInstance().getCallData() != null) {
                            HippoConfig.getInstance().getCallData().onNotificationReceived(context, jSONObject);
                        } else {
                            HippoConfig.getInstance().setCallListener(new CallData(){

                                @Override
                                public void onNotificationReceived(Context context, JSONObject jSONObject) {
                                }

                                @Override
                                public void onConfNotificationReceived(Context context, JSONObject jSONObject) {
                                }

                                @Override
                                public void networkStatus(int n2) {
                                }

                                @Override
                                public void onCallClick(Context context, int n2, Long l2, Long l3, boolean bl, boolean bl2, String string2, String string3, String string4) {
                                }

                                @Override
                                public void onExternalClick(Context context, String string2, Long l2, String string3, String string4, String string5, String string6) {
                                }
                            });
                        }
                        return;
                    }
                    if (jSONObject.optInt("notification_type") == 14) {
                        return;
                    }
                    if (jSONObject.optInt("notification_type") == 20) {
                        if (HippoConfig.getInstance().getCallData() != null) {
                            HippoConfig.getInstance().getCallData().onConfNotificationReceived(context, jSONObject);
                        }
                        return;
                    }
                    if (jSONObject.optInt("notification_type") == 23) {
                        new d().a(context, jSONObject, this.smallIcon == -1 ? R.drawable.hippo_default_notif_icon : this.smallIcon);
                        return;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (Build.VERSION.SDK_INT >= 26) {
                    intent = new NotificationChannel(CHANNEL_ONE_ID, (CharSequence)CHANNEL_ONE_NAME, 4);
                    bundle = new AudioAttributes.Builder().setContentType(4).setUsage(4).build();
                    intent.setSound(RingtoneManager.getDefaultUri((int)2), (AudioAttributes)bundle);
                    if (notificationManager != null) {
                        notificationManager.createNotificationChannel((NotificationChannel)intent);
                    }
                }
                intent = new Intent("notification_received");
                bundle = new Bundle();
                for (String string2 : map.keySet()) {
                    bundle.putString(string2, map.get(string2));
                }
                intent.putExtras(bundle);
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
                Paper.init((Context)context);
                if (jSONObject.has("is_announcement_push") && jSONObject.optInt("is_announcement_push", 0) == 1) {
                    String string32;
                    String string2;
                    String string4 = jSONObject.optString("title", "");
                    string2 = jSONObject.optString("new_message", "");
                    int n3 = jSONObject.optInt("disable_reply", 0);
                    String string5 = string2.replaceAll("<", "&lt;");
                    String string6 = string5.replaceAll(">", "&gt;");
                    String string7 = string6.replaceAll("\"", "&quot;");
                    string2 = string7.replaceAll("'", "&#39;");
                    String string8 = jSONObject.optString("deep_link", "app://settings");
                    Intent intent2 = new Intent(context, FuguPushIntentService.class);
                    intent2.putExtra("is_announcement_push", true);
                    intent2.putExtra("deeplink", string8);
                    Bundle bundle2 = new Bundle();
                    for (String string32 : map.keySet()) {
                        bundle2.putString(string32, map.get(string32));
                    }
                    intent2.putExtra("data", bundle2);
                    if (com.hippo.database.a.c() != -1) {
                        intent2.setFlags(com.hippo.database.a.c());
                    }
                    PendingIntent pendingIntent = PendingIntent.getService((Context)context, (int)((int)(new Date().getTime() / 1000L % Integer.MAX_VALUE)), (Intent)intent2, (int)0);
                    string32 = "";
                    try {
                        string32 = jSONObject.optJSONObject("custom_attributes").optJSONObject("image").optString("image_url", "");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!TextUtils.isEmpty((CharSequence)string32)) {
                        this.bigImageNotifAsync(context, string4, string2, string32, pendingIntent);
                    } else {
                        this.showPromotionalPush(context, string4, string2, pendingIntent, null);
                    }
                    break block36;
                }
                long l2 = -1L;
                long l3 = -1L;
                int n4 = jSONObject.optInt("disable_reply", 0);
                String string9 = jSONObject.optString("label", "");
                String string10 = jSONObject.optString("title", "");
                String string11 = jSONObject.optString("new_message", "");
                int n5 = jSONObject.optInt("channel_type", 0);
                String string12 = string11.replaceAll("<", "&lt;");
                String string13 = string12.replaceAll(">", "&gt;");
                String string14 = string13.replaceAll("\"", "&quot;");
                string11 = string14.replaceAll("'", "&#39;");
                if (jSONObject.has("channel_id") && n5 != 6) {
                    l2 = jSONObject.optLong("channel_id", -1L);
                }
                if (jSONObject.has("label_id")) {
                    l3 = jSONObject.optLong("label_id", -1L);
                }
                if (pushChannelId != null && l2 > 0L && pushChannelId.compareTo(l2) == 0) {
                    return;
                }
                if (pushLabelId != null && l3 > 0L && pushLabelId.compareTo(l3) == 0) {
                    return;
                }
                Intent intent3 = new Intent(context, FuguPushIntentService.class);
                intent3.putExtra("channelId", l2);
                intent3.putExtra("en_user_id", com.hippo.database.a.e().getData().getEn_user_id());
                intent3.putExtra("userId", (Serializable)com.hippo.database.a.e().getData().getUserId());
                intent3.putExtra("labelId", l3);
                intent3.putExtra("label", string9);
                intent3.putExtra("disable_reply", n4);
                Bundle bundle3 = new Bundle();
                for (String string15 : map.keySet()) {
                    bundle3.putString(string15, map.get(string15));
                }
                intent3.putExtra("data", bundle3);
                if (com.hippo.database.a.c() != -1) {
                    intent3.setFlags(com.hippo.database.a.c());
                }
                PendingIntent pendingIntent = PendingIntent.getService((Context)context, (int)((int)(new Date().getTime() / 1000L % Integer.MAX_VALUE)), (Intent)intent3, (int)0);
                int n6 = -1;
                if (!this.notificationSoundEnabled) {
                    n6 = 4;
                }
                NotificationCompat.Builder builder = new NotificationCompat.Builder(context, CHANNEL_ONE_ID).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)Html.fromHtml((String)string11))).setSmallIcon(this.smallIcon == -1 ? R.drawable.hippo_default_notif_icon : this.smallIcon).setLargeIcon(BitmapFactory.decodeResource((Resources)context.getResources(), (int)this.largeIcon)).setContentTitle((CharSequence)string10).setContentText((CharSequence)Html.fromHtml((String)string11)).setContentIntent(pendingIntent).setPriority(this.priority).setAutoCancel(true);
                builder.setDefaults(n6);
                builder.setChannelId(CHANNEL_ONE_ID);
                Notification notification = builder.build();
                if (Build.VERSION.SDK_INT >= 21 && (n2 = context.getResources().getIdentifier("right_icon", "id", "android")) != 0) {
                    if (notification.headsUpContentView != null) {
                        notification.headsUpContentView.setViewVisibility(n2, 4);
                    }
                    if (notification.bigContentView != null) {
                        notification.bigContentView.setViewVisibility(n2, 4);
                    }
                }
                notificationManager = (NotificationManager)context.getSystemService("notification");
                notificationManager.notify((int)(new Date().getTime() / 1000L % Integer.MAX_VALUE), notification);
                try {
                    if (HippoConfig.getInstance() == null || HippoConfig.getInstance().isChannelActivity() || (!jSONObject.has("channel_id") || pushChannelId.compareTo(jSONObject.getLong("channel_id")) == 0) && (!jSONObject.has("label_id") || pushLabelId.compareTo(jSONObject.getLong("label_id")) == 0)) break block36;
                    try {
                        long l4 = l2;
                        long l5 = l3;
                        this.addUnreadCount(l4, l5);
                    }
                    catch (Exception exception) {
                    }
                }
                catch (Exception exception) {}
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
    }

    private void addUnreadCount(Long l2, Long l3) {
        try {
            e.c(TAG, "In count");
            if (HippoConfig.getInstance().getCallbackListener() == null) {
                return;
            }
            if (!HippoConfig.getInstance().isChannelActivity()) {
                int n2;
                ArrayList<UnreadCountModel> arrayList;
                int n3;
                int n4 = -1;
                if (l2 > 0L) {
                    n4 = com.hippo.database.a.r().indexOf(new UnreadCountModel(l2));
                } else if (l3 > 0L && com.hippo.database.a.r() != null) {
                    ArrayList<UnreadCountModel> arrayList2 = com.hippo.database.a.r();
                    for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                        if (arrayList2.get(n3).getLabelId().compareTo(l3) != 0) continue;
                        n4 = n3;
                        break;
                    }
                }
                e.d(TAG, "index = " + n4);
                if (n4 > -1) {
                    arrayList = com.hippo.database.a.r();
                    e.d(TAG, "unreadCountModels = " + arrayList.size());
                    e.d(TAG, "unreadCountModels.get(index).getCount() = " + arrayList.get(n4).getCount());
                    n2 = arrayList.get(n4).getCount() + 1;
                    e.d(TAG, "channelCount = " + n2);
                    arrayList.get(n4).setCount(n2);
                    com.hippo.database.a.a(new ArrayList<UnreadCountModel>());
                    com.hippo.database.a.a(arrayList);
                } else {
                    n2 = 1;
                    UnreadCountModel unreadCountModel = new UnreadCountModel(l2, l3, n2);
                    arrayList = com.hippo.database.a.r();
                    e.d(TAG, "unreadCountModels = " + arrayList.size());
                    arrayList.add(unreadCountModel);
                    com.hippo.database.a.a(arrayList);
                }
                n2 = 0;
                for (n3 = 0; n3 < arrayList.size(); ++n3) {
                    n2 += arrayList.get(n3).getCount();
                }
                e.d(TAG, "count = " + n2);
                if (HippoConfig.getInstance().getCallbackListener() != null) {
                    HippoConfig.getInstance().getCallbackListener().count(n2);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void clearNotifications(Context context, ArrayList<Integer> arrayList) {
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        if (arrayList != null && arrayList.size() > 0) {
            for (Integer n2 : arrayList) {
                notificationManager.cancel(n2.intValue());
            }
        }
    }

    public static long getTimeMilliSec(String string2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        try {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                Date date = simpleDateFormat.parse(string2);
                return date.getTime();
            }
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        return 0L;
    }

    private void bigImageNotifAsync(final Context context, final String string2, final String string3, String string4, final PendingIntent pendingIntent) {
        try {
            Glide.with((Context)context).asBitmap().load(string4).into((Target)new CustomTarget<Bitmap>(){

                public void a(@NonNull Bitmap bitmap, @Nullable Transition<? super Bitmap> transition) {
                    HippoNotificationConfig.this.showPromotionalPush(context, string2, string3, pendingIntent, bitmap);
                }

                public void onLoadCleared(@Nullable Drawable drawable2) {
                    HippoNotificationConfig.this.showPromotionalPush(context, string2, string3, pendingIntent, null);
                }

                public /* synthetic */ void onResourceReady(@NonNull Object object, @Nullable Transition transition) {
                    this.a((Bitmap)object, (Transition<? super Bitmap>)transition);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void showPromotionalPush(Context context, String string2, String string3, PendingIntent pendingIntent, Bitmap bitmap) {
        int n2;
        int n3 = -1;
        if (!this.notificationSoundEnabled) {
            n3 = 4;
        }
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context, CHANNEL_ONE_ID).setSmallIcon(this.smallIcon == -1 ? R.drawable.hippo_default_notif_icon : this.smallIcon).setLargeIcon(BitmapFactory.decodeResource((Resources)context.getResources(), (int)this.largeIcon)).setContentTitle((CharSequence)string2).setContentText((CharSequence)Html.fromHtml((String)string3)).setContentIntent(pendingIntent).setPriority(this.priority).setAutoCancel(true);
        if (bitmap == null) {
            builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)Html.fromHtml((String)string3)));
        } else {
            builder.setLargeIcon(bitmap);
            builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigPictureStyle().bigPicture(bitmap).bigLargeIcon(null).setBigContentTitle((CharSequence)string2).setSummaryText((CharSequence)string3));
        }
        builder.setDefaults(n3);
        builder.setChannelId(CHANNEL_ONE_ID);
        Notification notification = builder.build();
        if (Build.VERSION.SDK_INT >= 21 && (n2 = context.getResources().getIdentifier("right_icon", "id", "android")) != 0) {
            if (notification.headsUpContentView != null) {
                notification.headsUpContentView.setViewVisibility(n2, 4);
            }
            if (notification.bigContentView != null) {
                notification.bigContentView.setViewVisibility(n2, 4);
            }
        }
        notificationManager = (NotificationManager)context.getSystemService("notification");
        notificationManager.notify((int)(new Date().getTime() / 1000L % Integer.MAX_VALUE), notification);
    }
}

