package com.hippo;

/**
 * Created by gurmail on 2020-03-09.
 *
 * @author gurmail
 */
public class AdditionalInfo {

    private boolean hasChannelPager;
    private String emptyChannelList;
    private boolean hasCreateNewChat;
    private String createChatBtnText;
    private boolean hasLogout;
    // for to send message if view gone in the chat screen
    private boolean canSubscribeChannel;

    public boolean isHasChannelPager() {
        return hasChannelPager;
    }

    public String getEmptyChannelList() {
        return emptyChannelList;
    }

    public boolean isHasCreateNewChat() {
        return hasCreateNewChat;
    }

    public String getCreateChatBtnText() {
        return createChatBtnText;
    }

    public boolean canSubscribeChannel() {
        return canSubscribeChannel;
    }

    public boolean hasLogoutBtn() {
        return hasLogout;
    }

    public static class Builder {

        private AdditionalInfo additionalInfo = new AdditionalInfo();

        public Builder hasChannelPager(boolean hasChannelPager) {
            additionalInfo.hasChannelPager = hasChannelPager;
            return this;
        }

        public Builder hasLogout(boolean hasLogout) {
            additionalInfo.hasLogout = hasLogout;
            return this;
        }

        public Builder setEmptyChannelList(String emptyChannelList) {
            additionalInfo.emptyChannelList = emptyChannelList;
            return this;
        }

        public Builder hasCreateNewChat(boolean hasCreateNewChat) {
            additionalInfo.hasCreateNewChat = hasCreateNewChat;
            return this;
        }

        public Builder setCreateChatBtnText(String createChatBtnText) {
            additionalInfo.createChatBtnText = createChatBtnText;
            return this;
        }

        public Builder canSubscribeChannel(boolean canSubscribeChannel) {
            additionalInfo.canSubscribeChannel = canSubscribeChannel;
            return this;
        }

        public AdditionalInfo build() {
            return additionalInfo;
        }
    }
}
