/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.drafts;

import java.math.BigInteger;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.TimeZone;
import org.java_websocket.WebSocket;
import org.java_websocket.c;
import org.java_websocket.c.h;
import org.java_websocket.c.i;
import org.java_websocket.d.b;
import org.java_websocket.drafts.Draft;
import org.java_websocket.exceptions.IncompleteException;
import org.java_websocket.exceptions.InvalidDataException;
import org.java_websocket.exceptions.InvalidFrameException;
import org.java_websocket.exceptions.InvalidHandshakeException;
import org.java_websocket.exceptions.LimitExedeedException;
import org.java_websocket.exceptions.NotSendableException;
import org.java_websocket.framing.Framedata;
import org.java_websocket.framing.f;

public class a
extends Draft {
    private org.java_websocket.b.b f = new org.java_websocket.b.a();
    private List<org.java_websocket.b.b> g;
    private org.java_websocket.d.a h;
    private List<org.java_websocket.d.a> i;
    private Framedata j;
    private List<ByteBuffer> k;
    private ByteBuffer l;
    private final Random m = new Random();

    public a() {
        this(Collections.emptyList());
    }

    public a(List<org.java_websocket.b.b> list) {
        this(list, Collections.singletonList(new b("")));
    }

    public a(List<org.java_websocket.b.b> list, List<org.java_websocket.d.a> list2) {
        if (list == null || list2 == null) {
            throw new IllegalArgumentException();
        }
        this.g = new ArrayList<org.java_websocket.b.b>(list.size());
        this.i = new ArrayList<org.java_websocket.d.a>(list2.size());
        boolean bl = false;
        this.k = new ArrayList<ByteBuffer>();
        for (org.java_websocket.b.b b2 : list) {
            if (!b2.getClass().equals(org.java_websocket.b.a.class)) continue;
            bl = true;
        }
        this.g.addAll(list);
        if (!bl) {
            this.g.add(this.g.size(), this.f);
        }
        this.i.addAll(list2);
    }

    @Override
    public Draft.HandshakeState a(org.java_websocket.c.a a2) throws InvalidHandshakeException {
        int n2 = this.b(a2);
        if (n2 != 13) {
            org.java_websocket.drafts.a.a("acceptHandshakeAsServer - Wrong websocket version.");
            return Draft.HandshakeState.NOT_MATCHED;
        }
        Draft.HandshakeState handshakeState = Draft.HandshakeState.NOT_MATCHED;
        String string = a2.b("Sec-WebSocket-Extensions");
        for (org.java_websocket.b.b object2 : this.g) {
            if (!object2.a(string)) continue;
            this.f = object2;
            handshakeState = Draft.HandshakeState.MATCHED;
            org.java_websocket.drafts.a.a("acceptHandshakeAsServer - Matching extension found: " + this.f.toString());
            break;
        }
        Object object3 = Draft.HandshakeState.NOT_MATCHED;
        String string2 = a2.b("Sec-WebSocket-Protocol");
        for (org.java_websocket.d.a a3 : this.i) {
            if (!a3.a(string2)) continue;
            this.h = a3;
            object3 = Draft.HandshakeState.MATCHED;
            org.java_websocket.drafts.a.a("acceptHandshakeAsServer - Matching protocol found: " + this.h.toString());
            break;
        }
        if (object3 == Draft.HandshakeState.MATCHED && handshakeState == Draft.HandshakeState.MATCHED) {
            return Draft.HandshakeState.MATCHED;
        }
        org.java_websocket.drafts.a.a("acceptHandshakeAsServer - No matching extension or protocol found.");
        return Draft.HandshakeState.NOT_MATCHED;
    }

    @Override
    public Draft.HandshakeState a(org.java_websocket.c.a a2, h h2) throws InvalidHandshakeException {
        if (!this.a(h2)) {
            org.java_websocket.drafts.a.a("acceptHandshakeAsClient - Missing/wrong upgrade or connection in handshake.");
            return Draft.HandshakeState.NOT_MATCHED;
        }
        if (!a2.c("Sec-WebSocket-Key") || !h2.c("Sec-WebSocket-Accept")) {
            org.java_websocket.drafts.a.a("acceptHandshakeAsClient - Missing Sec-WebSocket-Key or Sec-WebSocket-Accept");
            return Draft.HandshakeState.NOT_MATCHED;
        }
        String string = h2.b("Sec-WebSocket-Accept");
        String string2 = a2.b("Sec-WebSocket-Key");
        if (!(string2 = this.a(string2)).equals(string)) {
            org.java_websocket.drafts.a.a("acceptHandshakeAsClient - Wrong key for Sec-WebSocket-Key.");
            return Draft.HandshakeState.NOT_MATCHED;
        }
        Draft.HandshakeState handshakeState = Draft.HandshakeState.NOT_MATCHED;
        String string3 = h2.b("Sec-WebSocket-Extensions");
        for (org.java_websocket.b.b object2 : this.g) {
            if (!object2.b(string3)) continue;
            this.f = object2;
            handshakeState = Draft.HandshakeState.MATCHED;
            org.java_websocket.drafts.a.a("acceptHandshakeAsClient - Matching extension found: " + this.f.toString());
            break;
        }
        Object object3 = Draft.HandshakeState.NOT_MATCHED;
        String string4 = h2.b("Sec-WebSocket-Protocol");
        for (org.java_websocket.d.a a3 : this.i) {
            if (!a3.a(string4)) continue;
            this.h = a3;
            object3 = Draft.HandshakeState.MATCHED;
            org.java_websocket.drafts.a.a("acceptHandshakeAsClient - Matching protocol found: " + this.h.toString());
            break;
        }
        if (object3 == Draft.HandshakeState.MATCHED && handshakeState == Draft.HandshakeState.MATCHED) {
            return Draft.HandshakeState.MATCHED;
        }
        org.java_websocket.drafts.a.a("acceptHandshakeAsClient - No matching extension or protocol found.");
        return Draft.HandshakeState.NOT_MATCHED;
    }

    public org.java_websocket.b.b d() {
        return this.f;
    }

    public List<org.java_websocket.b.b> e() {
        return this.g;
    }

    public org.java_websocket.d.a f() {
        return this.h;
    }

    public List<org.java_websocket.d.a> g() {
        return this.i;
    }

    @Override
    public org.java_websocket.c.b a(org.java_websocket.c.b b2) {
        b2.a("Upgrade", "websocket");
        b2.a("Connection", "Upgrade");
        byte[] byArray = new byte[16];
        this.m.nextBytes(byArray);
        b2.a("Sec-WebSocket-Key", org.java_websocket.e.a.a(byArray));
        b2.a("Sec-WebSocket-Version", "13");
        StringBuilder stringBuilder = new StringBuilder();
        for (org.java_websocket.b.b object : this.g) {
            if (object.a() == null || object.a().length() == 0) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(object.a());
        }
        if (stringBuilder.length() != 0) {
            b2.a("Sec-WebSocket-Extensions", stringBuilder.toString());
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        for (org.java_websocket.d.a a2 : this.i) {
            if (a2.a().length() == 0) continue;
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append(", ");
            }
            stringBuilder2.append(a2.a());
        }
        if (stringBuilder2.length() != 0) {
            b2.a("Sec-WebSocket-Protocol", stringBuilder2.toString());
        }
        return b2;
    }

    @Override
    public org.java_websocket.c.c a(org.java_websocket.c.a a2, i i2) throws InvalidHandshakeException {
        i2.a("Upgrade", "websocket");
        i2.a("Connection", a2.b("Connection"));
        String string = a2.b("Sec-WebSocket-Key");
        if (string == null) {
            throw new InvalidHandshakeException("missing Sec-WebSocket-Key");
        }
        i2.a("Sec-WebSocket-Accept", this.a(string));
        if (this.d().b().length() != 0) {
            i2.a("Sec-WebSocket-Extensions", this.d().b());
        }
        if (this.f() != null && this.f().a().length() != 0) {
            i2.a("Sec-WebSocket-Protocol", this.f().a());
        }
        i2.a("Web Socket Protocol Handshake");
        i2.a("Server", "TooTallNate Java-WebSocket");
        i2.a("Date", this.h());
        return i2;
    }

    @Override
    public Draft c() {
        ArrayList<org.java_websocket.b.b> arrayList = new ArrayList<org.java_websocket.b.b>();
        for (org.java_websocket.b.b object : this.e()) {
            arrayList.add(object.c());
        }
        ArrayList arrayList2 = new ArrayList();
        for (org.java_websocket.d.a a2 : this.g()) {
            arrayList2.add(a2.b());
        }
        return new a(arrayList, arrayList2);
    }

    @Override
    public ByteBuffer a(Framedata framedata) {
        this.d().b(framedata);
        if (org.java_websocket.c.b) {
            System.out.println("afterEnconding(" + framedata.d().remaining() + "): {" + (framedata.d().remaining() > 1000 ? "too big to display" : new String(framedata.d().array())) + '}');
        }
        return this.b(framedata);
    }

    private ByteBuffer b(Framedata framedata) {
        boolean bl;
        ByteBuffer byteBuffer = framedata.d();
        boolean bl2 = bl = this.c == WebSocket.Role.CLIENT;
        int n2 = byteBuffer.remaining() <= 125 ? 1 : (byteBuffer.remaining() <= 65535 ? 2 : 8);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(1 + (n2 > 1 ? n2 + 1 : n2) + (bl ? 4 : 0) + byteBuffer.remaining());
        byte by = this.a(framedata.i());
        byte by2 = (byte)(framedata.e() ? -128 : 0);
        by2 = (byte)(by2 | by);
        byteBuffer2.put(by2);
        byte[] byArray = this.a(byteBuffer.remaining(), n2);
        assert (byArray.length == n2);
        if (n2 == 1) {
            byteBuffer2.put((byte)(byArray[0] | (bl ? -128 : 0)));
        } else if (n2 == 2) {
            byteBuffer2.put((byte)(0x7E | (bl ? -128 : 0)));
            byteBuffer2.put(byArray);
        } else if (n2 == 8) {
            byteBuffer2.put((byte)(0x7F | (bl ? -128 : 0)));
            byteBuffer2.put(byArray);
        } else {
            throw new RuntimeException("Size representation not supported/specified");
        }
        if (bl) {
            ByteBuffer byteBuffer3 = ByteBuffer.allocate(4);
            byteBuffer3.putInt(this.m.nextInt());
            byteBuffer2.put(byteBuffer3.array());
            int n3 = 0;
            while (byteBuffer.hasRemaining()) {
                byteBuffer2.put((byte)(byteBuffer.get() ^ byteBuffer3.get(n3 % 4)));
                ++n3;
            }
        } else {
            byteBuffer2.put(byteBuffer);
            byteBuffer.flip();
        }
        assert (byteBuffer2.remaining() == 0) : byteBuffer2.remaining();
        byteBuffer2.flip();
        return byteBuffer2;
    }

    public Framedata e(ByteBuffer byteBuffer) throws IncompleteException, InvalidDataException {
        Object object;
        byte by;
        int n2;
        int n3 = byteBuffer.remaining();
        if (n3 < (n2 = 2)) {
            throw new IncompleteException(n2);
        }
        byte by2 = byteBuffer.get();
        boolean bl = by2 >> 8 != 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if ((by2 & 0x40) != 0) {
            bl2 = true;
        }
        if ((by2 & 0x20) != 0) {
            bl3 = true;
        }
        if ((by2 & 0x10) != 0) {
            bl4 = true;
        }
        boolean bl5 = ((by = byteBuffer.get()) & 0xFFFFFF80) != 0;
        int n4 = by & 0x7F;
        Framedata.Opcode opcode = this.a((byte)(by2 & 0xF));
        if (n4 < 0 || n4 > 125) {
            if (opcode == Framedata.Opcode.PING || opcode == Framedata.Opcode.PONG || opcode == Framedata.Opcode.CLOSING) {
                throw new InvalidFrameException("more than 125 octets");
            }
            if (n4 == 126) {
                if (n3 < (n2 += 2)) {
                    throw new IncompleteException(n2);
                }
                object = new byte[3];
                object[1] = byteBuffer.get();
                object[2] = byteBuffer.get();
                n4 = new BigInteger((byte[])object).intValue();
            } else {
                if (n3 < (n2 += 8)) {
                    throw new IncompleteException(n2);
                }
                object = new byte[8];
                for (int i2 = 0; i2 < 8; ++i2) {
                    object[i2] = byteBuffer.get();
                }
                long l2 = new BigInteger((byte[])object).longValue();
                if (l2 > Integer.MAX_VALUE) {
                    throw new LimitExedeedException("Payloadsize is to big...");
                }
                n4 = (int)l2;
            }
        }
        n2 += bl5 ? 4 : 0;
        if (n3 < (n2 += n4)) {
            throw new IncompleteException(n2);
        }
        object = ByteBuffer.allocate(this.a(n4));
        if (bl5) {
            byte[] byArray = new byte[4];
            byteBuffer.get(byArray);
            for (int i3 = 0; i3 < n4; ++i3) {
                ((ByteBuffer)object).put((byte)(byteBuffer.get() ^ byArray[i3 % 4]));
            }
        } else {
            ((ByteBuffer)object).put(byteBuffer.array(), byteBuffer.position(), ((Buffer)object).limit());
            byteBuffer.position(byteBuffer.position() + ((Buffer)object).limit());
        }
        f f2 = org.java_websocket.framing.f.a(opcode);
        f2.a(bl);
        f2.b(bl2);
        f2.c(bl3);
        f2.d(bl4);
        ((ByteBuffer)object).flip();
        f2.a((ByteBuffer)object);
        this.d().c(f2);
        this.d().a(f2);
        if (org.java_websocket.c.b) {
            System.out.println("afterDecoding(" + f2.d().remaining() + "): {" + (f2.d().remaining() > 1000 ? "too big to display" : new String(f2.d().array())) + '}');
        }
        f2.c();
        return f2;
    }

    @Override
    public List<Framedata> c(ByteBuffer byteBuffer) throws InvalidDataException {
        Framedata framedata;
        int n2;
        LinkedList<Framedata> linkedList;
        while (true) {
            linkedList = new LinkedList<Framedata>();
            if (this.l == null) break;
            try {
                byteBuffer.mark();
                int n3 = byteBuffer.remaining();
                n2 = this.l.remaining();
                if (n2 > n3) {
                    this.l.put(byteBuffer.array(), byteBuffer.position(), n3);
                    byteBuffer.position(byteBuffer.position() + n3);
                    return Collections.emptyList();
                }
                this.l.put(byteBuffer.array(), byteBuffer.position(), n2);
                byteBuffer.position(byteBuffer.position() + n2);
                framedata = this.e((ByteBuffer)this.l.duplicate().position(0));
                linkedList.add(framedata);
                this.l = null;
            }
            catch (IncompleteException incompleteException) {
                ByteBuffer byteBuffer2 = ByteBuffer.allocate(this.a(incompleteException.getPreferredSize()));
                assert (byteBuffer2.limit() > this.l.limit());
                this.l.rewind();
                byteBuffer2.put(this.l);
                this.l = byteBuffer2;
                continue;
            }
            break;
        }
        while (byteBuffer.hasRemaining()) {
            byteBuffer.mark();
            try {
                framedata = this.e(byteBuffer);
                linkedList.add(framedata);
            }
            catch (IncompleteException incompleteException) {
                byteBuffer.reset();
                n2 = incompleteException.getPreferredSize();
                this.l = ByteBuffer.allocate(this.a(n2));
                this.l.put(byteBuffer);
                break;
            }
        }
        return linkedList;
    }

    @Override
    public List<Framedata> a(ByteBuffer byteBuffer, boolean bl) {
        org.java_websocket.framing.a a2 = new org.java_websocket.framing.a();
        a2.a(byteBuffer);
        a2.e(bl);
        try {
            a2.c();
        }
        catch (InvalidDataException invalidDataException) {
            throw new NotSendableException(invalidDataException);
        }
        return Collections.singletonList(a2);
    }

    @Override
    public List<Framedata> a(String string, boolean bl) {
        org.java_websocket.framing.i i2 = new org.java_websocket.framing.i();
        i2.a(ByteBuffer.wrap(org.java_websocket.e.c.a(string)));
        i2.e(bl);
        try {
            i2.c();
        }
        catch (InvalidDataException invalidDataException) {
            throw new NotSendableException(invalidDataException);
        }
        return Collections.singletonList(i2);
    }

    @Override
    public void a() {
        this.l = null;
        if (this.f != null) {
            this.f.d();
        }
        this.f = new org.java_websocket.b.a();
        this.h = null;
    }

    private String h() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat.format(calendar.getTime());
    }

    private String a(String string) {
        MessageDigest messageDigest;
        String string2 = string.trim();
        String string3 = string2 + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
        try {
            messageDigest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException(noSuchAlgorithmException);
        }
        return org.java_websocket.e.a.a(messageDigest.digest(string3.getBytes()));
    }

    private byte[] a(long l2, int n2) {
        byte[] byArray = new byte[n2];
        int n3 = 8 * n2 - 8;
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2] = (byte)(l2 >>> n3 - 8 * i2);
        }
        return byArray;
    }

    private byte a(Framedata.Opcode opcode) {
        if (opcode == Framedata.Opcode.CONTINUOUS) {
            return 0;
        }
        if (opcode == Framedata.Opcode.TEXT) {
            return 1;
        }
        if (opcode == Framedata.Opcode.BINARY) {
            return 2;
        }
        if (opcode == Framedata.Opcode.CLOSING) {
            return 8;
        }
        if (opcode == Framedata.Opcode.PING) {
            return 9;
        }
        if (opcode == Framedata.Opcode.PONG) {
            return 10;
        }
        throw new IllegalArgumentException("Don't know how to handle " + opcode.toString());
    }

    private Framedata.Opcode a(byte by) throws InvalidFrameException {
        switch (by) {
            case 0: {
                return Framedata.Opcode.CONTINUOUS;
            }
            case 1: {
                return Framedata.Opcode.TEXT;
            }
            case 2: {
                return Framedata.Opcode.BINARY;
            }
            case 8: {
                return Framedata.Opcode.CLOSING;
            }
            case 9: {
                return Framedata.Opcode.PING;
            }
            case 10: {
                return Framedata.Opcode.PONG;
            }
        }
        throw new InvalidFrameException("Unknown opcode " + (short)by);
    }

    @Override
    public void a(c c2, Framedata framedata) throws InvalidDataException {
        Framedata.Opcode opcode = framedata.i();
        if (opcode == Framedata.Opcode.CLOSING) {
            int n2 = 1005;
            String string = "";
            if (framedata instanceof org.java_websocket.framing.b) {
                org.java_websocket.framing.b b2 = (org.java_websocket.framing.b)framedata;
                n2 = b2.a();
                string = b2.b();
            }
            if (c2.i() == WebSocket.READYSTATE.CLOSING) {
                c2.b(n2, string, true);
            } else if (this.b() == Draft.CloseHandshakeType.TWOWAY) {
                c2.a(n2, string, true);
            } else {
                c2.c(n2, string, false);
            }
        } else if (opcode == Framedata.Opcode.PING) {
            c2.o().onWebsocketPing(c2, framedata);
        } else if (opcode == Framedata.Opcode.PONG) {
            c2.n();
            c2.o().onWebsocketPong(c2, framedata);
        } else if (!framedata.e() || opcode == Framedata.Opcode.CONTINUOUS) {
            if (opcode != Framedata.Opcode.CONTINUOUS) {
                if (this.j != null) {
                    throw new InvalidDataException(1002, "Previous continuous frame sequence not completed.");
                }
                this.j = framedata;
                this.k.add(framedata.d());
            } else if (framedata.e()) {
                if (this.j == null) {
                    throw new InvalidDataException(1002, "Continuous frame sequence was not started.");
                }
                this.k.add(framedata.d());
                if (this.j.i() == Framedata.Opcode.TEXT) {
                    ((f)this.j).a(this.i());
                    ((f)this.j).c();
                    try {
                        c2.o().onWebsocketMessage((WebSocket)c2, org.java_websocket.e.c.a(this.j.d()));
                    }
                    catch (RuntimeException runtimeException) {
                        c2.o().onWebsocketError(c2, runtimeException);
                    }
                } else if (this.j.i() == Framedata.Opcode.BINARY) {
                    ((f)this.j).a(this.i());
                    ((f)this.j).c();
                    try {
                        c2.o().onWebsocketMessage((WebSocket)c2, this.j.d());
                    }
                    catch (RuntimeException runtimeException) {
                        c2.o().onWebsocketError(c2, runtimeException);
                    }
                }
                this.j = null;
                this.k.clear();
            } else if (this.j == null) {
                throw new InvalidDataException(1002, "Continuous frame sequence was not started.");
            }
            if (opcode == Framedata.Opcode.TEXT && !org.java_websocket.e.c.b(framedata.d())) {
                throw new InvalidDataException(1007);
            }
            if (opcode == Framedata.Opcode.CONTINUOUS && this.j != null) {
                this.k.add(framedata.d());
            }
        } else {
            if (this.j != null) {
                throw new InvalidDataException(1002, "Continuous frame sequence not completed.");
            }
            if (opcode == Framedata.Opcode.TEXT) {
                try {
                    c2.o().onWebsocketMessage((WebSocket)c2, org.java_websocket.e.c.a(framedata.d()));
                }
                catch (RuntimeException runtimeException) {
                    c2.o().onWebsocketError(c2, runtimeException);
                }
            } else if (opcode == Framedata.Opcode.BINARY) {
                try {
                    c2.o().onWebsocketMessage((WebSocket)c2, framedata.d());
                }
                catch (RuntimeException runtimeException) {
                    c2.o().onWebsocketError(c2, runtimeException);
                }
            } else {
                throw new InvalidDataException(1002, "non control or continious frame expected");
            }
        }
    }

    @Override
    public Draft.CloseHandshakeType b() {
        return Draft.CloseHandshakeType.TWOWAY;
    }

    @Override
    public String toString() {
        String string = super.toString();
        if (this.d() != null) {
            string = string + " extension: " + this.d().toString();
        }
        if (this.f() != null) {
            string = string + " protocol: " + this.f().toString();
        }
        return string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        a a2 = (a)object;
        if (this.f != null ? !this.f.equals(a2.f) : a2.f != null) {
            return false;
        }
        return this.h != null ? this.h.equals(a2.h) : a2.h == null;
    }

    public int hashCode() {
        int n2 = this.f != null ? this.f.hashCode() : 0;
        n2 = 31 * n2 + (this.h != null ? this.h.hashCode() : 0);
        return n2;
    }

    private ByteBuffer i() throws LimitExedeedException {
        long l2 = 0L;
        for (ByteBuffer object : this.k) {
            l2 += (long)object.limit();
        }
        if (l2 > Integer.MAX_VALUE) {
            throw new LimitExedeedException("Payloadsize is to big...");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)l2);
        for (ByteBuffer byteBuffer2 : this.k) {
            byteBuffer.put(byteBuffer2);
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    private static void a(Object object) {
        if (org.java_websocket.c.b) {
            System.out.println(object);
        }
    }
}

