/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.payment;

import com.hippo.R;

public interface PaymentConstants {

    public static enum PaymentValue {
        RAZORPAY(1L, R.string.hippo_pay_with_razorpay, R.string.hippo_netbanking, 2),
        PAYTM(2L, R.string.hippo_pay_with_paytm, R.string.hippo_paytm, 6),
        STRIPE(3L, R.string.hippo_stripe, R.string.hippo_card, 1),
        BILLPLZ(512L, R.string.hippo_pay_with_netbanking, R.string.hippo_netbanking, 2),
        PAYFORT(32L, R.string.hippo_payfort, R.string.hippo_card, 1),
        PAYMOB(131072L, R.string.hippo_pay_with_paymob, R.string.hippo_pay_with_paymob, 2),
        NONE(-1L, R.string.fugu_empty, R.string.fugu_empty, -1);

        public final long intValue;
        public final int payViaPaymentStringId;
        public final int paymentMethodStringId;
        public final int paymentType;

        private PaymentValue(long l2, int n3, int n4, int n5) {
            this.intValue = l2;
            this.payViaPaymentStringId = n3;
            this.paymentMethodStringId = n4;
            this.paymentType = n5;
        }

        public static PaymentValue getPaymentByValue(long l2) {
            PaymentValue paymentValue = null;
            for (PaymentValue paymentValue2 : PaymentValue.values()) {
                if (paymentValue2.intValue != l2) continue;
                paymentValue = paymentValue2;
                break;
            }
            return paymentValue == null ? NONE : paymentValue;
        }
    }

    public static enum PaymentForFlow {
        ORDER_PAYMENT(0L),
        SIGN_UP_FEE(1L),
        IN_APP_WALLET(2L),
        GIFT_CARD(3L),
        REPAY_FROM_TASK_DETAILS(4L),
        REWARD(5L),
        DEBT(6L),
        USER_SUBSCRIPTION(11L);

        public final long intValue;

        private PaymentForFlow(long l2) {
            this.intValue = l2;
        }
    }
}

