/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.activity;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.hippo.utils.HippoLog;
import java.util.HashSet;

public final class HippoActivityLifecycleCallback {
    static boolean registered = false;
    private static final String TAG = HippoActivityLifecycleCallback.class.getSimpleName();
    private static HashSet<String> hippoClasses;

    @TargetApi(value=14)
    public static synchronized void register(Application application, String cleverTapID) {
        if (application == null) {
            HippoLog.i("register", "Application instance is null/system API is too old");
            return;
        }
        if (registered) {
            HippoLog.v("register", "Lifecycle callbacks have already been registered");
            return;
        }
        hippoClasses = new HashSet();
        registered = true;
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle bundle) {
                hippoClasses.add(activity.getClass().getSimpleName());
                HippoLog.v(TAG, "onActivityCreated");
            }

            public void onActivityStarted(Activity activity) {
                HippoLog.v(TAG, "onActivityStarted");
            }

            public void onActivityResumed(Activity activity) {
                HippoLog.v(TAG, "onActivityResumed");
            }

            public void onActivityPaused(Activity activity) {
                HippoLog.v(TAG, "onActivityPaused");
            }

            public void onActivityStopped(Activity activity) {
                HippoLog.v(TAG, "onActivityStopped");
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
                HippoLog.v(TAG, "onActivitySaveInstanceState");
            }

            public void onActivityDestroyed(Activity activity) {
                HippoLog.v(TAG, "onActivityDestroyed " + activity.getClass().getSimpleName());
                hippoClasses.remove(activity.getClass().getSimpleName());
                if (hippoClasses.size() == 0) {
                    HippoLog.w(TAG, "SDK's All classes Destroyed");
                }
            }
        });
        HippoLog.i("In callback", "Activity Lifecycle Callback successfully registered");
    }

    private void handleBack() {
    }

    @TargetApi(value=14)
    public static synchronized void register(Application application) {
        HippoActivityLifecycleCallback.register(application, null);
    }
}

