package com.hippo.activity;

import android.animation.ObjectAnimator;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.Toolbar;
import android.text.TextUtils;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.transition.Transition;
import com.hippo.R;
import com.hippo.model.Image;
import com.hippo.utils.HippoLog;
import com.hippo.utils.filepicker.Util;
import com.hippo.utils.photoview.OnDoubleTap;
import com.hippo.utils.photoview.PhotoView;
import com.hippo.utils.swipeLayout.frame.SwipeableLayout;
import com.hippo.utils.swipeLayout.listener.LayoutShiftListener;
import com.hippo.utils.swipeLayout.listener.OnLayoutPercentageChangeListener;
import com.hippo.utils.swipeLayout.listener.OnLayoutSwipedListener;

/**
 * Created by gurmail on 2019-11-25.
 *
 * @author gurmail
 */
public class ImageDisplayActivityNew extends FuguBaseActivity {

    private SwipeableLayout swipeableLayout;
    private PhotoView ivImageBig;
    private ImageView ivImageGif;
    private Toolbar toolbar;
    private ImageView ivBack;
    private FrameLayout colorContainer;

    private Image imageUrl = null;
    private int swipedFromDefault = OnLayoutSwipedListener.SWIPE;
    private float lastPerc = 0f;
    private boolean isTopBarVisivle = true;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.hippo_activity_new_image);

        imageUrl = (Image) getIntent().getSerializableExtra("image");

        swipeableLayout = findViewById(R.id.swipeableLayout);
        ivImageBig = findViewById(R.id.ivImageBigNew);
        ivImageGif = findViewById(R.id.ivImageGif);
        toolbar = findViewById(R.id.toolbar);
        ivBack = findViewById(R.id.ivBack);
        colorContainer = findViewById(R.id.colorContainer);

        ivBack.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackPressed();
            }
        });

        swipeableLayout.setOnLayoutPercentageChangeListener(new OnLayoutPercentageChangeListener() {
            @Override
            public void percentageX(float percentage) {
                super.percentageX(percentage);
            }

            @Override
            public void percentageY(float percentage) {
                super.percentageY(percentage);

                HippoLog.e("percent change", "percentage = "+percentage);
                if (lastPerc != 1.0f) {
                    colorContainer.setAlpha(1 - percentage);
                    toolbar.setAlpha(1 - percentage);
                }
                lastPerc = percentage;
            }
        });

        swipeableLayout.setLayoutShiftListener(new LayoutShiftListener() {
            @Override
            public void onLayoutShifted(float positionX, float positionY, boolean isTouched) {
                HippoLog.e("position Y", "positionY"+positionY);
                if (!isTouched && lastPerc != 1f && swipedFromDefault == OnLayoutSwipedListener.SWIPE) {
                    colorContainer.setAlpha(1f);
                    toolbar.setAlpha(1f);
                }
            }
        });

        swipeableLayout.setOnSwipedListener(new OnLayoutSwipedListener() {
            @Override
            public void onLayoutSwiped(int swipedFrom) {
                swipedFromDefault = swipedFrom;
                onBackPressed();
            }
        });

        ivImageBig.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (isTopBarVisivle) {
                    toolbar.animate().translationY(-150f).setDuration(100);
                } else {
                    toolbar.animate().translationY(0f).setDuration(100);
                }
                isTopBarVisivle = !isTopBarVisivle;
            }
        });

        RequestOptions requestOptions = new RequestOptions()
                .dontAnimate()
                .diskCacheStrategy(DiskCacheStrategy.ALL)
                .dontTransform();

        supportPostponeEnterTransition();

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            ivImageBig.setTransitionName(imageUrl.getTransitionName());
        }

        String fileExt = Util.getExtension(imageUrl.getImageUrl());
        if(!TextUtils.isEmpty(fileExt) && fileExt.equalsIgnoreCase("gif")) {
            ObjectAnimator alphaAnimation = ObjectAnimator.ofFloat(toolbar, View.ALPHA, 0f, 1f);
            alphaAnimation.setDuration(500);
            alphaAnimation.setStartDelay(200);
            alphaAnimation.start();
            supportStartPostponedEnterTransition();

            ivImageGif.setVisibility(View.VISIBLE);
            ivImageBig.setVisibility(View.GONE);
            Glide
                    .with(ImageDisplayActivityNew.this)
                    .asGif()
                    .load(imageUrl.getImageUrl())
                    .error(R.drawable.hippo_placeholder)
                    .diskCacheStrategy(DiskCacheStrategy.DATA)
                    .into(ivImageGif);
        } else {
            Glide.with(ImageDisplayActivityNew.this).load(imageUrl.getImageUrl())
                    .apply(requestOptions)
                    .into(new SimpleTarget<Drawable>() {
                        @Override
                        public void onResourceReady(@NonNull Drawable resource, @Nullable Transition<? super Drawable> transition) {
                            ObjectAnimator alphaAnimation = ObjectAnimator.ofFloat(toolbar, View.ALPHA, 0f, 1f);
                            alphaAnimation.setDuration(500);
                            alphaAnimation.setStartDelay(200);
                            alphaAnimation.start();
                            supportStartPostponedEnterTransition();
                            ivImageBig.setImageDrawable(resource);
                        }
                    });
        }




        ivImageBig.setOnDoubleTap(new OnDoubleTap() {
            @Override
            public void onDoubleTap(float zoom) {
                if (zoom <= 1.0f) {
                    swipeableLayout.isSwipeable(true);
                } else {
                    swipeableLayout.isSwipeable(false);
                }
            }
        });

    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
//        if (!TextUtils.isEmpty(imageUrl.getImageUrl())) {
//            Intent intent = new Intent();
//            intent.putExtra("imageUrl", imageUrl);
//            setResult(Activity.RESULT_OK, intent);
//        }

        supportFinishAfterTransition();
    }
}
