package com.hippo.activity;

/**
 * Created by gurmail on 2020-04-22.
 *
 * @author gurmail
 */
import android.annotation.TargetApi;
import android.app.Activity;
import android.os.Build;
import android.os.Bundle;

import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.ViewModelProvider;

import com.hippo.utils.HippoLog;

import java.util.HashSet;


/**
 * Class for handling activity lifecycle events
 */
@SuppressWarnings({"unused", "WeakerAccess"})
public final class HippoActivityLifecycleCallback {
    static boolean registered = false;
    private static final String TAG = HippoActivityLifecycleCallback.class.getSimpleName();
    private static HashSet<String> hippoClasses;

    /**
     * Enables lifecycle callbacks for Android devices
     * @param application App's Application object
     * @param cleverTapID Custom CleverTap ID
     */
    @TargetApi(Build.VERSION_CODES.ICE_CREAM_SANDWICH)
    public static synchronized void register(android.app.Application application, final String cleverTapID) {
        if (application == null) {
            HippoLog.i("register", "Application instance is null/system API is too old");
            return;
        }

        if (registered) {
            HippoLog.v("register", "Lifecycle callbacks have already been registered");
            return;
        }
        hippoClasses = new HashSet<>();
        registered = true;
        application.registerActivityLifecycleCallbacks(
                new android.app.Application.ActivityLifecycleCallbacks() {

                    @Override
                    public void onActivityCreated(Activity activity, Bundle bundle) {
//                        if(cleverTapID != null) {
//                            CleverTapAPI.onActivityCreated(activity,cleverTapID);
//                        }else{
//                            CleverTapAPI.onActivityCreated(activity);
//                        }
                        hippoClasses.add(activity.getClass().getSimpleName());
                        HippoLog.v(TAG, "onActivityCreated");

                        //AndroidViewModel viewModel = new ViewModelProvider(this).get(MainViewModel.class);
                        //AndroidViewModel viewModel = new ViewModelProvider(this).get(HippoViewModel.class);
                    }

                    @Override
                    public void onActivityStarted(Activity activity) {
                        HippoLog.v(TAG, "onActivityStarted");
                    }

                    @Override
                    public void onActivityResumed(Activity activity) {
//                        if(cleverTapID != null) {
//                            CleverTapAPI.onActivityResumed(activity,cleverTapID);
//                        }else{
//                            CleverTapAPI.onActivityResumed(activity);
//                        }
                        HippoLog.v(TAG, "onActivityResumed");
                    }

                    @Override
                    public void onActivityPaused(Activity activity) {
                        //CleverTapAPI.onActivityPaused();
                        HippoLog.v(TAG, "onActivityPaused");
                    }

                    @Override
                    public void onActivityStopped(Activity activity) {
                        HippoLog.v(TAG, "onActivityStopped");
                    }

                    @Override
                    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
                        HippoLog.v(TAG, "onActivitySaveInstanceState");
                    }

                    @Override
                    public void onActivityDestroyed(Activity activity) {
                        HippoLog.v(TAG, "onActivityDestroyed "+activity.getClass().getSimpleName());
                        hippoClasses.remove(activity.getClass().getSimpleName());
                        if(hippoClasses.size() == 0) {
                            HippoLog.w(TAG, "SDK's All classes Destroyed");
                        }
                    }
                }

        );
        HippoLog.i("In callback", "Activity Lifecycle Callback successfully registered");
    }

    private void handleBack() {

    }

    /**
     * Enables lifecycle callbacks for Android devices
     * @param application App's Application object
     */
    @TargetApi(Build.VERSION_CODES.ICE_CREAM_SANDWICH)
    public static synchronized void register(android.app.Application application) {
        register(application,null);
    }
}