package faye

import com.hippo.HippoConfig
import com.hippo.constant.FuguAppConstant
import com.hippo.database.CommonData
import com.hippo.utils.HippoLog
import org.json.JSONException
import org.json.JSONObject
import java.util.HashSet

/**
 * Created by gurmail on 2020-04-18.
 * @author gurmail
 */
object ConnectionManager {

    private var fayeClient: FayeClient? = null
    private var meta = MetaMessage()
    private var isSocketConnected = false
    private val mChannels: HashSet<String> = HashSet()
    private val mPendingChannels: HashSet<String> = HashSet()

    fun initFayeConnection() {
        fayeClient = getFayeClient()
        isSocketConnected = fayeClient != null && fayeClient!!.isConnectedServer && fayeClient!!.isOpened
        if(!isConnected()) {
            fayeClient!!.connectServer()
            println("########################## ConnectionManager initFayeConnection ##########################")
        }
        setListener()
    }

    private fun getFayeClient(): FayeClient? {
        if(fayeClient == null) {
            val jsonExt = JSONObject()
            try {
                if (HippoConfig.getInstance().userData != null) {
                    jsonExt.put("user_id", HippoConfig.getInstance().userData.userId)
                    jsonExt.put("device_type", 1)
                    jsonExt.put("source", 1)
                }
            } catch (e: JSONException) {
                e.printStackTrace()
            }

            meta.setAllExt(jsonExt.toString())
            fayeClient = FayeClient(getFayeUrl(), meta)
        }
        return fayeClient
    }

    private fun reconnectConnection() {
        initFayeConnection()
    }

    private fun getFayeUrl(): String {
        var url = CommonData.getServerUrl() + ":3002/faye"
        if (CommonData.getServerUrl() == FuguAppConstant.LIVE_SERVER) {
            url = CommonData.getServerUrl() + ":3002/faye"
        } else if (CommonData.getServerUrl() == FuguAppConstant.BETA_LIVE_SERVER) {
            url = FuguAppConstant.BETA_LIVE_SERVER + ":3001/faye"
        } else if (CommonData.getServerUrl() == FuguAppConstant.TEST_SERVER) {
            url = "https://hippo-api-dev.fuguchat.com:3012/faye"
        } else if (CommonData.getServerUrl() == FuguAppConstant.BETA_LIVE_SERVER) {
            url = FuguAppConstant.BETA_LIVE_SERVER + ":3001/faye"
        } else if (CommonData.getServerUrl() == FuguAppConstant.DEV_SERVER) {
            url = "https://hippo-api-dev.fuguchat.com:3002/faye"
        } else if (CommonData.getServerUrl() == FuguAppConstant.DEV_SERVER_3004) {
            url = "https://hippo-api-dev.fuguchat.com:3004/faye"
        } else {
            url = FuguAppConstant.LIVE_SERVER + ":3002/faye"
        }
        HippoLog.e("faye url", ">>>>>>>>>>>>>>>>>> $url")
        return url
    }

    private fun setListener() {
        if(fayeClient != null) {
            fayeClient!!.setmConnectionListener(object: FayeClientListener{
                override fun onConnectedServer(fc: FayeClient?) {
                    println(">>>>>>>>>>>>>>>>> ConnectionManager onConnectedServer <<<<<<<<<<<<<<<<<<<<<<")
                    subscribePendingChannels()
                }

                override fun onDisconnectedServer(fc: FayeClient?) {
                    println(">>>>>>>>>>>>>>>>> ConnectionManager onDisconnectedServer <<<<<<<<<<<<<<<<<<<<<<")
                }

                override fun onReceivedMessage(fc: FayeClient?, msg: String?, channel: String?) {
                    println(">>>>>>>>>>>>>>>>> ConnectionManager onReceivedMessage <<<<<<<<<<<<<<<<<<<<<<")
                }

                override fun onPongReceived() {
                    println(">>>>>>>>>>>>>>>>> ConnectionManager onPongReceived <<<<<<<<<<<<<<<<<<<<<<")
                    subscribePendingChannels()
                }

                override fun onWebSocketError() {
                    println(">>>>>>>>>>>>>>>>> ConnectionManager onWebSocketError <<<<<<<<<<<<<<<<<<<<<<")
                }

                override fun onErrorReceived(fc: FayeClient?, msg: String?, channel: String?) {
                    println(">>>>>>>>>>>>>>>>> ConnectionManager onErrorReceived <<<<<<<<<<<<<<<<<<<<<<")
                }

                override fun onNotConnected() {
                    println(">>>>>>>>>>>>>>>>> ConnectionManager onNotConnected <<<<<<<<<<<<<<<<<<<<<<")
                }

            })
        }
    }

    private fun isConnected(): Boolean {
        return fayeClient != null && fayeClient!!.isConnectedServer && fayeClient!!.isOpened
    }

    public fun subScribeChannel(channel: String) {
        if(isConnected()) {
            mChannels.add(channel)
        } else {
            // pending channels for subscriptions
            mPendingChannels.add(channel)
            reconnectConnection()
        }
    }

    public fun unsubScribeChannel(channel: String) {
        mChannels.remove(channel)

    }

    public fun unsubScribeChannedAll() {

    }

    public fun publish(channel: String, jsonObject: JSONObject) {
        if(isConnected()) {

        } else {
            mPendingChannels.add(channel)
            //CoroutineScope
            reconnectConnection()
        }
    }

    public fun closeConnection() {

    }

    private fun subscribePendingChannels() {
        synchronized(this) {
            if(mPendingChannels != null && mPendingChannels.size>0) {
                val tempChannel = mPendingChannels
                for (channel in tempChannel) {
                    fayeClient!!.subscribeChannel(channel)
                }
                mPendingChannels.removeAll(tempChannel)
            }
        }
    }
}