/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.activity;

import android.animation.ObjectAnimator;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Property;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.FragmentActivity;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.hippo.R;
import com.hippo.activity.FuguBaseActivity;
import com.hippo.model.Image;
import com.hippo.utils.HippoLog;
import com.hippo.utils.filepicker.Util;
import com.hippo.utils.photoview.OnDoubleTap;
import com.hippo.utils.photoview.PhotoView;
import com.hippo.utils.swipeLayout.frame.SwipeableLayout;
import com.hippo.utils.swipeLayout.listener.LayoutShiftListener;
import com.hippo.utils.swipeLayout.listener.OnLayoutPercentageChangeListener;
import com.hippo.utils.swipeLayout.listener.OnLayoutSwipedListener;

public class ImageDisplayActivityNew
extends FuguBaseActivity {
    private SwipeableLayout swipeableLayout;
    private PhotoView ivImageBig;
    private ImageView ivImageGif;
    private Toolbar toolbar;
    private ImageView ivBack;
    private FrameLayout colorContainer;
    private Image imageUrl = null;
    private int swipedFromDefault = 1;
    private float lastPerc = 0.0f;
    private boolean isTopBarVisivle = true;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        String fileExt;
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.hippo_activity_new_image);
        this.imageUrl = (Image)this.getIntent().getSerializableExtra("image");
        this.swipeableLayout = (SwipeableLayout)this.findViewById(R.id.swipeableLayout);
        this.ivImageBig = (PhotoView)this.findViewById(R.id.ivImageBigNew);
        this.ivImageGif = (ImageView)this.findViewById(R.id.ivImageGif);
        this.toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.ivBack = (ImageView)this.findViewById(R.id.ivBack);
        this.colorContainer = (FrameLayout)this.findViewById(R.id.colorContainer);
        this.ivBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ImageDisplayActivityNew.this.onBackPressed();
            }
        });
        this.swipeableLayout.setOnLayoutPercentageChangeListener(new OnLayoutPercentageChangeListener(){

            @Override
            public void percentageX(float percentage) {
                super.percentageX(percentage);
            }

            @Override
            public void percentageY(float percentage) {
                super.percentageY(percentage);
                HippoLog.e("percent change", "percentage = " + percentage);
                if (ImageDisplayActivityNew.this.lastPerc != 1.0f) {
                    ImageDisplayActivityNew.this.colorContainer.setAlpha(1.0f - percentage);
                    ImageDisplayActivityNew.this.toolbar.setAlpha(1.0f - percentage);
                }
                ImageDisplayActivityNew.this.lastPerc = percentage;
            }
        });
        this.swipeableLayout.setLayoutShiftListener(new LayoutShiftListener(){

            @Override
            public void onLayoutShifted(float positionX, float positionY, boolean isTouched) {
                HippoLog.e("position Y", "positionY" + positionY);
                if (!isTouched && ImageDisplayActivityNew.this.lastPerc != 1.0f && ImageDisplayActivityNew.this.swipedFromDefault == 1) {
                    ImageDisplayActivityNew.this.colorContainer.setAlpha(1.0f);
                    ImageDisplayActivityNew.this.toolbar.setAlpha(1.0f);
                }
            }
        });
        this.swipeableLayout.setOnSwipedListener(new OnLayoutSwipedListener(){

            @Override
            public void onLayoutSwiped(int swipedFrom) {
                ImageDisplayActivityNew.this.swipedFromDefault = swipedFrom;
                ImageDisplayActivityNew.this.onBackPressed();
            }
        });
        this.ivImageBig.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ImageDisplayActivityNew.this.isTopBarVisivle) {
                    ImageDisplayActivityNew.this.toolbar.animate().translationY(-150.0f).setDuration(100L);
                } else {
                    ImageDisplayActivityNew.this.toolbar.animate().translationY(0.0f).setDuration(100L);
                }
                ImageDisplayActivityNew.this.isTopBarVisivle = !ImageDisplayActivityNew.this.isTopBarVisivle;
            }
        });
        RequestOptions requestOptions = (RequestOptions)((RequestOptions)((RequestOptions)new RequestOptions().dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL)).dontTransform();
        this.supportPostponeEnterTransition();
        if (Build.VERSION.SDK_INT >= 21) {
            this.ivImageBig.setTransitionName(this.imageUrl.getTransitionName());
        }
        if (!TextUtils.isEmpty((CharSequence)(fileExt = Util.getExtension(this.imageUrl.getImageUrl()))) && fileExt.equalsIgnoreCase("gif")) {
            ObjectAnimator alphaAnimation = ObjectAnimator.ofFloat((Object)this.toolbar, (Property)View.ALPHA, (float[])new float[]{0.0f, 1.0f});
            alphaAnimation.setDuration(500L);
            alphaAnimation.setStartDelay(200L);
            alphaAnimation.start();
            this.supportStartPostponedEnterTransition();
            this.ivImageGif.setVisibility(0);
            this.ivImageBig.setVisibility(8);
            ((RequestBuilder)((RequestBuilder)Glide.with((FragmentActivity)this).asGif().load(this.imageUrl.getImageUrl()).error(R.drawable.hippo_placeholder)).diskCacheStrategy(DiskCacheStrategy.DATA)).into(this.ivImageGif);
        } else {
            Glide.with((FragmentActivity)this).load(this.imageUrl.getImageUrl()).apply((BaseRequestOptions)requestOptions).into((Target)new SimpleTarget<Drawable>(){

                public void onResourceReady(@NonNull Drawable resource, @Nullable Transition<? super Drawable> transition) {
                    ObjectAnimator alphaAnimation = ObjectAnimator.ofFloat((Object)ImageDisplayActivityNew.this.toolbar, (Property)View.ALPHA, (float[])new float[]{0.0f, 1.0f});
                    alphaAnimation.setDuration(500L);
                    alphaAnimation.setStartDelay(200L);
                    alphaAnimation.start();
                    ImageDisplayActivityNew.this.supportStartPostponedEnterTransition();
                    ImageDisplayActivityNew.this.ivImageBig.setImageDrawable(resource);
                }
            });
        }
        this.ivImageBig.setOnDoubleTap(new OnDoubleTap(){

            @Override
            public void onDoubleTap(float zoom) {
                if (zoom <= 1.0f) {
                    ImageDisplayActivityNew.this.swipeableLayout.isSwipeable(true);
                } else {
                    ImageDisplayActivityNew.this.swipeableLayout.isSwipeable(false);
                }
            }
        });
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.supportFinishAfterTransition();
    }
}

