/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.agent.Util.tagview;

import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Typeface;
import android.os.Build;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import com.hippo.agent.Util.TagContainerLayout;
import com.hippo.agent.Util.Utils;

public class TagView
extends View {
    private float mBorderWidth;
    private float mBorderRadius;
    private float mTextSize;
    private int mHorizontalPadding;
    private int mVerticalPadding;
    private int mBorderColor;
    private int mBackgroundColor;
    private int mTextColor;
    private boolean isViewClickable;
    private int mTagMaxLength;
    private OnTagClickListener mOnTagClickListener;
    private int mMoveSlop = 5;
    private int mSlopThreshold = 4;
    private int mLongPressTime = 500;
    private int mTextDirection = 3;
    private float bdDistance;
    private boolean mTagSupportLettersRTL = false;
    private Paint mPaint;
    private Paint mRipplePaint;
    private RectF mRectF;
    private String mAbstractText;
    private String mOriginText;
    private boolean isUp;
    private boolean isMoved;
    private boolean isExecLongClick;
    private int mLastX;
    private int mLastY;
    private float fontH;
    private float fontW;
    private float mTouchX;
    private float mTouchY;
    private int mRippleDuration = 1000;
    private float mRippleRadius;
    private int mRippleColor;
    private int mRippleAlpha;
    private Path mPath;
    private Typeface mTypeface;
    private ValueAnimator mRippleValueAnimator;
    private boolean mEnableCross;
    private float mCrossAreaWidth;
    private float mCrossAreaPadding;
    private int mCrossColor;
    private float mCrossLineWidth;
    private boolean unSupportedClipPath = false;
    private Runnable mLongClickHandle = new Runnable(){

        @Override
        public void run() {
            int state;
            if (!TagView.this.isMoved && !TagView.this.isUp && (state = ((TagContainerLayout)TagView.this.getParent()).getTagViewState()) == 0) {
                TagView.this.isExecLongClick = true;
                TagView.this.mOnTagClickListener.onTagLongClick((Integer)TagView.this.getTag(), TagView.this.getText());
            }
        }
    };

    public TagView(Context context, String text) {
        super(context);
        this.init(context, text);
    }

    private void init(Context context, String text) {
        this.mPaint = new Paint(1);
        this.mRipplePaint = new Paint(1);
        this.mRipplePaint.setStyle(Paint.Style.FILL);
        this.mRectF = new RectF();
        this.mPath = new Path();
        this.mOriginText = text == null ? "" : text;
        this.mMoveSlop = (int)Utils.dp2px(context, this.mMoveSlop);
        this.mSlopThreshold = (int)Utils.dp2px(context, this.mSlopThreshold);
    }

    private void onDealText() {
        this.mAbstractText = !TextUtils.isEmpty((CharSequence)this.mOriginText) ? (this.mOriginText.length() <= this.mTagMaxLength ? this.mOriginText : this.mOriginText.substring(0, this.mTagMaxLength - 3) + "...") : "";
        this.mPaint.setTypeface(this.mTypeface);
        this.mPaint.setTextSize(this.mTextSize);
        Paint.FontMetrics fontMetrics = this.mPaint.getFontMetrics();
        this.fontH = fontMetrics.descent - fontMetrics.ascent;
        if (this.mTextDirection == 4) {
            this.fontW = 0.0f;
            for (char c : this.mAbstractText.toCharArray()) {
                String sc = String.valueOf(c);
                this.fontW += this.mPaint.measureText(sc);
            }
        } else {
            this.fontW = this.mPaint.measureText(this.mAbstractText);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int height = this.mVerticalPadding * 2 + (int)this.fontH;
        int width = this.mHorizontalPadding * 2 + (int)this.fontW + (this.isEnableCross() ? height : 0);
        this.mCrossAreaWidth = Math.min(Math.max(this.mCrossAreaWidth, (float)height), (float)width);
        this.setMeasuredDimension(width, height);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mRectF.set(this.mBorderWidth, this.mBorderWidth, (float)w - this.mBorderWidth, (float)h - this.mBorderWidth);
    }

    protected void onDraw(Canvas canvas) {
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(this.mBackgroundColor);
        canvas.drawRoundRect(this.mRectF, this.mBorderRadius, this.mBorderRadius, this.mPaint);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(this.mBorderWidth);
        this.mPaint.setColor(this.mBorderColor);
        canvas.drawRoundRect(this.mRectF, this.mBorderRadius, this.mBorderRadius, this.mPaint);
        this.drawRipple(canvas);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(this.mTextColor);
        if (this.mTextDirection == 4) {
            if (this.mTagSupportLettersRTL) {
                float tmpX = (float)((this.isEnableCross() ? this.getWidth() + this.getHeight() : this.getWidth()) / 2) + this.fontW / 2.0f;
                for (char c : this.mAbstractText.toCharArray()) {
                    String sc = String.valueOf(c);
                    canvas.drawText(sc, tmpX -= this.mPaint.measureText(sc), (float)(this.getHeight() / 2) + this.fontH / 2.0f - this.bdDistance, this.mPaint);
                }
            } else {
                canvas.drawText(this.mAbstractText, (this.isEnableCross() ? (float)this.getWidth() + this.fontW : (float)this.getWidth()) / 2.0f - this.fontW / 2.0f, (float)(this.getHeight() / 2) + this.fontH / 2.0f - this.bdDistance, this.mPaint);
            }
        } else {
            canvas.drawText(this.mAbstractText, (float)((this.isEnableCross() ? this.getWidth() - this.getHeight() : this.getWidth()) / 2) - this.fontW / 2.0f, (float)(this.getHeight() / 2) + this.fontH / 2.0f - this.bdDistance, this.mPaint);
        }
        this.drawCross(canvas);
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        if (this.isViewClickable) {
            int y = (int)event.getY();
            int x = (int)event.getX();
            int action = event.getAction();
            switch (action) {
                case 0: {
                    if (this.getParent() != null) {
                        this.getParent().requestDisallowInterceptTouchEvent(true);
                    }
                    this.mLastY = y;
                    this.mLastX = x;
                    break;
                }
                case 2: {
                    if (Math.abs(this.mLastY - y) <= this.mSlopThreshold && Math.abs(this.mLastX - x) <= this.mSlopThreshold) break;
                    if (this.getParent() != null) {
                        this.getParent().requestDisallowInterceptTouchEvent(false);
                    }
                    this.isMoved = true;
                    return false;
                }
            }
        }
        return super.dispatchTouchEvent(event);
    }

    public boolean onTouchEvent(MotionEvent event) {
        int action = event.getAction();
        if (action == 0) {
            this.mRippleRadius = 0.0f;
            this.mTouchX = event.getX();
            this.mTouchY = event.getY();
            this.splashRipple();
        }
        if (this.isEnableCross() && this.isClickCrossArea(event) && this.mOnTagClickListener != null) {
            if (action == 1) {
                this.mOnTagClickListener.onTagCrossClick((Integer)this.getTag());
            }
            return true;
        }
        if (this.isViewClickable && this.mOnTagClickListener != null) {
            int x = (int)event.getX();
            int y = (int)event.getY();
            switch (action) {
                case 0: {
                    this.mLastY = y;
                    this.mLastX = x;
                    this.isMoved = false;
                    this.isUp = false;
                    this.isExecLongClick = false;
                    this.postDelayed(this.mLongClickHandle, this.mLongPressTime);
                    break;
                }
                case 2: {
                    if (this.isMoved || Math.abs(this.mLastX - x) <= this.mMoveSlop && Math.abs(this.mLastY - y) <= this.mMoveSlop) break;
                    this.isMoved = true;
                    break;
                }
                case 1: {
                    this.isUp = true;
                    if (this.isExecLongClick || this.isMoved) break;
                    this.mOnTagClickListener.onTagClick((Integer)this.getTag(), this.getText());
                }
            }
            return true;
        }
        return super.onTouchEvent(event);
    }

    private boolean isClickCrossArea(MotionEvent event) {
        if (this.mTextDirection == 4) {
            return event.getX() <= this.mCrossAreaWidth;
        }
        return event.getX() >= (float)this.getWidth() - this.mCrossAreaWidth;
    }

    private void drawCross(Canvas canvas) {
        if (this.isEnableCross()) {
            this.mCrossAreaPadding = this.mCrossAreaPadding > (float)(this.getHeight() / 2) ? (float)(this.getHeight() / 2) : this.mCrossAreaPadding;
            int ltX = this.mTextDirection == 4 ? (int)this.mCrossAreaPadding : (int)((float)(this.getWidth() - this.getHeight()) + this.mCrossAreaPadding);
            int ltY = this.mTextDirection == 4 ? (int)this.mCrossAreaPadding : (int)this.mCrossAreaPadding;
            int lbX = this.mTextDirection == 4 ? (int)this.mCrossAreaPadding : (int)((float)(this.getWidth() - this.getHeight()) + this.mCrossAreaPadding);
            int lbY = this.mTextDirection == 4 ? (int)((float)this.getHeight() - this.mCrossAreaPadding) : (int)((float)this.getHeight() - this.mCrossAreaPadding);
            int rtX = this.mTextDirection == 4 ? (int)((float)this.getHeight() - this.mCrossAreaPadding) : (int)((float)this.getWidth() - this.mCrossAreaPadding);
            int rtY = this.mTextDirection == 4 ? (int)this.mCrossAreaPadding : (int)this.mCrossAreaPadding;
            int rbX = this.mTextDirection == 4 ? (int)((float)this.getHeight() - this.mCrossAreaPadding) : (int)((float)this.getWidth() - this.mCrossAreaPadding);
            int rbY = this.mTextDirection == 4 ? (int)((float)this.getHeight() - this.mCrossAreaPadding) : (int)((float)this.getHeight() - this.mCrossAreaPadding);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setColor(this.mCrossColor);
            this.mPaint.setStrokeWidth(this.mCrossLineWidth);
            canvas.drawLine((float)ltX, (float)ltY, (float)rbX, (float)rbY, this.mPaint);
            canvas.drawLine((float)lbX, (float)lbY, (float)rtX, (float)rtY, this.mPaint);
        }
    }

    @TargetApi(value=11)
    private void drawRipple(Canvas canvas) {
        if (this.isViewClickable && Build.VERSION.SDK_INT >= 11 && canvas != null && !this.unSupportedClipPath) {
            if (Build.VERSION.SDK_INT < 18) {
                this.setLayerType(1, null);
            }
            try {
                canvas.save();
                this.mPath.reset();
                canvas.clipPath(this.mPath);
                this.mPath.addRoundRect(this.mRectF, this.mBorderRadius, this.mBorderRadius, Path.Direction.CCW);
                try {
                    if (Build.VERSION.SDK_INT >= 28) {
                        canvas.clipPath(this.mPath);
                    } else {
                        canvas.clipPath(this.mPath, Region.Op.INTERSECT);
                    }
                }
                catch (Exception e) {
                    canvas.clipPath(this.mPath);
                }
                canvas.drawCircle(this.mTouchX, this.mTouchY, this.mRippleRadius, this.mRipplePaint);
                canvas.restore();
            }
            catch (UnsupportedOperationException e) {
                this.unSupportedClipPath = true;
            }
            catch (Exception e) {
                this.unSupportedClipPath = true;
            }
        }
    }

    @TargetApi(value=11)
    private void splashRipple() {
        if (Build.VERSION.SDK_INT >= 11 && this.mTouchX > 0.0f && this.mTouchY > 0.0f) {
            this.mRipplePaint.setColor(this.mRippleColor);
            this.mRipplePaint.setAlpha(this.mRippleAlpha);
            final float maxDis = Math.max(Math.max(Math.max(this.mTouchX, this.mTouchY), Math.abs((float)this.getMeasuredWidth() - this.mTouchX)), Math.abs((float)this.getMeasuredHeight() - this.mTouchY));
            this.mRippleValueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, maxDis}).setDuration((long)this.mRippleDuration);
            this.mRippleValueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    float animValue = ((Float)animation.getAnimatedValue()).floatValue();
                    TagView.this.mRippleRadius = animValue >= maxDis ? 0.0f : animValue;
                    TagView.this.postInvalidate();
                }
            });
            this.mRippleValueAnimator.start();
        }
    }

    public String getText() {
        return this.mOriginText;
    }

    public boolean getIsViewClickable() {
        return this.isViewClickable;
    }

    public void setTagMaxLength(int maxLength) {
        this.mTagMaxLength = maxLength;
        this.onDealText();
    }

    public void setOnTagClickListener(OnTagClickListener listener) {
        this.mOnTagClickListener = listener;
    }

    public void setTagBackgroundColor(int color2) {
        this.mBackgroundColor = color2;
    }

    public void setTagBorderColor(int color2) {
        this.mBorderColor = color2;
    }

    public void setTagTextColor(int color2) {
        this.mTextColor = color2;
    }

    public void setBorderWidth(float width) {
        this.mBorderWidth = width;
    }

    public void setBorderRadius(float radius) {
        this.mBorderRadius = radius;
    }

    public void setTextSize(float size) {
        this.mTextSize = size;
        this.onDealText();
    }

    public void setHorizontalPadding(int padding) {
        this.mHorizontalPadding = padding;
    }

    public void setVerticalPadding(int padding) {
        this.mVerticalPadding = padding;
    }

    public void setIsViewClickable(boolean clickable) {
        this.isViewClickable = clickable;
    }

    public int getTextDirection() {
        return this.mTextDirection;
    }

    public void setTextDirection(int textDirection) {
        this.mTextDirection = textDirection;
    }

    public void setTypeface(Typeface typeface) {
        this.mTypeface = typeface;
        this.onDealText();
    }

    public void setRippleAlpha(int mRippleAlpha) {
        this.mRippleAlpha = mRippleAlpha;
    }

    public void setRippleColor(int mRippleColor) {
        this.mRippleColor = mRippleColor;
    }

    public void setRippleDuration(int mRippleDuration) {
        this.mRippleDuration = mRippleDuration;
    }

    public void setBdDistance(float bdDistance) {
        this.bdDistance = bdDistance;
    }

    public boolean isEnableCross() {
        return this.mEnableCross;
    }

    public void setEnableCross(boolean mEnableCross) {
        this.mEnableCross = mEnableCross;
    }

    public float getCrossAreaWidth() {
        return this.mCrossAreaWidth;
    }

    public void setCrossAreaWidth(float mCrossAreaWidth) {
        this.mCrossAreaWidth = mCrossAreaWidth;
    }

    public float getCrossLineWidth() {
        return this.mCrossLineWidth;
    }

    public void setCrossLineWidth(float mCrossLineWidth) {
        this.mCrossLineWidth = mCrossLineWidth;
    }

    public float getCrossAreaPadding() {
        return this.mCrossAreaPadding;
    }

    public void setCrossAreaPadding(float mCrossAreaPadding) {
        this.mCrossAreaPadding = mCrossAreaPadding;
    }

    public int getCrossColor() {
        return this.mCrossColor;
    }

    public void setCrossColor(int mCrossColor) {
        this.mCrossColor = mCrossColor;
    }

    public boolean isTagSupportLettersRTL() {
        return this.mTagSupportLettersRTL;
    }

    public void setTagSupportLettersRTL(boolean mTagSupportLettersRTL) {
        this.mTagSupportLettersRTL = mTagSupportLettersRTL;
    }

    public static interface OnTagClickListener {
        public void onTagClick(int var1, String var2);

        public void onTagLongClick(int var1, String var2);

        public void onTagCrossClick(int var1);
    }
}

