package com.hippo.apis;

import android.app.Activity;
import android.text.TextUtils;
import com.hippo.HippoConfig;
import com.hippo.NotificationListener;
import com.hippo.constant.FuguAppConstant;
import com.hippo.model.promotional.PromotionResponse;
import com.hippo.retrofit.*;

/**
 * Created by gurmail on 2019-12-23.
 *
 * @author gurmail
 */
public class ApiGetMobileNotification {

    private Activity activity;
    private NotificationListener listener;

    public ApiGetMobileNotification(Activity activity, NotificationListener listener) {
        this.activity = activity;
        this.listener = listener;
    }

    public void getNotificationData(int startOffset, int endOffset) {

        if(TextUtils.isEmpty(HippoConfig.getInstance().getAppKey()) ||
                TextUtils.isEmpty(HippoConfig.getInstance().getUserData().getEnUserId()))
            return;

        CommonParams params = new CommonParams.Builder()
                .add(FuguAppConstant.APP_SECRET_KEY, HippoConfig.getInstance().getAppKey())
                .add("en_user_id", HippoConfig.getInstance().getUserData().getEnUserId())
                .add("start_offset", startOffset)
                .add("end_offset", endOffset)
                .build();
        RestClient.getApiInterface().fetchMobilePush(params.getMap()).enqueue(new ResponseResolver<PromotionResponse>() {
            @Override
            public void success(PromotionResponse promotionResponse) {
                if(listener != null)
                    listener.onSucessListener(promotionResponse);
            }

            @Override
            public void failure(APIError error) {
                if(listener != null)
                    listener.onFailureListener();
            }
        });
    }

}
