package com.hippo;

import android.app.Activity;

import java.io.Serializable;

/**
 * Created by gurmail on 2019-12-23.
 *
 * @author gurmail
 */
public class MobileCampaignBuilder {

    private String mTitle;
    private int mLayout;
    private String parseFormat;
    private NotificationListener listener;

    private boolean closeActivityOnClick;
    private boolean closeOnlyDeepLink;

    public String getmTitle() {
        return mTitle;
    }

    public int getmLayout() {
        return mLayout;
    }

    public String getParseFormat() {
        return parseFormat;
    }

    public NotificationListener getListener() {
        return listener;
    }

    public boolean isCloseActivityOnClick() {
        return closeActivityOnClick;
    }

    public boolean isCloseOnlyDeepLink() {
        return closeOnlyDeepLink;
    }

    public static class Builder {

        private String mTitle;
        private int mLayout;
        private String parseFormat;
        private NotificationListener listener;
        private boolean closeActivityOnClick;
        private boolean closeOnlyDeepLink;

        public Builder setTitle(String mTitle) {
            this.mTitle = mTitle;
            return this;
        }

        public Builder setLayoutId(int mLayout) {
            this.mLayout = mLayout;
            return this;
        }

        public Builder setParseFormat(String parseFormat) {
            this.parseFormat = parseFormat;
            return this;
        }

        public Builder setListener(NotificationListener listener) {
            this.listener = listener;
            return this;
        }

        public Builder isCloseActivityOnClick(boolean closeActivityOnClick) {
            this.closeActivityOnClick = closeActivityOnClick;
            return this;
        }

        public Builder isCloseOnlyDeepLink(boolean closeOnlyDeepLink) {
            this.closeOnlyDeepLink = closeOnlyDeepLink;
            return this;
        }

        public MobileCampaignBuilder build() {
            return new MobileCampaignBuilder(this);
        }
    }

    private MobileCampaignBuilder(Builder builder) {
        this.mTitle = builder.mTitle;
        this.mLayout = builder.mLayout;
        this.parseFormat = builder.parseFormat;
        this.listener = builder.listener;
        this.closeActivityOnClick = builder.closeActivityOnClick;
        this.closeOnlyDeepLink = builder.closeOnlyDeepLink;
    }
}
