/*
 * Decompiled with CFR 0.152.
 */
package com.hippo;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.media.AudioAttributes;
import android.media.RingtoneManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.text.Html;
import android.text.TextUtils;
import androidx.core.app.NotificationCompat;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.google.gson.Gson;
import com.hippo.CallData;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.UnreadCountHelper;
import com.hippo.activity.FuguChannelsActivity;
import com.hippo.activity.FuguChatActivity;
import com.hippo.agent.AgentChatActivity;
import com.hippo.agent.AgentListActivity;
import com.hippo.agent.Util.FragmentType;
import com.hippo.agent.database.AgentCommonData;
import com.hippo.agent.model.getConversationResponse.Conversation;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.model.FuguConversation;
import com.hippo.model.UnreadCountModel;
import com.hippo.service.FuguPushIntentService;
import com.hippo.utils.DateUtils;
import com.hippo.utils.HippoLog;
import io.paperdb.Paper;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class HippoNotificationConfig
implements FuguAppConstant {
    private static final String TAG = HippoNotificationConfig.class.getSimpleName();
    public static final String CHANNEL_ONE_ID = "com.hippo.ONE";
    public static Long pushChannelId = -1L;
    public static Long pushLabelId = -1L;
    public static Long agentPushChannelId = -1L;
    public static boolean isChannelActivityOnPause = false;
    public static final String CHANNEL_ONE_NAME = "Default notification";
    private boolean notificationSoundEnabled = true;
    private int smallIcon = -1;
    private int largeIcon;
    private int priority;
    private static NotificationManager notificationManager;

    public void setNotificationSoundEnabled(boolean notificationSoundEnabled) {
        this.notificationSoundEnabled = notificationSoundEnabled;
    }

    public void setSmallIcon(int smallIcon) {
        this.smallIcon = smallIcon;
    }

    public void setLargeIcon(int largeIcon) {
        this.largeIcon = largeIcon;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public boolean isHippoNotification(Map<String, String> data) {
        return data.containsKey("push_source") && data.get("push_source").equalsIgnoreCase("FUGU");
    }

    public boolean isHippoCallNotification(Context context, Map<String, String> data) {
        try {
            Paper.init((Context)context);
            JSONObject messageJson = new JSONObject(data.get("message"));
            try {
                if (this.isCallEnabled(context, messageJson.optString("call_type")) && messageJson.optInt("notification_type") == 14 && (messageJson.optString("video_call_type").equalsIgnoreCase("START_CALL") || messageJson.optString("video_call_type").equalsIgnoreCase("CALL_HUNG_UP"))) {
                    return true;
                }
                if (messageJson.optInt("notification_type") == 14) {
                    return false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean isCallEnabled(Context context, String callType) {
        Paper.init((Context)context);
        if (callType.equalsIgnoreCase("AUDIO")) {
            if (AgentCommonData.isAgentFlow()) {
                return AgentCommonData.getAudioCallStatus();
            }
            return CommonData.getAudioCallStatus();
        }
        if (AgentCommonData.isAgentFlow()) {
            return AgentCommonData.getVideoCallStatus();
        }
        return CommonData.getVideoCallStatus();
    }

    public static void handleHippoPushNotification(final Context context, final Bundle bundle) {
        if (bundle == null) {
            return;
        }
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (AgentCommonData.isAgentFlow()) {
                    Conversation conversation = (Conversation)new Gson().fromJson(bundle.getString("conversation"), Conversation.class);
                    if (conversation != null && HippoConfig.getInstance() != null) {
                        Intent conversationIntent = new Intent(context, AgentChatActivity.class);
                        if (conversation.getChannelId() < 0L) {
                            conversationIntent = new Intent(context, AgentListActivity.class);
                        }
                        conversationIntent.putExtra("fragment_type", FragmentType.MY_CHAT.getOrdinal());
                        conversationIntent.putExtra("conversation", new Gson().toJson((Object)conversation, Conversation.class));
                        context.startActivity(conversationIntent);
                    }
                } else {
                    FuguConversation conversation = (FuguConversation)new Gson().fromJson(bundle.getString("conversation"), FuguConversation.class);
                    if (conversation != null && conversation.isStartChannelsActivity() && HippoConfig.getInstance() != null) {
                        HippoLog.e(TAG, "conversation: " + new Gson().toJson((Object)conversation));
                        Intent conversationIntent = new Intent(context, FuguChatActivity.class);
                        if (conversation.getChannelId() < 0L && conversation.getLabelId() < 0L) {
                            conversationIntent = new Intent(context, FuguChannelsActivity.class);
                        }
                        conversationIntent.putExtra("conversation", new Gson().toJson((Object)conversation, FuguConversation.class));
                        context.startActivity(conversationIntent);
                    }
                }
            }
        }, 1000L);
    }

    public static void cancelNotification(Context ctx, int notifyId) {
        String ns = "notification";
        NotificationManager nMgr = (NotificationManager)ctx.getSystemService(ns);
        nMgr.cancel(notifyId);
    }

    public void showNotification(Context context, Map<String, String> data) {
        try {
            Paper.init((Context)context);
            if (AgentCommonData.isAgentFlow()) {
                this.showAgentNotification(context, data);
            } else {
                this.showUserNotification(context, data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showAgentNotification(Context context, Map<String, String> data) {
        HippoLog.e(TAG, "Init time: " + new Date());
        try {
            int smallIconViewId;
            JSONObject messageJson = new JSONObject(data.get("message"));
            HippoLog.e(TAG, "Push message: " + data.get("message"));
            try {
                if (messageJson.optInt("notification_type") == 14 && (messageJson.optString("video_call_type").equalsIgnoreCase("START_CALL") || messageJson.optString("video_call_type").equalsIgnoreCase("CALL_HUNG_UP"))) {
                    if (HippoConfig.getInstance().getCallData() != null) {
                        HippoConfig.getInstance().getCallData().onNotificationReceived(context, messageJson);
                    } else {
                        String payload = new Gson().toJson((Object)messageJson);
                        Intent intent = new Intent();
                        intent.putExtra("FUGU_CUSTOM_ACTION_PAYLOAD", payload);
                        intent.setAction("hippo_call_notification_data");
                        context.sendBroadcast(intent);
                    }
                    return;
                }
                if (messageJson.optInt("notification_type") == 14) {
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Intent mIntent = new Intent("notification_received");
            Bundle dataBundle = new Bundle();
            for (String key : data.keySet()) {
                dataBundle.putString(key, data.get(key));
            }
            mIntent.putExtras(dataBundle);
            LocalBroadcastManager.getInstance((Context)context).sendBroadcast(mIntent);
            int disableReply = messageJson.optInt("disable_reply", 0);
            Long channelId = messageJson.optLong("channel_id", -1L);
            String label = messageJson.optString("label", "");
            if (channelId > 0L && agentPushChannelId.compareTo(channelId) == 0 && !isChannelActivityOnPause) {
                return;
            }
            Intent notificationIntent = new Intent(context, FuguPushIntentService.class);
            notificationIntent.putExtra("channelId", (Serializable)channelId);
            notificationIntent.putExtra("label", label);
            notificationIntent.putExtra("userId", (Serializable)AgentCommonData.getUserData().getUserId());
            notificationIntent.putExtra("is_from_push", true);
            notificationIntent.putExtra("disable_reply", disableReply);
            Bundle mBundle = new Bundle();
            for (String key : data.keySet()) {
                mBundle.putString(key, data.get(key));
            }
            notificationIntent.putExtra("data", mBundle);
            if (CommonData.getPushFlags() != -1) {
                notificationIntent.setFlags(CommonData.getPushFlags());
            }
            PendingIntent pi = PendingIntent.getService((Context)context, (int)channelId.intValue(), (Intent)notificationIntent, (int)0);
            int notificationDefaults = -1;
            if (!this.notificationSoundEnabled) {
                notificationDefaults = 4;
            }
            String dateTime = messageJson.optString("date_time", "");
            String channelOneId = "com.hippo.ONE." + channelId;
            String channelOneName = CHANNEL_ONE_NAME + channelId;
            NotificationCompat.Builder builder = new NotificationCompat.Builder(context, channelOneId);
            builder.setAutoCancel(true);
            builder.setContentTitle((CharSequence)messageJson.getString("title"));
            builder.setContentIntent(pi);
            builder.setDefaults(1);
            builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)Html.fromHtml((String)messageJson.getString("new_message"))));
            if (!TextUtils.isEmpty((CharSequence)dateTime)) {
                builder.setWhen(HippoNotificationConfig.getTimeMilliSec(DateUtils.getInstance().convertToLocal(dateTime)));
            }
            builder.setSmallIcon(this.smallIcon == -1 ? R.drawable.hippo_default_notif_icon : this.smallIcon);
            builder.setLargeIcon(BitmapFactory.decodeResource((Resources)context.getResources(), (int)this.largeIcon));
            builder.setContentText((CharSequence)Html.fromHtml((String)messageJson.getString("new_message")));
            builder.setPriority(this.getPriority());
            builder.setAutoCancel(true);
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            if (Build.VERSION.SDK_INT >= 26) {
                int importance = 4;
                NotificationChannel notificationChannel = new NotificationChannel(channelOneId, (CharSequence)channelOneName, importance);
                notificationChannel.enableLights(true);
                notificationChannel.setLightColor(-65536);
                notificationChannel.enableVibration(true);
                notificationChannel.setVibrationPattern(new long[]{100L, 200L, 300L, 400L, 500L, 400L, 300L, 200L, 400L});
                assert (notificationManager != null);
                builder.setChannelId(channelOneId);
                notificationManager.createNotificationChannel(notificationChannel);
            }
            Notification notification = builder.build();
            if (Build.VERSION.SDK_INT >= 21 && (smallIconViewId = context.getResources().getIdentifier("right_icon", "id", "android")) != 0) {
                if (notification.headsUpContentView != null) {
                    notification.headsUpContentView.setViewVisibility(smallIconViewId, 4);
                }
                if (notification.bigContentView != null) {
                    notification.bigContentView.setViewVisibility(smallIconViewId, 4);
                }
            }
            notificationManager = (NotificationManager)context.getSystemService("notification");
            int id2 = (int)System.currentTimeMillis();
            notificationManager.notify(id2, notification);
            AgentCommonData.saveNotificationId(channelId, id2);
            try {
                if (channelId != 0L && agentPushChannelId != channelId) {
                    if (!TextUtils.isEmpty((CharSequence)messageJson.optString("user_unique_key", ""))) {
                        UnreadCountHelper.getInstance().pushUpdateCount(messageJson.optString("user_unique_key", ""), true);
                    }
                    if (HippoConfig.getInstance() != null && !HippoConfig.getInstance().isChannelActivity()) {
                        UnreadCountHelper.getInstance().addTotalPushUnread(messageJson.getInt("channel_id"));
                    }
                }
            }
            catch (Exception exception) {}
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel notificationChannel = new NotificationChannel(CHANNEL_ONE_ID, (CharSequence)CHANNEL_ONE_NAME, 4);
            AudioAttributes audioAttributes = new AudioAttributes.Builder().setContentType(4).setUsage(4).build();
            notificationChannel.setSound(RingtoneManager.getDefaultUri((int)2), audioAttributes);
            if (notificationManager != null) {
                notificationManager.createNotificationChannel(notificationChannel);
            }
        }
        HippoLog.e(TAG, "Creation at: " + new Date());
    }

    private int getPriority() {
        if (Build.VERSION.SDK_INT >= 24) {
            return 5;
        }
        return 2;
    }

    private void showUserNotification(Context context, Map<String, String> data) throws Exception {
        block26: {
            CommonData.setPushBoolean(true);
            if (CommonData.getConversationList() != null && CommonData.getConversationList().size() <= 0) {
                CommonData.setNotificationFirstClick(true);
            }
            try {
                int smallIconViewId;
                JSONObject messageJson = new JSONObject(data.get("message"));
                try {
                    if (CommonData.getVideoCallStatus() && messageJson.optInt("notification_type") == 14 && (messageJson.optString("video_call_type").equalsIgnoreCase("START_CALL") || messageJson.optString("video_call_type").equalsIgnoreCase("CALL_HUNG_UP"))) {
                        if (HippoConfig.getInstance().getCallData() != null) {
                            HippoConfig.getInstance().getCallData().onNotificationReceived(context, messageJson);
                        } else {
                            HippoConfig.getInstance().setCallListener(new CallData(){

                                @Override
                                public void onNotificationReceived(Context context, JSONObject data) {
                                }

                                @Override
                                public void networkStatus(int status) {
                                }

                                @Override
                                public void onCallClick(Context context, int callType, Long channelId, Long userId, boolean isAgentFlow, boolean isAllowCall, String fullname, String image) {
                                }

                                @Override
                                public void onExternalClick(Context context, String callType, Long userid, String otherUserName, String fuguPeerChatParams, String otherUserImageUrl) {
                                }
                            });
                        }
                        return;
                    }
                    if (messageJson.optInt("notification_type") == 14) {
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (Build.VERSION.SDK_INT >= 26) {
                    NotificationChannel notificationChannel = new NotificationChannel(CHANNEL_ONE_ID, (CharSequence)CHANNEL_ONE_NAME, 4);
                    if (notificationManager != null) {
                        notificationManager.createNotificationChannel(notificationChannel);
                    }
                }
                Intent mIntent = new Intent("notification_received");
                Bundle dataBundle = new Bundle();
                for (String key : data.keySet()) {
                    dataBundle.putString(key, data.get(key));
                }
                mIntent.putExtras(dataBundle);
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(mIntent);
                Paper.init((Context)context);
                long channelId = -1L;
                long labelId = -1L;
                int disableReply = messageJson.optInt("disable_reply", 0);
                String label = messageJson.optString("label", "");
                String title = messageJson.optString("title", "");
                String message = messageJson.optString("new_message", "");
                String removeLt = message.replaceAll("<", "&lt;");
                String removeGt = removeLt.replaceAll(">", "&gt;");
                String removeQuotes = removeGt.replaceAll("\"", "&quot;");
                message = removeQuotes.replaceAll("'", "&#39;");
                if (messageJson.has("channel_id")) {
                    channelId = messageJson.optLong("channel_id", -1L);
                }
                if (messageJson.has("label_id")) {
                    labelId = messageJson.optLong("label_id", -1L);
                }
                if (pushChannelId != null && channelId > 0L && pushChannelId.compareTo(channelId) == 0) {
                    return;
                }
                if (pushLabelId != null && labelId > 0L && pushLabelId.compareTo(labelId) == 0) {
                    return;
                }
                Intent notificationIntent = new Intent(context, FuguPushIntentService.class);
                notificationIntent.putExtra("channelId", channelId);
                notificationIntent.putExtra("en_user_id", CommonData.getUserDetails().getData().getEn_user_id());
                notificationIntent.putExtra("userId", (Serializable)CommonData.getUserDetails().getData().getUserId());
                notificationIntent.putExtra("labelId", labelId);
                notificationIntent.putExtra("label", label);
                notificationIntent.putExtra("disable_reply", disableReply);
                Bundle mBundle = new Bundle();
                for (String key : data.keySet()) {
                    mBundle.putString(key, data.get(key));
                }
                notificationIntent.putExtra("data", mBundle);
                if (CommonData.getPushFlags() != -1) {
                    notificationIntent.setFlags(CommonData.getPushFlags());
                }
                PendingIntent pi = PendingIntent.getService((Context)context, (int)((int)(new Date().getTime() / 1000L % Integer.MAX_VALUE)), (Intent)notificationIntent, (int)0);
                int notificationDefaults = -1;
                if (!this.notificationSoundEnabled) {
                    notificationDefaults = 4;
                }
                NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(context, CHANNEL_ONE_ID).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)Html.fromHtml((String)message))).setSmallIcon(this.smallIcon == -1 ? R.drawable.hippo_default_notif_icon : this.smallIcon).setLargeIcon(BitmapFactory.decodeResource((Resources)context.getResources(), (int)this.largeIcon)).setContentTitle((CharSequence)title).setContentText((CharSequence)Html.fromHtml((String)message)).setContentIntent(pi).setPriority(this.priority).setAutoCancel(true);
                mBuilder.setDefaults(notificationDefaults);
                mBuilder.setChannelId(CHANNEL_ONE_ID);
                Notification notification = mBuilder.build();
                if (Build.VERSION.SDK_INT >= 21 && (smallIconViewId = context.getResources().getIdentifier("right_icon", "id", "android")) != 0) {
                    if (notification.headsUpContentView != null) {
                        notification.headsUpContentView.setViewVisibility(smallIconViewId, 4);
                    }
                    if (notification.bigContentView != null) {
                        notification.bigContentView.setViewVisibility(smallIconViewId, 4);
                    }
                }
                notificationManager = (NotificationManager)context.getSystemService("notification");
                notificationManager.notify((int)(new Date().getTime() / 1000L % Integer.MAX_VALUE), notification);
                try {
                    if (HippoConfig.getInstance() == null || HippoConfig.getInstance().isChannelActivity() || (!messageJson.has("channel_id") || pushChannelId.compareTo(messageJson.getLong("channel_id")) == 0) && (!messageJson.has("label_id") || pushLabelId.compareTo(messageJson.getLong("label_id")) == 0)) break block26;
                    try {
                        long channelid = channelId;
                        long labelid = labelId;
                        this.addUnreadCount(channelid, labelid);
                    }
                    catch (Exception exception) {
                    }
                }
                catch (Exception exception) {}
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    private void addUnreadCount(Long channelId, Long labelId) {
        try {
            HippoLog.e(TAG, "In count");
            if (!HippoConfig.getInstance().isChannelActivity()) {
                int channelCount;
                ArrayList<UnreadCountModel> unreadCountModels;
                int i;
                int index = -1;
                if (channelId > 0L) {
                    index = CommonData.getUnreadCountModel().indexOf(new UnreadCountModel(channelId));
                } else if (labelId > 0L && CommonData.getUnreadCountModel() != null) {
                    ArrayList<UnreadCountModel> unreadCountModel = CommonData.getUnreadCountModel();
                    for (i = 0; i < unreadCountModel.size(); ++i) {
                        if (unreadCountModel.get(i).getLabelId().compareTo(labelId) != 0) continue;
                        index = i;
                        break;
                    }
                }
                HippoLog.v(TAG, "index = " + index);
                if (index > -1) {
                    unreadCountModels = CommonData.getUnreadCountModel();
                    HippoLog.v(TAG, "unreadCountModels = " + unreadCountModels.size());
                    HippoLog.v(TAG, "unreadCountModels.get(index).getCount() = " + unreadCountModels.get(index).getCount());
                    channelCount = unreadCountModels.get(index).getCount() + 1;
                    HippoLog.v(TAG, "channelCount = " + channelCount);
                    unreadCountModels.get(index).setCount(channelCount);
                    CommonData.setUnreadCount(new ArrayList<UnreadCountModel>());
                    CommonData.setUnreadCount(unreadCountModels);
                } else {
                    channelCount = 1;
                    UnreadCountModel countModel = new UnreadCountModel(channelId, labelId, channelCount);
                    unreadCountModels = CommonData.getUnreadCountModel();
                    HippoLog.v(TAG, "unreadCountModels = " + unreadCountModels.size());
                    unreadCountModels.add(countModel);
                    CommonData.setUnreadCount(unreadCountModels);
                }
                int count = 0;
                for (i = 0; i < unreadCountModels.size(); ++i) {
                    count += unreadCountModels.get(i).getCount();
                }
                HippoLog.v(TAG, "count = " + count);
                if (HippoConfig.getInstance().getCallbackListener() != null) {
                    HippoConfig.getInstance().getCallbackListener().count(count);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void clearNotifications(Context context, ArrayList<Integer> ids) {
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        if (ids != null && ids.size() > 0) {
            for (Integer integer : ids) {
                notificationManager.cancel(integer.intValue());
            }
        }
    }

    public static long getTimeMilliSec(String timeStamp) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        try {
            if (!TextUtils.isEmpty((CharSequence)timeStamp)) {
                Date date = format.parse(timeStamp);
                return date.getTime();
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return 0L;
    }
}

