/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.easypermissions;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import com.hippo.utils.easypermissions.AfterPermissionGranted;
import com.hippo.utils.easypermissions.PermissionRequest;
import com.hippo.utils.easypermissions.helper.PermissionHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class EasyPermissions {
    private static final String TAG = "EasyPermissions";

    public static boolean hasPermissions(@NonNull Context context, String ... perms) {
        if (Build.VERSION.SDK_INT < 23) {
            Log.w((String)TAG, (String)"hasPermissions: API version < M, returning true by default");
            return true;
        }
        if (context == null) {
            throw new IllegalArgumentException("Can't check permissions for null context");
        }
        for (String perm : perms) {
            if (ContextCompat.checkSelfPermission((Context)context, (String)perm) == 0) continue;
            return false;
        }
        return true;
    }

    public static void requestPermissions(@NonNull Activity host, @NonNull String rationale, int requestCode, String ... perms) {
        EasyPermissions.requestPermissions(new PermissionRequest.Builder(host, requestCode, perms).setRationale(rationale).build());
    }

    public static void requestPermissions(@NonNull Fragment host, @NonNull String rationale, int requestCode, String ... perms) {
        EasyPermissions.requestPermissions(new PermissionRequest.Builder(host, requestCode, perms).setRationale(rationale).build());
    }

    public static void requestPermissions(PermissionRequest request) {
        if (EasyPermissions.hasPermissions(request.getHelper().getContext(), request.getPerms())) {
            EasyPermissions.notifyAlreadyHasPermissions(request.getHelper().getHost(), request.getRequestCode(), request.getPerms());
            return;
        }
        request.getHelper().requestPermissions(request.getRationale(), request.getPositiveButtonText(), request.getNegativeButtonText(), request.getTheme(), request.getRequestCode(), request.getPerms());
    }

    public static void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults, Object ... receivers) {
        ArrayList<String> granted = new ArrayList<String>();
        ArrayList<String> denied = new ArrayList<String>();
        for (int i = 0; i < permissions.length; ++i) {
            String perm = permissions[i];
            if (grantResults[i] == 0) {
                granted.add(perm);
                continue;
            }
            denied.add(perm);
        }
        for (Object object : receivers) {
            if (!granted.isEmpty() && object instanceof PermissionCallbacks) {
                ((PermissionCallbacks)object).onPermissionsGranted(requestCode, granted);
            }
            if (!denied.isEmpty() && object instanceof PermissionCallbacks) {
                ((PermissionCallbacks)object).onPermissionsDenied(requestCode, denied);
            }
            if (granted.isEmpty() || !denied.isEmpty()) continue;
            EasyPermissions.runAnnotatedMethods(object, requestCode);
        }
    }

    public static boolean somePermissionPermanentlyDenied(@NonNull Activity host, @NonNull List<String> deniedPermissions) {
        return PermissionHelper.newInstance(host).somePermissionPermanentlyDenied(deniedPermissions);
    }

    public static boolean somePermissionPermanentlyDenied(@NonNull Fragment host, @NonNull List<String> deniedPermissions) {
        return PermissionHelper.newInstance(host).somePermissionPermanentlyDenied(deniedPermissions);
    }

    public static boolean permissionPermanentlyDenied(@NonNull Activity host, @NonNull String deniedPermission) {
        return PermissionHelper.newInstance(host).permissionPermanentlyDenied(deniedPermission);
    }

    public static boolean permissionPermanentlyDenied(@NonNull Fragment host, @NonNull String deniedPermission) {
        return PermissionHelper.newInstance(host).permissionPermanentlyDenied(deniedPermission);
    }

    public static boolean somePermissionDenied(@NonNull Activity host, String ... perms) {
        return PermissionHelper.newInstance(host).somePermissionDenied(perms);
    }

    public static boolean somePermissionDenied(@NonNull Fragment host, String ... perms) {
        return PermissionHelper.newInstance(host).somePermissionDenied(perms);
    }

    private static void notifyAlreadyHasPermissions(@NonNull Object object, int requestCode, @NonNull String[] perms) {
        int[] grantResults = new int[perms.length];
        for (int i = 0; i < perms.length; ++i) {
            grantResults[i] = 0;
        }
        EasyPermissions.onRequestPermissionsResult(requestCode, perms, grantResults, object);
    }

    private static void runAnnotatedMethods(@NonNull Object object, int requestCode) {
        Class<?> clazz = object.getClass();
        if (EasyPermissions.isUsingAndroidAnnotations(object)) {
            clazz = clazz.getSuperclass();
        }
        while (clazz != null) {
            for (Method method : clazz.getDeclaredMethods()) {
                AfterPermissionGranted ann = method.getAnnotation(AfterPermissionGranted.class);
                if (ann == null || ann.value() != requestCode) continue;
                if (method.getParameterTypes().length > 0) {
                    throw new RuntimeException("Cannot execute method " + method.getName() + " because it is non-void method and/or has input parameters.");
                }
                try {
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    method.invoke(object, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    Log.e((String)TAG, (String)"runDefaultMethod:IllegalAccessException", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    Log.e((String)TAG, (String)"runDefaultMethod:InvocationTargetException", (Throwable)e);
                }
            }
            clazz = clazz.getSuperclass();
        }
    }

    private static boolean isUsingAndroidAnnotations(@NonNull Object object) {
        if (!object.getClass().getSimpleName().endsWith("_")) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName("org.androidannotations.api.view.HasViews");
            return clazz.isInstance(object);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static interface RationaleCallbacks {
        public void onRationaleAccepted(int var1);

        public void onRationaleDenied(int var1);
    }

    public static interface PermissionCallbacks
    extends ActivityCompat.OnRequestPermissionsResultCallback {
        public void onPermissionsGranted(int var1, @NonNull List<String> var2);

        public void onPermissionsDenied(int var1, @NonNull List<String> var2);
    }
}

