/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.os.SystemClock;
import android.util.Patterns;
import java.util.regex.Pattern;

public class Utils {
    private static final int MULTIPLE_CLICK_THRESHOLD = 2500;
    private static long mLastClickTime = 0L;

    public static boolean isNumeric(String value) {
        if (value == null) {
            return false;
        }
        return Pattern.matches("-?\\d+(\\.\\d+)?", value);
    }

    public static boolean isEmailValid(String email) {
        if (email == null) {
            return false;
        }
        return Patterns.EMAIL_ADDRESS.matcher(email).matches();
    }

    public static final boolean isValidPhoneNumber(CharSequence target) {
        if (target == null) {
            return false;
        }
        if (target.length() < 6 || target.length() > 17) {
            return false;
        }
        return Patterns.PHONE.matcher(target).matches();
    }

    public static boolean preventMultipleClicks() {
        if (SystemClock.elapsedRealtime() - mLastClickTime < 2500L) {
            return false;
        }
        mLastClickTime = SystemClock.elapsedRealtime();
        return true;
    }

    public static Bitmap getCircleBitmap(Bitmap bitmap) {
        Bitmap output = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        int color2 = -65536;
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        RectF rectF = new RectF(rect);
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-65536);
        canvas.drawOval(rectF, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);
        bitmap.recycle();
        return output;
    }
}

