/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.support.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.Toolbar;
import com.google.gson.Gson;
import com.hippo.ChatByUniqueIdAttributes;
import com.hippo.HippoColorConfig;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.database.CommonData;
import com.hippo.support.Utils.Constants;
import com.hippo.support.Utils.SupportKeys;
import com.hippo.support.callback.OnActionTypeCallback;
import com.hippo.support.callback.SupportDetailPresenter;
import com.hippo.support.callback.SupportDetailView;
import com.hippo.support.fragment.BaseFragment;
import com.hippo.support.logicImplView.HippoSupportDetailInterImpl;
import com.hippo.support.logicImplView.HippoSupportDetailView;
import com.hippo.support.model.Category;
import com.hippo.support.model.Content;
import com.hippo.support.model.Item;
import com.hippo.support.model.callbackModel.OpenChatParams;
import com.hippo.support.model.callbackModel.SendQueryChat;
import com.hippo.utils.HippoLog;
import java.util.ArrayList;

public class HippoSupportDetailFragment
extends BaseFragment
implements View.OnClickListener,
SupportDetailView {
    private static final String TAG = HippoSupportDetailFragment.class.getSimpleName();
    private View rootView;
    private Toolbar toolbar;
    private TextView header;
    private TextView description;
    private TextView errorView;
    private EditText descriptionBox;
    private Button submit;
    private Button callBtn;
    private Button chatBtn;
    private SupportDetailPresenter supportDetailView;
    private OnActionTypeCallback typeCallback;
    private ArrayList<String> pathList;
    private String transactionId;
    private String message = "";
    private Gson gson;
    private Item supportResponses;
    private Category category;
    private HippoColorConfig hippoColorConfig;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.gson = new Gson();
        if (this.getArguments() != null) {
            if (this.getArguments().containsKey("default_support")) {
                this.supportResponses = (Item)this.gson.fromJson(this.getArguments().getString("default_support"), Item.class);
            }
            if (this.getArguments().containsKey("support_path")) {
                this.pathList = (ArrayList)this.gson.fromJson(this.getArguments().getString("support_path"), ArrayList.class);
            }
            if (this.getArguments().containsKey("support_transaction_id")) {
                this.transactionId = this.getArguments().getString("support_transaction_id");
            }
            if (this.getArguments().containsKey("support_category_data")) {
                this.category = (Category)this.gson.fromJson(this.getArguments().getString("support_category_data"), Category.class);
            }
            HippoLog.d(TAG, "transactionId = " + this.transactionId);
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.rootView = inflater.inflate(R.layout.fugu_support_detail, container, false);
        return this.rootView;
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.initView();
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.typeCallback = (OnActionTypeCallback)context;
    }

    public void onDetach() {
        super.onDetach();
        if (this.typeCallback != null) {
            this.typeCallback = null;
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.supportDetailView != null) {
            this.supportDetailView.onDestroy();
        }
    }

    private void initView() {
        this.toolbar = (Toolbar)this.rootView.findViewById(R.id.my_toolbar);
        this.header = (TextView)this.rootView.findViewById(R.id.textViewSubtitle);
        this.description = (TextView)this.rootView.findViewById(R.id.textViewDescription);
        this.errorView = (TextView)this.rootView.findViewById(R.id.textViewRSOtherError);
        this.descriptionBox = (EditText)this.rootView.findViewById(R.id.editTextMessage);
        this.descriptionBox.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (v.getId() == R.id.editTextMessage) {
                    v.getParent().requestDisallowInterceptTouchEvent(true);
                    switch (event.getAction() & 0xFF) {
                        case 1: {
                            v.getParent().requestDisallowInterceptTouchEvent(false);
                        }
                    }
                }
                return false;
            }
        });
        this.submit = (Button)this.rootView.findViewById(R.id.buttonSubmit);
        this.callBtn = (Button)this.rootView.findViewById(R.id.buttonCall);
        this.chatBtn = (Button)this.rootView.findViewById(R.id.buttonChat);
        this.setData();
        this.setConfigColor();
        this.submit.setOnClickListener((View.OnClickListener)this);
        this.callBtn.setOnClickListener((View.OnClickListener)this);
        this.chatBtn.setOnClickListener((View.OnClickListener)this);
        this.supportDetailView = new HippoSupportDetailView((Activity)this.getActivity(), this, new HippoSupportDetailInterImpl());
        try {
            this.setupUI(this.rootView);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setConfigColor() {
        this.hippoColorConfig = CommonData.getColorConfig();
        this.header.setTextColor(this.hippoColorConfig.getHippoTextColorPrimary());
        this.description.setTextColor(this.hippoColorConfig.getHippoFaqDescription());
        this.descriptionBox.setHintTextColor(this.hippoColorConfig.getHippoTypeMessageHint());
        this.descriptionBox.setTextColor(this.hippoColorConfig.getHippoTypeMessageText());
        this.submit.setTextColor(this.hippoColorConfig.getHippoActionBarText());
        this.callBtn.setTextColor(this.hippoColorConfig.getHippoActionBarText());
        this.chatBtn.setTextColor(this.hippoColorConfig.getHippoActionBarText());
        float radius = Constants.convertDpToPixel(5.0f);
        if (Build.VERSION.SDK_INT >= 16) {
            this.submit.setBackground((Drawable)HippoColorConfig.makeRoundedSelector(this.hippoColorConfig.getHippoActionBarBg(), radius));
            this.callBtn.setBackground((Drawable)HippoColorConfig.makeRoundedSelector(this.hippoColorConfig.getHippoActionBarBg(), radius));
            this.chatBtn.setBackground((Drawable)HippoColorConfig.makeRoundedSelector(this.hippoColorConfig.getHippoActionBarBg(), radius));
        } else {
            this.submit.setBackgroundDrawable((Drawable)HippoColorConfig.makeRoundedSelector(this.hippoColorConfig.getHippoActionBarBg(), radius));
            this.callBtn.setBackgroundDrawable((Drawable)HippoColorConfig.makeRoundedSelector(this.hippoColorConfig.getHippoActionBarBg(), radius));
            this.chatBtn.setBackgroundDrawable((Drawable)HippoColorConfig.makeRoundedSelector(this.hippoColorConfig.getHippoActionBarBg(), radius));
        }
    }

    private void setData() {
        this.setToolbar(this.toolbar, this.supportResponses.getTitle());
        Content content = this.supportResponses.getContent();
        if (content != null) {
            if (content.getSubHeading() == null || TextUtils.isEmpty((CharSequence)content.getSubHeading().getText())) {
                this.header.setVisibility(8);
            } else {
                this.header.setText((CharSequence)content.getSubHeading().getText());
                this.header.setVisibility(0);
            }
            if (content.getDescription() == null || TextUtils.isEmpty((CharSequence)content.getDescription().getText())) {
                this.description.setVisibility(8);
            } else {
                this.description.setText((CharSequence)content.getDescription().getText());
                this.description.setVisibility(0);
            }
            if (content.getQueryForm() == null || content.getQueryForm().getTextView() == null) {
                this.descriptionBox.setVisibility(8);
            } else {
                if (!TextUtils.isEmpty((CharSequence)content.getQueryForm().getTextView().getText())) {
                    this.descriptionBox.setText((CharSequence)content.getQueryForm().getTextView().getText());
                }
                this.descriptionBox.setVisibility(0);
            }
            if (content.getSubmitButton() == null || TextUtils.isEmpty((CharSequence)content.getSubmitButton().getText())) {
                this.submit.setVisibility(8);
            } else {
                this.submit.setTag((Object)content.getSubmitButton().getSucessMessage());
                this.submit.setText((CharSequence)content.getSubmitButton().getText());
                this.submit.setVisibility(0);
            }
            if (content.getCallButton() == null || TextUtils.isEmpty((CharSequence)content.getCallButton().getPhone())) {
                this.callBtn.setVisibility(8);
            } else {
                this.callBtn.setText((CharSequence)content.getCallButton().getText());
                this.callBtn.setVisibility(0);
            }
            if (content.getChatButton() == null || TextUtils.isEmpty((CharSequence)content.getChatButton().getText())) {
                this.chatBtn.setVisibility(8);
            } else {
                this.chatBtn.setText((CharSequence)content.getChatButton().getText());
                this.chatBtn.setVisibility(0);
            }
        }
        this.pathList = CommonData.getPathList();
        this.pathList.add(this.supportResponses.getTitle());
        CommonData.setSupportPath(this.pathList);
    }

    private void openCallIntent(Activity activity, String phoneNumber) {
        try {
            Intent callIntent = new Intent("android.intent.action.VIEW");
            callIntent.setData(Uri.parse((String)("tel:" + phoneNumber)));
            activity.startActivity(callIntent);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showError();
        }
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.buttonSubmit) {
            String successMsg;
            this.message = null;
            if (this.descriptionBox.getVisibility() == 0 && !TextUtils.isEmpty((CharSequence)this.descriptionBox.getText().toString().trim())) {
                this.message = this.descriptionBox.getText().toString().trim();
            }
            successMsg = TextUtils.isEmpty((CharSequence)(successMsg = (String)this.submit.getTag())) ? this.getActivity().getString(R.string.hippo_message_sucessfully) : successMsg;
            SendQueryChat queryChat = new SendQueryChat(SupportKeys.SupportQueryType.QUERY, this.category, this.transactionId, CommonData.getUserUniqueKey(), this.supportResponses.getSupportId(), this.pathList, this.message, successMsg);
            if (this.supportResponses.getContent().getSubHeading() != null && this.supportResponses.getContent().getSubHeading().getText() != null) {
                queryChat.setSubHeader(this.supportResponses.getContent().getSubHeading().getText());
            }
            this.supportDetailView.sendQuery(queryChat);
        } else if (id2 == R.id.buttonChat) {
            SendQueryChat queryChat = new SendQueryChat(SupportKeys.SupportQueryType.CHAT, this.category, this.transactionId, CommonData.getUserUniqueKey(), this.supportResponses.getSupportId(), this.pathList);
            if (this.supportResponses.getContent().getSubHeading() != null && this.supportResponses.getContent().getSubHeading().getText() != null) {
                queryChat.setSubHeader(this.supportResponses.getContent().getSubHeading().getText());
            }
            this.supportDetailView.sendQuery(queryChat);
        } else if (id2 == R.id.buttonCall) {
            this.openCallIntent((Activity)this.getActivity(), this.supportResponses.getContent().getCallButton().getPhone());
        }
    }

    @Override
    public void showProgress() {
    }

    @Override
    public void hideProgress() {
    }

    @Override
    public void openChat(OpenChatParams chatParams) {
        ChatByUniqueIdAttributes attributes = new ChatByUniqueIdAttributes.Builder().setTransactionId(chatParams.getTransactionId()).setUserUniqueKey(chatParams.getUserUniqueKey()).setChannelName(chatParams.getChannelName()).setTags(chatParams.getTagsList()).setMessage(chatParams.getData()).setSupportTicket(true).setCustomAttributes(chatParams.getCustomAttributes()).build();
        HippoConfig.getInstance().openChatByUniqueId(attributes);
    }

    @Override
    public void sucessfull() {
        this.typeCallback.removeFragment();
    }

    @Override
    public void showError() {
        Toast.makeText((Context)this.getActivity(), (CharSequence)"Something went wrong. Please try again", (int)0).show();
    }
}

