/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.campaign;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.appcompat.widget.Toolbar;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.google.gson.Gson;
import com.hippo.HippoConfig;
import com.hippo.MobileCampaignBuilder;
import com.hippo.NotificationListener;
import com.hippo.R;
import com.hippo.activity.FuguBaseActivity;
import com.hippo.adapter.CampaignAdapter;
import com.hippo.apis.ApiGetMobileNotification;
import com.hippo.database.CommonData;
import com.hippo.interfaces.OnItemClickListener;
import com.hippo.model.promotional.Data;
import com.hippo.model.promotional.PromotionResponse;
import com.hippo.utils.filepicker.ToastUtil;
import java.util.ArrayList;

public class CampaignActivity
extends FuguBaseActivity
implements OnItemClickListener,
SwipeRefreshLayout.OnRefreshListener {
    private SwipeRefreshLayout refreshLayout;
    private RecyclerView recyclerView;
    private CampaignAdapter campaignAdapter;
    private MobileCampaignBuilder campaignBuilder;
    private int startOffset = 0;
    private int offset = 19;
    private int endOffset;
    private ArrayList<Data> arrayList = new ArrayList();
    private LinearLayoutManager layoutManager;
    private int pastVisiblesItems;
    private int visibleItemCount;
    private int totalItemCount;
    private boolean hasMorePages;
    private boolean isPagingApiInProgress;
    private LinearLayout llNoConversation;
    private TextView titleError;
    private TextView detailError;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.hippo_campaigns_layout);
        this.campaignBuilder = HippoConfig.getInstance().getMobileCampaignBuilder();
        Toolbar myToolbar = (Toolbar)this.findViewById(R.id.my_toolbar);
        this.setSupportActionBar(myToolbar);
        String title = this.campaignBuilder.getmTitle();
        if (TextUtils.isEmpty((CharSequence)title)) {
            title = CommonData.getChatTitle();
        }
        this.setToolbar(myToolbar, title);
        this.endOffset = this.startOffset + this.offset;
        this.refreshLayout = (SwipeRefreshLayout)this.findViewById(R.id.swipe_refresh);
        this.refreshLayout.setOnRefreshListener((SwipeRefreshLayout.OnRefreshListener)this);
        this.refreshLayout.setColorSchemeResources(new int[]{R.color.hippo_white});
        this.refreshLayout.setProgressBackgroundColorSchemeResource(R.color.fugu_theme_color_primary);
        this.refreshLayout.setSize(1);
        this.titleError = (TextView)this.findViewById(R.id.title_error);
        this.detailError = (TextView)this.findViewById(R.id.detail_error);
        this.titleError.setText((CharSequence)"No Message Found");
        this.detailError.setText((CharSequence)"Currently no message available");
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recyclerView);
        this.layoutManager = new LinearLayoutManager((Context)this);
        this.layoutManager.setOrientation(1);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        int layoutId = 0;
        if (this.campaignBuilder != null && this.campaignBuilder.getmLayout() > 0) {
            layoutId = this.campaignBuilder.getmLayout();
        }
        this.campaignAdapter = new CampaignAdapter(layoutId, null, this.recyclerView, this);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.campaignAdapter);
        this.llNoConversation = (LinearLayout)this.findViewById(R.id.llNoConversation);
        this.fetchData();
        this.recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (dy > 0) {
                    CampaignActivity.this.visibleItemCount = CampaignActivity.this.layoutManager.getChildCount();
                    CampaignActivity.this.totalItemCount = CampaignActivity.this.layoutManager.getItemCount();
                    CampaignActivity.this.pastVisiblesItems = CampaignActivity.this.layoutManager.findFirstVisibleItemPosition();
                    if (!CampaignActivity.this.isPagingApiInProgress && CampaignActivity.this.hasMorePages && CampaignActivity.this.visibleItemCount + CampaignActivity.this.pastVisiblesItems >= CampaignActivity.this.totalItemCount) {
                        CampaignActivity.this.startOffset = CampaignActivity.this.endOffset + 1;
                        CampaignActivity.this.endOffset = CampaignActivity.this.startOffset + CampaignActivity.this.offset;
                        CampaignActivity.this.fetchData();
                    }
                }
            }
        });
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    @Override
    protected void onPause() {
        super.onPause();
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    public void onRefresh() {
        if (this.isNetworkAvailable()) {
            this.startOffset = 0;
            this.endOffset = this.startOffset + this.offset;
            this.fetchData();
        } else {
            this.refreshLayout.setRefreshing(false);
        }
    }

    private void fetchData() {
        if (this.isNetworkAvailable()) {
            if (this.startOffset != 0) {
                this.isPagingApiInProgress = true;
                this.campaignAdapter.showPaginationProgressBar(true, true);
            }
            new ApiGetMobileNotification((Activity)this, new NotificationListener(){

                @Override
                public void onSucessListener(PromotionResponse response) {
                    try {
                        if (CampaignActivity.this.arrayList == null) {
                            CampaignActivity.this.arrayList = new ArrayList();
                        }
                        if (CampaignActivity.this.startOffset == 0) {
                            CampaignActivity.this.arrayList.clear();
                        }
                        if (CampaignActivity.this.startOffset != 0) {
                            CampaignActivity.this.isPagingApiInProgress = false;
                            CampaignActivity.this.campaignAdapter.showPaginationProgressBar(false, true);
                        }
                        CampaignActivity.this.arrayList.addAll(response.getData());
                        if (CampaignActivity.this.arrayList.size() == 0) {
                            CampaignActivity.this.llNoConversation.setVisibility(0);
                        } else {
                            CampaignActivity.this.llNoConversation.setVisibility(8);
                        }
                        if (CampaignActivity.this.campaignAdapter != null) {
                            CampaignActivity.this.campaignAdapter.setData(CampaignActivity.this.arrayList);
                        }
                        CampaignActivity.this.refreshLayout.setRefreshing(false);
                        CampaignActivity.this.hasMorePages = response.getData().size() == CampaignActivity.this.offset;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void onFailureListener() {
                    CampaignActivity.this.refreshLayout.setRefreshing(false);
                    if (CampaignActivity.this.startOffset != 0) {
                        CampaignActivity.this.isPagingApiInProgress = false;
                        CampaignActivity.this.campaignAdapter.showPaginationProgressBar(false, true);
                    }
                }

                @Override
                public void onItemClickListener(String url) {
                }
            }).getNotificationData(this.startOffset, this.endOffset);
        } else {
            ToastUtil.getInstance((Context)this).showToast(R.string.fugu_not_connected_to_internet);
            this.refreshLayout.setRefreshing(false);
            if (this.startOffset != 0) {
                this.isPagingApiInProgress = false;
                this.campaignAdapter.showPaginationProgressBar(false, true);
            }
        }
    }

    @Override
    public void onLoadMore() {
    }

    @Override
    public void onClickListener(int position) {
        try {
            if (this.campaignBuilder != null && this.campaignBuilder.getListener() != null) {
                String data = new Gson().toJson((Object)this.arrayList.get(position).getCustomAttributes());
                this.campaignBuilder.getListener().onItemClickListener(data);
                if (this.campaignBuilder != null) {
                    if (this.campaignBuilder.isCloseActivityOnClick()) {
                        this.finish();
                    } else if (this.campaignBuilder.isCloseOnlyDeepLink() && !TextUtils.isEmpty((CharSequence)this.arrayList.get(position).getCustomAttributes().getDeeplink())) {
                        this.finish();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

