/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.agent.fragment;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.google.gson.Gson;
import com.hippo.HippoColorConfig;
import com.hippo.R;
import com.hippo.agent.AgentBroadcastActivity;
import com.hippo.agent.database.AgentCommonData;
import com.hippo.agent.fragment.BaseFragment;
import com.hippo.agent.fragment.BroadcastFilterList;
import com.hippo.agent.fragment.BroadcastStatusFragment;
import com.hippo.agent.helper.BroadcastListenerHelper;
import com.hippo.agent.listeners.BroadcastListener;
import com.hippo.agent.model.LoginModel.UserData;
import com.hippo.agent.model.broadcastResponse.BroadcastModel;
import com.hippo.agent.model.broadcastResponse.Tag;
import com.hippo.agent.model.broadcastResponse.User;
import com.hippo.agent.model.broadcastStatus.BroadcastResponseModel;
import com.hippo.database.CommonData;
import com.hippo.retrofit.CommonParams;
import com.hippo.utils.loadingBox.LoadingBox;
import java.util.ArrayList;

public class BroadcastFragment
extends BaseFragment
implements BroadcastListener.BroadcastResponse {
    private static final String TAG = BroadcastFragment.class.getSimpleName();
    private BroadcastListener broadcastListener;
    private UserData userData;
    private ArrayList<Tag> pairBoolData = new ArrayList();
    private ArrayList<User> pairFleetData = new ArrayList();
    private ArrayList<User> finalFleetData = new ArrayList();
    private BroadcastModel broadcastModel;
    private Button sendBtn;
    private TextView broadcastStatus;
    private TextView titleView;
    private TextView titleInfo;
    private TextView selectTeamsView;
    private TextView selectFleetsView;
    private TextView showFleetsView;
    private EditText edTitleView;
    private EditText edMessageView;
    private LinearLayout selectedTeamsLayout;
    private LinearLayout selectedFleetsLayout;
    private LinearLayout showFleetsLayout;
    private AgentBroadcastActivity activity;
    private BroadcastFilterList filterList;
    private HippoColorConfig hippoColorConfig;
    private int teamId = -2;
    private String teamName = "";

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fugu_broadcast_fragment, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.broadcastListener = new BroadcastListenerHelper();
        this.activity = (AgentBroadcastActivity)this.getActivity();
        this.activity.updateToolBar("Broadcast Message");
        this.hippoColorConfig = CommonData.getColorConfig();
        if (this.userData == null) {
            this.userData = AgentCommonData.getUserData();
        }
        String accessToken = this.userData.getAccessToken();
        CommonParams commonParams = new CommonParams.Builder().add("access_token", accessToken).build();
        this.broadcastListener.getGroupingList(commonParams.getMap(), this);
        this.titleView = (TextView)view.findViewById(R.id.title_view);
        this.titleInfo = (TextView)view.findViewById(R.id.title_view_info);
        this.selectTeamsView = (TextView)view.findViewById(R.id.select_teams_view);
        this.selectFleetsView = (TextView)view.findViewById(R.id.select_fleets_view);
        this.showFleetsView = (TextView)view.findViewById(R.id.show_fleets_view);
        this.edTitleView = (EditText)view.findViewById(R.id.ed_title_view);
        this.edMessageView = (EditText)view.findViewById(R.id.ed_message_view);
        this.sendBtn = (Button)view.findViewById(R.id.sendBtn);
        this.selectedTeamsLayout = (LinearLayout)view.findViewById(R.id.selected_teams_layout);
        this.selectedFleetsLayout = (LinearLayout)view.findViewById(R.id.selected_fleets_layout);
        this.showFleetsLayout = (LinearLayout)view.findViewById(R.id.show_fleets_layout);
        this.broadcastStatus = (TextView)view.findViewById(R.id.broadcastStatus);
        this.setTextViews();
        this.setSpinnerColor(1);
        this.edMessageView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (v.getId() == R.id.ed_message_view) {
                    v.getParent().requestDisallowInterceptTouchEvent(true);
                    switch (event.getAction() & 0xFF) {
                        case 1: {
                            v.getParent().requestDisallowInterceptTouchEvent(false);
                        }
                    }
                }
                return false;
            }
        });
        this.broadcastStatus.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BroadcastFragment.this.openBroadcastStatus();
            }
        });
        this.sendBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (BroadcastFragment.this.finalFleetData == null || BroadcastFragment.this.finalFleetData.size() == 0) {
                    Toast.makeText((Context)BroadcastFragment.this.getActivity(), (CharSequence)("Please select " + BroadcastFragment.this.getString(R.string.hippo_display_name_for_customers)), (int)0).show();
                } else if (TextUtils.isEmpty((CharSequence)BroadcastFragment.this.edTitleView.getText().toString().trim())) {
                    Toast.makeText((Context)BroadcastFragment.this.getActivity(), (CharSequence)(BroadcastFragment.this.getString(R.string.hippo_title_string) + " can't be empty"), (int)0).show();
                } else if (TextUtils.isEmpty((CharSequence)BroadcastFragment.this.edMessageView.getText().toString().trim())) {
                    Toast.makeText((Context)BroadcastFragment.this.getActivity(), (CharSequence)(BroadcastFragment.this.getString(R.string.hippo_message_string) + " can't be empty"), (int)0).show();
                } else {
                    LoadingBox.showOn((Activity)BroadcastFragment.this.getActivity());
                    BroadcastFragment.this.sendingBroadcastMessages();
                }
            }
        });
        this.selectedTeamsLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BroadcastFragment.this.hideKeyboard(BroadcastFragment.this.edTitleView);
                BroadcastFilterList broadcastFilterList = new BroadcastFilterList();
                Bundle bundle = new Bundle();
                bundle.putString("data", new Gson().toJson((Object)BroadcastFragment.this.pairBoolData));
                bundle.putInt("fragment_type", 1);
                bundle.putString("title", BroadcastFragment.this.getString(R.string.hippo_select_teams_string));
                broadcastFilterList.setArguments(bundle);
                BroadcastFragment.this.getActivity().getSupportFragmentManager().beginTransaction().add(R.id.main_layout, (Fragment)broadcastFilterList, BroadcastFilterList.class.getName()).addToBackStack(BroadcastFilterList.class.getName()).hide(BroadcastFragment.this.getActivity().getSupportFragmentManager().findFragmentByTag(BroadcastFragment.this.getActivity().getSupportFragmentManager().getBackStackEntryAt(BroadcastFragment.this.getActivity().getSupportFragmentManager().getBackStackEntryCount() - 1).getName())).commitAllowingStateLoss();
            }
        });
        this.selectedFleetsLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BroadcastFragment.this.hideKeyboard(BroadcastFragment.this.edTitleView);
                BroadcastFilterList broadcastFilterList = new BroadcastFilterList();
                Bundle bundle = new Bundle();
                bundle.putString("data", new Gson().toJson((Object)BroadcastFragment.this.pairFleetData));
                bundle.putInt("fragment_type", 2);
                bundle.putString("team_name", BroadcastFragment.this.teamName);
                bundle.putString("title", BroadcastFragment.this.getString(R.string.hippo_select_string) + " " + BroadcastFragment.this.getString(R.string.hippo_display_name_for_customers));
                broadcastFilterList.setArguments(bundle);
                BroadcastFragment.this.getActivity().getSupportFragmentManager().beginTransaction().add(R.id.main_layout, (Fragment)broadcastFilterList, BroadcastFilterList.class.getName()).addToBackStack(BroadcastFilterList.class.getName()).hide(BroadcastFragment.this.getActivity().getSupportFragmentManager().findFragmentByTag(BroadcastFragment.this.getActivity().getSupportFragmentManager().getBackStackEntryAt(BroadcastFragment.this.getActivity().getSupportFragmentManager().getBackStackEntryCount() - 1).getName())).commitAllowingStateLoss();
            }
        });
        this.showFleetsLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BroadcastFragment.this.hideKeyboard(BroadcastFragment.this.edTitleView);
                BroadcastFilterList broadcastFilterList = new BroadcastFilterList();
                Bundle bundle = new Bundle();
                bundle.putString("data", new Gson().toJson((Object)BroadcastFragment.this.finalFleetData));
                bundle.putInt("fragment_type", 3);
                bundle.putString("title", BroadcastFragment.this.getString(R.string.hippo_selected_string) + " " + BroadcastFragment.this.getString(R.string.hippo_display_name_for_customers));
                broadcastFilterList.setArguments(bundle);
                BroadcastFragment.this.getActivity().getSupportFragmentManager().beginTransaction().add(R.id.main_layout, (Fragment)broadcastFilterList, BroadcastFilterList.class.getName()).addToBackStack(BroadcastFilterList.class.getName()).hide(BroadcastFragment.this.getActivity().getSupportFragmentManager().findFragmentByTag(BroadcastFragment.this.getActivity().getSupportFragmentManager().getBackStackEntryAt(BroadcastFragment.this.getActivity().getSupportFragmentManager().getBackStackEntryCount() - 1).getName())).commitAllowingStateLoss();
            }
        });
        this.activity.getWindow().setSoftInputMode(35);
    }

    private void setTextViews() {
        this.titleView.setText((CharSequence)String.format("%s %s", this.getString(R.string.hippo_broadcast_title), this.getString(R.string.hippo_display_name_for_customers)));
        this.titleInfo.setText((CharSequence)this.getString(R.string.hippo_broadcast_title_info));
        this.selectTeamsView.setText((CharSequence)this.getString(R.string.hippo_select_teams_string));
        this.setShowValue(0);
        this.edTitleView.setHint((CharSequence)this.getString(R.string.hippo_title_string));
        this.edMessageView.setHint((CharSequence)this.getString(R.string.hippo_message_string));
        this.sendBtn.setText((CharSequence)this.getString(R.string.hippo_send_button));
        this.broadcastStatus.setText((CharSequence)this.getString(R.string.hippo_see_previous_messges));
    }

    private void setShowValue(int count) {
        this.showFleetsView.setText((CharSequence)(this.getString(R.string.hippo_show_string) + " " + this.getString(R.string.hippo_display_name_for_customers) + "(" + count + " " + this.getString(R.string.hippo_selected_string) + ")"));
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.broadcastListener = null;
    }

    public void onResume() {
        super.onResume();
    }

    public void onHiddenChanged(boolean hidden) {
        super.onHiddenChanged(hidden);
        if (!hidden) {
            this.activity.updateToolBar("Broadcast Message");
        }
    }

    private void setSpinnerColor(int pos) {
        switch (pos) {
            case 1: {
                this.showFleetsView.setTextColor(Color.parseColor((String)"#882c2333"));
                this.selectFleetsView.setTextColor(Color.parseColor((String)"#882c2333"));
                this.selectedFleetsLayout.setClickable(false);
                this.selectedFleetsLayout.setEnabled(false);
                this.showFleetsLayout.setClickable(false);
                this.showFleetsLayout.setEnabled(false);
                break;
            }
            case 2: {
                this.selectFleetsView.setTextColor(this.hippoColorConfig.getHippoTextColorPrimary());
                this.showFleetsView.setTextColor(Color.parseColor((String)"#882c2333"));
                this.selectedFleetsLayout.setClickable(true);
                this.selectedFleetsLayout.setEnabled(true);
                this.showFleetsLayout.setClickable(false);
                this.showFleetsLayout.setEnabled(false);
                break;
            }
            case 3: {
                this.showFleetsView.setTextColor(this.hippoColorConfig.getHippoTextColorPrimary());
                this.showFleetsLayout.setClickable(true);
                this.showFleetsLayout.setEnabled(true);
                break;
            }
            case 4: {
                this.showFleetsView.setTextColor(Color.parseColor((String)"#882c2333"));
                this.showFleetsLayout.setClickable(false);
                this.showFleetsLayout.setEnabled(false);
                break;
            }
        }
    }

    @Override
    public void groupingResponse(BroadcastModel broadcastModel) {
        LoadingBox.hide();
        this.broadcastModel = broadcastModel;
        Tag tag = new Tag();
        tag.setTagId(-1);
        tag.setSelected(false);
        tag.setTagName(this.getString(R.string.hippo_all_team));
        this.pairBoolData.add(tag);
        for (Tag tag1 : broadcastModel.getData().getTags()) {
            if (tag1.getUsers() == null || tag1.getUsers().size() <= 0) continue;
            this.pairBoolData.add(tag1);
        }
    }

    @Override
    public void sendBroadcastResponse(BroadcastResponseModel responseModel) {
        LoadingBox.hide();
        Toast.makeText((Context)this.activity, (CharSequence)("" + responseModel.getMessage()), (int)0).show();
        this.activity.finish();
    }

    @Override
    public void broadcastListResponse(BroadcastResponseModel responseModel) {
    }

    @Override
    public void broadcastStatusResponse(BroadcastResponseModel responseModel) {
    }

    @Override
    public void onFailure(int type, String errorMessage) {
        LoadingBox.hide();
        Toast.makeText((Context)this.getActivity(), (CharSequence)errorMessage, (int)0).show();
        switch (type) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
        }
    }

    public void selectedTeam(int id2, Tag tag) {
        this.teamId = id2;
        this.selectedFleetsLayout.setEnabled(true);
        this.selectedFleetsLayout.setClickable(true);
        this.selectFleetsView.setText((CharSequence)String.format("%s %s", this.getString(R.string.hippo_select_string), this.getString(R.string.hippo_display_name_for_customers)));
        if (this.finalFleetData == null) {
            this.finalFleetData = new ArrayList();
        }
        this.finalFleetData.clear();
        if (this.teamId == -1) {
            for (int i = 1; i < this.pairBoolData.size(); ++i) {
                this.finalFleetData.addAll(this.pairBoolData.get(i).getUsers());
                this.pairBoolData.get(i).setSelected(true);
            }
            this.pairBoolData.get(0).setSelected(true);
            this.selectedFleetsLayout.setClickable(false);
            this.selectedFleetsLayout.setEnabled(false);
            this.showFleetsLayout.setEnabled(true);
            this.showFleetsLayout.setClickable(true);
            this.setSpinnerColor(3);
            this.setShowValue(this.finalFleetData.size());
            this.teamName = this.getString(R.string.hippo_all_team);
            this.selectTeamsView.setText((CharSequence)this.getString(R.string.hippo_all_team));
            this.selectFleetsView.setText((CharSequence)String.format("%s %s %s", this.getString(R.string.hippo_all_agents), this.getString(R.string.hippo_display_name_for_customers), this.getString(R.string.hippo_selected_string)));
        } else if (this.teamId > -1) {
            this.pairFleetData.clear();
            User user = new User();
            user.setUserId(-1);
            user.setFullName(this.getString(R.string.hippo_all_agents) + " " + this.getString(R.string.hippo_display_name_for_customers));
            if (id2 == -1) {
                user.setSelected(true);
            }
            this.pairFleetData.add(user);
            this.pairBoolData.get(0).setSelected(false);
            this.pairFleetData.addAll(tag.getUsers());
            for (int i = 1; i < this.pairBoolData.size(); ++i) {
                if (id2 == this.pairBoolData.get(i).getTagId()) {
                    this.pairBoolData.get(i).setSelected(true);
                    continue;
                }
                this.pairBoolData.get(i).setSelected(false);
            }
            this.setSpinnerColor(2);
            this.teamName = tag.getTagName();
            this.selectTeamsView.setText((CharSequence)tag.getTagName());
        } else {
            this.teamName = "";
            this.setSpinnerColor(1);
            this.finalFleetData.clear();
            for (int i = 1; i < this.pairBoolData.size(); ++i) {
                this.pairBoolData.get(i).setSelected(false);
            }
            this.selectTeamsView.setText((CharSequence)this.getString(R.string.hippo_select_teams_string));
        }
    }

    public void selectedFleet(ArrayList<User> userData) {
        this.pairFleetData.clear();
        this.pairFleetData.addAll(userData);
        this.finalFleetData.clear();
        if (userData.get(0).isSelected()) {
            this.finalFleetData.addAll(userData);
            this.finalFleetData.remove(0);
            this.showFleetsLayout.setEnabled(true);
            this.showFleetsLayout.setClickable(true);
            this.setSpinnerColor(3);
            this.setShowValue(userData.size() - 1);
        } else {
            boolean flag = false;
            int count = 0;
            for (int i = 1; i < userData.size(); ++i) {
                if (!userData.get(i).isSelected()) continue;
                this.finalFleetData.add(userData.get(i));
                flag = true;
                ++count;
            }
            this.setShowValue(count);
            if (flag) {
                this.setSpinnerColor(3);
                this.showFleetsLayout.setEnabled(true);
                this.showFleetsLayout.setClickable(true);
            } else {
                this.setSpinnerColor(4);
            }
        }
    }

    private void sendingBroadcastMessages() {
        if (this.broadcastListener == null) {
            this.broadcastListener = new BroadcastListenerHelper();
        }
        if (this.userData == null) {
            this.userData = AgentCommonData.getUserData();
        }
        String accessToken = this.userData.getAccessToken();
        ArrayList<Integer> fleets = new ArrayList<Integer>();
        for (User user : this.finalFleetData) {
            fleets.add(user.getUserId());
        }
        CommonParams commonParams = new CommonParams.Builder().add("access_token", accessToken).add("user_ids", new Gson().toJson(fleets)).add("user_first_message", this.edMessageView.getText().toString().trim()).add("broadcast_title", this.edTitleView.getText().toString().trim()).build();
        LoadingBox.showOn((Activity)this.getActivity());
        this.broadcastListener.sendBroadcastMessage(commonParams.getMap(), this);
    }

    private void openBroadcastStatus() {
        this.getActivity().getSupportFragmentManager().beginTransaction().add(R.id.main_layout, (Fragment)new BroadcastStatusFragment(), BroadcastStatusFragment.class.getName()).addToBackStack(BroadcastStatusFragment.class.getName()).hide(this.getActivity().getSupportFragmentManager().findFragmentByTag(this.getActivity().getSupportFragmentManager().getBackStackEntryAt(this.getActivity().getSupportFragmentManager().getBackStackEntryCount() - 1).getName())).commitAllowingStateLoss();
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.activity.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        inflater.inflate(R.menu.fugu_chat_menu, menu2);
    }
}

