package com.hippo.agent;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.app.Dialog;
import android.content.*;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.PorterDuff;
import android.graphics.drawable.GradientDrawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.appcompat.app.AlertDialog;
import androidx.cardview.widget.CardView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.appcompat.widget.Toolbar;
import android.text.Editable;
import android.text.Html;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.*;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.InputMethodManager;
import android.widget.*;
import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.bumptech.glide.request.RequestOptions;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.hippo.HippoCallView;
import com.hippo.HippoColorConfig;
import com.hippo.HippoConfig;
import com.hippo.HippoNotificationConfig;
import com.hippo.R;
import com.hippo.adapter.FuguMessageAdapter;
import com.hippo.agent.Util.*;
import com.hippo.agent.adapter.FuguAgentMessageAdapter;
import com.hippo.agent.database.AgentCommonData;
import com.hippo.agent.helper.UploadingService;
import com.hippo.agent.listeners.OnUserChannelListener;
import com.hippo.agent.listeners.UnreadListener;
import com.hippo.agent.model.*;
import com.hippo.agent.model.LoginModel.UserData;
import com.hippo.agent.model.Message;
import com.hippo.agent.model.createConversation.CreateConversation;
import com.hippo.agent.model.getConversationResponse.Conversation;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.model.*;
import com.hippo.retrofit.*;
import com.hippo.utils.*;
import com.hippo.utils.Utils;
import com.hippo.utils.beatAnimation.AVLoadingIndicatorView;
import com.hippo.utils.easypermissions.AfterPermissionGranted;
import com.hippo.utils.easypermissions.AppSettingsDialog;
import com.hippo.utils.easypermissions.EasyPermissions;
import com.hippo.utils.fileUpload.FileManager;
import com.hippo.utils.fileUpload.FileuploadModel;
import com.hippo.utils.fileUpload.Prefs;
import com.hippo.utils.filepicker.*;
import com.hippo.utils.filepicker.filter.entity.AudioFile;
import com.hippo.utils.filepicker.filter.entity.ImageFile;
import com.hippo.utils.filepicker.filter.entity.NormalFile;
import com.hippo.utils.filepicker.filter.entity.VideoFile;
import com.hippo.utils.loadingBox.LoadingBox;
import com.hippo.utils.loadingBox.ProgressWheel;
import com.hippo.utils.zoomview.ZoomageView;
import faye.FayeAgentListener;
import faye.FayeClient;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.lang.reflect.Type;
import java.util.*;

//import com.hippo.videoCall.FuguCallActivity;
//import com.hippo.videoCall.VideoCallModel;
//import com.hippo.videoCall.WebRTCCallConstants;
//import com.hippo.videoCall.model.IceServers;

public class AgentChatActivity extends AgentBaseActivity implements FayeAgentListener,
        View.OnClickListener, FuguAppConstant, OnUserChannelListener,
        KeyboardUtil.SoftKeyboardToggleListener, EasyPermissions.PermissionCallbacks {

    private static final String TAG = AgentChatActivity.class.getSimpleName();

    public static Long pushChannelId = -1L;
    public static Long currentChannelId = -1L;

    // Initial FayeClient
    private static final FayeClient mClient = HippoConfig.getClient();

    private String LOG_TAG = getClass().getSimpleName();
    private CustomRelative llRoot;
    private TextView tvNoInternet, tvTitle, tvAssignNotify;
    private EditText etMsg;

    private RecyclerView rvMessages;
    private LinearLayoutManager layoutManager;
    private FuguAgentMessageAdapter fuguMessageAdapter;
    private RelativeLayout relativeLayout;
    private CardView cvTypeMessage;
    private int isTyping = 0;
    private Toolbar myToolbar;
    private AVLoadingIndicatorView aviTyping;
    private LinearLayout llTyping, llUserDetails;
    private int onSubscribe = 0;
    private Conversation conversation;
    private ProgressBar pbSendingImage;
    private ImageView ivSend, ivAudioView, ivAttachment;
    private View vText;
    private DateUtils dateUtils;
    private String sentAtUTC = "", savedPrivateNote = "";
    private int messageType = TEXT_MESSAGE;
    private ProgressBar pbLoading;
    private boolean showLoading = true;
    private boolean allMessagesFetched = false;
    private boolean isNetworkStateChanged = false;
    //    private RelativeLayout rlScrollBottom;
    private ImageView ivViewInfo;
    private FuguImageUtils imageUtils;
    private HippoColorConfig hippoColorConfig;

    private int position;
    // Declaring objects and variables
    private ArrayList<TagData> tagData = new ArrayList<>();
    private Type listType = new TypeToken<List<TagData>>() {
    }.getType();

    private Type countlistType = new TypeToken<ArrayList<String>>() {
    }.getType();

    private int pageStart = 1;
    private int dateItemCount = 0;
    private int scrollBottomCount = 0;
    private int status;

    private UserData userData;
    private boolean isBlock = false;

    private boolean firstOpen = true;
    private boolean isFromGetConversation;
    private boolean isFromConversation;
    private boolean isAgentChatActivity = false;
    private boolean isReadAcknowledgement = true;
    private boolean isMsgReceviedInBackground = false;
    private boolean isFromPushNotification = false;

    private String lineBeforeFeedback, lineAfterFeedback_1, lineAfterFeedback_2;
    private static int API_DELAY_TIME = 1000;
    private int fragmentType;
    @SuppressLint("StaticFieldLeak")
    private static LinearLayout llInternet;
    @SuppressLint("StaticFieldLeak")
    private static TextView tvStatus;
    private LinearLayout llBottom, retryLayout;
    private TextView btnRetry;
    private ProgressWheel progressWheel;
    private boolean isFirstTimeOpened = true;
    private boolean isFromFilePicker = false;

    // Declaring objects and variables
    @NonNull
    private ArrayList<ListItem> fuguMessageList = new ArrayList<>();
    private LinkedHashMap<String, ListItem> sentMessages = new LinkedHashMap<>();
    private LinkedHashMap<String, ListItem> unsentMessages = new LinkedHashMap<>();

    @NonNull
    private LinkedHashMap<String, JSONObject> unsentMessageMapNew = new LinkedHashMap<>();

    private String inputFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private String outputFormat = "yyyy-MM-dd";

    private Handler handler = new Handler();
    private final static Integer RECONNECTION_TIME = 2000;
    private int index = -1;
    private int messageIndex = -1;

    private FayeClient getmClient() {
        return mClient;
    }

    private ImageView ivVideoView;
    private boolean infoClickable = false;
    public String audioMuid = "";
    public int playingItem = -1;

    boolean isO2OChat = false;
    boolean isCreateO2OChat = false;
    String email;
    private String transactionId;

    private static final int USER_CONCENT_MESSAGE = 20;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.fugu_activity_agent_chat);

        initViews();
        fetchIntentData();

        setUpUI();
        stateChangeListeners();

        isFirstTimeOpened = true;

        mClient.setAgentListener(this);
        if (!getmClient().isConnectedServer())
            getmClient().connectServer();
        else
            setSubscribeChannel();

        LocalBroadcastManager.getInstance(this).registerReceiver(mMessageReceiver, getIntentFilter());
        LocalBroadcastManager.getInstance(this).registerReceiver(fileUploadReceiver, new IntentFilter(FuguAppConstant.HIPPO_FILE_UPLOAD));
    }

    private void setupClient() {

    }

    private void afterSetupClient() {

    }

    // intentFilter to add multiple actions
    private IntentFilter getIntentFilter() {
        IntentFilter intent = new IntentFilter();
        intent.addAction(NETWORK_STATE_INTENT);
        intent.addAction(NOTIFICATION_TAPPED);
        return intent;
    }


    private void initViews() {
        isAgentChatActivity = true;
        myToolbar = (Toolbar) findViewById(R.id.my_toolbar);
        setSupportActionBar(myToolbar);
        setToolbar(myToolbar, "");
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        tvTitle = myToolbar.findViewById(R.id.tv_toolbar_name);
        ivViewInfo = findViewById(R.id.ivViewInfo);

        ivSend = findViewById(R.id.ivSend);
        ivViewInfo.setVisibility(View.GONE);
        hippoColorConfig = CommonData.getColorConfig();
        ivAudioView = findViewById(R.id.ivAudioView);
        ivVideoView = findViewById(R.id.ivVideoView);

        // TODO: 31/12/18 Exposs drawable method to end user.
        ivAudioView.setImageResource(R.drawable.hippo_ic_call_black);
        ivVideoView.setImageResource(R.drawable.hippo_ic_videocam);

        ivAudioView.setVisibility(View.GONE);
        ivVideoView.setVisibility(View.GONE);

        ivAudioView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                videoCallInit(FuguAppConstant.AUDIO_CALL_VIEW);
            }
        });

        ivVideoView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                videoCallInit(VIDEO_CALL_VIEW);
            }
        });

        tvTitle.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (conversation.getAgentId() == null || !infoClickable)
                    return;
                if (!isNetworkAvailable()) {
                    Toast.makeText(AgentChatActivity.this, getString(R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
                    return;
                }
                if (!Utils.preventMultipleClicks()) {
                    return;
                }
                Intent i = new Intent(AgentChatActivity.this, AgentChatOptions.class);
                i.putExtra(FuguAppConstant.CONVERSATION, new Gson().toJson(conversation, Conversation.class));
                i.putExtra("is_o2o_chat", isO2OChat);
                i.putExtra(FuguAppConstant.TAGS_DATA, new Gson().toJson(tagData, listType));
                startActivityForResult(i, 100);
            }
        });

        relativeLayout = findViewById(R.id.activity_main);
        llRoot = findViewById(R.id.llRoot);
        cvTypeMessage = findViewById(R.id.cvTypeMessage);
        tvNoInternet = findViewById(R.id.tvNoInternet);
        tvAssignNotify = (TextView) findViewById(R.id.tvAssignNotify);
        aviTyping = findViewById(R.id.aviTyping);
        llTyping = findViewById(R.id.llTyping);
        llTyping.setFocusable(false);
        etMsg = findViewById(R.id.etMsg);
        rvMessages = findViewById(R.id.rvMessages);
        tvStatus = (TextView) findViewById(R.id.tvStatus);
        llInternet = (LinearLayout) findViewById(R.id.llInternet);

        imageUtils = new FuguImageUtils(AgentChatActivity.this);

        etMsg.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                //You can identify which key pressed buy checking keyCode value with KeyEvent.KEYCODE_
                if (keyCode == KeyEvent.KEYCODE_DEL) {
                    //this is for backspace
                }
                return false;
            }
        });

        rvMessages.addOnLayoutChangeListener(new View.OnLayoutChangeListener() {
            @Override
            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                if (bottom < oldBottom) {
                    rvMessages.postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            try {
                                if (rvMessages.getAdapter() != null) {
                                    rvMessages.smoothScrollToPosition(
                                            rvMessages.getAdapter().getItemCount() - 1);
                                }
                            } catch (Exception e) {

                            }
                        }
                    }, 100);
                }
            }
        });


        pbSendingImage = findViewById(R.id.pbSendingImage);

        ivAttachment = findViewById(R.id.ivAttachment);

        pbLoading = findViewById(R.id.pbLoading);
        dateUtils = DateUtils.getInstance();
        configColors();
    }

    private void configColors() {
        relativeLayout.setBackgroundColor(hippoColorConfig.getHippoChatBg());
        GradientDrawable drawable = (GradientDrawable) llTyping.getBackground();
        drawable.setColor(hippoColorConfig.getHippoBgMessageFrom());
        drawable.setStroke((int) getResources().getDimension(R.dimen.fugu_border_width), hippoColorConfig.getHippoBorderColor()); // set stroke width and stroke color
        aviTyping.setIndicatorColor(hippoColorConfig.getHippoPrimaryTextMsgFrom());
        cvTypeMessage.getBackground().setColorFilter(hippoColorConfig.getHippoTypeMessageBg(), PorterDuff.Mode.SRC_ATOP);
        etMsg.setHintTextColor(hippoColorConfig.getHippoTypeMessageHint());
        etMsg.setTextColor(hippoColorConfig.getHippoTypeMessageText());
        tvNoInternet.setTextColor(hippoColorConfig.getHippoThemeColorPrimary());

        try {
            if(HippoConfig.getInstance().getIcSend() != -1) {
                ivSend.setImageResource(HippoConfig.getInstance().getIcSend());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchIntentData() {
        userData = AgentCommonData.getUserData();
        if (!isFromGetConversation) {
            isCreateO2OChat = getIntent().getBooleanExtra("is_one_two_one", false);
            if(isCreateO2OChat) {
                email = getIntent().getStringExtra("one_two_one_email");
            }
            conversation = new Gson().fromJson(getIntent().getStringExtra(FuguAppConstant.CONVERSATION), Conversation.class);
            isO2OChat = conversation.isA2AChat();
            fragmentType = getIntent().getIntExtra(FuguAppConstant.FRAGMENT_TYPE, FragmentType.ALL_CHAT.getOrdinal());
            isFromPushNotification = getIntent().getBooleanExtra("is_from_push", false);
            if(getIntent().hasExtra("transactionId")) {
                transactionId = getIntent().getStringExtra("transactionId");
            }
            if (isFromPushNotification) {
                HippoConfig.getInstance().getTotalUnreadCount();
                try {
                    for (OnUserChannelListener listener : HippoConfig.getInstance().getUIListeners(OnUserChannelListener.class)) {
                        if (listener != null)
                            listener.updateCount(conversation.getChannelId());
                    }
                } catch (Exception e) {

                }
            }

            try {
                new Handler().postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        for (UnreadListener listener : HippoConfig.getInstance().getUIListeners(UnreadListener.class)) {
                            if (listener != null)
                                listener.getUpdatedUnreadCount(null);
                        }
                    }
                }, 1500);
            } catch (Exception e) {

            }
        }
        llBottom = findViewById(R.id.llMessageLayout);
        btnRetry = findViewById(R.id.btnRetry);
        progressWheel = findViewById(R.id.retry_loader);
        retryLayout = findViewById(R.id.retry_layout);
        if (conversation.isDisableReply()) {
            llBottom.setVisibility(View.GONE);
        }
        status = conversation.getStatus().equals(MessageMode.OPEN_CHAT.getOrdinal()) ? MessageMode.CLOSED_CHAT.getOrdinal() : MessageMode.OPEN_CHAT.getOrdinal();
        tvTitle.setText(conversation.getLabel());
        pushChannelId = conversation.getChannelId();
        currentChannelId = conversation.getChannelId();
        HippoNotificationConfig.agentPushChannelId = pushChannelId;

        if (AgentCommonData.getUnsentMessageMapByChannel(conversation.getChannelId()) != null) {
            unsentMessageMapNew = AgentCommonData.getUnsentMessageMapByChannel(conversation.getChannelId());
        }

        if (currentChannelId > 0) {
            AgentCommonData.removeTotalUnreadCount(currentChannelId.intValue());
        }

        clearNotification(currentChannelId);

        rvMessages = findViewById(R.id.rvMessages);
        fuguMessageAdapter = new FuguAgentMessageAdapter(AgentChatActivity.this, fuguMessageList, rvMessages, conversation);
        layoutManager = new LinearLayoutManager(AgentChatActivity.this);
        layoutManager.setStackFromEnd(true);
        rvMessages.setLayoutManager(layoutManager);
        rvMessages.setAdapter(fuguMessageAdapter);

        if (!isFromGetConversation && !TextUtils.isEmpty(transactionId)) {
            createConversation();
        }

    }

    private String videoCustomerName = "Customer";
    private String videoAgentName = "Agent";
    private boolean isChatAssignToMe = false;
    private boolean isVideoCallEnable = false;

    private void setUpUI() {
        if (AgentCommonData.getAgentMessageResponse(conversation.getChannelId().intValue()) != null
                && AgentCommonData.getAgentMessageResponse(conversation.getChannelId().intValue()).getData().getMessages().size() > 0) {
            FuguAgentGetMessageResponse response = AgentCommonData.getAgentMessageResponse(conversation.getChannelId().intValue());

            videoCustomerName = response.getData().getCustomerName();
            videoAgentName = response.getData().getAgentName();
            isChatAssignToMe = (response.getData().getUserId() == AgentCommonData.getUserData().getUserId().intValue()) ? true : false;

            try {
                if (AgentCommonData.getUserData().isVideoCallEnabled()
                        && response != null && response.getData() != null && response.getData().isAllowVideoCall()) {
                    isVideoCallEnable = true;
                }
            } catch (Exception e) {

            }


            Log.e(TAG, "System.currentTimeMillis(): " + System.currentTimeMillis());
            showLoading = false;
            sentMessages = new LinkedHashMap<>();
            unsentMessages = new LinkedHashMap<>();
            fuguMessageList.clear();

            if (AgentCommonData.getSentMessageByChannel(conversation.getChannelId()) != null) {
                sentMessages = AgentCommonData.getSentMessageByChannel(conversation.getChannelId());
                fuguMessageList.addAll(sentMessages.values());
            }

            List<String> reverseOrderedKeys = new ArrayList<String>(sentMessages.keySet());
            Collections.reverse(reverseOrderedKeys);
            sentAtUTC = "";
            for (String key : reverseOrderedKeys) {
                if (sentMessages.get(key) instanceof HeaderItem) {
                    sentAtUTC = key;
                    break;
                }
            }

            if (AgentCommonData.getUnsentMessageByChannel(conversation.getChannelId()) != null) {
                unsentMessages = AgentCommonData.getUnsentMessageByChannel(conversation.getChannelId());
                if (unsentMessages == null)
                    unsentMessages = new LinkedHashMap<>();

                for (String key : unsentMessages.keySet()) {
                    ListItem listItem = unsentMessages.get(key);
                    String time = ((EventItem) listItem).getEvent().getSentAtUtc();
                    int expireTimeCheck = ((EventItem) listItem).getEvent().getIsMessageExpired();
                    if (((EventItem) listItem).getEvent().getMessageType() != IMAGE_MESSAGE
                            && expireTimeCheck == 0 && DateUtils.getTimeDiff(time)) {
                        ((EventItem) listItem).getEvent().setIsMessageExpired(1);
                        try {
                            JSONObject messageJson = unsentMessageMapNew.get(key);
                            messageJson.put("is_message_expired", 1);
                            unsentMessageMapNew.put(key, messageJson);
                        } catch (Exception e) {
                            //e.printStackTrace();
                        }
                    } else if (((EventItem) listItem).getEvent().getMessageType() == IMAGE_MESSAGE) {
                        JSONObject messageJson = unsentMessageMapNew.get(key);
                        if (messageJson == null) {
                            ((EventItem) listItem).getEvent().setMessageStatus(MESSAGE_IMAGE_RETRY);
                        }
                    }
                }
                AgentCommonData.setUnsentMessageByChannel(conversation.getChannelId(), unsentMessages);
                AgentCommonData.setUnsentMessageMapByChannel(conversation.getChannelId(), unsentMessageMapNew);

                for (String key : unsentMessages.keySet()) {
                    ListItem listItem = unsentMessages.get(key);
                    String time = ((EventItem) listItem).getEvent().getSentAtUtc();
                    String localDate = dateUtils.convertToLocal(time, inputFormat, outputFormat);
                    //String date = dateUtils.getDate(loaclDate);
                    if (!sentAtUTC.equalsIgnoreCase(localDate)) {
                        fuguMessageList.add(new HeaderItem(localDate));
                        sentAtUTC = localDate;
                        System.out.println("Date: " + localDate);
                        //dateItemCount = dateItemCount + 1;
                    }
                    fuguMessageList.add(unsentMessages.get(key));
                }

            }

            Log.e(TAG, "System.currentTimeMillis(): " + System.currentTimeMillis());

            try {
                if (userData.isVideoCallEnabled() && response.getData() != null) {
                    if (response.getData().isAllowVideoCall() && response.getData().getUserId() > 0
                            && userData.getUserId().intValue() == response.getData().getUserId()) {
                        ivVideoView.setVisibility(View.VISIBLE);
                    }
                }
            } catch (Exception e) {
                if (HippoConfig.DEBUG)
                    e.printStackTrace();
            }

            try {
                if (AgentCommonData.getUserData().isAudioCallEnabled() && response.getData() != null) {
                    if (response.getData().isAllowAudioCall() && response.getData().getUserId() > 0
                            && AgentCommonData.getUserData().getUserId().intValue() == response.getData().getUserId()) {
                        ivAudioView.setVisibility(View.VISIBLE);
                    }
                }
            } catch (Exception e) {
                if (HippoConfig.DEBUG)
                    e.printStackTrace();
            }

            setRecyclerViewData();
            llRoot.setVisibility(View.VISIBLE);
        } else {
            showLoading = true;
        }
        if (isNetworkAvailable()) {
            if(isCreateO2OChat && conversation.getChannelId().intValue() < 0) {
                createViaEmail(email);
            } else {
                getMessages();
            }
        } else {
            setConnectionMessage(3);
        }

        if (conversation.isDisableReply()) {
            cvTypeMessage.setVisibility(View.GONE);
        }

    }

    private void stateChangeListeners() {
        etMsg.setOnFocusChangeListener(new View.OnFocusChangeListener() {
            @Override
            public void onFocusChange(View view, boolean b) {
            }
        });

        etMsg.addTextChangedListener(new TextWatcher() {
            private final long DELAY = 3000; // milliseconds
            private Timer timer = new Timer();

            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                if (charSequence.length() > 0 && isNetworkAvailable()) {
                    ivSend.setClickable(true);
                    ivSend.setAlpha(1f);
                } else {
                    ivSend.setClickable(false);
                    ivSend.setAlpha(0.5f);
                }
            }

            @Override
            public void afterTextChanged(Editable editable) {

                if (isNetworkAvailable()) {
                    if (isTyping != 1) {
                        HippoLog.d(LOG_TAG, isTyping + "started typing");
                        // publish start typing event

                        if (!etMsg.getText().toString().isEmpty()) {
                            isTyping = 1;
                            publishOnFaye(getString(R.string.fugu_empty), messageType,
                                    getString(R.string.fugu_empty), getString(R.string.fugu_empty), NOTIFICATION_DEFAULT, null);
                        }
                    }
                    timer.cancel();
                    timer = new Timer();
                    timer.schedule(
                            new TimerTask() {
                                @Override
                                public void run() {
                                    HippoLog.d(LOG_TAG, isTyping + "stopped typing");
                                    //publish stopped typing event
                                    stopTyping();
                                }
                            },
                            DELAY
                    );
                }
            }
        });
    }

    private void setSubscribeChannel() {
        try {
            if (conversation.getChannelId() != null && conversation.getChannelId() > -1) {
                getmClient().subscribeChannel("/" + String.valueOf(conversation.getChannelId()));
                // Include ext and id
                if (getmClient() != null) {
                    if (getmClient().isConnectedServer()) {
                        getmClient().publish("/" + String.valueOf(conversation.getChannelId()), prepareMessageJson(1));
                        fayeDisconnect = false;
                    }
                } else {

                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void checkUnsentMessageStatus(RefreshDone done) {
        //unsentMessages = CommonData.getUnsentMessageByChannel(conversation.getChannelId());
        index = -1;
        if (unsentMessages == null)
            unsentMessages = new LinkedHashMap<>();
        for (String key : unsentMessages.keySet()) {
            ListItem listItem = unsentMessages.get(key);
            String time = ((EventItem) listItem).getEvent().getSentAtUtc();
            int expireTimeCheck = ((EventItem) listItem).getEvent().getIsMessageExpired();
            if (((EventItem) listItem).getEvent().getMessageType() != IMAGE_MESSAGE
                    && expireTimeCheck == 0 && DateUtils.getTimeDiff(time)) {
                ((EventItem) listItem).getEvent().setIsMessageExpired(1);
                try {
                    JSONObject messageJson = unsentMessageMapNew.get(key);
                    messageJson.put("is_message_expired", 1);
                    unsentMessageMapNew.put(key, messageJson);
                    if (index == -1)
                        index = messageJson.optInt("message_index", -1);
                } catch (Exception e) {
                    //e.printStackTrace();
                }
            }
        }
        AgentCommonData.setUnsentMessageByChannel(conversation.getChannelId(), unsentMessages);
        AgentCommonData.setUnsentMessageMapByChannel(conversation.getChannelId(), unsentMessageMapNew);

        if (index > -1 && fuguMessageAdapter != null) {
            try {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        fuguMessageAdapter.notifyItemRangeChanged(index, fuguMessageList.size());
                    }
                });
            } catch (Exception e) {

            }
        }

        if (done != null) {
            done.onRefreshComplete();
        }
    }

    boolean messageSending = false;
    boolean messageSendingRecursion = false;
    boolean fayeDisconnect = true;
    boolean fayeConnecting = false;

    @Override
    public void onConnectedServer(FayeClient fc) {
        fayeDisconnect = false;
        if (conversation.getChannelId() > -1) {
            fc.subscribeChannel("/" + String.valueOf(conversation.getChannelId()));
            if (mClient != null && mClient.isConnectedServer()) {
                mClient.publish("/" + String.valueOf(conversation.getChannelId()), prepareMessageJson(1));
            }

            getMessages(false, true);
//            try {
//                setConnectionMessage(1);
//            } catch (Exception e) {
//
//            }
        }

        try {
            setConnectionMessage(0);
        } catch (Exception e) {

        }
        try {
            handlerDisable.removeCallbacks(runnableDisable);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onDisconnectedServer(FayeClient fc) {
        messageSending = false;
        messageSendingRecursion = false;
        fayeDisconnect = true;
        try {
            if (!isFirstTimeDisconnected) {
                setConnectionMessage(2);
            } else {
                handlerDisable.postDelayed(runnableDisable, 2000);
            }
            isFirstTimeDisconnected = false;

            if (isNetworkAvailable())
                handler.postDelayed(runnable, RECONNECTION_TIME);
        } catch (Exception e) {

        }
    }

    Runnable runnable = new Runnable() {
        @Override
        public void run() {
            try {
                if (pushChannelId > 0 && fayeDisconnect) {
                    //btnRetry.setText("Server connecting... ");
                    setConnectionMessage(4);
                    connectAgainToServer();
                }
                try {
                    handlerDisable.removeCallbacks(runnableDisable);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            } catch (Exception e) {

            }
        }
    };

    private void connectAgainToServer() throws Exception {
        if (!fayeConnecting) {
            fayeConnecting = true;
            handler.removeCallbacks(runnable);

            mClient.connectServer();
        }

        HandlerThread thread = new HandlerThread("FayeReconnect");
        thread.start();

        try {
            new Handler(thread.getLooper()).postDelayed(new Runnable() {
                @Override
                public void run() {
                    fayeConnecting = false;
                }
            }, 2000);
        } catch (Exception e) {
            e.printStackTrace();
            fayeConnecting = false;
        }
    }

    private void updateFeedback(final int position, final boolean scrollDown) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                try {
                    if (scrollDown) {
                        fuguMessageAdapter.notifyDataSetChanged();
                        scrollListToBottom();
                    } else {
                        fuguMessageAdapter.notifyItemChanged(position);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void onWebSocketError() {
        messageSending = false;
        messageSendingRecursion = false;
        fayeDisconnect = true;
        try {
            if (isNetworkAvailable())
                handler.postDelayed(runnable, RECONNECTION_TIME);
            else
                setConnectionMessage(2);
        } catch (Exception e) {

        }
    }

    @Override
    public void onPongReceived() {
        fayeDisconnect = false;
        checkUnsentMessageStatus(new RefreshDone() {
            @Override
            public void onRefreshComplete() {
                sendMessages();
            }
        });

        try {
            if (retryLayout.getVisibility() == View.VISIBLE) {
                setConnectionMessage(0);
            }
        } catch (Exception e) {
        }
        try {
            handlerDisable.removeCallbacks(runnableDisable);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onReceivedMessage(FayeClient fc, String msg, String channel) {
        try {
            ActivityManager mngr = (ActivityManager) getSystemService(ACTIVITY_SERVICE);
            List<ActivityManager.RunningTaskInfo> taskList = mngr.getRunningTasks(10);
            HippoLog.e(TAG, "TopActivity Name = " + taskList.get(0).topActivity.getClassName());
            if (!isAgentChatActivity && !taskList.get(0).topActivity.getClassName().equals("com.hippo.agent.AgentChatActivity")) {
                HippoLog.e(TAG, " AgentChatActivity not opened right now");
                return;
            }
        } catch (SecurityException e) {
            e.printStackTrace();
        }
        if (TextUtils.isEmpty(msg))
            return;
        if (channel.replace("/", "").equalsIgnoreCase(String.valueOf(conversation.getChannelId()))) {
            HippoLog.e(TAG, "Message: " + msg);
            HippoLog.e(TAG, "channel" + channel);

            boolean isSelf = false;

            try {
                final JSONObject messageJson = new JSONObject(msg);

                if (!messageJson.getString("user_id").equals(String.valueOf(String.valueOf(userData.getUserId()))) && messageJson.has("on_subscribe")) {
                    onSubscribe = messageJson.getInt("on_subscribe");
                }

                try {
                    if (messageJson.optInt(MESSAGE_TYPE, 0) == USER_CONCENT_MESSAGE
                            && messageJson.optInt("message_status") != MESSAGE_UNSENT) {
                        for (int i = fuguMessageList.size() - 1; i >= 0; i--) {
                            if (fuguMessageList.get(i).getType() == USER_CONCENT_MESSAGE) {
                                Message currentMessage = ((EventItem) fuguMessageList.get(i)).getEvent();
                                if (!TextUtils.isEmpty(currentMessage.getMuid()) && currentMessage.getMuid().equals(messageJson.getString("muid"))) {
                                    currentMessage.setSelectedBtnId(messageJson.optString("selected_btn_id"));
                                    updateFeedback(i, false);
                                    Log.e(TAG, "updaed ***************************************");
                                    return;
                                }
                            }
                        }
                    }
                } catch (Exception e) {
                    //e.printStackTrace();
                }

                try {
                    int userType = messageJson.optInt("user_type");
                    if(isO2OChat) {
                        if(messageJson.optInt("user_id") == userData.getUserId().intValue()) {
                            isSelf = true;
                        }
                    } else {
                        if (userType == UserType.AGENT.getOrdinal() || userType == UserType.SYSTEM.getOrdinal()) {
                            isSelf = true;
                        }
                    }
                } catch (Exception e) {
                    // e.printStackTrace();
                }

                if (messageJson.optInt(NOTIFICATION_TYPE, 0) == READ_MESSAGE) {
                    // Read functionality
                    for (int i = 0; i < fuguMessageList.size(); i++) {
                        if (fuguMessageList.get(i).getType() == ListItem.ITEM_TYPE_SELF && messageJson.optInt(USER_TYPE) == 1) {
                            if (((EventItem) fuguMessageList.get(i)).getEvent().getMessageStatus().intValue() == MESSAGE_SENT) {
                                ((EventItem) fuguMessageList.get(i)).getEvent().setMessageStatus(MESSAGE_READ);
                            }
                        }
                    }
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            try {
                                rvMessages.getRecycledViewPool().clear();
                                if (fuguMessageAdapter != null) {
                                    fuguMessageAdapter.notifyDataSetChanged();
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                } else if (messageJson.optInt(IS_TYPING, 0) == TYPING_SHOW_MESSAGE &&
                        messageJson.getInt(MESSAGE_TYPE) == VIDEO_CALL && messageJson.has("muid")) {
                    // for video call
                } else {
                    if (messageJson.optInt("is_typing") == 0 &&
                            (!messageJson.getString("message").isEmpty()  || messageJson.has(CUSTOM_ACTION)
                                    || (messageJson.has("url") && !messageJson.getString("url").isEmpty())
                                    || (messageJson.has("image_url") && !messageJson.getString("image_url").isEmpty()))
                            && (messageJson.getInt(MESSAGE_TYPE) == TEXT_MESSAGE
                            || messageJson.getInt(MESSAGE_TYPE) == FILE_MESSAGE
                            || messageJson.getInt(MESSAGE_TYPE) == PRIVATE_NOTE
                            || messageJson.getInt(MESSAGE_TYPE) == IMAGE_MESSAGE
                            || messageJson.getInt(MESSAGE_TYPE) == USER_CONCENT_MESSAGE
                            || messageJson.getInt(MESSAGE_TYPE) == ACTION_MESSAGE_NEW)) {


                        if (isSelf && messageJson.has("message_status") && messageJson.has("message_index")
                                && messageJson.getInt("message_status") == MESSAGE_UNSENT) {

                            messageIndex = messageJson.getInt("message_index");
                            try {
                                if (fuguMessageList.get(messageJson.getInt("message_index")).getType() == ListItem.TYPE_HEADER
                                        && (messageJson.getInt("message_index") + 1 < fuguMessageList.size())) {
                                    ((EventItem) fuguMessageList.get(messageJson.getInt("message_index") + 1))
                                            .getEvent().setMessageStatus(MESSAGE_SENT);
                                    messageIndex = messageIndex + 1;
                                } else if (messageJson.getInt("message_index") < fuguMessageList.size()) {
                                    ((EventItem) fuguMessageList.get(messageJson.getInt("message_index")))
                                            .getEvent().setMessageStatus(MESSAGE_SENT);
                                }
                            } catch (Exception e) {
                                messageIndex = -1;
                                try {
                                    for (int i = fuguMessageList.size() - 1; i >= 0; i--) {
                                        if (((EventItem) fuguMessageList.get(i)).getEvent().getMuid().equals(messageJson.getString("muid"))) {
                                            messageIndex = i;
                                            break;
                                        }
                                    }
                                } catch (Exception e1) {
                                    e1.printStackTrace();
                                }
                                if (messageIndex > -1) {
                                    ((EventItem) fuguMessageList.get(messageJson.getInt("message_index")))
                                            .getEvent().setMessageStatus(MESSAGE_SENT);
                                } else {
                                    return;
                                }
                            }


                            ListItem listItem = unsentMessages.get(messageJson.getString("muid"));
                            if (listItem == null)
                                return;
                            ((EventItem) listItem).getEvent().setMessageStatus(MESSAGE_SENT);

                            if (messageJson.has("thumbnail_url")) {
                                ((EventItem) listItem).getEvent().setThumbnailUrl(messageJson.optString("thumbnail_url"));
                                ((EventItem) listItem).getEvent().setImageUrl(messageJson.optString("image_url"));
                                ((EventItem) listItem).getEvent().setFileUrl(messageJson.optString("image_url"));
                                if (messageJson.has("url"))
                                    ((EventItem) listItem).getEvent().setFileUrl(messageJson.optString("url"));
                            }

                            List<String> reverseOrderedKeys = new ArrayList<>(sentMessages.keySet());
                            Collections.reverse(reverseOrderedKeys);
                            String tempSentAtUTC = "";
                            for (String key : reverseOrderedKeys) {
                                if (sentMessages.get(key) instanceof HeaderItem) {
                                    tempSentAtUTC = key;
                                    break;
                                }
                            }
                            String time = ((EventItem) listItem).getEvent().getSentAtUtc();
                            String localDate = dateUtils.convertToLocal(time, inputFormat, outputFormat);
                            if (!tempSentAtUTC.equalsIgnoreCase(localDate)) {
                                sentMessages.put(localDate, new HeaderItem(localDate));
                            }

                            sentMessages.put(messageJson.getString("muid"), listItem);
                            unsentMessageMapNew.remove(messageJson.getString("muid"));
                            unsentMessages.remove(messageJson.getString("muid"));

                            Log.e(TAG, "Remainning keys: " + unsentMessageMapNew.keySet());

                            if (unsentMessageMapNew.size() == 0 && isNetworkStateChanged) {
                                pageStart = 1;
                                getMessages();
                                isNetworkStateChanged = false;
                            }

                            runOnUiThread(new Runnable() {
                                @Override
                                public void run() {
                                    try {
                                        fuguMessageAdapter.notifyItemChanged(messageIndex);
                                    } catch (Exception e) {
                                        fuguMessageAdapter.notifyDataSetChanged();
                                        e.printStackTrace();
                                    }
                                }
                            });

                            messageSending = false;
                            sendMessages();


                        } else {
                            //String date = dateUtils.getDate(dateUtils.convertToLocal(messageJson.getString("date_time")));
                            String localDate = dateUtils.convertToLocal(messageJson.getString("date_time"), inputFormat, outputFormat);

                            if (!sentAtUTC.equalsIgnoreCase(localDate)) {
                                sentMessages.put(localDate, new HeaderItem(localDate));
                                fuguMessageList.add(new HeaderItem(localDate));
                                sentAtUTC = localDate;
                                dateItemCount = dateItemCount + 1;
                            }

                            Message message = new Message(messageJson.getString("full_name"),
                                    Integer.parseInt(messageJson.getString("user_id")),
                                    messageJson.getString("message"),
                                    messageJson.getString("date_time"),
                                    isSelf,
                                    onSubscribe == 1 ? MESSAGE_READ : MESSAGE_SENT,
                                    fuguMessageList.size(),
                                    messageJson.has("image_url") ? messageJson.getString("image_url") : "",
                                    messageJson.has("thumbnail_url") ? messageJson.getString("thumbnail_url") : "",
                                    messageJson.getInt("message_type"),
                                    messageJson.has("user_type") ? messageJson.getInt("user_type") : UserType.AGENT.getOrdinal());

                            if (messageJson.has(CUSTOM_ACTION)) {
                                message.setCustomAction(new Gson().fromJson(messageJson.getJSONObject(CUSTOM_ACTION).toString(), CustomAction.class));
                            }

                            message.setIntegrationSource(messageJson.optInt("integration_source", 0));
                            message.setMuid(messageJson.optString("muid", ""));

                            if (message.getMessageType() == FILE_MESSAGE) {
                                message.setFileName(messageJson.optString("file_name"));
                                message.setFileSize(messageJson.optString("file_size"));
                                message.setImageUrl(messageJson.optString("image_url"));
                                message.setFileUrl(messageJson.optString("url"));
                                message.setThumbnailUrl(messageJson.optString("thumbnail_url"));
                                message.setDocumentType(messageJson.optString("document_type"));
                                String fileExt = Util.getExtension(messageJson.optString("url"));
                                if (!TextUtils.isEmpty(fileExt))
                                    message.setFileExtension(fileExt);
                            } else if (messageJson.getInt(MESSAGE_TYPE) == USER_CONCENT_MESSAGE) {
                                List<ContentValue> contentValue = new ArrayList<>();
                                JSONArray contentvaluesArray = messageJson.getJSONArray("content_value");
                                if (contentvaluesArray != null) {
                                    for (int a = 0; a < contentvaluesArray.length(); a++) {
                                        JSONObject object = contentvaluesArray.getJSONObject(a);
                                        ContentValue contentValue1 = new ContentValue();
                                        contentValue1.setBtnId(object.optString("btn_id"));
                                        contentValue1.setBtnColor(object.optString("btn_color"));
                                        contentValue1.setBtnTitle(object.optString("btn_title"));
                                        contentValue1.setBtnSelectedColor(object.optString("btn_selected_color"));
                                        contentValue1.setBtnTitleColor(object.optString("btn_title_color"));
                                        contentValue1.setBtnTitleSelectedColor(object.optString("btn_title_selected_color"));
                                        contentValue.add(contentValue1);
                                    }
                                }

                                message.setSelectedBtnId(messageJson.optString("selected_btn_id"));
                                message.setMessageType(USER_CONCENT_MESSAGE);
                                message.setContentValue(contentValue);
                            }

                            try {
                                message.setMessageState(messageJson.optInt("message_state"));
                                message.setVideoCallDuration(messageJson.optInt("video_call_duration"));
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                            fuguMessageList.add(new EventItem(message));
                            if (isReadAcknowledgement) {
                                sendReadAcknowledgement();
                            } else {
                                isMsgReceviedInBackground = true;
                            }
                        }

                    }
                }

                if (!messageJson.getString("user_id").equals(String.valueOf(String.valueOf(userData.getUserId()))) &&
                        onSubscribe == 1 && messageJson.optString("message").isEmpty() && messageJson.has("on_subscribe") && messageJson.optInt(USER_TYPE) == 1) {

                    for (int i = 0; i < fuguMessageList.size(); i++) {
                        if (fuguMessageList.get(i).getType() == ListItem.ITEM_TYPE_SELF && messageJson.optInt(USER_TYPE) == 1 &&
                                ((EventItem) fuguMessageList.get(i)).getEvent().getMessageStatus() == MESSAGE_SENT) {
                            ((EventItem) fuguMessageList.get(i)).getEvent().setMessageStatus(MESSAGE_READ);
                        }
                    }


                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            try {
                                rvMessages.getRecycledViewPool().clear();
                                fuguMessageAdapter.notifyDataSetChanged();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }

                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        try {
                            if (messageJson.has("message_type") && (messageJson.optInt("message_type") == TEXT_MESSAGE
                                    || messageJson.optInt("message_type") == PRIVATE_NOTE
                                    || messageJson.getInt(MESSAGE_TYPE) == FILE_MESSAGE
                                    || messageJson.optInt(MESSAGE_TYPE) == USER_CONCENT_MESSAGE
                                    || messageJson.optInt("message_type") == IMAGE_MESSAGE)) {
                                if ((messageJson.optInt("is_typing") == 0) &&
                                        (!messageJson.getString("message").isEmpty() ||
                                                (messageJson.has("url") && !messageJson.getString("url").isEmpty()) ||
                                                messageJson.optInt(MESSAGE_TYPE) == USER_CONCENT_MESSAGE ||
                                                (messageJson.has("image_url") && !messageJson.getString("image_url").isEmpty()))) {
                                    updateRecycler(Integer.parseInt(messageJson.getString("user_id")));

                                } else if ((messageJson.getInt("is_typing") == 1) && !messageJson.getString("user_id").equals(String.valueOf(userData.getUserId()))) {
                                    if (layoutManager != null) {
                                        if (layoutManager.findLastVisibleItemPosition() >= fuguMessageList.size() - 2) {
                                            startAnim();
                                        }
                                    }
                                } else {
                                    stopAnim();
                                }
                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                });


            } catch (JSONException e) {
                e.printStackTrace();
            }
        }

    }

    private JSONObject prepareMessageJson(int onSubscribe) {
        JSONObject messageJson = new JSONObject();

        try {
            messageJson.put("user_id", String.valueOf(userData.getUserId()));
            messageJson.put("full_name", String.valueOf(userData.getFullName()));
            messageJson.put("is_typing", isTyping);
            messageJson.put("message", "");
            messageJson.put("message_type", TEXT_MESSAGE);
            messageJson.put(USER_TYPE, String.valueOf(UserType.AGENT.getOrdinal()));
            messageJson.put("on_subscribe", onSubscribe);
            messageJson.put("channel_id", conversation.getChannelId());

            String localDate = DateUtils.getInstance().getFormattedDate(
                    new Date());
            messageJson.put("date_time", DateUtils.getInstance().convertToUTC(localDate));


        } catch (JSONException e) {
            e.printStackTrace();
        }

        return messageJson;
    }

    private void addMessageToList(String message, int messageType, String imageUrl, String thumbnailUrl,
                                  String muid, String localPath, FileuploadModel fileDetails, int index) {

        String localDate = DateUtils.getInstance().getFormattedDate(new Date());
        String localDate1 = DateUtils.getInstance().getFormattedDate(new Date(), outputFormat);

        if (!sentAtUTC.equalsIgnoreCase(localDate1)) {
            fuguMessageList.add(new HeaderItem(localDate1));
            sentAtUTC = localDate1;
            dateItemCount = dateItemCount + 1;
        }

        Message messageObj = new Message(String.valueOf(userData.getFullName()),
                userData.getUserId(),
                message,
                DateUtils.getInstance().convertToUTC(localDate),
                true,
                MESSAGE_UNSENT,
                index,
                imageUrl.isEmpty() ? "" : imageUrl,
                thumbnailUrl.isEmpty() ? "" : thumbnailUrl,
                messageType,
                UserType.AGENT.getOrdinal());

        messageObj.setMuid(muid);
        messageObj.setIntegrationSource(0);
        messageObj.setIsMessageExpired(0);
        messageObj.setLocalImagePath(localPath);

        if (fileDetails != null) {
            messageObj.setFileName(fileDetails.getFileName());
            messageObj.setFileSize(fileDetails.getFileSizeReadable());
            messageObj.setFileExtension(fileDetails.getFileMime());
            messageObj.setFilePath(fileDetails.getFilePath());
            messageObj.setFileUrl(fileDetails.getFilePath());
            messageObj.setDocumentType(fileDetails.getDocumentType());
            messageObj.setUploadStatus(UPLOAD_IN_PROGRESS);
            if (fileDetails.getDimns() != null && fileDetails.getDimns().size() > 1) {
                messageObj.setImageHeight(fileDetails.getDimns().get(0));
                messageObj.setImageWidth(fileDetails.getDimns().get(1));
            }
        }

        /*if (bot != null) {
            if (messageType == FEEDBACK_MESSAGE) {
                messageObj.setComment("");
                messageObj.setRatingGiven(0);
                messageObj.setIsRatingGiven(0);
                messageObj.setTotalRating(5);
                messageObj.setLineBeforeFeedback(CommonData.getLineFeedback("lineBeforeFeedback"));
                messageObj.setLineAfterFeedback_1(CommonData.getLineFeedback("lineBeforeFeedback_1"));
                messageObj.setLineAfterFeedback_2(CommonData.getLineFeedback("lineAfterFeedback_2"));
            } else if (messageType == BOT_FORM_MESSAGE) {
                messageObj.setContentValue(bot.getContentValue());
                messageObj.setValues((ArrayList<String>) bot.getValues());
            }
        }*/

        /*if (mentions != null && mentions.getInsertedMentions() != null && mentions.getInsertedMentions().size() != 0) {

            taggedUsers = new ArrayList<>();

            for (Mentionable mention : mentions.getInsertedMentions()) {
                if (!taggedUsers.contains((int) mention.getUserId())) {
                    taggedUsers.add((int) mention.getUserId());
                }
            }
            messageObj.setTaggedUsers(taggedUsers);
        }*/

        fuguMessageList.add(new EventItem(messageObj));
        unsentMessages.put(muid, new EventItem(messageObj));
        etMsg.setText("");
        updateRecycler(userData.getUserId());

        scrollListToBottom();
    }

    private void sendMessage(String message, int messageType, String url, String thumbnailUrl,
                             ArrayList<Integer> ids, String localPath, FileuploadModel fileuploadModel) {
        sendMessage(message, messageType, url, thumbnailUrl, ids, localPath, null, -1, fileuploadModel);
    }

    private void sendMessage(String message, int messageType, String url, String thumbnailUrl,
                             ArrayList<Integer> ids, String localPath, String localMuid, int localIndex, FileuploadModel fileuploadModel) {
        String initialMessage = message.trim();
        String removeLt = initialMessage.replaceAll("<", "&lt;");
        String removeGt = removeLt.replaceAll(">", "&gt;");
        String removeQuotes = removeGt.replaceAll("\"", "&quot;");
        String removsinglequote = removeQuotes.replaceAll("'", "&#39;");

        String localDate = DateUtils.getInstance().getFormattedDate(new Date());

        int index = fuguMessageList.size();
        if (localIndex > 0)
            index = localIndex;

        String muid;

        if (TextUtils.isEmpty(localMuid)) {
            muid = UUID.randomUUID().toString() + "." + new Date().getTime();
            if (fileuploadModel != null && !TextUtils.isEmpty(fileuploadModel.getMuid())) {
                muid = fileuploadModel.getMuid();
            }
            addMessageToList(removsinglequote, messageType, localPath, localPath, muid, localPath, fileuploadModel, index);
        } else {
            muid = localMuid;
        }

        try {
            JSONObject messageJson = new JSONObject();
            if (String.valueOf(userData.getFullName()) != null) {
                messageJson.put("full_name", String.valueOf(userData.getFullName()));
            }
            messageJson.put("muid", muid);
            messageJson.put("is_message_expired", 0);
            messageJson.put("message", removsinglequote);
            messageJson.put("message_type", messageType);
            messageJson.put(USER_TYPE, UserType.AGENT.getOrdinal());
            messageJson.put("date_time", DateUtils.getInstance().convertToUTC(localDate));
            messageJson.put("message_index", fuguMessageList.size() - 1);
            messageJson.put("is_typing", TYPING_SHOW_MESSAGE);
            messageJson.put("message_status", MESSAGE_UNSENT);
            messageJson.put("user_id", userData.getUserId());
            messageJson.put("user_type", UserType.AGENT.getOrdinal());

            if (messageType == IMAGE_MESSAGE) {
                if (!url.trim().isEmpty() && !thumbnailUrl.trim().isEmpty()) {
                    messageJson.put("image_url", url);
                    messageJson.put("thumbnail_url", thumbnailUrl);
                } else if (!TextUtils.isEmpty(localPath)) {
                    messageJson.put("local_url", localPath);
                }
                if (fileuploadModel != null && fileuploadModel.getDimns() != null && fileuploadModel.getDimns().size() > 0) {
                    messageJson.put("image_height", fileuploadModel.getDimns().get(0));
                    messageJson.put("image_width", fileuploadModel.getDimns().get(1));
                } else {
                    messageJson.put("image_height", 700);
                    messageJson.put("image_width", 700);
                }
                messageJson.put("file_name", fileuploadModel.getFileName());
                messageJson.put("file_size", fileuploadModel.getFileSizeReadable());
            } else if (messageType == FILE_MESSAGE) {
                if (!url.trim().isEmpty() && !thumbnailUrl.trim().isEmpty()) {
                    messageJson.put("url", url);
                    messageJson.put(THUMBNAIL_URL, thumbnailUrl);
                } else if (!TextUtils.isEmpty(localPath)) {
                    messageJson.put("local_url", localPath);
                }
                messageJson.put("file_name", fileuploadModel.getFileName());
                messageJson.put("file_size", fileuploadModel.getFileSizeReadable());
                messageJson.put("document_type", fileuploadModel.getDocumentType());
            }

            unsentMessageMapNew.put(muid, messageJson);
            if (conversation != null && conversation.getChannelId() != null)
                AgentCommonData.setUnsentMessageMapByChannel(conversation.getChannelId(), unsentMessageMapNew);

            if (messageType == IMAGE_MESSAGE || messageType == FILE_MESSAGE) {
                if (!TextUtils.isEmpty(localPath)) {
                    fileuploadModel.setMuid(muid);
                    fileuploadModel.setMessageIndex(fuguMessageList.size() - 1);
                    fileuploadModel.setChannelId(currentChannelId);
                    Log.e(TAG, "messageJson = " + new Gson().toJson(messageJson));
                    fileuploadModel.setMessageObject(messageJson);
                    Log.d(TAG, "fileuploadModel = " + new Gson().toJson(fileuploadModel));
                    uploadFile(fileuploadModel);

                    AgentCommonData.setUnsentMessageMapByChannel(conversation.getChannelId(), unsentMessageMapNew);
                    AgentCommonData.setUnsentMessageByChannel(conversation.getChannelId(), unsentMessages);

                } else {
                    if (isNetworkAvailable()) {
                        sendMessages();
                    }
                }
            } else {
                if (!messageSendingRecursion && isNetworkAvailable()) {
                    sendMessages();
                }
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void sendPaymentRequest(PaymentData paymentData) {
        /*if (channelId.compareTo(-1L) == 0) {
            if (mClient.isConnectedServer()) {
                if (!isConversationCreated) {
                    conversation.setChannelStatus(ChannelStatus.OPEN.getOrdinal());
                    createConversation();
                    CommonData.setPaymentData(paymentData);
                    return;
                }
            } else {
                mClient.connectServer();
                Toast.makeText(AgentChatActivity.this, getString(R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
                return;
            }
        }*/
        String muid = UUID.randomUUID().toString() + "." + new Date().getTime();
        ArrayList<DescriptionObject> descriptionObjects = new ArrayList<>();

        try {

            float totalAmount = 0;
            String localDate = DateUtils.getInstance().getFormattedDate(new Date());

            JSONObject messageJson = new JSONObject();
            if (String.valueOf(userData.getFullName()) != null) {
                messageJson.put(FULL_NAME, String.valueOf(userData.getFullName()));
            }
            messageJson.put("muid", muid);
            messageJson.put("is_message_expired", 0);
            messageJson.put(MESSAGE, "");
            messageJson.put(MESSAGE_TYPE, 19);
            messageJson.put(USER_TYPE, UserType.AGENT.getOrdinal());
            messageJson.put(DATE_TIME, DateUtils.getInstance().convertToUTC(localDate));
            messageJson.put(MESSAGE_INDEX, fuguMessageList.size() - 1);
            messageJson.put(IS_TYPING, TYPING_SHOW_MESSAGE);
            messageJson.put(MESSAGE_STATUS, MESSAGE_UNSENT);
            messageJson.put(USER_ID, userData.getUserId());
            messageJson.put(USER_TYPE, UserType.AGENT.getOrdinal());

            JSONObject customAction = new JSONObject();
            customAction.put("title", paymentData.getTitle());

            customAction.put("currency_symbol", paymentData.getCurrencySymbol());


            JSONArray jsonArray = new JSONArray();
            try {
                for (int a = 0; a < paymentData.getPaymentModelData().size(); a++) {
                    JSONObject jsonObj = new JSONObject();
                    jsonObj.put("header", paymentData.getPaymentModelData().get(a).getItemDescription());
                    jsonObj.put("content", paymentData.getCurrencySymbol()+" "+paymentData.getPaymentModelData().get(a).getPrice());

                    jsonArray.put(jsonObj);
                    DescriptionObject descriptionObject = new DescriptionObject();
                    descriptionObject.setHeader(paymentData.getPaymentModelData().get(a).getItemDescription());
                    descriptionObject.setContent(paymentData.getCurrencySymbol()+" "+paymentData.getPaymentModelData().get(a).getPrice());
                    descriptionObjects.add(descriptionObject);

                    totalAmount = totalAmount + Float.parseFloat(paymentData.getPaymentModelData().get(a).getPrice());
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

            customAction.put("amount", totalAmount);

            JSONArray actionButtons = new JSONArray();
            JSONObject actionButtonObj = new JSONObject();

            JSONObject buttonAction = new JSONObject();
            buttonAction.put("title", paymentData.getTitle());
            buttonAction.put("amount", totalAmount);
            buttonAction.put("currency_symbol", paymentData.getCurrencySymbol());
            buttonAction.put("description", jsonArray);
            buttonAction.put("reference", "");
            buttonAction.put("action_type", "NATIVE_ACTIVITY");
            buttonAction.put("transaction_id", "");

            actionButtonObj.put("button_text", "Pay");
            actionButtonObj.put("button_action", buttonAction);

            actionButtons.put(actionButtonObj);
            customAction.put("action_buttons", actionButtons);
            customAction.put("description", jsonArray);


            messageJson.put("custom_action", customAction);
            HippoLog.v("custom_action", "custom_action = "+new Gson().toJson(messageJson));

            unsentMessageMapNew.put(muid, messageJson);
            if (conversation != null && conversation.getChannelId() != null)
                AgentCommonData.setUnsentMessageMapByChannel(conversation.getChannelId(), unsentMessageMapNew);

            if (!messageSendingRecursion && isNetworkAvailable()) {
                sendMessages();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        try {
            String localDate = DateUtils.getInstance().getFormattedDate(new Date());
            String localDate1 = DateUtils.getInstance().getFormattedDate(new Date(), outputFormat);

            if (!sentAtUTC.equalsIgnoreCase(localDate1)) {
                fuguMessageList.add(new HeaderItem(localDate1));
                sentAtUTC = localDate1;
                dateItemCount = dateItemCount + 1;
            }

            Message messageObj = new Message(String.valueOf(userData.getFullName()),
                    userData.getUserId(),
                    "",
                    DateUtils.getInstance().convertToUTC(localDate),
                    true,
                    MESSAGE_UNSENT,
                    index,
                    "",
                    "",
                    19,
                    UserType.AGENT.getOrdinal());

            CustomAction customAction = new CustomAction();
            customAction.setTitle(paymentData.getTitle());
            customAction.setDescriptionObjects(descriptionObjects);

            ArrayList<ActionButtonModel> actionButtonObject = new ArrayList<>();
            ActionButtonModel buttonModel = new ActionButtonModel();
            buttonModel.setButtonText("Pay");
            actionButtonObject.add(buttonModel);

            customAction.setActionButtons(actionButtonObject);

            messageObj.setCustomAction(customAction);
            messageObj.setMuid(muid);
            messageObj.setIntegrationSource(0);
            messageObj.setIsMessageExpired(0);
            messageObj.setLocalImagePath(null);
            messageObj.setMessageState(MESSAGE_UNSENT);

            fuguMessageList.add(new EventItem(messageObj));
            unsentMessages.put(muid, new EventItem(messageObj));
            etMsg.setText("");
            updateRecycler(userData.getUserId());

            scrollListToBottom();

            HippoLog.d("messageObj", "messageObj = " + new Gson().toJson(messageObj));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    int sendingTry = 0;
    private LinkedHashMap<String, JSONObject> unsentMessageMap = new LinkedHashMap<>();

    private synchronized void sendMessages() {
        if (getmClient() != null) {
            if (getmClient().isConnectedServer()) {
                if (unsentMessageMapNew == null || unsentMessageMapNew.size() == 0)
                    messageSendingRecursion = false;

                sendingTry = sendingTry + 1;
                if (sendingTry == 3) {
                    messageSendingRecursion = false;
                    messageSending = false;
                }

                try {
                    if (unsentMessageMapNew.keySet().iterator().hasNext()) {
                        String key = unsentMessageMapNew.keySet().iterator().next();
                        Log.e(TAG, "key: " + key);
                        JSONObject messageJson = unsentMessageMapNew.get(key);
                        if (messageJson.optInt("is_message_expired", 0) == 1) {
                            unsentMessageMap.put(key, messageJson);
                            unsentMessageMapNew.remove(key);
                            sendMessages();
                        } else {
                            int messageType = messageJson.optInt(MESSAGE_TYPE);
                            if (!messageSending && messageJson.optInt("is_message_expired", 0) == 0 && (messageType != IMAGE_MESSAGE && messageType != FILE_MESSAGE)) {
                                Log.e(TAG, "Sending: " + new Gson().toJson(messageJson));
                                sendingTry = 0;
                                messageSending = true;
                                getmClient().publish("/" + String.valueOf(conversation.getChannelId()), messageJson);
                            }
                            if (!messageSending && messageJson.optInt("is_message_expired", 0) == 0 && (messageType == IMAGE_MESSAGE || messageType == FILE_MESSAGE)) {
                                String localPath = messageJson.optString("local_url", "");
                                String url = messageJson.optString("url");
                                String muid = messageJson.optString("muid");
                                //int index = messageJson.optInt(MESSAGE_INDEX);
                                if (!TextUtils.isEmpty(url)) {
                                    localPath = null;
                                    messageJson.remove("local_url");
                                }
                                if (!TextUtils.isEmpty(localPath)) {
                                    //uploadFileServerCall(localPath, "image/*", index, muid);
                                    for (String muidKey : unsentMessageMapNew.keySet()) {
                                        JSONObject newMessageJson = unsentMessageMapNew.get(muidKey);
                                        if (newMessageJson.optInt("is_message_expired", 0) == 1) {
                                            unsentMessageMap.put(muidKey, newMessageJson);
                                            unsentMessageMapNew.remove(muidKey);
                                            sendMessages();
                                            return;
                                        } else {
                                            int newMessageType = newMessageJson.optInt(MESSAGE_TYPE);
                                            if (!messageSending && newMessageJson.optInt("is_message_expired", 0) == 0
                                                    && ((!TextUtils.isEmpty(newMessageJson.optString("url", "")))
                                                    || (newMessageType != IMAGE_MESSAGE && newMessageType != FILE_MESSAGE))) {
                                                sendingTry = 0;
                                                messageSending = true;
                                                getmClient().publish("/" + String.valueOf(conversation.getChannelId()), newMessageJson);
                                                return;
                                            } else if (!messageSending && newMessageJson.optInt("is_message_expired", 0) == 0
                                                    && (newMessageType == IMAGE_MESSAGE || newMessageType == FILE_MESSAGE)) {
                                                continue;
                                            }
                                        }
                                    }
                                } else {
                                    sendingTry = 0;
                                    messageSending = true;
                                    getmClient().publish("/" + String.valueOf(conversation.getChannelId()), messageJson);
                                }
                            }
                        }
                    } else if (unsentMessageMap.size() > 0) {
                        unsentMessageMapNew.putAll(unsentMessageMap);
                        unsentMessageMap.clear();
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
                /*try {
                    if (unsentMessageMapNew.keySet().iterator().hasNext()) {
                        String key = unsentMessageMapNew.keySet().iterator().next();
                        Log.e(TAG, "key: " + key);
                        JSONObject messageJson = unsentMessageMapNew.get(key);
                        if (!messageSending && messageJson.optInt("is_message_expired", 0) == 0) {
                            Log.e(TAG, "Sending: " + new Gson().toJson(messageJson));
                            sendingTry = 0;
                            messageSending = true;
                            getmClient().publish("/" + String.valueOf(conversation.getChannelId()), messageJson);
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }*/

                if (isTyping == TYPING_SHOW_MESSAGE && messageType == TEXT_MESSAGE) {
                    isTyping = TypingMode.TYPING_START.getOrdinal();
                }
            } else {
                try {
                    connectAgainToServer();
                } catch (Exception e) {

                }
            }
        }
    }

    private void publishOnFaye(String message, int messageType, String imageUrl, String thumbnailUrl, int notificationType, String muid) {
        publishOnFaye(message, messageType, imageUrl, thumbnailUrl, notificationType, false, null, muid);
    }

    private void publishOnFaye(String message, int messageType, String imageUrl, String thumbnailUrl,
                               int notificationType, boolean isPrivateNotes, ArrayList<Integer> ids, String muid) {

        String removsinglequote = message.trim();
        String localDate = DateUtils.getInstance().getFormattedDate(new Date());

        try {

            if (isNetworkAvailable()) {

                JSONObject messageJson = new JSONObject();

                if (notificationType == READ_MESSAGE) {
                    messageJson.put("notification_type", notificationType);
                    messageJson.put("channel_id", conversation.getChannelId());
                } else {
                    if (userData.getFullName() != null) {
                        messageJson.put("full_name", userData.getFullName());
                    }

                    messageJson.put("message", removsinglequote);
                    messageJson.put("message_type", messageType);
                    messageJson.put(USER_TYPE, UserType.AGENT.getOrdinal());
                    messageJson.put("date_time", DateUtils.getInstance().convertToUTC(localDate));
                    messageJson.put("message_index", fuguMessageList.size() - 1);
                    if (isPrivateNotes) {
                        messageJson.put("tagged_users", ids);
                    }

                    if (messageType == IMAGE_MESSAGE && !imageUrl.trim().isEmpty() && !thumbnailUrl.trim().isEmpty()) {
                        messageJson.put("image_url", imageUrl);
                        messageJson.put("thumbnail_url", thumbnailUrl);
                    }

                    if (messageType == TEXT_MESSAGE) {
                        messageJson.put("is_typing", isTyping);
                    } else {
                        messageJson.put("is_typing", TYPING_SHOW_MESSAGE);
                    }

                    messageJson.put("message_status", MESSAGE_UNSENT);
                }
                if (!TextUtils.isEmpty(muid))
                    messageJson.put("muid", muid);

                messageJson.put("user_id", userData.getUserId());
                messageJson.put("user_type", UserType.AGENT.getOrdinal());

                HippoLog.v("messageJson", "messageJson = " + new Gson().toJson(messageJson));
                if (getmClient() != null) {
                    if (getmClient().isConnectedServer()) {
                        getmClient().publish("/" + String.valueOf(conversation.getChannelId()), messageJson);

                        if (isTyping == TYPING_SHOW_MESSAGE && messageType == TEXT_MESSAGE) {
                            isTyping = TypingMode.TYPING_START.getOrdinal();
                        }

                    } else {
                        if (!getmClient().isConnectedServer())
                            getmClient().connectServer();
                    }
                }
            }
//            else if (!removsinglequote.isEmpty()) {
//                unsentMessageMap.put(fuguMessageList.size() - 1, fuguMessageList.get(fuguMessageList.size() - 1));
//            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater menuInflater = getMenuInflater();
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.home) {
            onBackPressed();
        } else {
            return super.onOptionsItemSelected(item);
        }
        return super.onOptionsItemSelected(item);
    }

    private void startAnim() {
        aviTyping.show();
        llTyping.setVisibility(View.VISIBLE);
        // or avi.smoothToShow();
    }

    private void stopAnim() {
        llTyping.setVisibility(View.GONE);
        aviTyping.hide();
        // or avi.smoothToHide();
    }

    @Override
    protected void onDestroy() {
        isAgentChatActivity = false;
        HippoNotificationConfig.isChannelActivityOnPause = false;
        stopFayeClient();

        HippoLog.i(TAG, "getUIListeners = " + HippoConfig.getInstance().getUIListeners(UnreadListener.class).size());
        for (UnreadListener listener : HippoConfig.getInstance().getUIListeners(UnreadListener.class)) {
            HippoLog.i(TAG, "  = " + listener);
            if (listener != null) {
                listener.sendTotalUnreadCount();
                listener.getUnreadCount();
            }
        }

//        UnreadCountHelper.getInstance().sendTotalUnreadCount();
//        UnreadCountHelper.getInstance().getUnreadCount();
        pushChannelId = -1L;
        currentChannelId = -1L;
        HippoNotificationConfig.agentPushChannelId = -1L;
        LocalBroadcastManager.getInstance(this).unregisterReceiver(mMessageReceiver);
        LocalBroadcastManager.getInstance(this).unregisterReceiver(fileUploadReceiver);

        super.onDestroy();
    }

    @Override
    protected void onResume() {
        isReadAcknowledgement = true;
        HippoNotificationConfig.isChannelActivityOnPause = false;
        isAgentChatActivity = true;
        super.onResume();
        pushChannelId = conversation.getChannelId();
        currentChannelId = conversation.getChannelId();
        if (!isFirstTimeOpened && isNetworkAvailable() && !isFromFilePicker) {
            setConnectionMessage(1);
            getMessages(false, true);
        }
        isFirstTimeOpened = false;
        isFromFilePicker = false;


        if (isMsgReceviedInBackground && isNetworkAvailable()) {
            isMsgReceviedInBackground = false;
            sendReadAcknowledgement();
        }
        KeyboardUtil.addKeyboardToggleListener(AgentChatActivity.this, this);
    }

    @Override
    protected void onPause() {
        isReadAcknowledgement = false;
        HippoNotificationConfig.isChannelActivityOnPause = true;
        super.onPause();
        stopTyping();
        try {
            if (conversation.getChannelId() > 0) {
                AgentCommonData.removeTotalUnreadCount(conversation.getChannelId().intValue());
            }
        } catch (Exception e) {
            HippoLog.e(TAG, "Error on saving total unread count: " + e.toString());
        }
        pushChannelId = -1L;
        if (unsentMessages != null && unsentMessages.size() == 0) {
            AgentCommonData.removeUnsentMessageMapChannel(conversation.getChannelId());
            AgentCommonData.removeUnsentMessageChannel(conversation.getChannelId());
        } else {
            AgentCommonData.setUnsentMessageMapByChannel(conversation.getChannelId(), unsentMessageMapNew);
            AgentCommonData.setUnsentMessageByChannel(conversation.getChannelId(), unsentMessages);
        }
        if (!TextUtils.isEmpty(audioMuid)) {
            ListItem listItem = sentMessages.get(audioMuid);
            ((EventItem) listItem).getEvent().setAudioPlaying(false);
            CommonMediaPlayer.getInstance().stopMedia();
        }
        AgentCommonData.setSentMessageByChannel(conversation.getChannelId(), sentMessages);
        KeyboardUtil.removeKeyboardToggleListener(this);
    }

    private void createViaEmail(String email) {
        CommonParams commonParams = new CommonParams.Builder()
                .add(FuguAppConstant.ACCESS_TOKEN, String.valueOf(userData.getAccessToken()))
                .add("chat_with_email", email)
                .build(2);

        RestClient.getAgentApiInterface().createO2OConversation(commonParams.getMap()).enqueue(new ResponseResolver<CreateConversation>(AgentChatActivity.this, true, false) {
            @Override
            public void success(CreateConversation createConversation) {
                conversation = new Conversation();
                conversation.setChannelId(createConversation.getData().getChannelId());
                conversation.setStatus(MessageMode.OPEN_CHAT.getOrdinal());

                ivSend.setVisibility(View.VISIBLE);

                pushChannelId = conversation.getChannelId();
                currentChannelId = conversation.getChannelId();
                isFromGetConversation = true;
                isFromConversation = true;
                setSubscribeChannel();
                getMessages();
            }

            @Override
            public void failure(APIError error) {
                /*new AlertDialog.Builder(AgentChatActivity.this)
                        .setMessage(error.getMessage())
                        .create().show();*/

                String errorMsg = TextUtils.isEmpty(error.getMessage()) ? "Something went wrong. Try again" : error.getMessage();
                ToastUtil.getInstance(AgentChatActivity.this).showToast(errorMsg);
//                ivSend.setVisibility(View.GONE);
//                showErrorMessage(error.getMessage(), getString(R.string.fugu_ok));
            }
        });
    }


    public void createConversation() {
        HashMap<String, Object> params = new HashMap<>();
        params.put(FuguAppConstant.ACCESS_TOKEN, String.valueOf(userData.getAccessToken()));
        params.put("initiator_en_agent_id", String.valueOf(userData.getEnUserId()));
        if (fragmentType == FragmentType.USER_CHAT.getOrdinal()) {
            ArrayList<String> userUniqueKey = new ArrayList<>();
            userUniqueKey.add(conversation.getUserUniqueKeys());
            params.put(FuguAppConstant.OTHER_USER_UNIQUE_KEY, new Gson().toJson(userUniqueKey));

        } else {
            params.put("user_id", String.valueOf(conversation.getUserId()));
        }
        if(!TextUtils.isEmpty(transactionId)) {
            params.put("transaction_id", transactionId);
        }
        params.put("chat_type", "0");

        CommonParams commonParams = new CommonParams.Builder()
                .addAll(params)
                .build(2);

        pbSendingImage.setVisibility(View.VISIBLE);
        ivSend.setVisibility(View.GONE);
        RestClient.getAgentApiInterface().createConversation(commonParams.getMap())
                .enqueue(new ResponseResolver<CreateConversation>(AgentChatActivity.this, false, true) {
                    @Override
                    public void success(CreateConversation createConversation) {
                        conversation = new Conversation();
                        conversation.setUserId(Integer.parseInt(createConversation.getData().getUserId()));
                        if(tvTitle != null && !TextUtils.isEmpty(tvTitle.getText().toString())) {
                            conversation.setLabel(tvTitle.getText().toString());
                        } else {
                            conversation.setLabel(createConversation.getData().getLabel());
                        }
                        //conversation.setLabel(createConversation.getData().getLabel());
                        conversation.setChannelName(createConversation.getData().getChannelName());
                        conversation.setChannelId(createConversation.getData().getChannelId());

                        conversation.setStatus(MessageMode.OPEN_CHAT.getOrdinal());
                        conversation.setDisableReply(createConversation.getData().getDisableReply());

                        ivSend.setVisibility(View.VISIBLE);


                        if (!etMsg.getText().toString().trim().isEmpty()) {
                            if (isBlock) {
                                Animation animation1 = AnimationUtils.loadAnimation(AgentChatActivity.this, R.anim.hippo_shake);
                                tvAssignNotify.startAnimation(animation1);
                                return;
                            }

                            isTyping = 0;

                        }

                        pushChannelId = conversation.getChannelId();
                        currentChannelId = conversation.getChannelId();
                        isFromGetConversation = true;

                        if (fragmentType == FragmentType.USER_CHAT.getOrdinal()) {
                            isFromConversation = true;
                            fetchIntentData();
                            setUpUI();
                            setSubscribeChannel();
                            getMessages();
                        } else {
                            pbSendingImage.setVisibility(View.GONE);
                            apiGetConversation(true, createConversation.getData().getChannelId().intValue());
                        }
                    }

                    @Override
                    public void failure(APIError error) {
                        ivSend.setVisibility(View.VISIBLE);
                        pbSendingImage.setVisibility(View.GONE);
                    }

                });
    }

    public void apiGetConversation(boolean showLoading, final Integer channelId) {
        if (isNetworkAvailable()) {
            int[] statusArray = new int[]{MessageMode.OPEN_CHAT.getOrdinal()};
            int[] typeArray = new int[]{
                    ConversationMode.DEFAULT.getOrdinal()};
            int[] labelsArray = new int[]{};
            int pageStart = 1;
            HippoLog.v("statusArray......------", Arrays.toString(statusArray));
            HippoLog.v("typeArray......------", Arrays.toString(typeArray));
            HashMap<String, Object> params = new HashMap<>();
            params.put(FuguAppConstant.EN_USER_ID, String.valueOf(userData.getEnUserId()));
            params.put(FuguAppConstant.ACCESS_TOKEN, String.valueOf(userData.getAccessToken()));
            params.put(FuguAppConstant.STATUS, Arrays.toString(statusArray));
            params.put(FuguAppConstant.DEVICE_TYPE, 1);
//            params.put(FuguAppConstant.APP_VERSION, String.valueOf(BuildConfig.VERSION_CODE));
            params.put(FuguAppConstant.TYPE, Arrays.toString(typeArray));
//            if (labelsArray.length > 0) {
//                params.put(FuguAppConstant.LABEL, Arrays.toString(labelsArray));
//            }
            if (pageStart != 0) {
                params.put(FuguAppConstant.PAGE_START, String.valueOf(pageStart));
            }

            CommonParams commonParams = new CommonParams.Builder()
                    .addAll(params)
                    .build(2);

            RestClient.getAgentApiInterface().getConversation(commonParams.getMap())
                    .enqueue(new ResponseResolver<GetConversationResponse>(this, showLoading, false) {
                        @Override
                        public void success(final GetConversationResponse getConversationResponse) {
                            LoadingBox.showOn(AgentChatActivity.this);
                            try {
                                HippoLog.e("Size of Array", getConversationResponse.getData().getConversation().size() + "");
                                if (getConversationResponse != null) {
                                    for (int i = 0; i < getConversationResponse.getData().getConversation().size(); i++) {
                                        if (String.valueOf(channelId).equalsIgnoreCase(String.valueOf(getConversationResponse.getData().getConversation().get(i).getChannelId()))) {
                                            conversation = new Conversation();
                                            conversation = getConversationResponse.getData().getConversation().get(i);
                                        }
                                    }
                                    pushChannelId = conversation.getChannelId();
                                    currentChannelId = conversation.getChannelId();
                                    isFromGetConversation = true;
                                    initViews();
                                    fetchIntentData();
                                    setUpUI();
                                    stateChangeListeners();

                                    setSubscribeChannel();

                                }
                                LoadingBox.hide();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void failure(APIError error) {
                            HippoLog.e("error", "error" + error.getMessage());
                            LoadingBox.hide();
                            Toast.makeText(AgentChatActivity.this, error.getMessage(), Toast.LENGTH_SHORT).show();
                        }
                    });
        } else {
            Toast.makeText(AgentChatActivity.this, getString(R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
        }
    }

    public void onClick(View v) {
        if (v.getId() == R.id.ivSend) {
            if (conversation.getChannelId() > 0 && fayeDisconnect) {
                if (retryLayout.getVisibility() != View.VISIBLE) {
                    setConnectionMessage(2);
                }
                return;
            }

            if (conversation.getChannelId() > 0) {
                if (!etMsg.getText().toString().trim().isEmpty()) {
                    if (isBlock) {
                        Animation animation1 = AnimationUtils.loadAnimation(this, R.anim.hippo_shake);
                        tvAssignNotify.startAnimation(animation1);
                        return;
                    }

                    isTyping = 0;
                    try {
                        sendMessage(etMsg.getText().toString().trim(), messageType, "", "", null, "", null);
                    } catch (Exception ignored) {

                    }
                }
            } else {
                if (!isNetworkAvailable()) {
                    Toast.makeText(AgentChatActivity.this, getString(R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
                    return;
                }
                if(isCreateO2OChat) {
                    createViaEmail(email);
                } else {
                    createConversation();
                }
            }
        } else if (v.getId() == R.id.tvNoInternet) {
            getMessages();
        } else if (v.getId() == R.id.ivAttachment) {
            if (!isNetworkAvailable()) {
                Toast.makeText(AgentChatActivity.this, getString(R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
                return;
            }
            selectImage(v);
        }
    }

    private void updateRecycler(final int userId) {
        if (fuguMessageAdapter != null) {
            fuguMessageAdapter.updateList(fuguMessageList);
            //scrollListToBottom();
        }

        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                try {
                    if (fuguMessageAdapter != null) {
                        try {
                            fuguMessageAdapter.notifyItemInserted(fuguMessageList.size() - 1);
                            if (fuguMessageAdapter.getItemCount() > 0
                                    && layoutManager.findLastVisibleItemPosition() == fuguMessageList.size() - 2) {
                                scrollBottomCount = 0;
                                scrollListToBottom();
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    boolean isApiRunning;
    private HashSet<String> messagesApi = new HashSet<>();

    private void getMessages() {
        getMessages(false, false);
    }

    private void getMessages(final boolean flag, final boolean isFromOnResume) {
        if (isApiRunning) {
            messagesApi.add("getMessages");
            pbSendingImage.setVisibility(View.GONE);
            return;
        }

        if (conversation.getChannelId() > 0) {
            if (isNetworkAvailable()) {
                if (!allMessagesFetched || isNetworkStateChanged || isFromOnResume) {
                    FuguAgentGetMessageParams commonParams = new FuguAgentGetMessageParams(userData.getAccessToken(),
                            conversation.getChannelId().intValue(),
                            userData.getEnUserId(),
                            isFromOnResume ? 1 : pageStart);

                    if (isFromOnResume && fuguMessageList.size() > 100)
                        commonParams.setPageEnd(fuguMessageList.size() - dateItemCount);

                    try {
                        if (!showLoading && (pageStart == 1 || isFromOnResume)) {
                            setConnectionMessage(1);
                        } else {
                            setConnectionMessage(0);
                        }
                    } catch (Exception e) {

                    }

                    isApiRunning = true;
                    RestClient.getAgentApiInterface().getMessages(commonParams)
                            .enqueue(new ResponseResolver<FuguAgentGetMessageResponse>(this, showLoading, false) {
                                @Override
                                public void success(FuguAgentGetMessageResponse fuguGetMessageResponse) {

                                    if (fuguGetMessageResponse != null && fuguGetMessageResponse.getData() != null && fuguGetMessageResponse.getData().getChannelId() != null)
                                        AgentCommonData.saveVideoCallAgent(fuguGetMessageResponse.getData().getChannelId(), fuguGetMessageResponse);

                                    if (fuguGetMessageResponse != null && fuguGetMessageResponse.getData() != null) {
                                        if (fuguGetMessageResponse.getData().isDisableReply()) {
                                            llBottom.setVisibility(View.GONE);
                                        }
                                    }

                                    try {
                                        if (userData.isVideoCallEnabled()
                                                && fuguGetMessageResponse != null && fuguGetMessageResponse.getData() != null) {
                                            if (fuguGetMessageResponse.getData().isAllowVideoCall() && fuguGetMessageResponse.getData().getUserId() > 0
                                                    && userData.getUserId().intValue() == fuguGetMessageResponse.getData().getUserId()) {
                                                ivVideoView.setVisibility(View.VISIBLE);
                                            }
                                        }
                                    } catch (Exception e) {
                                        if (HippoConfig.DEBUG)
                                            e.printStackTrace();
                                    }

                                    try {
                                        if (AgentCommonData.getUserData().isAudioCallEnabled()
                                                && fuguGetMessageResponse != null && fuguGetMessageResponse.getData() != null) {
                                            if (fuguGetMessageResponse.getData().isAllowAudioCall() && fuguGetMessageResponse.getData().getUserId() > 0
                                                    && AgentCommonData.getUserData().getUserId().intValue() == fuguGetMessageResponse.getData().getUserId()) {
                                                ivAudioView.setVisibility(View.VISIBLE);
                                            }
                                        }
                                    } catch (Exception e) {
                                        if (HippoConfig.DEBUG)
                                            e.printStackTrace();
                                    }

                                    boolean flaghide = true;
                                    if (fuguGetMessageResponse.getData().getMessages() != null) {
                                        //setAssignTaskLocaly(fuguGetMessageResponse);
                                        tagData = fuguGetMessageResponse.getData().getTags();
                                        userData.setUserName(fuguGetMessageResponse.getData().getFullName());
                                        onSubscribe = fuguGetMessageResponse.getData().getOnSubscribe();

                                        HippoLog.e("getMessages onSubscribe", "==" + onSubscribe);

                                        LinkedHashMap<String, ListItem> tempMessages = new LinkedHashMap<>();
                                        LinkedHashMap<String, ListItem> tempSentMessages = new LinkedHashMap<>();

                                        String tempSentAtUtc = "";

                                        AgentData messageResponseData = fuguGetMessageResponse.getData();


                                        if (userData == null)
                                            userData = AgentCommonData.getUserData();

//                                        if (messageResponseData.getUserId() > 0 && userData.getUserId() == messageResponseData.getUserId())
//                                            ivVideoView.setVisibility(View.VISIBLE);

                                        if (conversation != null && conversation.getAgentId() == null)
                                            conversation.setAgentId(messageResponseData.getUserId());

                                        if (conversation != null && conversation.getUserId() == null)
                                            conversation.setUserId(messageResponseData.getOwnerId());

                                        try {
                                            conversation.setCustomerName(messageResponseData.getCustomerName());
                                            conversation.setCustomerPhone(messageResponseData.getCustomerPhone());
                                            conversation.setCustomerEmail(messageResponseData.getCustomerEmail());
                                        } catch (Exception e) {

                                        }


                                        if (messageResponseData.getMessages().size() < messageResponseData.getPageSize()) {
                                            allMessagesFetched = true;
                                        }

                                        if (pageStart == 1 || isFromOnResume) {
                                            fuguMessageList.clear();
                                            tempSentMessages.putAll(sentMessages);
                                            sentMessages.clear();
                                            dateItemCount = 0;
                                        }

                                        if (pageStart == 1 && !flag && !isFromOnResume) {
                                            fuguMessageList.clear();
                                            dateItemCount = 0;
                                        }

                                        if (TextUtils.isEmpty(conversation.getLabel()))
                                            tvTitle.setText(messageResponseData.getLabel());

                                        conversation.setStatus(messageResponseData.getChannelStatus());

                                        if (conversation.getUserId() > 0) {
                                            //ivViewInfo.setVisibility(View.VISIBLE);
                                            infoClickable = true;
                                        }


                                        int dateCount = 0;
                                        try {
                                            isO2OChat = messageResponseData.isA2AChat();
                                            for (int i = 0; i < messageResponseData.getMessages().size(); i++) {
                                                Message messageObj = fuguGetMessageResponse.getData().getMessages().get(i);
                                                boolean isSelf = false;
                                                if(isO2OChat) {
                                                    if(userData.getUserId().equals(messageObj.getUserId())) {
                                                        isSelf = true;
                                                    }
                                                } else {
                                                    if (messageObj.getUserType() != null) {
                                                        if (messageObj.getUserType() == UserType.AGENT.getOrdinal() || messageObj.getUserType() == UserType.SYSTEM.getOrdinal()) {
                                                            isSelf = true;
                                                        }
                                                    }
                                                }

                                                String localDate = dateUtils.convertToLocal(messageObj.getSentAtUtc(), inputFormat, outputFormat);

                                                if (!tempSentAtUtc.equalsIgnoreCase(localDate)) {
                                                    tempMessages.put(localDate, new HeaderItem(localDate));
                                                    tempSentAtUtc = localDate;
                                                    dateItemCount = dateItemCount + 1;
                                                    dateCount = dateCount + 1;
                                                }

                                                String muid = messageObj.getMuid();
                                                if (TextUtils.isEmpty(muid))
                                                    muid = messageObj.getId();

                                                Message message = new Message(messageObj.getfromName(),
                                                        messageObj.getUserId(),
                                                        messageObj.getMessage(),
                                                        messageObj.getSentAtUtc(),
                                                        isSelf,
                                                        messageObj.getMessageStatus(),
                                                        i,
                                                        messageObj.getImageUrl(),
                                                        messageObj.getThumbnailUrl(),
                                                        messageObj.getMessageType(),
                                                        messageObj.getUserType());

                                                if (messageObj.getCustomAction() != null) {
                                                    message.setCustomAction(messageObj.getCustomAction());
                                                }
                                                message.setMuid(muid);
                                                message.setIntegrationSource(messageObj.getIntegrationSource());

                                                if (messageObj.getMessageType() == FILE_MESSAGE) {
                                                    message.setFileExtension(messageObj.getFileExtension());
                                                    message.setFileName(messageObj.getFileName());
                                                    message.setFileSize(messageObj.getFileSize());
                                                    message.setFilePath(messageObj.getFilePath());
                                                    message.setFileUrl(messageObj.getFileUrl());
                                                    message.setDocumentType(messageObj.getDocumentType());
                                                } else if (messageObj.getMessageType() == USER_CONCENT_MESSAGE) {
                                                    message.setContentValue(messageObj.getContentValue());
                                                    message.setSelectedBtnId(messageObj.getSelectedBtnId());
                                                    message.setRepliedBy(messageObj.getRepliedBy());
                                                }

                                                tempMessages.put(muid, new EventItem(message));
                                                tempSentMessages.remove(muid);
                                                if (!TextUtils.isEmpty(messageObj.getMuid())) {
                                                    if (unsentMessageMapNew.size() > 0) {
                                                        unsentMessageMapNew.remove(messageObj.getMuid());
                                                    }
                                                    if (unsentMessages.size() > 0) {
                                                        unsentMessages.remove(messageObj.getMuid());
                                                    }
                                                }

                                            }
                                        } catch (Exception e) {
                                            e.printStackTrace();
                                        }

                                        Log.e(TAG, "tempSentMessages 2: " + new Gson().toJson(tempSentMessages.values()));
                                        if (sentMessages.containsKey(tempSentAtUtc)) {
                                            sentMessages.remove(tempSentAtUtc);
                                            dateItemCount = dateItemCount - 1;
                                            dateCount = dateCount - 1;
                                        }

                                        tempMessages.putAll(sentMessages);
                                        sentMessages.clear();
                                        sentMessages.putAll(tempMessages);

                                        // put local sent messages into updated sent list
                                        if (tempSentMessages.values().size() > 0) {
                                            long lastMessageTime = dateUtils.getTimeInLong(messageResponseData.getMessages().get(messageResponseData.getMessages().size() - 1).getSentAtUtc());
                                            if (lastMessageTime > 0) {
                                                for (String key : tempSentMessages.keySet()) {
                                                    try {
                                                        if (tempSentMessages.get(key) instanceof EventItem) {
                                                            ListItem listItem = tempSentMessages.get(key);
                                                            long localMessageTime = dateUtils.getTimeInLong(((EventItem) listItem).getEvent().getSentAtUtc());
                                                            Log.i(TAG, "localMessageTime: " + localMessageTime);
                                                            if (localMessageTime > lastMessageTime) {
                                                                sentMessages.put(((EventItem) listItem).getEvent().getMuid(), listItem);
                                                            }
                                                        }
                                                    } catch (Exception e) {
                                                        e.printStackTrace();
                                                    }
                                                }
                                            }
                                        }

                                        tempSentMessages.clear();

                                        fuguMessageList = new ArrayList<>();
                                        fuguMessageList.addAll(sentMessages.values());

                                        for (String key : unsentMessages.keySet()) {
                                            ListItem listItem = unsentMessages.get(key);
                                            String time = ((EventItem) listItem).getEvent().getSentAtUtc();
                                            String localDate = dateUtils.convertToLocal(time, inputFormat, outputFormat);
                                            if (!sentMessages.containsKey(localDate)) {
                                                if (!tempSentAtUtc.equalsIgnoreCase(localDate)) {
                                                    fuguMessageList.add(new HeaderItem(localDate));
                                                    tempSentAtUtc = localDate;
                                                    System.out.println("Date 2: " + localDate);
                                                }
                                            }
                                            if (unsentMessageMapNew != null && unsentMessageMapNew.size() == 0) {
                                                CommonData.removeUnsentMessageMapChannel(currentChannelId);
                                            } else {
                                                CommonData.setUnsentMessageMapByChannel(currentChannelId, unsentMessageMapNew);
                                            }


                                            if (unsentMessages != null && unsentMessages.size() == 0) {
                                                AgentCommonData.removeUnsentMessageChannel(currentChannelId);
                                            } else {
                                                AgentCommonData.setUnsentMessageByChannel(currentChannelId, unsentMessages);
                                            }

                                            // update
                                            try {
                                                JSONObject messageJson = unsentMessageMapNew.get(key);
                                                if (messageJson != null) {
                                                    messageJson.put("message_index", fuguMessageList.size());
                                                    unsentMessageMapNew.put(key, messageJson);
                                                }
                                                fuguMessageList.add(unsentMessages.get(key));
                                            } catch (Exception e) {

                                            }
                                        }

                                        tvNoInternet.setVisibility(View.GONE);
                                        llRoot.setVisibility(View.VISIBLE);

                                        if (pageStart == 1 || isFromOnResume) {
                                            showLoading = false;
                                            sentAtUTC = tempSentAtUtc;
                                            AgentCommonData.setAgentMessageResponse(conversation.getChannelId().intValue(), fuguGetMessageResponse);
                                            //setRecyclerViewData();

                                            try {
                                                videoCustomerName = fuguGetMessageResponse.getData().getCustomerName();
                                                videoAgentName = fuguGetMessageResponse.getData().getAgentName();
                                                isChatAssignToMe = (fuguGetMessageResponse.getData().getUserId() == AgentCommonData.getUserData().getUserId().intValue()) ? true : false;
                                                try {
                                                    if (AgentCommonData.getUserData().isVideoCallEnabled()
                                                            && fuguGetMessageResponse != null && fuguGetMessageResponse.getData() != null && fuguGetMessageResponse.getData().isAllowVideoCall()) {
                                                        isVideoCallEnable = true;
                                                    }
                                                } catch (Exception e) {

                                                }
                                            } catch (Exception e) {

                                            }

                                            try {
                                                flaghide = false;
                                                setConnectionMessage(0);
                                                setRecyclerViewData();
                                            } catch (Exception e) {
                                                flaghide = true;
                                                if (HippoConfig.DEBUG) {
                                                    e.printStackTrace();
                                                }
                                            }
                                        } else {
                                            pbLoading.setVisibility(View.GONE);
                                            fuguMessageAdapter.updateList(fuguMessageList);
//                                            fuguMessageAdapter.notifyDataSetChanged();
                                            if(fuguMessageList.size()<210) {
                                                fuguMessageAdapter.notifyItemRangeChanged(0, fuguMessageList.size() - 1);
                                            } else {
                                                fuguMessageAdapter.notifyItemRangeInserted(0, messageResponseData.getMessages().size() + dateCount);
                                            }


                                        }

                                        pageStart = sentMessages.values().size() + 1 - dateItemCount;
                                    } else {
                                        allMessagesFetched = true;
                                    }
                                    if (flaghide)
                                        setConnectionMessage(0);
                                    pbLoading.setVisibility(View.GONE);
                                    if (conversation.getChannelId() > 0) {
                                        AgentCommonData.removeTotalUnreadCount(conversation.getChannelId().intValue());
                                    }

                                    isApiRunning = false;
                                    if (messagesApi != null && messagesApi.size() > 0) {
                                        if (messagesApi.contains("getMessages")) {
                                            messagesApi.remove("getMessages");
                                            getMessages(flag, isFromOnResume);
                                        }
                                    }

                                    try {
                                        if(!TextUtils.isEmpty(etMsg.getText().toString().trim()) && isFromConversation) {
                                            isFromConversation = false;
                                            sendMessage(etMsg.getText().toString().trim(), messageType, "", "", null, "", null);
                                        }
                                    } catch (Exception ignored) {

                                    }

                                }


                                @Override
                                public void failure(APIError error) {
                                    isApiRunning = false;
                                    if (error.getStatusCode() == FuguAppConstant.SESSION_EXPIRE) {
                                        try {
                                            Toast.makeText(AgentChatActivity.this, error.getMessage(), Toast.LENGTH_SHORT).show();
                                            if (error.getStatusCode() == ApiResponseFlags.SESSION_EXPIRED.getOrdinal()) {
                                                if (getmClient() != null) {
                                                    if (getmClient().isConnectedServer()) {
                                                        getmClient().unsubscribeChannel(String.valueOf(conversation.getChannelId()));
                                                    }
                                                }
                                            }

                                        } catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                    } else {
                                        if (pageStart == 1 &&
                                                (AgentCommonData.getSentMessageByChannel(conversation.getChannelId()) == null ||
                                                        AgentCommonData.getSentMessageByChannel(conversation.getChannelId()).size() == 0)) {
                                            llRoot.setVisibility(View.GONE);
                                            tvNoInternet.setVisibility(View.VISIBLE);
                                        }
                                        pbLoading.setVisibility(View.GONE);
                                        Toast.makeText(AgentChatActivity.this, error.getMessage(), Toast.LENGTH_SHORT).show();
                                    }

                                    if (messagesApi != null && messagesApi.size() > 0) {
                                        if (messagesApi.contains("getMessages")) {
                                            messagesApi.remove("getMessages");
                                            getMessages(flag, isFromOnResume);
                                        }
                                    }
                                }
                            });
                }
            } else {
                if (pageStart == 1 &&
                        (AgentCommonData.getAgentMessageResponse(conversation.getChannelId().intValue()) == null ||
                                AgentCommonData.getAgentMessageResponse(conversation.getChannelId().intValue()).getData().getMessages().size() == 0)) {
                    llRoot.setVisibility(View.GONE);
                    tvNoInternet.setVisibility(View.VISIBLE);
                }
                pbLoading.setVisibility(View.GONE);
                setConnectionMessage(3);
            }
        }
        if(pbSendingImage.getVisibility() == View.VISIBLE)
            pbSendingImage.setVisibility(View.GONE);
    }

    private void setRecyclerViewData() {

        if (fuguMessageAdapter != null) {
            fuguMessageAdapter.setCustomeName(videoCustomerName);
            fuguMessageAdapter.setAgentName(videoAgentName);
            fuguMessageAdapter.setIsChatAssignToMe(isChatAssignToMe);
            fuguMessageAdapter.isVideoCallEnabled(isVideoCallEnable);
        }

        try {
            fuguMessageAdapter.updateList(fuguMessageList);
            fuguMessageAdapter.notifyDataSetChanged();
            rvMessages.setVisibility(View.VISIBLE);
            rvMessages.setItemAnimator(null);
            rvMessages.scrollToPosition(fuguMessageList.size() - 1);
        } catch (Exception e) {
            if (HippoConfig.DEBUG)
                e.printStackTrace();
        }

        fuguMessageAdapter.setOnVideoCallListener(new FuguMessageAdapter.onVideoCall() {
            @Override
            public void onVideoCallClicked(int callType) {
                try {
                    FuguAgentGetMessageResponse fuguGetMessageResponse = AgentCommonData.getAgentMessageResponse(conversation.getChannelId().intValue());
                    if (userData.isVideoCallEnabled()
                            && fuguGetMessageResponse != null && fuguGetMessageResponse.getData() != null) {
                        if (fuguGetMessageResponse.getData().isAllowVideoCall() && fuguGetMessageResponse.getData().getUserId() > 0
                                && userData.getUserId().intValue() == fuguGetMessageResponse.getData().getUserId()) {
                            videoCallInit(callType);
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });

        fuguMessageAdapter.setOnRetryListener(new FuguAgentMessageAdapter.OnRetryListener() {
            @Override
            public void onRetry(String file, String fileType, int messageIndex, String muid) {
                //uploadFileServerCall(file, fileType, messageIndex, muid);
            }

            @Override
            public void onMessageRetry(String muid, int position) {
                try {
                    //String updatedMuid = UUID.randomUUID().toString();

                    JSONObject jsonObject = unsentMessageMapNew.get(muid);
                    ListItem listItem = unsentMessages.get(muid);

                    //fuguMessageList.remove(position);

                    jsonObject.put("is_message_expired", 0);
                    //jsonObject.put("muid", updatedMuid);
                    jsonObject.put("message_index", position);
                    String localDate = DateUtils.getInstance().getFormattedDate(new Date());
                    jsonObject.put("date_time", DateUtils.getInstance().convertToUTC(localDate));

                    ((EventItem) listItem).getEvent().setIsMessageExpired(0);
                    ((EventItem) listItem).getEvent().setMessageIndex(position);
                    ((EventItem) listItem).getEvent().setSentAtUtc(DateUtils.getInstance().convertToUTC(localDate));
                    //((EventItem) listItem).getEvent().setMuid(updatedMuid);

                    //unsentMessageMapNew.remove(muid);
                    //unsentMessages.remove(muid);

                    unsentMessageMapNew.put(muid, jsonObject);
                    unsentMessages.put(muid, listItem);
                    fuguMessageList.remove(position);
                    fuguMessageList.add(position, listItem);

                    updateRecycler(userData.getUserId());
                    if (fuguMessageAdapter != null) {
                        fuguMessageAdapter.updateList(fuguMessageList);
                        //scrollListToBottom();
                    }
                    fuguMessageAdapter.notifyItemRangeChanged(position, fuguMessageList.size());
//                    scrollListToBottom();

                    sendMessages();
                } catch (JSONException e) {

                }
            }

            @Override
            public void onMessageCancel(String muid, int position) {
                fuguMessageList.remove(position);
                fuguMessageAdapter.notifyItemRemoved(position);
                boolean isItemFound = false;
                for (String key : unsentMessageMapNew.keySet()) {
                    if (key.equalsIgnoreCase(muid)) {
//                        unsentMessageMapNew.remove(muid);
//                        unsentMessages.remove(muid);
                        isItemFound = true;
                        continue;
                    }
                    if (isItemFound) {
                        try {
                            ListItem listItem = unsentMessages.get(key);
                            int index = ((EventItem) listItem).getEvent().getMessageIndex();
                            ((EventItem) listItem).getEvent().setMessageIndex(index - 1);
                            JSONObject jsonObject = unsentMessageMapNew.get(key);
                            jsonObject.put("message_index", index);
                            unsentMessageMapNew.put(key, jsonObject);
                            unsentMessages.put(key, listItem);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                unsentMessageMapNew.remove(muid);
                unsentMessages.remove(muid);
            }

            @Override
            public void onFileMessageRetry(final String muid, final int position) {
                try {
                    ArrayList<FileuploadModel> fileuploadModels = new Gson().fromJson(Prefs.with(AgentChatActivity.this).getString(KEY, ""), fileuploadType);
                    if (fileuploadModels == null)
                        fileuploadModels = new ArrayList<>();
//                    if (fileuploadModels.size() > 4) {
//                        Toast.makeText(AgentChatActivity.this, "Already files in queue. Please wait", Toast.LENGTH_SHORT).show();
//                        return;
//                    }

                    JSONObject jsonObject = unsentMessageMapNew.get(muid);

                    if (jsonObject == null) {
                        new AlertDialog.Builder(AgentChatActivity.this)
                                .setMessage("Something went wrong. Please try again")
                                .setPositiveButton(R.string.fugu_ok, new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick(final DialogInterface dialog, final int which) {
                                        onMessageCancel(muid, position);
                                    }
                                })
                                .setNegativeButton(R.string.fugu_cancel, new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick(DialogInterface dialog, int which) {

                                    }
                                })
                                .setCancelable(false)
                                .show();
                        return;
                    }
                    ListItem listItem = unsentMessages.get(muid);

                    jsonObject.put("is_message_expired", 0);
                    jsonObject.put("message_index", position);
                    String localDate = DateUtils.getInstance().getFormattedDate(new Date());
                    jsonObject.put("date_time", DateUtils.getInstance().convertToUTC(localDate));

                    ((EventItem) listItem).getEvent().setIsMessageExpired(0);
                    ((EventItem) listItem).getEvent().setMessageIndex(position);
                    ((EventItem) listItem).getEvent().setSentAtUtc(DateUtils.getInstance().convertToUTC(localDate));
                    ((EventItem) listItem).getEvent().setMessageStatus(MESSAGE_UNSENT);
                    ((EventItem) listItem).getEvent().setUploadStatus(FuguAppConstant.UPLOAD_IN_PROGRESS);

                    unsentMessageMapNew.put(muid, jsonObject);
                    unsentMessages.put(muid, listItem);
                    fuguMessageList.remove(position);
                    fuguMessageList.add(position, listItem);

                    updateRecycler(-1);
                    if (fuguMessageAdapter != null) {
                        fuguMessageAdapter.updateList(fuguMessageList);
                    }
                    fuguMessageAdapter.notifyItemRangeChanged(position, fuguMessageList.size());

                    if (!TextUtils.isEmpty(jsonObject.optString("local_url"))) {
                        String fileName = jsonObject.optString("file_name");
                        String fileSize = jsonObject.optString("file_size");
                        String filePath = jsonObject.optString("local_url");

                        FileuploadModel fileuploadModel = new FileuploadModel(fileName, fileSize, filePath, muid);

                        fileuploadModel.setChannelId(currentChannelId);
                        fileuploadModel.setFileUploaded(false);
                        fileuploadModel.setDocumentType(jsonObject.optString("document_type"));
                        fileuploadModel.setMessageIndex(jsonObject.optInt("message_index"));
                        fileuploadModel.setMessageType(jsonObject.optInt("message_type"));
                        fileuploadModel.setMessageObject(jsonObject);

                        if(jsonObject.optInt("message_type") == 10) {
                            ArrayList<Integer> integers = new ArrayList<>();
                            integers.add(jsonObject.optInt("image_height", 700));
                            integers.add(jsonObject.optInt("image_width", 700));
                            fileuploadModel.setDimns(integers);
                        }

                        uploadFile(fileuploadModel);
                    } else {
                        if (isNetworkAvailable()) {
                            sendMessages();
                        }
                    }
                } catch (Exception e) {
                    if (HippoConfig.DEBUG)
                        e.printStackTrace();
                }
            }
        });

        // Add the scroll listener
        rvMessages.addOnScrollListener(new RecyclerView.OnScrollListener() {
            @Override
            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (layoutManager.findFirstVisibleItemPosition() == 0 && fuguMessageList.size() >= 25
                        && !allMessagesFetched && pbLoading.getVisibility() == View.GONE && isNetworkAvailable()) {
                    pbLoading.setVisibility(View.VISIBLE);
                    if (unsentMessageMapNew.size() == 0) {
                        getMessages();
                    }
                }
            }
        });

        rvMessages.addOnScrollListener(new RecyclerView.OnScrollListener() {
            @Override
            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                position = newState;
            }
        });
    }

    private BroadcastReceiver mMessageReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            switch (intent.getAction()) {
                case NETWORK_STATE_INTENT:
                    HippoLog.d(TAG, "Network connectivity change " + intent.getBooleanExtra("isConnected", false));
                    if (intent.getBooleanExtra("isConnected", false)) {
                        if (getmClient() != null) {
                            getmClient().setAgentListener(AgentChatActivity.this);
                            new Handler().postDelayed(new Runnable() {
                                @Override
                                public void run() {
                                    try {
                                        connectAgainToServer();
                                    } catch (Exception e) {

                                    }
                                }
                            }, 500);
                        }

                        if (unsentMessageMapNew.size() == 0) {
                            pageStart = 1;
                            getMessages();
                        } else {
                            isNetworkStateChanged = true;
                            btnRetry.setText("Connecting...");
                        }
                        enableButtons();
                    } else if (llTyping.getVisibility() == View.VISIBLE) {
                        stopAnim();
                    }
                    if (!intent.getBooleanExtra("isConnected", false)) {
                        setConnectionMessage(3);
                        enableButtons();
                    }
                    break;
                case NOTIFICATION_TAPPED:
                    conversation = new Gson().fromJson(intent.getStringExtra(FuguAppConstant.CONVERSATION), Conversation.class);
                    HippoNotificationConfig.agentPushChannelId = conversation.getChannelId();
                    currentChannelId = conversation.getChannelId();
                    clearNotification(currentChannelId);
                    allMessagesFetched = false;
                    pageStart = 1;
                    setUpUI();
                    if (mClient.isConnectedServer()) {
                        mClient.unsubscribeAll();
                        mClient.subscribeChannel("/" + String.valueOf(conversation.getChannelId()));
                    } else {
                        mClient.connectServer();
                    }
                    break;
            }

        }
    };

    @Override
    public void onBackPressed() {
        View view = this.getCurrentFocus();
        if (view != null) {
            InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
            if (imm != null) {
                imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
            }
        }
        if (getmClient() != null) {
            if (getmClient().isConnectedServer()) {
                getmClient().publish("/" + String.valueOf(conversation.getChannelId()), prepareMessageJson(0));
            }
        }
        super.onBackPressed();
    }

    private FuguImageUtils fuguImageUtils;
    boolean isCameraPermission;
    boolean keyboardVisibility;

    /**
     * Method to select an image for Position in
     * the List of AddImages
     */
    public void selectImage(View view) {
        if (fuguImageUtils == null)
            fuguImageUtils = new FuguImageUtils(AgentChatActivity.this);

        boolean isPayment = (conversation.getChannelId().compareTo(-1L) > 0 && CommonData.getAttributes().isPaymentEnabled() && !isO2OChat);
        FileSharingUtils fileSharingUtils = new FileSharingUtils(AgentChatActivity.this, view, keyboardVisibility, fuguImageUtils, isPayment);
        fileSharingUtils.selectFiles(new FileSharingUtils.FileSharingListner() {
            @Override
            public void onCameraOpened() {
                openCamera();
            }
        });

        //imageUtils.showImageChooser(OPEN_CAMERA_ADD_IMAGE, OPEN_GALLERY_ADD_IMAGE, SELECT_FILE, SELECT_AUDIO, SELECT_VIDEO, false, false);
    }

    private void openCamera() {
        if (fuguImageUtils == null)
            fuguImageUtils = new FuguImageUtils(AgentChatActivity.this);
        boolean isGranted = EasyPermissions.hasPermissions(this, "android.permission.CAMERA", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
        isCameraPermission = true;
        if (isGranted) {
            fuguImageUtils.startCamera();
        } else {
            EasyPermissions.requestPermissions(this, getString(R.string.vw_rationale_storage),
                    RC_OPEN_CAMERA, "android.permission.CAMERA", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {

        HippoLog.e(TAG, "onRequestPermissionsResult" + requestCode);
        // Forward results to EasyPermissions
        EasyPermissions.onRequestPermissionsResult(requestCode, permissions, grantResults, this);

    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case Constant.REQUEST_CODE_PICK_IMAGE:
                if (resultCode == RESULT_OK) {
                    isFromFilePicker = true;
                    ArrayList<ImageFile> list = data.getParcelableArrayListExtra(Constant.RESULT_PICK_IMAGE);
                    StringBuilder builder = new StringBuilder();
                    String path = null;

                    ImageFile actualfile = list.get(0);
                    String fileMuid = UUID.randomUUID().toString();
                    String muid = fileMuid + "." + new Date().getTime();
                    String fileExt = Util.getExtension(actualfile.getPath());
                    String fileName = fileMuid;


                    if (!TextUtils.isEmpty(fileExt)) {
                        actualfile.setName(fileName + "." + fileExt);
                        //actualfile.setName(actualfile.getName() + "_" + muid + "." + fileExt);
                    }
                    actualfile.setMuid(muid);
                    String localPath = Util.setImageFullPath(fileName + "_" + muid + "." + fileExt);
                    actualfile.setDestinationPath(localPath);

                    if (actualfile != null)
                        compressImage(actualfile);

                    //HippoLog.v(TAG, "Image: "+builder.toString());
                }
                break;
            case Constant.REQUEST_CODE_PICK_VIDEO:
                if (resultCode == RESULT_OK) {
                    isFromFilePicker = true;
                    ArrayList<VideoFile> list = data.getParcelableArrayListExtra(Constant.RESULT_PICK_VIDEO);
                    VideoFile file = list.get(0);

                    String fileMuid = UUID.randomUUID().toString();
                    String muid = fileMuid + "." + new Date().getTime();
                    String fileExt = Util.getExtension(file.getPath());
                    String fileName = fileMuid;
                    if (!TextUtils.isEmpty(fileExt)) {
                        fileName = fileName + "." + fileExt;
                    }
                    FileuploadModel fileuploadModel = new FileuploadModel(fileName, String.valueOf(file.getSize()), file.getPath(), muid);
                    fileuploadModel.setFileSizeReadable(Util.humanReadableByteCount(file.getSize(), true));
                    fileuploadModel.setDocumentType(DocumentType.VIDEO.toString());
                    fileuploadModel.setMessageType(FILE_MESSAGE);

                    copingFileToLocal(fileuploadModel, VIDEO_FOLDER);

                    HippoLog.v(TAG, "File List: " + new Gson().toJson(list));
                }
                break;
            case Constant.REQUEST_CODE_PICK_AUDIO:
                if (resultCode == RESULT_OK) {
                    isFromFilePicker = true;
                    ArrayList<AudioFile> list = data.getParcelableArrayListExtra(Constant.RESULT_PICK_AUDIO);
                    AudioFile file = list.get(0);
                    String fileMuid = UUID.randomUUID().toString();
                    String muid = fileMuid + "." + new Date().getTime();
                    String fileExt = Util.getExtension(file.getPath());
                    String fileName = fileMuid;
                    if (!TextUtils.isEmpty(fileExt)) {
                        fileName = fileName + "." + fileExt;
                    }
                    FileuploadModel fileuploadModel = new FileuploadModel(fileName, String.valueOf(file.getSize()), file.getPath(), muid);
                    fileuploadModel.setFileSizeReadable(Util.humanReadableByteCount(file.getSize(), true));
                    fileuploadModel.setDocumentType(DocumentType.AUDIO.toString());
                    fileuploadModel.setMessageType(FILE_MESSAGE);

                    copingFileToLocal(fileuploadModel, AUDIO_FOLDER);

                    HippoLog.v(TAG, "File List: " + new Gson().toJson(list));
                }
                break;
            case Constant.REQUEST_CODE_PICK_FILE:
                if (resultCode == RESULT_OK) {
                    isFromFilePicker = true;
                    ArrayList<NormalFile> list = data.getParcelableArrayListExtra(Constant.RESULT_PICK_FILE);
                    StringBuilder builder = new StringBuilder();
                    NormalFile file = list.get(0);
                    /*for (NormalFile file : list) {
                        String path = file.getPath();
                        builder.append(path + "\n");
                        builder.append(file.getMimeType() +"\n");
                        builder.append(file.getSize() +"\n");
                    }*/

                    String fileMuid = UUID.randomUUID().toString();
                    String muid = fileMuid + "." + new Date().getTime();

                    String fileExt = Util.getExtension(file.getPath());
                    String fileName = fileMuid;
                    if (!TextUtils.isEmpty(fileExt)) {
                        fileName = fileMuid + "." + fileExt;
                    }

                    String filePath = "";

                    FileuploadModel fileuploadModel = new FileuploadModel(fileName, String.valueOf(file.getSize()), file.getPath(), muid);
                    fileuploadModel.setFileSizeReadable(Util.humanReadableByteCount(file.getSize(), true));
                    fileuploadModel.setDocumentType(DocumentType.FILE.toString());
                    fileuploadModel.setMessageType(FILE_MESSAGE);

                    copingFileToLocal(fileuploadModel, DOC_FOLDER);
                    //sendMessage(getString(R.string.fugu_empty), FILE_MESSAGE, "", "", file.getPath(), null, fileuploadModel);


                    HippoLog.v(TAG, "File: " + builder.toString());
                    HippoLog.v(TAG, "File List: " + new Gson().toJson(list));
                }
                break;
            case Constant.REQUEST_CODE_TAKE_IMAGE:
                if (resultCode == RESULT_OK) {
                    String path = CommonData.getTime();
                    ImageFile imageFile = new ImageFile();
                    imageFile.setPath(path);
                    imageFile.setDestinationPath(path);
                    imageFile.setMuid(CommonData.getImageMuid());
                    imageFile.setSize(new File(path).length());
                    imageFile.setName(Util.extractFileNameWithSuffix(path));
                    HippoLog.d(TAG, "camera imageFile: " + new Gson().toJson(imageFile));
                    compressImage(imageFile);

                }
                break;
            case Constant.REQUEST_CODE_PICK_PAYMENT:
                if (resultCode == RESULT_OK) {
                    PaymentData paymentData = (PaymentData) data.getSerializableExtra("data");
                    //Log.v(TAG, "Data = "+new Gson().toJson(paymentData));
                    sendPaymentRequest(paymentData);
                }
                break;
            case AppSettingsDialog.DEFAULT_SETTINGS_REQ_CODE:
                if (EasyPermissions.hasPermissions(this, "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE")) {
                    //openFileIntent();
                }
                break;
        }
    }

    private void uploadFileServerCall(String file, String fileType, final int messageIndex, final String muid) {
        if (getmClient() != null) {
            if (isNetworkAvailable() && getmClient().isConnectedServer()) {

                MultipartParams.Builder multipartBuilder = new MultipartParams.Builder();
                MultipartParams multipartParams = multipartBuilder
                        .addFile("file", new File(file))
                        .add(FuguAppConstant.ACCESS_TOKEN, userData.getAccessToken())
                        .add("file_type", fileType).build();

                //Log.v("map = ", multipartParams.getMap().toString());
                RestClient.getApiInterface()
                        .uploadFile(multipartParams.getMap())
                        .enqueue(new ResponseResolver<FuguUploadImageResponse>(AgentChatActivity.this, false, false) {
                            @Override
                            public void success(FuguUploadImageResponse fuguUploadImageResponse) {

                                try {
                                    String image_url = fuguUploadImageResponse.getData().getUrl();
                                    String thumbnail_url = fuguUploadImageResponse.getData().getThumbnailUrl();

                                    sendMessage("", IMAGE_MESSAGE, image_url, thumbnail_url, null, null, muid, -1, null);

                                } catch (Exception e) {
                                    e.printStackTrace();
                                }

                            }

                            @Override
                            public void failure(APIError error) {
                                try {
                                    ((EventItem) fuguMessageList.get(messageIndex)).getEvent().setMessageStatus(MESSAGE_IMAGE_RETRY);
                                    fuguMessageAdapter.notifyItemChanged(messageIndex);
                                    if (ivSend.getVisibility() == View.GONE) {
                                        pbSendingImage.setVisibility(View.GONE);
                                        ivSend.setVisibility(View.VISIBLE);
                                    }
                                } catch (Exception e) {

                                }
                            }
                        });
            } else {
                ((EventItem) fuguMessageList.get(messageIndex)).getEvent().setMessageStatus(MESSAGE_IMAGE_RETRY);
                fuguMessageAdapter.notifyItemChanged(messageIndex);
            }
        }
    }


    private void sendReadAcknowledgement() {
        if (conversation.getChannelId() > -1) {
            publishOnFaye(getString(R.string.fugu_empty), 0,
                    getString(R.string.fugu_empty), getString(R.string.fugu_empty), READ_MESSAGE, null);
        }
    }

    private void scrollListToBottom() {
        try {
            rvMessages.scrollToPosition(fuguMessageList.size() - 1);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }


    private void setAssignTaskLocaly(FuguAgentGetMessageResponse fuguGetMessageResponse) {
        try {
            if (conversation != null && conversation.getAgentId() != null) {
                if (!conversation.getAgentId().equals(fuguGetMessageResponse.getData().getUserId())) {
                    try {
                        conversation.setAgentId(fuguGetMessageResponse.getData().getUserId());
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (fuguGetMessageResponse.getData().getUserId() == userData.getUserId()) {
                        String txt = "This chat has been <b>Assigned</b> to you";
                        tvAssignNotify.setVisibility(View.VISIBLE);
                        tvAssignNotify.setText(Html.fromHtml(txt));
                        tvAssignNotify.setBackgroundColor(getResources().getColor(R.color.fugu_green));
                        tvAssignNotify.setCompoundDrawablesWithIntrinsicBounds(R.drawable.hippo_ic_self_assign, 0, 0, 0);
                        goneAssignLayout();
                        if(isO2OChat)
                            return;
                        Bundle conData = new Bundle();
                        conData.putString(FuguAppConstant.CHANNEL_ID, String.valueOf(fuguGetMessageResponse.getData().getChannelId()));
                        Intent intent = new Intent();
                        intent.putExtras(conData);
                        setResult(Overlay.ASSIGNMENT.getOrdinal(), intent);
                    } else if (!fuguGetMessageResponse.getData().getAgentName().equals("") && fuguGetMessageResponse.getData().getUserId() != userData.getUserId()) {
                        String txt = "This chat has been <b>Assigned</b> to " + fuguGetMessageResponse.getData().getAgentName();
                        tvAssignNotify.setVisibility(View.VISIBLE);
                        tvAssignNotify.setText(Html.fromHtml(txt));
                        tvAssignNotify.setBackgroundColor(getResources().getColor(R.color.fugu_assign_color));
                        tvAssignNotify.setCompoundDrawablesWithIntrinsicBounds(R.drawable.hippo_ic_self_assign, 0, 0, 0);
                        if(isO2OChat)
                            return;
                        Bundle conData = new Bundle();
                        conData.putString(FuguAppConstant.CHANNEL_ID, String.valueOf(fuguGetMessageResponse.getData().getChannelId()));
                        Intent intent = new Intent();
                        intent.putExtras(conData);
                        setResult(Overlay.ASSIGNMENT.getOrdinal(), intent);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public RecyclerView getRvMessages() {
        return rvMessages;
    }

    private void goToGmail(String mail) {
        Intent emailIntent = new Intent(Intent.ACTION_SENDTO, Uri.fromParts(
                "mailto", mail, null));
        startActivity(Intent.createChooser(emailIntent, "Send email..."));
    }

    private void goToPhone(String phone) {
        Intent phoneIntent = new Intent(Intent.ACTION_DIAL, Uri.fromParts(
                "tel", phone, null));
        startActivity(phoneIntent);
    }

    private void handleChatTypeCase() {
        {
            HippoLog.v("fragmentType --->>>", String.valueOf(fragmentType));
            if (fragmentType == FragmentType.MY_CHAT.getOrdinal() &&
                    userData.getAgentType() != AgentType.ADMIN.getOrdinal()) {
                isBlock = true;
            } else {
                isBlock = false;
            }
        }

        if (fragmentType == FragmentType.ALL_CHAT.getOrdinal()) {
            goneAssignLayout();
        }
    }


    private void showKeyboard() {
        // Check if no view has focus:
        View view = this.getCurrentFocus();
        if (view != null) {
            InputMethodManager inputManager = (InputMethodManager) this.getSystemService(Context.INPUT_METHOD_SERVICE);
            inputManager.showSoftInput(etMsg, InputMethodManager.HIDE_IMPLICIT_ONLY);
        }
    }


    private void hideKeyboard() {
        // Check if no view has focus:
        View view = this.getCurrentFocus();
        if (view != null) {
            InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    private void goneAssignLayout() {
        Handler handler = new Handler();
        handler.postDelayed(new Runnable() {
            @Override
            public void run() {
                tvAssignNotify.setVisibility(View.GONE);
            }
        }, 3000);
    }

    private void changeAssignTextBackground(String txt, int color, int drawable) {
        tvAssignNotify.setVisibility(View.VISIBLE);
        tvAssignNotify.setText(Html.fromHtml(txt));
        tvAssignNotify.setBackgroundColor(color);
        tvAssignNotify.setCompoundDrawablesWithIntrinsicBounds(drawable, 0, 0, 0);
    }


    @Override
    public void onAssignChat(JSONObject msgData) {

        String channelId = "";
        try {
            channelId = msgData.getString("channel_id");
        } catch (JSONException e) {
            e.printStackTrace();
        }

        if (msgData != null && channelId.equals(String.valueOf(conversation.getChannelId().toString()))) {

            if (msgData.optInt("assigned_by") == msgData.optInt("assigned_to")
                    && userData.getUserId() == msgData.optInt("assigned_to")) {
                HippoLog.v("assign----->>>>", "self");
                String txt = "This chat has been <b>Assigned</b> to you";
                changeAssignTextBackground(txt, getResources().getColor(R.color.fugu_green), R.drawable.hippo_ic_self_assign);
                goneAssignLayout();


            } else if (msgData.optInt("assigned_by") == msgData.optInt("assigned_to")
                    && userData.getUserId() != msgData.optInt("assigned_to")) {
                try {
                    HippoLog.v("done with----->>>>", msgData.get("message").toString());
                    String txt = msgData.get("assigned_by_name").toString() + " assigned the chat to themselves";
                    changeAssignTextBackground(txt, getResources().getColor(R.color.fugu_assign_color), R.drawable.hippo_ic_other_assign);
                } catch (JSONException e) {
                    e.printStackTrace();
                }
                handleChatTypeCase();
            } else {
                try {
                    HippoLog.v("done with----->>>>", msgData.get("message").toString());
                    String txt = msgData.get("message").toString();
                    changeAssignTextBackground(txt, getResources().getColor(R.color.fugu_assign_color), R.drawable.hippo_ic_other_assign);
                } catch (JSONException e) {
                    e.printStackTrace();
                }
                handleChatTypeCase();
            }
            try {
                conversation.setAgentId(msgData.optInt("assigned_to"));
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void onControlChannelData(JSONObject jsonObject) {

    }

    @Override
    public void onRefreshData() {

    }

    @Override
    public void onReadAll(JSONObject jsonObject) {

    }

    @Override
    public void updateCount(Long channelId) {

    }

    private static final int NOT_CONNECTED = 0;
    private static final int CONNECTED_TO_INTERNET = 1;
    private static final int CONNECTED_TO_INTERNET_VIA_WIFI = 2;

    public static void changeStatus(int status) {
        /*try {
            switch (status) {
                case CONNECTED_TO_INTERNET:
                case CONNECTED_TO_INTERNET_VIA_WIFI:
                    new Handler().postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            enableButtons();
                        }
                    }, 500);
                    break;
                default:
                    break;
            }
        } catch (Exception e) {

        }*/
    }

    private void enableButtons() {
        try {
            if (etMsg.getText().toString().trim().length() > 0 && isNetworkAvailable()) {
                ivSend.setClickable(true);
                ivSend.setAlpha(1f);
            } else {
                ivSend.setClickable(false);
                ivSend.setAlpha(0.5f);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopFayeClient() {
        try {
            HandlerThread thread = new HandlerThread("TerminateThread");
            thread.start();
            new Handler(thread.getLooper()).post(new Runnable() {
                @Override
                public void run() {
                    if (getmClient().isConnectedServer()) {
                        getmClient().disconnectServer();
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void stopTyping() {
        if (isTyping == TYPING_STARTED) {
            isTyping = TYPING_STOPPED;
            publishOnFaye(getString(R.string.fugu_empty), messageType,
                    getString(R.string.fugu_empty), getString(R.string.fugu_empty), NOTIFICATION_DEFAULT, null);
        }
    }

    private void callUnreadHelper(int type) {
        for (UnreadListener listener : HippoConfig.getInstance().getUIListeners(UnreadListener.class))
            switch (type) {
                case 1:

                    break;
                default:

                    break;
            }
    }

    @Override
    public void onToggleSoftKeyboard(boolean isVisible) {
        keyboardVisibility = isVisible;
    }

    @Override
    public void onPermissionsGranted(int requestCode, @NonNull List<String> perms) {
        if (isCameraPermission) {
            if (fuguImageUtils == null)
                fuguImageUtils = new FuguImageUtils(AgentChatActivity.this);
            fuguImageUtils.startCamera();
            isCameraPermission = false;
        }
    }

    @Override
    public void onPermissionsDenied(int requestCode, @NonNull List<String> perms) {
        if (EasyPermissions.somePermissionPermanentlyDenied(this, perms)) {
            new AppSettingsDialog.Builder(this).build().show();
        } else {
            Toast.makeText(AgentChatActivity.this, "Please grant permission", Toast.LENGTH_SHORT).show();
            //finish();
        }
    }

    /**
     * Called when a custom action button is clicked
     *
     * @param buttonAction the action button object associated with this button
     */
    public void onCustomActionClicked(final Object buttonAction) {
        //send a broadcast to listening parent app
        String payload = new Gson().toJson(buttonAction);
        Intent intent = new Intent();
        intent.putExtra(FUGU_CUSTOM_ACTION_PAYLOAD, payload);
        intent.setAction(FUGU_CUSTOM_ACTION_SELECTED);
        sendBroadcast(intent);
    }

    public interface RefreshDone {
        void onRefreshComplete();
    }

    private void setConnectionMessage(int status) {
        if (isNetworkAvailable()) {
            switch (status) {
                case 0:
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            retryLayout.setVisibility(View.GONE);
                        }
                    });
                    break;
                case 1:
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            retryLayout.setVisibility(View.VISIBLE);
                            progressWheel.setVisibility(View.VISIBLE);
                            btnRetry.setText(getString(R.string.hippo_fetching_messages));
                            retryLayout.setBackgroundColor(hippoColorConfig.getHippoConnected());
                        }
                    });
                    break;
                case 2:
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            retryLayout.setVisibility(View.VISIBLE);
                            progressWheel.setVisibility(View.GONE);
                            btnRetry.setText(getString(R.string.hippo_server_disconnect));
                            retryLayout.setBackgroundColor(hippoColorConfig.getHippoNotConnected());
                        }
                    });
                    break;
                case 3:
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            retryLayout.setVisibility(View.VISIBLE);
                            progressWheel.setVisibility(View.GONE);
                            btnRetry.setText(getString(R.string.hippo_no_network_connected));
                            retryLayout.setBackgroundColor(hippoColorConfig.getHippoNotConnected());
                        }
                    });
                    break;
                case 4:
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            retryLayout.setVisibility(View.VISIBLE);
                            progressWheel.setVisibility(View.GONE);
                            btnRetry.setText(getString(R.string.hippo_server_disconnect));
                            retryLayout.setBackgroundColor(hippoColorConfig.getHippoConnected());
                        }
                    });
                    break;
                default:

                    break;
            }
        } else {
            runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    retryLayout.setVisibility(View.VISIBLE);
                    progressWheel.setVisibility(View.GONE);
                    btnRetry.setText(getString(R.string.hippo_no_network_connected));
                    retryLayout.setBackgroundColor(hippoColorConfig.getHippoNotConnected());
                }
            });
        }
    }

    private boolean isFirstTimeDisconnected = true;
    Handler handlerDisable = new Handler();
    Runnable runnableDisable = new Runnable() {
        @Override
        public void run() {
            setConnectionMessage(2);
        }
    };

    private void clearNotification(Long channelId) {
        try {
            ArrayList<Integer> arrayList = AgentCommonData.getNotificationArray(channelId);
            HippoNotificationConfig.clearNotifications(AgentChatActivity.this, arrayList);
            AgentCommonData.removeNotificationChannel(channelId);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    /**
     * Read external storage file
     */
    @AfterPermissionGranted(RC_READ_EXTERNAL_STORAGE)
    public void readExternalStorage() {
        boolean isGranted = EasyPermissions.hasPermissions(this, "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
        if (isGranted) {
            //openFileIntent();
        } else {
            EasyPermissions.requestPermissions(this, getString(R.string.vw_rationale_storage),
                    RC_READ_EXTERNAL_STORAGE, "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
        }
    }

    public boolean checkPermission() {
        return EasyPermissions.hasPermissions(this, "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
    }

    private void copingFileToLocal(FileuploadModel fileuploadModel, String folderType) {
        LoadingBox.showOn(AgentChatActivity.this);
        try {
            FileManager.getInstance().copyFile(fileuploadModel.getFilePath(), FOLDER_TYPE.get(folderType), fileuploadModel, new FileManager.FileCopyListener() {
                @Override
                public void onCopingFile(boolean flag, FileuploadModel fileuploadModel) {
                    sendMessage(getString(R.string.fugu_empty), fileuploadModel.getMessageType(), "", "", null, fileuploadModel.getFilePath(), fileuploadModel);
                    LoadingBox.hide();
                }

                @Override
                public void largeFileSize() {
                    showErrorMessage(getString(R.string.hippo_large_file, Util.humanReadableSize(HippoConfig.getMaxSize(), true)), "OK");
                    LoadingBox.hide();
                }

                @Override
                public void onError() {
                    LoadingBox.hide();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
            LoadingBox.hide();
        }

    }

    public void compressImage(final ImageFile actualFile) {
        try {
            int screenWidth = getResources().getDisplayMetrics().widthPixels;
            if (screenWidth > 1024)
                screenWidth = 1024;

            new Compressor()
                    .setMaxWidth(screenWidth)
                    .setMaxHeight(screenWidth)
                    .setQuality(75)
                    .setCompressFormat(Bitmap.CompressFormat.JPEG)
                    .setListener(new CompressorListener() {
                        @Override
                        public void onImageCompressed(File file, String path, ImageFile imageFile, ArrayList<Integer> integers) {
                            showImageDialog(AgentChatActivity.this, file, path, imageFile, integers);
                        }
                    })
                    .compressToFile(new File(actualFile.getPath()), actualFile);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showImageDialog(Context activity, File imgUrl, final String image, final ImageFile imageFile, final ArrayList<Integer> integers) {

        try {
            final Dialog dialog = new Dialog(activity, android.R.style.Theme_Translucent_NoTitleBar);
            //setting custom layout to dialog
            dialog.setContentView(R.layout.fugu_image_dialog);

            Window dialogWindow = dialog.getWindow();
            WindowManager.LayoutParams layoutParams = dialogWindow.getAttributes();
            layoutParams.dimAmount = 1.0f;

            dialogWindow.getAttributes().windowAnimations = R.style.CustomDialog;

            dialogWindow.addFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND);

            dialog.setCancelable(true);
            dialog.setCanceledOnTouchOutside(false);
            ZoomageView ivImage = dialog.findViewById(R.id.ivImage);
            RequestOptions myOptions = RequestOptions
                    .bitmapTransform(new RoundedCornersTransformation(activity, 7, 2))
                    .dontAnimate()
                    .diskCacheStrategy(DiskCacheStrategy.ALL)
                    .priority(Priority.HIGH)
                    .error(ContextCompat.getDrawable(activity, R.drawable.hippo_placeholder));

            RequestOptions options = new RequestOptions()
                    .centerCrop()
                    .dontAnimate()
                    .diskCacheStrategy(DiskCacheStrategy.ALL)
                    .placeholder(R.drawable.hippo_placeholder)
                    .error(R.drawable.hippo_placeholder)
                    .fitCenter()
                    .priority(Priority.HIGH)
                    .transforms(new CenterCrop(), new RoundedCorners(3));

            Glide.with(activity).asBitmap()
                    .apply(options)
                    .load(imgUrl)
                    //.transition(withCrossFade())
                    .into(ivImage);
            TextView tvCross = dialog.findViewById(R.id.tvCross);
//            LinearLayout linearLayout = dialog.findViewById(R.id.llMessageLayout);
//            linearLayout.setVisibility(View.VISIBLE);
//
            ImageView ivSend = dialog.findViewById(R.id.ivSend);
            ivSend.setVisibility(View.VISIBLE);
            ivSend.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    String muid = Util.getMuid(imageFile.getName());
                    if (!TextUtils.isEmpty(imageFile.getMuid())) {
                        muid = imageFile.getMuid();
                    }
                    FileuploadModel fileuploadModel = new FileuploadModel(imageFile.getName(), String.valueOf(imageFile.getSize()), imageFile.getPath(), muid);
                    fileuploadModel.setFileSizeReadable(Util.humanReadableByteCount(imageFile.getSize(), true));
                    fileuploadModel.setDocumentType(DocumentType.IMAGE.toString());
                    fileuploadModel.setMessageType(IMAGE_MESSAGE);
                    fileuploadModel.setDimns(integers);
                    fileuploadModel.setMuid(imageFile.getMuid());

                    HippoLog.v(TAG, "fileuploadModel: " + new Gson().toJson(fileuploadModel));
                    sendMessage(getString(R.string.fugu_empty), IMAGE_MESSAGE, "", "",
                            null, imageFile.getPath(), fileuploadModel);
                    dialog.dismiss();
                }
            });
            tvCross.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    dialog.dismiss();
                }
            });
            dialog.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ArrayList<Integer> getIMGSize(String url) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile(url, options);
        int imageHeight = options.outHeight;
        int imageWidth = options.outWidth;
        ArrayList<Integer> dimns = new ArrayList<>();
        dimns.add(imageHeight);
        dimns.add(imageWidth);
        return dimns;
    }

    //    private Type fileuploadType = new TypeToken<List<FileuploadModel>>() {
//    }.getType();
    private void uploadFile(FileuploadModel fileuploadModel) {

        ArrayList<FileuploadModel> fileuploadModels = new Gson().fromJson(Prefs.with(this).getString(KEY, ""), fileuploadType);
        if (fileuploadModels == null)
            fileuploadModels = new ArrayList<>();
//        if (fileuploadModels.size() > 4) {
//            Toast.makeText(AgentChatActivity.this, "Already files in queue. Please wait", Toast.LENGTH_SHORT).show();
//            return;
//        }
        fileuploadModels.add(fileuploadModel);
        String data = new Gson().toJson(fileuploadModels, fileuploadType);
        HippoLog.e(TAG, "data = " + data);

        Prefs.with(this).save(KEY, data);

        if (!isMyServiceRunning(UploadingService.class)) {
            Intent intent = new Intent(getBaseContext(), UploadingService.class);
            intent.setAction("start");
            if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.O) {
                startForegroundService(intent);
            } else {
                //lower then Oreo, just start the service.
                startService(intent);
            }
        } else {
            //ToastUtil.getInstance(this).showToast("Already running");
        }

        if (conversation.getChannelId().compareTo(-1l) == 0) {
            createConversation();
        }
    }

//    private void checkAutoUpload() {
//        if(!isMyServiceRunning(UploadingService.class)) {
//            ArrayList<FileuploadModel> fileuploadModels = new Gson().fromJson(Prefs.with(this).getString(KEY, ""), fileuploadType);
//            if (fileuploadModels == null)
//                return;
//            if(fileuploadModels.size() > 0) {
//                Intent intent = new Intent(getBaseContext(), UploadingService.class);
//                intent.setAction("start");
//                if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.O) {
//                    startForegroundService(intent);
//                } else {
//                    //lower then Oreo, just start the service.
//                    startService(intent);
//                }
//            }
//        }
//    }

//    private boolean isMyServiceRunning(Class<?> serviceClass) {
//        ActivityManager manager = (ActivityManager) getSystemService(Context.ACTIVITY_SERVICE);
//        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
//            if (serviceClass.getName().equals(service.service.getClassName())) {
//                return true;
//            }
//        }
//        return false;
//    }


    private BroadcastReceiver fileUploadReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            int status = intent.getIntExtra(BROADCAST_STATUS, 0);
            switch (status) {
                case BroadCastStatus.UPLOADED_SUCESSFULLY:
                    if (conversation.getChannelId() != null && conversation.getChannelId().equals(intent.getLongExtra("channelId", -2))) {
                        String muid = intent.getStringExtra("muid");
                        int messageIndex = intent.getIntExtra("messageIndex", 0);
                        String imageUrl = intent.getStringExtra("image_url");
                        String thumbnailUrl = intent.getStringExtra("thumbnail_url");
                        FileuploadModel fileuploadModel = new Gson().fromJson(intent.getStringExtra("fileuploadModel"), FileuploadModel.class);

                        unsentMessageMapNew.put(muid, fileuploadModel.getMessageObject());

                        ListItem listItem = unsentMessages.get(fileuploadModel.getMuid());
                        if (listItem == null)
                            return;
                        Message message = ((EventItem) listItem).getEvent();
                        message.setMessageStatus(MESSAGE_FILE_UPLOADED);
                        message.setFileUrl(imageUrl);
                        message.setImageUrl(imageUrl);
                        message.setLocalImagePath("");
                        message.setThumbnailUrl(thumbnailUrl);
                        message.setUploadStatus(UPLOAD_COMPLETED);

                        unsentMessages.put(muid, new EventItem(message));

                        try {
                            ((EventItem) fuguMessageList.get(messageIndex)).getEvent().setMessageStatus(MESSAGE_FILE_UPLOADED);
                            fuguMessageAdapter.notifyItemChanged(messageIndex);
                            if (!messageSendingRecursion && isNetworkAvailable()) {
                                sendMessages();
                            }
                        } catch (Exception e) {
                            try {
                                for (int i = fuguMessageList.size() - 1; i >= 0; i--) {
                                    if (fuguMessageList.get(i) instanceof EventItem) {
                                        Message currentMessage = ((EventItem) fuguMessageList.get(i)).getEvent();
                                        if (currentMessage.getMuid().equals(muid)) {
                                            messageIndex = i;
                                            ((EventItem) fuguMessageList.get(messageIndex)).getEvent().setMessageStatus(MESSAGE_FILE_UPLOADED);
                                            fuguMessageAdapter.notifyItemChanged(messageIndex);
                                            if (!messageSendingRecursion && isNetworkAvailable()) {
                                                sendMessages();
                                            }
                                            break;
                                        }
                                    }
                                }
                            } catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                    break;
                case BroadCastStatus.UPLOADING_FAILED:
                    try {
                        if (currentChannelId == intent.getLongExtra("channelId", -2)) {
                            String muid = intent.getStringExtra("muid");
                            int messageIndex = intent.getIntExtra("messageIndex", 0);
                            String imageUrl = intent.getStringExtra("image_url");
                            String thumbnailUrl = intent.getStringExtra("thumbnail_url");
                            FileuploadModel fileuploadModel = new Gson().fromJson(intent.getStringExtra("fileuploadModel"), FileuploadModel.class);

                            unsentMessageMapNew.put(muid, fileuploadModel.getMessageObject());

                            ListItem listItem = unsentMessages.get(fileuploadModel.getMuid());
                            if (listItem == null)
                                return;
                            Message message = ((EventItem) listItem).getEvent();
                            message.setMessageStatus(MESSAGE_FILE_RETRY);
                            message.setFileUrl(imageUrl);
                            message.setImageUrl(imageUrl);
                            message.setLocalImagePath(fileuploadModel.getFilePath());
                            message.setThumbnailUrl(thumbnailUrl);
                            message.setUploadStatus(UPLOAD_FAILED);

                            unsentMessages.put(muid, new EventItem(message));

                            try {
                                ((EventItem) fuguMessageList.get(messageIndex)).getEvent().setMessageStatus(MESSAGE_FILE_RETRY);
                                fuguMessageAdapter.notifyItemChanged(messageIndex);
                            } catch (Exception e) {
                                try {
                                    for (int i = fuguMessageList.size() - 1; i >= 0; i--) {
                                        if (fuguMessageList.get(i) instanceof EventItem) {
                                            Message currentMessage = ((EventItem) fuguMessageList.get(i)).getEvent();
                                            if (currentMessage.getMuid().equals(muid)) {
                                                messageIndex = i;
                                                ((EventItem) fuguMessageList.get(messageIndex)).getEvent().setMessageStatus(MESSAGE_FILE_RETRY);
                                                fuguMessageAdapter.notifyItemChanged(messageIndex);
                                                break;
                                            }
                                        }
                                    }
                                } catch (Exception e1) {
                                    e1.printStackTrace();
                                }
                            }
                        }
                    } catch (Exception e) {
                        if (HippoConfig.DEBUG)
                            e.printStackTrace();
                    }
                    break;
                case BroadCastStatus.PUBLISHED:

                    break;
                case BroadCastStatus.CREATE_CHANNEL:
                    /*if(CommonData.isFirstTimeCreated()) {
                        CommonData.setFirstTimeCreated(false);
                        final FileuploadModel fileuploadModel = new Gson().fromJson(intent.getStringExtra("fileuploadModel"), FileuploadModel.class);
                        runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                createConversation(fileuploadModel.getMessageObject(), fileuploadModel.getLabelId());
                            }
                        });

                    }*/
                    break;
                case BroadCastStatus.MESSAGE_EXPIRED:
                    String muid = intent.getStringExtra("muid");
                    int messageIndex = intent.getIntExtra("messageIndex", 0);

                    if (unsentMessages == null)
                        unsentMessages = new LinkedHashMap<>();

                    ListItem listItem = unsentMessages.get(muid);
                    if (listItem != null) {
                        ((EventItem) listItem).getEvent().setIsMessageExpired(1);
                        ((EventItem) listItem).getEvent().setUploadStatus(UPLOAD_FAILED);
                    }

                    try {
                        JSONObject messageJson = unsentMessageMapNew.get(muid);
                        messageJson.put("is_message_expired", 1);
                        unsentMessageMapNew.put(muid, messageJson);
                        index = messageJson.optInt("message_index", -1);
                        fuguMessageAdapter.notifyItemChanged(index);
                    } catch (Exception e) {
                        //e.printStackTrace();
                    }

                    AgentCommonData.setUnsentMessageByChannel(conversation.getChannelId(), unsentMessages);
                    AgentCommonData.setUnsentMessageMapByChannel(conversation.getChannelId(), unsentMessageMapNew);

                    break;
                default:

                    break;
            }
        }
    };

    private boolean checkButtonClick() {
        boolean click = false;
        if (isNetworkAvailable()) {
            click = true;
            ArrayList<FileuploadModel> fileuploadModels = new Gson().fromJson(Prefs.with(this).getString(KEY, ""), fileuploadType);
            try {
                if (fileuploadModels != null && fileuploadModels.size() > 5) {
                    click = false;
                    Toast.makeText(AgentChatActivity.this, "Already files in queue. Please wait", Toast.LENGTH_SHORT).show();
                }
            } catch (Exception e) {
                click = true;
            }
        } else {
            Toast.makeText(AgentChatActivity.this, getString(R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
        }
        return click;
    }

    String fullname = "";
    String image = "";

    private void videoCallInit(int callType) {
        boolean isAgentFlow = false;
        boolean isAllowCall = false;

        FuguAgentGetMessageResponse mFuguGetMessageResponse = AgentCommonData.getSingleAgentData(conversation.getChannelId());
        if (mFuguGetMessageResponse == null || mFuguGetMessageResponse.getData() == null)
            return;

        if (callType == AUDIO_CALL_VIEW && (!mFuguGetMessageResponse.getData().isAllowAudioCall() || !AgentCommonData.getAudioCallStatus()))
            return;

        if (callType == VIDEO_CALL_VIEW && (!mFuguGetMessageResponse.getData().isAllowVideoCall() || !AgentCommonData.getVideoCallStatus()))
            return;


//        if (mFuguGetMessageResponse != null && mFuguGetMessageResponse.getData() != null &&
//                !TextUtils.isEmpty(mFuguGetMessageResponse.getData().getAgentName())) {
//            fullname = mFuguGetMessageResponse.getData().getAgentName();
//        }
        if (mFuguGetMessageResponse.getData() != null && !TextUtils.isEmpty(mFuguGetMessageResponse.getData().getCustomerName())) {
            fullname = mFuguGetMessageResponse.getData().getCustomerName();
        }

        Integer userId = AgentCommonData.getUserData().getUserId();
        if(mFuguGetMessageResponse != null && mFuguGetMessageResponse.getData() != null &&
                mFuguGetMessageResponse.getData().getOtherUsers() != null && mFuguGetMessageResponse.getData().getOtherUsers().size()>0) {
            fullname = mFuguGetMessageResponse.getData().getOtherUsers().get(0).getFullName();
            image = mFuguGetMessageResponse.getData().getOtherUsers().get(0).getUserImage();
        }


        if (HippoConfig.getInstance().getCallData() != null) {
            HippoConfig.getInstance().getCallData().onCallClick(this, callType, conversation.getChannelId(), (long) userId, isAgentFlow, isAllowCall,
                    fullname, image);
        } else {
            try {
                HippoConfig.getInstance();
                HippoCallView.getInstance().onCallBtnClick(this, callType, conversation.getChannelId(), (long) userId, isAgentFlow, isAllowCall, fullname, image);
            } catch (Exception e) {

            }
        }


    }

    /*private com.hippo.videoCall.model.Message getTurnCredentials() {
        com.hippo.videoCall.model.Message turnCredentials = new com.hippo.videoCall.model.Message();
        turnCredentials.setCredentials("3FXCGBCnDfqsrOqs");
        turnCredentials.setUsername("fuguadmin");

        IceServers iceServers = new IceServers();
        ArrayList<String> stringStun = new ArrayList<>();
        stringStun.add("stun:turnserver.fuguchat.com:19305");
        iceServers.setStun(stringStun);

        ArrayList<String> stringTurn = new ArrayList<>();
        stringTurn.add("turn:turnserver.fuguchat.com:19305?transport=UDP");
        stringTurn.add("turn:turnserver.fuguchat.com:19305?transport=TCP");
        stringTurn.add("turns:turnserver.fuguchat.com:5349?transport=UDP");
        stringTurn.add("turns:turnserver.fuguchat.com:5349?transport=TCP");
        iceServers.setTurn(stringTurn);
        turnCredentials.setIceServers(iceServers);

        turnCredentials.setTurnApiKey("VPlwuCJcizZye2znMflmJ75x0IraJ5cQ");

        return turnCredentials;
    }


    private void videoCallInit(int callType) {
        com.hippo.videoCall.model.Message turnCredentials = getTurnCredentials();
        Intent videoIntent = new Intent(AgentChatActivity.this, FuguCallActivity.class);
        String messageUniqueId = UUID.randomUUID().toString() + "." + new Date().getTime();

        String fullname = TextUtils.isEmpty(videoCustomerName) ?  AgentCommonData.getAgentMessageResponse(conversation.getChannelId().intValue()).getData().getCustomerName(): videoCustomerName;


        String image = "";
        String activityLaunchState = WebRTCCallConstants.AcitivityLaunchState.SELF.toString();
        if(callType == AUDIO_CALL_VIEW)
            activityLaunchState = WebRTCCallConstants.AcitivityLaunchState.AUDIO.toString();

        VideoCallModel videoCallModel = new VideoCallModel(currentChannelId,
                image,
                fullname,
                userData.getUserId(), fullname, callType, turnCredentials.getTurnApiKey(),
                turnCredentials.getUsername(), turnCredentials.getCredentials(),
                (ArrayList<String>) (turnCredentials.getIceServers().getStun()),
                (ArrayList<String>) (turnCredentials.getIceServers().getTurn()),
                activityLaunchState, messageUniqueId);
        videoIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        videoIntent.addFlags(Intent.FLAG_ACTIVITY_EXCLUDE_FROM_RECENTS);
        videoIntent.putExtra("videoCallModel", videoCallModel);
        startActivity(videoIntent);
    }*/
}
