package com.hippo.activity;

import android.os.Bundle;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.appcompat.widget.Toolbar;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.adapter.CustomerInitalAdapter;
import com.hippo.apis.ApiPutUserDetails;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.interfaces.CustomerInitalListener;
import com.hippo.model.Field;
import com.hippo.utils.HippoLog;

import java.util.ArrayList;
import java.util.HashMap;

/**
 * Created by gurmail on 14/02/19.
 *
 * @author gurmail
 */
public class CustomerInitalActivity extends FuguBaseActivity implements FuguAppConstant, CustomerInitalListener {

    private static final String TAG = CustomerInitalActivity.class.getSimpleName();
    private RecyclerView recyclerView;
    private CustomerInitalAdapter initalAdapter;
    private Toolbar myToolbar;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.hippo_activity_customer_inital);

        myToolbar = findViewById(R.id.my_toolbar);
        setSupportActionBar(myToolbar);

        String title = "";
        try {
            title = CommonData.getUserDetails().getData().getCustomerInitialFormInfo().getPageTitle();
        } catch (Exception e) {

        }
        title = TextUtils.isEmpty(title) ? CommonData.getChatTitle() : title;
        setToolbar(myToolbar, title);

        recyclerView = findViewById(R.id.recyclerView);
        LinearLayoutManager layoutManager = new LinearLayoutManager(CustomerInitalActivity.this);
        layoutManager.setOrientation(LinearLayoutManager.VERTICAL);

        recyclerView.setLayoutManager(layoutManager);

        ArrayList<Object> objects = new ArrayList<>();


        /*ArrayList<Field> fields = new ArrayList<>();
        ArrayList<Button> buttons = new ArrayList<>();

        for(int i=0;i<4;i++) {
            Field field = getField(i);
            fields.add(field);
        }


        for(int i=0;i<1;i++) {
            Button button = new Button();
            button.setAction("SUBMIT");
            button.setButtonBackgroundColor("#ffffff");
            button.setId(""+i);
            button.setTitle("Submit");
            button.setTitleColor("#000000");
            button.setType("BUTTON");

            buttons.add(button);
        }*/

        objects.addAll(CommonData.getUserDetails().getData().getCustomerInitialFormInfo().getFields());
        objects.add(CommonData.getUserDetails().getData().getCustomerInitialFormInfo().getButton());

        initalAdapter = new CustomerInitalAdapter(objects, getSupportFragmentManager(), this);
        recyclerView.setAdapter(initalAdapter);

    }

    /*private Field getField(int pos) {
        Field field = new Field();
        switch (pos) {
            case 0:
                field.setIndex(pos);
                field.setDescription("To continue you need to fill below details");
                field.setIsRequired(true);
                field.setPlaceholder("");
                field.setKey("");
                field.setTitle("Please Fill below details");
                field.setType("LABEL");
                field.setValidationType("NONE");
                break;
            case 1:
                field.setIndex(pos);
                field.setDescription("");
                field.setIsRequired(true);
                field.setPlaceholder("Enter Email");
                field.setKey("email");
                field.setTitle("Email");
                field.setType("TEXTFIELD");
                field.setValidationType("EMAIL");
                break;
            case 2:
                field.setIndex(pos);
                field.setDescription("");
                field.setIsRequired(true);
                field.setPlaceholder("Enter your full name");
                field.setKey("full_name");
                field.setTitle("Name");
                field.setType("TEXTFIELD");
                field.setValidationType("ANY");
                break;
            case 3:
                field.setIndex(pos);
                field.setDescription("");
                field.setIsRequired(true);
                field.setPlaceholder("Enter Contact Number");
                field.setKey("phone_number");
                field.setTitle("Contact Number");
                field.setType("CONTACT_NUMBER");
                field.setValidationType("PHONE_NUMBER");
                break;
            default:

                break;
        }

        return field;
    }*/

    @Override
    protected void onResume() {
        super.onResume();
    }

    @Override
    protected void onPause() {
        super.onPause();
    }

    @Override
    protected void onStop() {
        super.onStop();
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
    }


    @Override
    public void onButtonClicked(ArrayList<Object> objects) {
        HippoLog.v(TAG, "objects >>>>>> "+new Gson().toJson(objects));

        HashMap<String, Object> objectHashMap = CommonData.getPutUserParams();
        for(Object object : objects) {
            if(object instanceof Field) {
                Field field = (Field) object;
                if(field.getType().toLowerCase().equalsIgnoreCase("LABEL")) {
                    //do nothing here.
                } else if(field.getType().toLowerCase().equalsIgnoreCase("contact_number")) {
                    objectHashMap.put(field.getKey(), field.getCountryCode()+field.getTextValue().trim());
                } else {
                    objectHashMap.put(field.getKey(), field.getTextValue().trim());
                }

            } else {
//                Button button = (Button) object;
//                objectHashMap.put(button.getKey(), button.getAction());
            }
        }


        new ApiPutUserDetails(CustomerInitalActivity.this, new ApiPutUserDetails.Callback() {
            @Override
            public void onSuccess() {
                openConversation();
            }

            @Override
            public void onFailure() {

            }
        }).updateUserData(objectHashMap);

    }

    @Override
    public void onNotifyAdapter(ArrayList<Object> objects) {
        HippoLog.v(TAG, "arrayList ******** "+new Gson().toJson(objects));

        if(initalAdapter != null) {
//            initalAdapter.notifyDataSetChanged();
            initalAdapter = null;
            initalAdapter = new CustomerInitalAdapter(objects, getSupportFragmentManager(), this);
            recyclerView.setAdapter(initalAdapter);
        }
    }

    private void openConversation() {
        HippoConfig.getInstance().showConversations(CustomerInitalActivity.this, CommonData.getChatTitle());
        finish();
    }
}
