package com.hippo.agent;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Typeface;
import android.os.Bundle;
import androidx.annotation.Nullable;
import com.google.android.material.tabs.TabLayout;
import androidx.fragment.app.Fragment;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.viewpager.widget.ViewPager;
import androidx.appcompat.widget.Toolbar;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StyleSpan;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.hippo.HippoColorConfig;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.agent.Util.ConversationMode;
import com.hippo.agent.Util.FragmentType;
import com.hippo.agent.adapter.PagerAdapter;
import com.hippo.agent.database.AgentCommonData;
import com.hippo.agent.fragment.AllChatFragment;
import com.hippo.agent.fragment.MyChatFragment;
import com.hippo.agent.listeners.AgentConnectionListener;
import com.hippo.agent.listeners.UnreadListener;
import com.hippo.agent.model.GetConversationResponse;
import com.hippo.agent.model.LoginModel.UserData;
import com.hippo.agent.model.getConversationResponse.Conversation;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.CommonParams;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.utils.HippoLog;
import com.hippo.utils.loadingBox.LoadingBox;
import com.hippo.utils.loadingBox.ProgressWheel;
import com.google.gson.Gson;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

import static com.hippo.constant.FuguAppConstant.NETWORK_STATE_INTENT;

/**
 * Created by gurmail on 18/06/18.
 *
 * @author gurmail
 */

public class AgentListActivity extends AgentBaseActivity implements AgentConnectionListener {

    private static final String TAG = AgentListActivity.class.getSimpleName();
    private TabLayout tabLayout;
    private ViewPager viewPager;
    private PagerAdapter pagerAdapter;
    ArrayList<Fragment> pagerFragments = new ArrayList<>();
    String[] titles = new String[2];
    public UserData userData;
    /*@SuppressLint("StaticFieldLeak")
    private static LinearLayout llInternet;
    @SuppressLint("StaticFieldLeak")
    private static TextView tvStatus;*/
    private HippoColorConfig hippoColorConfig;
    private TextView tvPoweredBy;
    private LinearLayout fragmentView;
    private boolean skipFirstResume;
    private ImageView ivViewInfo, ivViewBroadcast;
    private Toolbar myToolbar;

    private LinearLayout retryLayout;
    private TextView btnRetry;
    private ProgressWheel progressWheel;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.hippo_activity_chatlist);
        HippoConfig.getInstance().setChannelActivity(true);
        setConnectionManager();
        initView();
        LocalBroadcastManager.getInstance(this).registerReceiver(mMessageReceiver, getIntentFilter());

        checkAutoUpload();
    }


    private void setConnectionManager() {
        userData = AgentCommonData.getUserData();
        AgentConnectionManager.getInstance().setUserData(userData);
        AgentConnectionManager.getInstance().setUpFayeConnection();
        AgentConnectionManager.getInstance().setConnectionListener(this);
    }

    private void initView() {

        myToolbar = findViewById(R.id.my_toolbar);
        setSupportActionBar(myToolbar);


        ivViewInfo = findViewById(R.id.ivViewInfo);
        ivViewBroadcast = findViewById(R.id.ivViewBroadcast);

        ivViewInfo.setVisibility(View.GONE);
        //ivViewBroadcast.setVisibility(View.GONE);

        btnRetry = findViewById(R.id.btnRetry);
        progressWheel = findViewById(R.id.retry_loader);
        retryLayout = findViewById(R.id.retry_layout);

        tvPoweredBy = findViewById(R.id.tvPoweredBy);
        viewPager = findViewById(R.id.view_pager);
        tabLayout = findViewById(R.id.sliding_tabs);
        pagerFragments = new ArrayList<>();
        hippoColorConfig = CommonData.getColorConfig();
        fragmentView = findViewById(R.id.fragment_view);
        skipFirstResume = true;
        String transactionId = "";
        if(getIntent().hasExtra("transaction_id"))
            transactionId = getIntent().getStringExtra("transaction_id");
        if (getIntent().hasExtra("user_unique_key")) {
            String userUniqueKey = getIntent().getStringExtra("user_unique_key");
            openUserUniqueChat(userUniqueKey, transactionId);
        } else {
            openPagerScreen();
        }
        setTabColor();
        setPoweredByText();

        ivViewBroadcast.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(AgentListActivity.this, AgentBroadcastActivity.class);
                intent.putExtra("title", "Broadcast Message");
                startActivity(intent);
            }
        });
    }

    private void openPagerScreen() {
        setToolbar(myToolbar, AgentCommonData.getMainTitle());//getIntent().getStringExtra("title"));
        fragmentView.setVisibility(View.GONE);
        ivViewInfo.setVisibility(View.GONE);

        // TODO: 31/12/18 Exposs broadcast drawable to end user.
        ivViewBroadcast.setImageResource(R.drawable.hippo_ic_broadcast);
        try {
            if(CommonData.getAttributes().isBroadcastEnabled()) {
                ivViewBroadcast.setVisibility(View.VISIBLE);
            } else {
                ivViewBroadcast.setVisibility(View.GONE);
            }
        } catch (Exception e) {
            ivViewBroadcast.setVisibility(View.GONE);
        }

//        ivViewBroadcast.setImageResource(HippoConfig.getInstance().getBroadcastDrawable() == -1
//                ? R.drawable.hippo_ic_broadcast : HippoConfig.getInstance().getBroadcastDrawable());

        viewPager.setVisibility(View.VISIBLE);
        tabLayout.setVisibility(View.VISIBLE);
        pagerFragments = new ArrayList<>();

        //clear unsent data
        AgentCommonData.clearTotalUnreadCount();

        boolean isReverseOrder = AgentCommonData.getPagerOrder();

        if(isReverseOrder) {
            pagerFragments.add(new AllChatFragment());
            pagerFragments.add(new MyChatFragment());

            titles[0] = "All Chat";
            titles[1] = "My Chat";
        } else {
            pagerFragments.add(new MyChatFragment());
            pagerFragments.add(new AllChatFragment());

            titles[0] = "My Chat";
            titles[1] = "All Chat";
        }



        pagerAdapter = new PagerAdapter(getSupportFragmentManager(), pagerFragments, titles);
        viewPager.setAdapter(pagerAdapter);
        // Give the TabLayout the ViewPager

        tabLayout.setupWithViewPager(viewPager);
    }

    private void setTabColor() {
        tabLayout.setSelectedTabIndicatorColor(hippoColorConfig.getHippoSelectedTabIndicatorColor());
//        tabLayout.setSelectedTabIndicatorHeight((int) (5 * getResources().getDisplayMetrics().density));
        tabLayout.setTabTextColors(hippoColorConfig.getHippoTabTextColor(), hippoColorConfig.getHippoTabSelectedTextColor());
    }

    @Override
    protected void onStart() {
        super.onStart();
    }

    @Override
    protected void onStop() {
        super.onStop();
    }

    @Override
    protected void onResume() {
        super.onResume();
        if (!skipFirstResume)
            AgentConnectionManager.getInstance().onRefreshData();
        skipFirstResume = false;
    }

    @Override
    protected void onPause() {
        super.onPause();
        skipFirstResume = false;
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();

    }

    @Override
    protected void onDestroy() {
        for (UnreadListener listener : HippoConfig.getInstance().getUIListeners(UnreadListener.class)) {
            if (listener != null) {
                listener.sendTotalUnreadCount();
                listener.getUnreadCount();
            }
        }
//        UnreadCountHelper.getInstance().sendTotalUnreadCount();
//        UnreadCountHelper.getInstance().getUnreadCount();
        HippoConfig.getInstance().setChannelActivity(false);
        AgentConnectionManager.getInstance().onDestroy();
        LocalBroadcastManager.getInstance(this).unregisterReceiver(mMessageReceiver);
        super.onDestroy();
    }

    private int[] typeIntArray = new int[]{ConversationMode.DEFAULT.getOrdinal()};

    private void openUserUniqueChat(final String userUniqueId, final String transactionId) {
        setToolbar(myToolbar, "");

        ArrayList<String> strings = new ArrayList<>();
        strings.add(userUniqueId);

        if (userData == null) {
            userData = AgentCommonData.getUserData();
        }
        if(!isNetworkAvailable()) {
            setToolbar(myToolbar, getIntent().getStringExtra("title"));
            return;
        }

        LoadingBox.showOn(AgentListActivity.this);

        String userID = String.valueOf(userData.getEnUserId());
        String accessToken = userData.getAccessToken();
        HashMap<String, Object> params = new HashMap<>();
        params.put(FuguAppConstant.EN_USER_ID, userID);
        params.put(FuguAppConstant.ACCESS_TOKEN, accessToken);
        params.put(FuguAppConstant.STATUS, "[1]");
        params.put(FuguAppConstant.DEVICE_TYPE, 1);
        params.put(FuguAppConstant.TYPE, Arrays.toString(typeIntArray));

        params.put("search_user_unique_key", new Gson().toJson(strings));

        if(!TextUtils.isEmpty(transactionId))
            params.put("transaction_id", transactionId);

        CommonParams commonParams = new CommonParams.Builder()
                .addAll(params)
                .build(2);

        RestClient.getAgentApiInterface().getConversation(commonParams.getMap()).enqueue(new ResponseResolver<GetConversationResponse>() {
            @Override
            public void success(GetConversationResponse getConversationResponse) {

                fragmentView.setVisibility(View.VISIBLE);
                viewPager.setVisibility(View.GONE);
                tabLayout.setVisibility(View.GONE);
                LoadingBox.hide();
                ArrayList<Conversation> conversationChatList = (ArrayList<Conversation>) getConversationResponse.getData().getConversation();
                if(conversationChatList != null && conversationChatList.size() == 0) {
                    openp2pConversation(userUniqueId, getIntent().getStringExtra("title"));
                } else if(conversationChatList != null && conversationChatList.size() == 1) {
                    Conversation conversation = (Conversation) conversationChatList.get(0);
                    Intent intent = new Intent(AgentListActivity.this, AgentChatActivity.class);
                    intent.putExtra(FuguAppConstant.CONVERSATION, new Gson().toJson(conversation, Conversation.class));
                    intent.putExtra(FuguAppConstant.CREATE_NEW_CHAT, true);
                    intent.putExtra(FuguAppConstant.FRAGMENT_TYPE, FragmentType.USER_CHAT.getOrdinal());
                    startActivity(intent);
                    overridePendingTransition(0,0);
                    finish();
                }
                else {
                    setToolbar(myToolbar, getIntent().getStringExtra("title"));
                    String data = new Gson().toJson(getConversationResponse, GetConversationResponse.class);
                    MyChatFragment myChatFragment = new MyChatFragment();
                    Bundle bundle = new Bundle();
                    int fragmentType = FragmentType.USER_CHAT.getOrdinal();
                    bundle.putString(FuguAppConstant.USER_UNIQUE_KEY, userUniqueId);
                    bundle.putString(FuguAppConstant.CONVERSATION, data);
                    bundle.putInt(FuguAppConstant.FRAGMENT_TYPE, fragmentType);
                    myChatFragment.setArguments(bundle);
                    getSupportFragmentManager().beginTransaction()
                            .add(R.id.fragment_view, myChatFragment, MyChatFragment.class.getName())
                            .commitAllowingStateLoss();
                    ivViewInfo.setVisibility(View.VISIBLE);

                    ivViewBroadcast.setVisibility(View.GONE);


                    // TODO: 31/12/18 Exposs drawable to end user.
                    ivViewInfo.setImageResource(R.drawable.ic_hippo_chat_info);


                    /*ivViewInfo.setImageResource(HippoConfig.getInstance().getHomeIconDrawable() == -1
                            ? R.drawable.hippo_ic_fugu_home : HippoConfig.getInstance().getHomeIconDrawable());
                    if(HippoConfig.getInstance().getHomeIconDrawable() != -1) {
                        ivViewInfo.getDrawable().setColorFilter(hippoColorConfig.getHippoHomeColor(), PorterDuff.Mode.SRC_IN);
                    }*/

                    ivViewInfo.setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View v) {
                            openPagerScreen();
                            ivViewInfo.setVisibility(View.GONE);
                        }
                    });
                }
            }

            @Override
            public void failure(APIError error) {
                LoadingBox.hide();
                Log.e(TAG, "Error: "+error.getMessage());
            }
        });

    }

    /**
     * Set powered by text
     */
    private void setPoweredByText() {
        UserData userData = AgentCommonData.getUserData();
        tvPoweredBy.setVisibility(View.GONE);
        /*if (!userData.getWhiteLabel()) {
            try {
                poweredByView(getString(R.string.fugu_powered_by), getString(R.string.fugu_text), hippoColorConfig);
            } catch (Exception e) {
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {

                    String text = "<font color="
                            + String.format("#%06X",
                            (0xFFFFFF & hippoColorConfig.getHippoTextColorPrimary())) + ">"
                            + getString(R.string.fugu_powered_by)
                            + "<font color=" + String.format("#%06X",
                            (0xFFFFFF & hippoColorConfig.getFuguRunsOnColor())) + "> "
                            + getString(R.string.fugu_text) + "</font>";
                    //noinspection deprecation
                    tvPoweredBy.setText(Html.fromHtml(text));
                } else {
                    String text = "<font color="
                            + String.format("#%06X",
                            (0xFFFFFF & hippoColorConfig.getHippoTextColorPrimary())) + ">"
                            + getString(R.string.fugu_powered_by)
                            + "<font color=" + String.format("#%06X",
                            (0xFFFFFF & hippoColorConfig.getFuguRunsOnColor())) + "> "
                            + getString(R.string.fugu_text) + "</font>";
                    tvPoweredBy.setText(Html.fromHtml(text));
                }

                tvPoweredBy.setBackgroundDrawable(HippoColorConfig.makeSelector(hippoColorConfig.getHippoChannelItemBg(), hippoColorConfig.getHippoChannelItemBgPressed()));
            }
        } else {
            tvPoweredBy.setVisibility(View.GONE);
        }*/
    }

    private void poweredByView(String firstString, String lastString, HippoColorConfig hippoColorConfig) throws Exception {
        String changeString = (lastString != null ? lastString : "Hippo");
        String totalString = firstString + " " + changeString;
        Log.v(TAG, "totalString = " + totalString);
        Spannable spanText = new SpannableString(totalString);
        spanText.setSpan(new StyleSpan(Typeface.BOLD), String.valueOf(firstString).length(), totalString.length(), 0);
        spanText.setSpan(new ForegroundColorSpan(hippoColorConfig.getFuguRunsOnColor()), String.valueOf(firstString).length(), totalString.length(), 0);
        spanText.setSpan(new RelativeSizeSpan(0.8f), 0, String.valueOf(firstString).length(), 0);


        tvPoweredBy.setText(spanText);
        tvPoweredBy.setBackgroundDrawable(HippoColorConfig.makeSelector(hippoColorConfig.getHippoChannelItemBg(), hippoColorConfig.getHippoChannelItemBgPressed()));
    }

    private void openp2pConversation(String userUniqueKey, String title) {
        Conversation conversation = new Conversation();
        conversation.setChannelId(-1L);
        conversation.setChannelName("dummyChannelName");
        conversation.setStatus(-2);
        conversation.setAgentId(-2);
        conversation.setUserUniqueKeys(userUniqueKey);

        conversation.setLabel(title);
        conversation.setUnreadCount(0);

        Intent intent = new Intent(AgentListActivity.this, AgentChatActivity.class);
        intent.putExtra(FuguAppConstant.CONVERSATION, new Gson().toJson(conversation, Conversation.class));
        intent.putExtra(FuguAppConstant.CREATE_NEW_CHAT, true);
        intent.putExtra(FuguAppConstant.FRAGMENT_TYPE, FragmentType.USER_CHAT.getOrdinal());
        startActivity(intent);
        overridePendingTransition(0,0);
        finish();
    }
    public void setConnectionMessage(int status) {
        if (isNetworkAvailable()) {
            switch (status) {
                case 0:
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            retryLayout.setVisibility(View.GONE);
                        }
                    });
                    break;
                case 1:
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            retryLayout.setVisibility(View.VISIBLE);
                            progressWheel.setVisibility(View.VISIBLE);
                            btnRetry.setText(getString(R.string.hippo_fetching_messages));
                            retryLayout.setBackgroundColor(hippoColorConfig.getHippoConnected());
                        }
                    });
                    break;
                case 2:
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            retryLayout.setVisibility(View.VISIBLE);
                            progressWheel.setVisibility(View.GONE);
                            btnRetry.setText(getString(R.string.hippo_server_disconnect));
                            retryLayout.setBackgroundColor(hippoColorConfig.getHippoNotConnected());
                        }
                    });
                    break;
                case 3:
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            retryLayout.setVisibility(View.VISIBLE);
                            progressWheel.setVisibility(View.GONE);
                            btnRetry.setText(getString(R.string.hippo_no_network_connected));
                            retryLayout.setBackgroundColor(hippoColorConfig.getHippoNotConnected());
                        }
                    });
                    break;
                case 4:
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            retryLayout.setVisibility(View.VISIBLE);
                            progressWheel.setVisibility(View.GONE);
                            btnRetry.setText(getString(R.string.hippo_server_connecting));
                            retryLayout.setBackgroundColor(hippoColorConfig.getHippoConnected());
                        }
                    });
                    break;
                default:

                    break;
            }
        } else {
            runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    retryLayout.setVisibility(View.VISIBLE);
                    progressWheel.setVisibility(View.GONE);
                    btnRetry.setText(getString(R.string.hippo_no_network_connected));
                    retryLayout.setBackgroundColor(hippoColorConfig.getHippoNotConnected());
                }
            });
        }
    }

    @Override
    public void onConnectionStatus(final String message, int status) {
        if(status ==0 && !myChatFlag && !allChatFlag)
            setConnectionMessage(status);
        else
            setConnectionMessage(status);
    }

    // intentFilter to add multiple actions
    private IntentFilter getIntentFilter() {
        IntentFilter intent = new IntentFilter();
        intent.addAction(NETWORK_STATE_INTENT);
        return intent;
    }

    public boolean myChatFlag, allChatFlag;
    public void hideLoader(int type) {
        if(type == 1)
            myChatFlag = true;
        if(type == 2)
            allChatFlag = true;
        if(myChatFlag && allChatFlag)
            setConnectionMessage(0);
    }

    private BroadcastReceiver mMessageReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            switch (intent.getAction()) {
                case NETWORK_STATE_INTENT:
                    HippoLog.d(TAG, "Network connectivity change " + intent.getBooleanExtra("isConnected", false));
                    if (intent.getBooleanExtra("isConnected", false)) {
                        AgentConnectionManager.getInstance().setNetworkStatus(true);
                        setConnectionManager();
                    } else {

                    }
                    break;
            }

        }
    };
}
