/*
 * Decompiled with CFR 0.152.
 */
package com.hippo;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.core.content.PermissionChecker;
import com.downloader.PRDownloader;
import com.downloader.PRDownloaderConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.hippo.AgentUnreadCountListener;
import com.hippo.CallData;
import com.hippo.CaptureUserData;
import com.hippo.ChatByUniqueIdAttributes;
import com.hippo.HippoConfigAttributes;
import com.hippo.HippoLifeCycle;
import com.hippo.HippoTicketAttributes;
import com.hippo.R;
import com.hippo.UnreadCount;
import com.hippo.UnreadCountFor;
import com.hippo.UnreadCountHelper;
import com.hippo.activity.CustomerInitalActivity;
import com.hippo.activity.FuguChannelsActivity;
import com.hippo.activity.FuguChatActivity;
import com.hippo.agent.AgentBroadcastActivity;
import com.hippo.agent.AgentChatActivity;
import com.hippo.agent.AgentListActivity;
import com.hippo.agent.Util.ConversationMode;
import com.hippo.agent.Util.FragmentType;
import com.hippo.agent.database.AgentCommonData;
import com.hippo.agent.listeners.AgentListener;
import com.hippo.agent.model.ApiResponseFlags;
import com.hippo.agent.model.GetConversationResponse;
import com.hippo.agent.model.LoginModel.UserData;
import com.hippo.agent.model.LoginResponse;
import com.hippo.agent.model.getConversationResponse.Conversation;
import com.hippo.apis.ApiPutUserDetails;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.interfaces.fayeClient;
import com.hippo.model.CustomAttributes;
import com.hippo.model.FuguConversation;
import com.hippo.model.FuguCreateConversationParams;
import com.hippo.model.FuguPutUserDetailsResponse;
import com.hippo.model.UserInfoModel;
import com.hippo.receiver.FuguNetworkStateReceiver;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.CommonParams;
import com.hippo.retrofit.CommonResponse;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.support.HippoSupportActivity;
import com.hippo.utils.CustomAlertDialog;
import com.hippo.utils.HippoLog;
import com.hippo.utils.StringUtil;
import com.hippo.utils.UniqueIMEIID;
import com.hippo.utils.UnreadCountApi;
import com.hippo.utils.Utils;
import com.hippo.utils.fileUpload.Prefs;
import com.hippo.utils.loadingBox.LoadingBox;
import faye.FayeClient;
import faye.MetaMessage;
import io.paperdb.Paper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Callback;

public class HippoConfig
implements FuguAppConstant {
    private static final String TAG = HippoConfig.class.getSimpleName();
    private static HippoConfig hippoConfig;
    private CaptureUserData userData;
    private static HippoConfigAttributes configAttributes;
    private String serverUrl = "";
    private int homeUpIndicatorDrawableId = -1;
    private int videoCallNotificationDrawable = R.drawable.hippo_default_notif_icon;
    private int videoCallDrawableId = -1;
    private int audioCallDrawableId = -1;
    private int chatInfoDrawable = -1;
    private int homeIconDrawable = -1;
    private int broadcastDrawable = -1;
    private int icSend = -1;
    public String appKey = "";
    private String appType = "1";
    private HippoConfigAttributes attributes;
    private static String mResellerToken;
    private static int mReferenceId;
    protected Context context;
    private Activity activity;
    private long lastClickTime = 0L;
    private boolean isDataCleared = true;
    public static boolean DEBUG;
    private boolean isChannelActivity;
    private static boolean isUnreadRequired;
    private static MetaMessage meta;
    private static FayeClient mClient;
    public static boolean progressLoader;
    String title = "";
    String userUniqueKey = "";
    String transactionId = "";
    private ArrayList<String> strings;
    String email;
    private AgentUnreadCountListener unreadCount;
    private HashMap<String, Long> channelIds = new HashMap();
    private int targetSDKVersion = 0;
    private UnreadCount callbackListener;
    private AgentUnreadCountListener countListener;
    private boolean openAgentScreen;
    private boolean apiInProgress;
    private String chatTitle = "Chat";
    private Queue<String> objectQueue = new LinkedList<String>();
    private Map<Class<? extends AgentListener>, Collection<? extends AgentListener>> agentListeners;
    private CallData callData;
    private HippoLifeCycle lifeCycle;
    private Integer botId = null;
    private Boolean skipBot = null;
    private String skipBotReasion = "";

    public int getHomeUpIndicatorDrawableId() {
        return this.homeUpIndicatorDrawableId;
    }

    public void setHomeUpIndicatorDrawableId(int homeUpIndicatorDrawableId) {
        this.homeUpIndicatorDrawableId = homeUpIndicatorDrawableId;
    }

    public int getIcSend() {
        return this.icSend;
    }

    public void setIcSend(int icSend) {
        this.icSend = icSend;
    }

    private HippoConfig() {
    }

    public static long getMaxSize() {
        try {
            Long maxFileSize = 0x1900000L;
            maxFileSize = AgentCommonData.isAgentFlow() ? AgentCommonData.getUserData().getMaxFileSize() : CommonData.getUserDetails().getData().getMaxFileSize();
            return maxFileSize;
        }
        catch (Exception e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            return 0x1900000L;
        }
    }

    public Context getContext() {
        return this.context;
    }

    public static HippoConfig getInstance() {
        if (hippoConfig == null) {
            hippoConfig = new HippoConfig();
        }
        return hippoConfig;
    }

    private HippoConfigAttributes getAttributes() {
        if (this.attributes == null) {
            this.attributes = CommonData.getAttributes();
        }
        return this.attributes;
    }

    public static HippoConfig initHippoConfig(Activity activity, HippoConfigAttributes attributes) {
        block9: {
            hippoConfig = HippoConfig.getInstance();
            Paper.init((Context)activity);
            DEBUG = attributes.isShowLog();
            HippoConfig.getInstance().activity = activity;
            if (!CommonData.getClearHippoDataKey()) {
                try {
                    CommonData.clearData();
                    CommonData.setClearHippoDataKey(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            AgentCommonData.setAgentLoginInit(attributes.isManager());
            if (TextUtils.isEmpty((CharSequence)attributes.getProvider())) {
                new CustomAlertDialog.Builder((Context)activity).setMessage("Provider cannot be null").setPositiveButton("Ok", new CustomAlertDialog.CustomDialogInterface.OnClickListener(){

                    @Override
                    public void onClick() {
                        HippoConfig.getInstance().activity.finish();
                    }
                }).show();
            } else {
                CommonData.setProvider(attributes.getProvider());
            }
            if (attributes.getColorConfig() != null) {
                CommonData.setColorConfig(attributes.getColorConfig());
            }
            if (!TextUtils.isEmpty((CharSequence)attributes.getImagePath())) {
                CommonData.setUserImagePath(attributes.getImagePath());
            }
            try {
                CommonData.saveDeviceToken(attributes.getDeviceToken());
            }
            catch (Exception e) {
                if (!DEBUG) break block9;
                e.printStackTrace();
            }
        }
        CommonData.saveFuguConfigAttribute(attributes);
        HippoLog.v("inside initHippoConfig", "inside initHippoConfig");
        hippoConfig.setFuguConfig(activity, attributes);
        return hippoConfig;
    }

    private void initDownloader() {
        PRDownloaderConfig config = PRDownloaderConfig.newBuilder().setDatabaseEnabled(true).setReadTimeout(30000).setConnectTimeout(30000).build();
        PRDownloader.initialize((Context)this.activity, (PRDownloaderConfig)config);
    }

    private void setFuguConfig(final Activity activity, HippoConfigAttributes attributes) {
        String environment;
        String string2 = environment = TextUtils.isEmpty((CharSequence)attributes.getEnvironment()) ? "live" : attributes.getEnvironment();
        if (environment != null && environment.equalsIgnoreCase("test")) {
            HippoConfig.getInstance().serverUrl = "https://hippo-api-dev.fuguchat.com:3011";
            CommonData.setServerUrl("https://hippo-api-dev.fuguchat.com:3011");
        } else if (environment != null && environment.equalsIgnoreCase("dev")) {
            HippoConfig.getInstance().serverUrl = "https://hippo-api-dev.fuguchat.com:3002";
            CommonData.setServerUrl("https://hippo-api-dev.fuguchat.com:3002");
        } else if (environment != null && environment.equalsIgnoreCase("beta-live")) {
            HippoConfig.getInstance().serverUrl = "https://api.fuguchat.com";
            CommonData.setServerUrl("https://api.fuguchat.com");
        } else {
            HippoConfig.getInstance().serverUrl = "https://api.fuguchat.com";
            CommonData.setServerUrl("https://api.fuguchat.com");
        }
        this.attributes = attributes;
        this.registerNetworkListener((Context)activity);
        if (attributes.isManager()) {
            this.initHippoManager(activity, attributes);
        } else if (!TextUtils.isEmpty((CharSequence)CommonData.getUserCountryCode())) {
            this.initHippoCustomer(activity, attributes);
        } else {
            new ApiPutUserDetails(activity, null).getUserContryInfo(attributes, new ApiPutUserDetails.UserCallback(){

                @Override
                public void onSuccess(UserInfoModel userInfoModel, HippoConfigAttributes attributes) {
                    HippoConfig.this.initHippoCustomer(activity, attributes);
                }
            });
        }
    }

    private void initHippoCustomer(Activity activity, HippoConfigAttributes attributes) {
        HippoConfig.getInstance().appKey = attributes.getAppKey();
        HippoConfig.getInstance().appType = attributes.getAppType();
        if (HippoConfig.getInstance().appKey != null) {
            CommonData.setAppSecretKey(HippoConfig.getInstance().appKey);
        }
        CommonData.setAppType(HippoConfig.getInstance().appType);
        CommonData.clearLeftTimeInSec();
        this.updateUserDetails(activity, attributes);
    }

    private void initHippoManager(Activity activity, HippoConfigAttributes attributes) {
        AgentCommonData.setPagerOrder(attributes.isReversePageOrder());
        HippoConfig.getInstance().activity = activity;
        HippoConfig.getInstance().context = activity;
        HippoConfig.getInstance().appType = attributes.getAppType();
        CommonData.setAppType(HippoConfig.getInstance().appType);
        if (attributes.isWhitelabel()) {
            CommonParams commonParams = new CommonParams.Builder().add("agent_secret_key", attributes.getAuthToken()).add("device_type", 1).add("device_token", hippoConfig.getAttributes().getDeviceToken()).add("device_id", UniqueIMEIID.getUniqueIMEIId((Context)activity)).add("device_details", CommonData.deviceDetails((Context)activity)).add("app_version", 207).add("app_version_code", 207).add("source", String.valueOf(2)).add("app_type", this.appType).build(2);
            this.getAgentToken(activity, commonParams.getMap(), attributes.getCustomAttributes());
        } else {
            CommonParams commonParams = new CommonParams.Builder().add("auth_token", attributes.getAuthToken()).add("device_type", 1).add("device_token", hippoConfig.getAttributes().getDeviceToken()).add("device_id", UniqueIMEIID.getUniqueIMEIId((Context)activity)).add("device_details", CommonData.deviceDetails((Context)activity)).add("app_version", 207).add("app_version_code", 207).add("source", String.valueOf(2)).add("app_type", this.appType).build(2);
            this.agentTokenVerfy(activity, commonParams.getMap(), attributes.getCustomAttributes());
        }
    }

    private void updateUserDetails(Activity activity, final HippoConfigAttributes attributes) {
        HippoConfig.getInstance().isDataCleared = false;
        CommonData.setIsDataCleared(false);
        HippoConfig.getInstance().activity = activity;
        HippoConfig.getInstance().context = activity;
        HippoConfig.getInstance().appType = attributes.getAppType();
        HippoConfig.getInstance().userData = attributes.getCaptureUserData() == null ? new CaptureUserData() : attributes.getCaptureUserData();
        CommonData.saveUserData(HippoConfig.getInstance().userData);
        new ApiPutUserDetails(activity, new ApiPutUserDetails.Callback(){

            @Override
            public void onSuccess() {
                if (attributes.isUnreadCount()) {
                    HippoConfig.this.getUnreadCount(HippoConfig.getInstance().activity, CommonData.getUserDetails().getData().getEn_user_id());
                }
            }

            @Override
            public void onFailure() {
            }
        }).sendUserDetails(attributes.getResellerToken(), attributes.getReferenceId());
    }

    private void getAgentToken(final Activity activity, final Map<String, Object> stringMap, final HashMap<String, Object> customAttributes) {
        this.apiInProgress = true;
        RestClient.getAgentApiInterface().getAgentToken(stringMap).enqueue((Callback)new ResponseResolver<LoginResponse>(){

            @Override
            public void success(LoginResponse loginResponse) {
                CommonParams.Builder builder = new CommonParams.Builder();
                builder.add("access_token", loginResponse.getUserData().getAccessToken());
                builder.add("device_type", 1);
                builder.add("device_token", hippoConfig.getAttributes().getDeviceToken());
                builder.add("device_id", UniqueIMEIID.getUniqueIMEIId((Context)activity));
                builder.add("device_details", CommonData.deviceDetails((Context)activity));
                builder.add("source", String.valueOf(2));
                builder.add("app_version", 207);
                builder.add("app_version_code", 207);
                builder.add("app_type", stringMap.get("app_type"));
                if (customAttributes != null && customAttributes.size() > 0 && !customAttributes.isEmpty()) {
                    builder.add("custom_attributes", new JSONObject((Map)customAttributes));
                }
                CommonParams commonParams = builder.build(2);
                HippoConfig.this.agentTokenLogin(activity, commonParams.getMap());
            }

            @Override
            public void failure(APIError error) {
                LoadingBox.hide();
                Log.e((String)TAG, (String)("Token not verified: " + error.getMessage()));
                HippoConfig.this.clearLocalData();
                HippoConfig.this.apiInProgress = false;
            }
        });
    }

    private void agentTokenVerfy(final Activity activity, final Map<String, Object> stringMap, final HashMap<String, Object> customAttributes) {
        this.apiInProgress = true;
        RestClient.getAgentApiInterface().verifyAuthToken(stringMap).enqueue((Callback)new ResponseResolver<LoginResponse>(){

            @Override
            public void success(LoginResponse loginResponse) {
                CommonParams.Builder builder = new CommonParams.Builder();
                builder.add("access_token", loginResponse.getUserData().getAccessToken());
                builder.add("device_type", 1);
                builder.add("device_token", hippoConfig.getAttributes().getDeviceToken());
                builder.add("device_id", UniqueIMEIID.getUniqueIMEIId((Context)activity));
                builder.add("device_details", CommonData.deviceDetails((Context)activity));
                builder.add("source", String.valueOf(2));
                builder.add("app_version", 207);
                builder.add("app_version_code", 207);
                builder.add("app_type", stringMap.get("app_type"));
                if (customAttributes != null && customAttributes.size() > 0 && !customAttributes.isEmpty()) {
                    builder.add("custom_attributes", new JSONObject((Map)customAttributes));
                }
                CommonParams commonParams = builder.build(2);
                HippoConfig.this.agentTokenLogin(activity, commonParams.getMap());
            }

            @Override
            public void failure(APIError error) {
                LoadingBox.hide();
                Log.e((String)TAG, (String)("Token not verified: " + error.getMessage()));
                HippoConfig.this.clearLocalData();
                HippoConfig.this.apiInProgress = false;
            }
        });
    }

    private void agentTokenLogin(final Activity activity, Map<String, Object> stringMap) {
        RestClient.getAgentApiInterface().login(stringMap).enqueue((Callback)new ResponseResolver<LoginResponse>(){

            @Override
            public void success(LoginResponse loginResponse) {
                try {
                    if (ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == loginResponse.getStatusCode().intValue()) {
                        Paper.book((String)"hippo.paperdb").delete("hippo_user_data");
                        Paper.book((String)"hippo.paperdb").delete("hippo_tags");
                        AgentCommonData.saveUserData(loginResponse.getUserData());
                        AgentCommonData.saveTags(loginResponse.getUserData().getTags());
                        CommonData.setUserId(String.valueOf(loginResponse.getUserData().getUserId()));
                        HippoConfig.this.apiInProgress = false;
                        HippoConfig.getInstance().isDataCleared = false;
                        HippoConfig.this.checkSavedQueue();
                    } else {
                        Toast.makeText((Context)activity, (CharSequence)loginResponse.getMessage(), (int)0).show();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                HippoConfig.this.apiInProgress = false;
                LoadingBox.hide();
            }

            @Override
            public void failure(APIError error) {
                HippoConfig.this.apiInProgress = false;
                HippoConfig.this.clearLocalData();
                Log.e((String)TAG, (String)("Agent Login failed: " + error.getMessage()));
                LoadingBox.hide();
            }
        });
    }

    private void checkSavedQueue() {
        Iterator iterator = this.objectQueue.iterator();
        while (iterator.hasNext()) {
            String str;
            switch (str = (String)iterator.next()) {
                case "open_agent_screen": {
                    Intent intent = new Intent(this.activity.getApplicationContext(), AgentListActivity.class);
                    intent.putExtra("title", this.chatTitle);
                    this.activity.startActivity(intent);
                    break;
                }
                case "get_agent_count": {
                    UnreadCountHelper.getInstance().getUpdatedUnreadCount(this.strings, this.unreadCount);
                    break;
                }
                case "start_conversation": {
                    if (!TextUtils.isEmpty((CharSequence)this.userUniqueKey) && !TextUtils.isEmpty((CharSequence)this.transactionId)) {
                        Conversation conversation = new Conversation();
                        conversation.setChannelId(-1L);
                        conversation.setChannelName("dummyChannelName");
                        conversation.setStatus(-2);
                        conversation.setAgentId(-2);
                        conversation.setUserUniqueKeys(this.userUniqueKey);
                        conversation.setLabel(this.title);
                        conversation.setUnreadCount(0);
                        Intent intent1 = new Intent(this.activity.getApplicationContext(), AgentChatActivity.class);
                        intent1.putExtra("conversation", new Gson().toJson((Object)conversation, Conversation.class));
                        intent1.putExtra("create_chat", true);
                        intent1.putExtra("transactionId", this.transactionId);
                        intent1.putExtra("fragment_type", FragmentType.USER_CHAT.getOrdinal());
                        this.activity.startActivity(intent1);
                        break;
                    }
                    Intent intent2 = new Intent(this.activity.getApplicationContext(), AgentListActivity.class);
                    intent2.putExtra("title", this.title);
                    if (!TextUtils.isEmpty((CharSequence)this.userUniqueKey)) {
                        intent2.putExtra("user_unique_key", this.userUniqueKey);
                    }
                    this.activity.startActivity(intent2);
                    break;
                }
                case "agent_total_count": {
                    this.getTotalUnreadCount();
                    break;
                }
                case "send_broadcast_message": {
                    Intent intent2 = new Intent(this.activity.getApplicationContext(), AgentBroadcastActivity.class);
                    intent2.putExtra("title", this.title);
                    this.activity.startActivity(intent2);
                    break;
                }
                case "open_one_two_one": {
                    Conversation conversation = new Conversation();
                    conversation.setChannelId(-1L);
                    conversation.setChannelName("dummyChannelName");
                    conversation.setStatus(-2);
                    conversation.setAgentId(-2);
                    conversation.setChatType(2);
                    conversation.setLabel(this.title);
                    conversation.setUnreadCount(0);
                    Intent intent3 = new Intent(this.activity.getApplicationContext(), AgentChatActivity.class);
                    intent3.putExtra("conversation", new Gson().toJson((Object)conversation, Conversation.class));
                    intent3.putExtra("create_chat", true);
                    intent3.putExtra("is_one_two_one", true);
                    intent3.putExtra("one_two_one_email", this.email);
                    this.activity.startActivity(intent3);
                    break;
                }
            }
        }
        this.objectQueue.clear();
    }

    public void startOneToOneConversation(String email) {
        if (AgentCommonData.isAgentFlow()) {
            if (Utils.isEmailValid(email)) {
                if (AgentCommonData.getUserData() == null || this.apiInProgress) {
                    this.objectQueue.add("open_one_two_one");
                    this.email = email;
                    LoadingBox.showOn(this.activity);
                    if (!this.apiInProgress) {
                        this.initHippoManager(this.activity, hippoConfig.getAttributes());
                    }
                } else {
                    Conversation conversation = new Conversation();
                    conversation.setChannelId(-1L);
                    conversation.setChannelName("dummyChannelName");
                    conversation.setStatus(-2);
                    conversation.setAgentId(-2);
                    conversation.setChatType(2);
                    conversation.setLabel(this.title);
                    conversation.setUnreadCount(0);
                    Intent intent = new Intent(this.activity.getApplicationContext(), AgentChatActivity.class);
                    intent.putExtra("conversation", new Gson().toJson((Object)conversation, Conversation.class));
                    intent.putExtra("create_chat", true);
                    intent.putExtra("is_one_two_one", true);
                    intent.putExtra("one_two_one_email", email);
                    this.activity.startActivity(intent);
                }
            } else {
                Log.e((String)TAG, (String)"Enter valid email");
            }
        } else {
            Log.e((String)TAG, (String)"Can't call this method in Client flow");
        }
    }

    public void sendBroadcastMessage(Activity activity, String title) {
        if (AgentCommonData.isAgentFlow()) {
            if (!this.getAttributes().isBroadcastEnabled()) {
                Log.e((String)TAG, (String)"Broadcast isn't enabled");
                return;
            }
            if (AgentCommonData.getUserData() == null || this.apiInProgress) {
                this.title = title;
                this.objectQueue.add("send_broadcast_message");
                LoadingBox.showOn(activity);
                if (!this.apiInProgress) {
                    this.initHippoManager(activity, hippoConfig.getAttributes());
                }
            } else {
                Intent intent = new Intent(activity.getApplicationContext(), AgentBroadcastActivity.class);
                intent.putExtra("title", title);
                activity.startActivity(intent);
            }
        } else {
            Log.e((String)TAG, (String)"Can't call this method in Client flow");
        }
    }

    public void openConversation(Activity activity, String title) {
        AgentCommonData.setMainTitle(title);
        if (AgentCommonData.getUserData() == null || this.apiInProgress) {
            this.title = title;
            this.objectQueue.add("open_agent_screen");
            LoadingBox.showOn(activity);
            if (!this.apiInProgress) {
                this.initHippoManager(activity, hippoConfig.getAttributes());
            }
        } else {
            Intent intent = new Intent(activity.getApplicationContext(), AgentListActivity.class);
            intent.putExtra("title", title);
            activity.startActivity(intent);
        }
    }

    public void openConversationFor(Activity activity, String otherUserUniqueKey, String title) {
        this.openConversationFor(activity, otherUserUniqueKey, title, "");
    }

    public void openConversationFor(Activity activity, String otherUserUniqueKey, String title, String transactionId) {
        if (HippoConfig.getInstance().activity == null || HippoConfig.getInstance().context == null) {
            HippoConfig.getInstance().activity = activity;
            HippoConfig.getInstance().context = activity;
        }
        if (AgentCommonData.getUserData() == null || this.apiInProgress) {
            this.title = title;
            this.userUniqueKey = otherUserUniqueKey;
            this.transactionId = transactionId;
            this.objectQueue.add("start_conversation");
            LoadingBox.showOn(activity);
            if (!this.apiInProgress) {
                this.initHippoManager(activity, hippoConfig.getAttributes());
            }
        } else if (!TextUtils.isEmpty((CharSequence)otherUserUniqueKey) && !TextUtils.isEmpty((CharSequence)transactionId)) {
            Conversation conversation = new Conversation();
            conversation.setChannelId(-1L);
            conversation.setChannelName("dummyChannelName");
            conversation.setStatus(-2);
            conversation.setAgentId(-2);
            conversation.setUserUniqueKeys(otherUserUniqueKey);
            conversation.setLabel(title);
            conversation.setUnreadCount(0);
            Intent intent = new Intent(activity.getApplicationContext(), AgentChatActivity.class);
            intent.putExtra("conversation", new Gson().toJson((Object)conversation, Conversation.class));
            intent.putExtra("create_chat", true);
            intent.putExtra("transactionId", transactionId);
            intent.putExtra("fragment_type", FragmentType.USER_CHAT.getOrdinal());
            activity.startActivity(intent);
        } else {
            Intent intent = new Intent(activity.getApplicationContext(), AgentListActivity.class);
            intent.putExtra("title", title);
            if (!TextUtils.isEmpty((CharSequence)otherUserUniqueKey)) {
                intent.putExtra("user_unique_key", otherUserUniqueKey);
            }
            activity.startActivity(intent);
        }
    }

    public void setUnreadCount(AgentUnreadCountListener unreadCount) {
        this.unreadCount = unreadCount;
    }

    public void getUnreadCountFor(ArrayList<String> strings) {
        AgentCommonData.setAgentUniqueKey(strings);
        if (AgentCommonData.getUserData() == null || this.apiInProgress) {
            this.strings = strings;
            this.objectQueue.add("get_agent_count");
            if (!this.apiInProgress) {
                this.initHippoManager(this.activity, hippoConfig.getAttributes());
            }
        } else {
            UnreadCountHelper.getInstance().getUpdatedUnreadCount(strings);
        }
    }

    public void getTotalUnreadCount() {
        block5: {
            try {
                ActivityManager mngr = (ActivityManager)this.activity.getSystemService("activity");
                List taskList = mngr.getRunningTasks(10);
                if (((ActivityManager.RunningTaskInfo)taskList.get((int)0)).topActivity.getClassName().equals("com.hippo.agent.AgentChatActivity")) {
                    UnreadCountHelper.getInstance().sendTotalUnreadCount();
                    return;
                }
            }
            catch (Exception mngr) {
                // empty catch block
            }
            try {
                this.getTotalUnreadCountData();
            }
            catch (Exception e) {
                if (!DEBUG) break block5;
                e.printStackTrace();
            }
        }
    }

    private void getTotalUnreadCountData() throws Exception {
        if (HippoConfig.getInstance().getCallbackListener() == null) {
            Log.e((String)TAG, (String)"Set CallbackListener first");
            return;
        }
        if (AgentCommonData.getUserData() == null || this.apiInProgress) {
            this.objectQueue.add("agent_total_count");
            if (!this.apiInProgress) {
                this.initHippoManager(this.activity, hippoConfig.getAttributes());
            }
        } else {
            int[] typeIntArray = new int[]{ConversationMode.ALL.getOrdinal(), ConversationMode.DEFAULT.getOrdinal()};
            UserData userData = AgentCommonData.getUserData();
            String userID = String.valueOf(userData.getEnUserId());
            String accessToken = userData.getAccessToken();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("en_user_id", userID);
            params.put("access_token", accessToken);
            params.put("status", "[1]");
            params.put("device_type", 1);
            params.put("type", Arrays.toString(typeIntArray));
            CommonParams commonParams = new CommonParams.Builder().addAll(params).build(2);
            RestClient.getAgentApiInterface().getConversation(commonParams.getMap()).enqueue((Callback)new ResponseResolver<GetConversationResponse>(){

                @Override
                public void success(GetConversationResponse getConversationResponse) {
                    try {
                        if (getConversationResponse != null && ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == getConversationResponse.getStatusCode().intValue()) {
                            HashMap<Integer, Integer> hashMap = AgentCommonData.getTotalUnreadCount();
                            int totalCount = 0;
                            for (Conversation conversation : getConversationResponse.getData().getConversation()) {
                                hashMap.put(conversation.getChannelId().intValue(), conversation.getUnreadCount());
                                totalCount += conversation.getUnreadCount().intValue();
                            }
                            AgentCommonData.addTotalUnreadCount(hashMap);
                            UnreadCountHelper.getInstance().sendTotalUnreadCount();
                            if (HippoConfig.getInstance().getCallbackListener() != null) {
                                HippoConfig.getInstance().getCallbackListener().count(totalCount);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void failure(APIError error) {
                }
            });
        }
    }

    public static void clearHippoData(Activity activity) {
        try {
            if (AgentCommonData.isAgentFlow()) {
                HippoConfig.logoutAgent(activity);
            } else {
                HippoConfig.logOutUser(activity);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            hippoConfig.clearLocalData();
            Prefs.with((Context)activity).removeAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void clearLocalData() {
        HippoConfig.getInstance().isDataCleared = true;
        CommonData.setIsDataCleared(true);
        try {
            CommonData.clearData();
            AgentCommonData.clearAgentData();
            this.userData = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getFayeUrl() {
        String url = CommonData.getServerUrl() + ":3002/faye";
        url = CommonData.getServerUrl().equals("https://api.fuguchat.com") ? CommonData.getServerUrl() + ":3002/faye" : (CommonData.getServerUrl().equals("https://hippo-api-dev.fuguchat.com:3011") || CommonData.getServerUrl().equals("https://api.fuguchat.com") ? "https://hippo-api-dev.fuguchat.com:3012/faye" : (CommonData.getServerUrl().equals("https://hippo-api-dev.fuguchat.com:3002") ? "https://hippo-api-dev.fuguchat.com:3002/faye" : "https://api.fuguchat.com:3002/faye"));
        return url;
    }

    public static void getClient(fayeClient listener) {
        meta = new MetaMessage();
        JSONObject jsonExt = new JSONObject();
        try {
            if (HippoConfig.getInstance().getUserData() != null) {
                jsonExt.put("user_id", (Object)HippoConfig.getInstance().getUserData().getUserId());
                jsonExt.put("device_type", 1);
                jsonExt.put("source", 1);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        meta.setAllExt(jsonExt.toString());
        mClient = new FayeClient(HippoConfig.getFayeUrl(), meta);
        listener.Listener(mClient);
    }

    public static void getExistingClient(fayeClient listener) {
        HippoConfig.getExistingClient(listener, true);
    }

    public static void getExistingClient(fayeClient listener, boolean flag) {
        if (mClient == null && flag) {
            meta = new MetaMessage();
            JSONObject jsonExt = new JSONObject();
            try {
                if (HippoConfig.getInstance().getUserData() != null) {
                    jsonExt.put("user_id", (Object)HippoConfig.getInstance().getUserData().getUserId());
                    jsonExt.put("device_type", 1);
                    jsonExt.put("source", 1);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            meta.setAllExt(jsonExt.toString());
            mClient = new FayeClient(HippoConfig.getFayeUrl(), meta);
        }
        listener.Listener(mClient);
    }

    public static FayeClient getClient() {
        if (mClient == null) {
            meta = new MetaMessage();
            JSONObject jsonExt = new JSONObject();
            try {
                if (HippoConfig.getInstance().getUserData() != null) {
                    jsonExt.put("user_id", (Object)HippoConfig.getInstance().getUserData().getUserId());
                    jsonExt.put("device_type", 1);
                    jsonExt.put("source", 1);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            meta.setAllExt(jsonExt.toString());
            mClient = new FayeClient(HippoConfig.getFayeUrl(), meta);
        }
        return mClient;
    }

    public String getAppKey() {
        if (TextUtils.isEmpty((CharSequence)this.appKey)) {
            this.appKey = CommonData.getAppSecretKey();
        }
        return this.appKey;
    }

    public static String getmResellerToken() {
        if (TextUtils.isEmpty((CharSequence)mResellerToken)) {
            mResellerToken = CommonData.getResellerToken();
        }
        return mResellerToken;
    }

    public static int getmReferenceId() {
        if (mReferenceId == -1) {
            mReferenceId = CommonData.getReferenceId();
        }
        return mReferenceId;
    }

    public String getAppType() {
        return HippoConfig.getInstance().appType;
    }

    public boolean isDataCleared() {
        return this.isDataCleared;
    }

    public boolean isChannelActivity() {
        return this.isChannelActivity;
    }

    public void setChannelActivity(boolean channelActivity) {
        this.isChannelActivity = channelActivity;
    }

    public void setRideTime(long timeInSecs) {
        if (timeInSecs > 0L) {
            CommonData.setLeftTimeInSec(timeInSecs);
        } else {
            CommonData.clearLeftTimeInSec();
        }
    }

    public void stopOnlineStatus(Activity activity) {
        CommonData.clearLeftTimeInSec();
        new ApiPutUserDetails(activity, new ApiPutUserDetails.Callback(){

            @Override
            public void onSuccess() {
            }

            @Override
            public void onFailure() {
            }
        }).stopRideStatus();
    }

    public void discartEstimatedTime() {
        CommonData.clearLeftTimeInSec();
    }

    public void showConversations(Activity activity, final String title) {
        if (HippoConfig.getInstance().activity == null || HippoConfig.getInstance().context == null) {
            HippoConfig.getInstance().activity = activity;
            HippoConfig.getInstance().context = activity;
        }
        if (AgentCommonData.isAgentFlow()) {
            Log.e((String)TAG, (String)"Can't call this method with manager flow");
            return;
        }
        CommonData.setChatTitle(title);
        if (CommonData.isFirstTimeWithNotification() || CommonData.getConversationList() != null && CommonData.getConversationList().size() <= 0) {
            new ApiPutUserDetails(activity, new ApiPutUserDetails.Callback(){

                @Override
                public void onSuccess() {
                    CommonData.setNotificationFirstClick(false);
                    if (CommonData.getConversationList().size() == 0) {
                        HippoConfig.this.caseOne(title);
                    } else {
                        HippoConfig.this.caseElse(title);
                    }
                }

                @Override
                public void onFailure() {
                    CommonData.setNotificationFirstClick(false);
                }
            }).sendUserDetails(HippoConfig.getmResellerToken(), HippoConfig.getmReferenceId());
        } else if (CommonData.getConversationList().size() == 0) {
            this.caseOne(title);
        } else {
            this.caseElse(title);
        }
    }

    public void openChat(Activity activity, Long messageChannelId) {
        if (HippoConfig.getInstance().activity == null || HippoConfig.getInstance().context == null) {
            HippoConfig.getInstance().activity = activity;
            HippoConfig.getInstance().context = activity;
        }
        this.openChat(activity, messageChannelId, null);
    }

    public void openChat(final Activity activity, final Long messageChannelId, final String titleString) {
        if (HippoConfig.getInstance().getUserData() == null || this.userData.getUserId().compareTo(-1L) == 0) {
            HippoLog.v("In openChat before FuguChatActivity", "userData null");
            ApiPutUserDetails apiPutUserDetails = new ApiPutUserDetails(activity, new ApiPutUserDetails.Callback(){

                @Override
                public void onSuccess() {
                    Intent chatIntent = new Intent(activity.getApplicationContext(), FuguChatActivity.class);
                    FuguConversation conversation = new FuguConversation();
                    conversation.setLabelId(messageChannelId);
                    conversation.setLabel(titleString);
                    conversation.setOpenChat(true);
                    conversation.setUserName(StringUtil.toCamelCase(HippoConfig.getInstance().getUserData().getFullName()));
                    conversation.setUserId(HippoConfig.getInstance().getUserData().getUserId());
                    conversation.setEnUserId(HippoConfig.getInstance().getUserData().getEnUserId());
                    chatIntent.putExtra("conversation", new Gson().toJson((Object)conversation, FuguConversation.class));
                    activity.startActivity(chatIntent);
                }

                @Override
                public void onFailure() {
                }
            });
            HippoConfig.getInstance();
            String string2 = HippoConfig.getmResellerToken();
            HippoConfig.getInstance();
            apiPutUserDetails.sendUserDetails(string2, HippoConfig.getmReferenceId());
        } else {
            Intent chatIntent = new Intent(activity.getApplicationContext(), FuguChatActivity.class);
            FuguConversation conversation = new FuguConversation();
            conversation.setLabelId(messageChannelId);
            conversation.setLabel(titleString);
            conversation.setOpenChat(true);
            conversation.setUserName(StringUtil.toCamelCase(HippoConfig.getInstance().getUserData().getFullName()));
            conversation.setUserId(HippoConfig.getInstance().getUserData().getUserId());
            conversation.setEnUserId(HippoConfig.getInstance().getUserData().getEnUserId());
            chatIntent.putExtra("conversation", new Gson().toJson((Object)conversation, FuguConversation.class));
            activity.startActivity(chatIntent);
        }
    }

    public void openChatByUniqueId(ChatByUniqueIdAttributes attributes) {
        String transactionId = attributes.getTransactionId();
        String userUniqueKey = attributes.getUserUniqueKey();
        ArrayList<String> otherUserUniqueKeys = attributes.getOtherUserUniqueKeys();
        String channelName = attributes.getChannelName();
        ArrayList<String> tags = attributes.getTags();
        int chatType = 0;
        String[] message = attributes.getMessage();
        ArrayList<String> groupingTags = attributes.getGroupingTags();
        String isSupportTicket = attributes.isSupportTicket() ? "1" : "0";
        CustomAttributes customAttributes = attributes.getCustomAttributes();
        this.showGroupChat(transactionId, userUniqueKey, otherUserUniqueKeys, channelName, tags, chatType, message, groupingTags, isSupportTicket, customAttributes);
    }

    private void showGroupChat(final String transactionId, final String userUniqueKey, final ArrayList<String> otherUserUniqueKeys, final String channelName, final ArrayList<String> tags, final int chatType, final String[] message, final ArrayList<String> groupingTags, final String isSupportTicket, final CustomAttributes customAttributes) {
        HippoLog.i("showGroupChat", "In ShowGroupChat");
        if (HippoConfig.getInstance().getUserData() == null || this.getUserData().getUserId().compareTo(-1L) == 0) {
            new ApiPutUserDetails(this.activity, new ApiPutUserDetails.Callback(){

                @Override
                public void onSuccess() {
                    HippoConfig.this.showGroupChats(transactionId, userUniqueKey, otherUserUniqueKeys, channelName, tags, chatType, message, groupingTags, isSupportTicket, customAttributes);
                }

                @Override
                public void onFailure() {
                }
            }).sendUserDetails(HippoConfig.getmResellerToken(), HippoConfig.getmReferenceId(), true);
        } else {
            this.showGroupChats(transactionId, userUniqueKey, otherUserUniqueKeys, channelName, tags, chatType, message, groupingTags, isSupportTicket, customAttributes);
        }
    }

    private void showGroupChats(String transactionId, String userUniqueKey, ArrayList<String> otherUserUniqueKeys, String channelName, ArrayList<String> tags, int chatType, String[] message, ArrayList<String> groupingTags, String isSupportTicket, CustomAttributes customAttributes) {
        HippoLog.i("showGroupChat", "userData not null");
        Intent chatIntent = new Intent(this.activity.getApplicationContext(), FuguChatActivity.class);
        HippoLog.d("UserName", "showGroupChat" + HippoConfig.getInstance().getUserData().getUserId());
        FuguConversation conversation = new FuguConversation();
        conversation.setLabelId(-1L);
        conversation.setLabel(CommonData.getUserDetails().getData().getBusinessName());
        conversation.setUserId(HippoConfig.getInstance().getUserData().getUserId());
        conversation.setEnUserId(HippoConfig.getInstance().getUserData().getEnUserId());
        conversation.setUserName(StringUtil.toCamelCase(HippoConfig.getInstance().getUserData().getFullName()));
        chatIntent.putExtra("conversation", new Gson().toJson((Object)conversation, FuguConversation.class));
        chatType = otherUserUniqueKeys != null && otherUserUniqueKeys.size() > 0 && !TextUtils.isEmpty((CharSequence)otherUserUniqueKeys.get(0)) ? 2 : 3;
        chatIntent.putExtra("chat_type", chatType);
        Gson gson = new GsonBuilder().create();
        JsonArray otherUsersArray = null;
        JsonArray tagsArray = null;
        if (otherUserUniqueKeys != null) {
            otherUsersArray = gson.toJsonTree(otherUserUniqueKeys).getAsJsonArray();
        }
        if (tags != null) {
            tagsArray = gson.toJsonTree(tags).getAsJsonArray();
        }
        FuguCreateConversationParams fuguPeerChatParams = new FuguCreateConversationParams();
        fuguPeerChatParams.setAppSecretKey(HippoConfig.getInstance().getAppKey());
        fuguPeerChatParams.setChannelName(channelName);
        fuguPeerChatParams.setTransactionId(transactionId);
        fuguPeerChatParams.setLabelId(-1L);
        fuguPeerChatParams.setEnUserId(HippoConfig.getInstance().getUserData().getEnUserId());
        fuguPeerChatParams.setUserId(HippoConfig.getInstance().getUserData().getUserId());
        fuguPeerChatParams.setChatType(chatType);
        if (!TextUtils.isEmpty((CharSequence)userUniqueKey)) {
            fuguPeerChatParams.setUserUniqueKey(userUniqueKey);
        }
        chatType = 0;
        if (otherUserUniqueKeys != null && otherUserUniqueKeys.size() > 0 && !TextUtils.isEmpty((CharSequence)otherUserUniqueKeys.get(0))) {
            fuguPeerChatParams.setOtherUserUniqueKeys(otherUsersArray);
            chatType = otherUserUniqueKeys != null ? (otherUserUniqueKeys.size() > 1 ? 1 : 1) : 0;
        }
        fuguPeerChatParams.setChatType(chatType);
        if (message != null && message.length > 0 && !TextUtils.isEmpty((CharSequence)message[0])) {
            fuguPeerChatParams.setUser_first_messages(message);
        }
        try {
            if (customAttributes != null) {
                fuguPeerChatParams.setCustomAttributes(customAttributes);
            }
            if (!TextUtils.isEmpty((CharSequence)isSupportTicket) && Integer.parseInt(isSupportTicket) == 1) {
                fuguPeerChatParams.setIsSupportTicket(Integer.parseInt(isSupportTicket));
            }
            if (groupingTags != null && groupingTags.size() > 0) {
                fuguPeerChatParams.setGroupingTags(groupingTags);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (TextUtils.isEmpty((CharSequence)fuguPeerChatParams.getEnUserId()) && fuguPeerChatParams.getUserId() == -1L) {
            Log.e((String)TAG, (String)"UserID can't be -1");
            return;
        }
        chatIntent.putExtra("peer_chat_params", new Gson().toJson((Object)fuguPeerChatParams, FuguCreateConversationParams.class));
        this.activity.startActivity(chatIntent);
    }

    public void showFAQSupport(HippoTicketAttributes HippoTicketAttributes2, Object object) {
        if (SystemClock.elapsedRealtime() - this.lastClickTime < 1000L) {
            return;
        }
        if (object != null) {
            CommonData.saveExtraData(object);
        } else {
            CommonData.clearExtraTicketData();
        }
        if (HippoTicketAttributes2 != null) {
            this.openSupportScreen(HippoTicketAttributes2.getmFaqName(), HippoTicketAttributes2.getmTransactionId());
        } else {
            this.openSupportScreen(null, null);
        }
        this.lastClickTime = SystemClock.elapsedRealtime();
    }

    private void openSupportScreen(final String categoryId, final String transactionId) {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                HippoConfig.this.openFuguSupportActivity(categoryId, transactionId);
            }
        }, 100L);
    }

    private static void logoutAgent(Activity activity) throws Exception {
        if (AgentCommonData.getUserData() != null) {
            CommonParams commonParams = new CommonParams.Builder().add("access_token", AgentCommonData.getUserData().getAccessToken()).add("device_id", UniqueIMEIID.getUniqueIMEIId((Context)activity)).add("device_type", 1).add("app_version", 207).add("source_type", String.valueOf(1)).build(2);
            RestClient.getAgentApiInterface().logout(commonParams.getMap()).enqueue((Callback)new ResponseResolver<LoginResponse>(){

                @Override
                public void success(LoginResponse loginResponse) {
                }

                @Override
                public void failure(APIError error) {
                }
            });
        }
    }

    private static void logOutUser(Activity activity) throws Exception {
        if (HippoConfig.getInstance().getUserData() != null && HippoConfig.getInstance().getUserData().getEnUserId() != null) {
            CommonParams commonParams = new CommonParams.Builder().add("app_secret_key", HippoConfig.getInstance().getAppKey()).add("en_user_id", HippoConfig.getInstance().getUserData().getEnUserId()).add("app_version", "2.0.7").add("device_id", UniqueIMEIID.getUniqueIMEIId((Context)activity)).add("device_type", 1).build();
            RestClient.getApiInterface().logOut(commonParams.getMap()).enqueue((Callback)new ResponseResolver<CommonResponse>(activity, Boolean.valueOf(false), Boolean.valueOf(false)){

                @Override
                public void success(CommonResponse commonResponse) {
                }

                @Override
                public void failure(APIError error) {
                }
            });
        }
    }

    private void openUserInitForm() {
        Intent intent = new Intent(this.activity.getApplicationContext(), CustomerInitalActivity.class);
        this.activity.startActivity(intent);
    }

    private void caseOne(String title) {
        HippoLog.e("Case 1", "case 1");
        if (CommonData.getUpdatedDetails().getData().getCustomerInitialFormInfo() != null) {
            this.openUserInitForm();
        } else {
            Intent chatIntent = new Intent(this.activity.getApplicationContext(), FuguChatActivity.class);
            FuguConversation conversation = new FuguConversation();
            conversation.setBusinessName(title);
            conversation.setOpenChat(true);
            conversation.setUserName(StringUtil.toCamelCase(HippoConfig.getInstance().getUserData().getFullName()));
            conversation.setUserId(HippoConfig.getInstance().getUserData().getUserId());
            conversation.setEnUserId(HippoConfig.getInstance().getUserData().getEnUserId());
            chatIntent.putExtra("conversation", new Gson().toJson((Object)conversation, FuguConversation.class));
            this.activity.startActivity(chatIntent);
        }
    }

    private void caseElse(String title) {
        HippoLog.e("Case else", "case else");
        if (CommonData.getUpdatedDetails().getData().getCustomerInitialFormInfo() != null) {
            this.openUserInitForm();
        } else {
            Intent conversationsIntent = new Intent(this.activity.getApplicationContext(), FuguChannelsActivity.class);
            conversationsIntent.putExtra("title", title);
            conversationsIntent.putExtra("appVersion", this.getAppVersion());
            this.activity.startActivity(conversationsIntent);
        }
    }

    private void openFuguSupportActivity(String faqName, String transactionId) {
        Intent intent = new Intent(this.activity.getApplicationContext(), HippoSupportActivity.class);
        intent.putExtra("support_id", faqName);
        intent.putExtra("support_transaction_id", transactionId);
        this.activity.startActivity(intent);
    }

    private int getAppVersion() {
        try {
            if (this.activity != null) {
                return HippoConfig.getInstance().activity.getPackageManager().getPackageInfo((String)HippoConfig.getInstance().activity.getPackageName(), (int)0).versionCode;
            }
            return 205;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 205;
        }
    }

    public CaptureUserData getUserData() {
        return this.getUserData(true);
    }

    public CaptureUserData getUserData(boolean fetchSavedData) {
        if (this.userData == null) {
            this.userData = CommonData.getUserData();
        }
        if (fetchSavedData) {
            try {
                if (TextUtils.isEmpty((CharSequence)this.userData.getEnUserId())) {
                    FuguPutUserDetailsResponse response = CommonData.getUpdatedDetails();
                    if (response != null && response.getData() != null && !TextUtils.isEmpty((CharSequence)response.getData().getEn_user_id())) {
                        this.userData.setEnUserId(response.getData().getEn_user_id());
                        this.userData.setUserId(response.getData().getUserId());
                        this.userData.setFullName(response.getData().getFullName());
                        this.userData.setEmail(response.getData().getEmail());
                    } else if (this.context != null) {
                        this.userData.setEnUserId(Prefs.with(this.context).getString("en_user_id", ""));
                        this.userData.setUserId(Prefs.with(this.context).getLong("user_id", -1L));
                        this.userData.setFullName(Prefs.with(this.context).getString("full_name", ""));
                        this.userData.setEmail(Prefs.with(this.context).getString("email", ""));
                    }
                }
            }
            catch (Exception e) {
                if (DEBUG) {
                    e.printStackTrace();
                }
                try {
                    if (this.context != null) {
                        this.userData.setEnUserId(Prefs.with(this.context).getString("en_user_id", ""));
                        this.userData.setUserId(Prefs.with(this.context).getLong("user_id", -1L));
                        this.userData.setFullName(Prefs.with(this.context).getString("full_name", ""));
                        this.userData.setEmail(Prefs.with(this.context).getString("email", ""));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.userData;
    }

    public void getUnreadCount() {
        this.getUnreadCount(this.activity, HippoConfig.getInstance().getUserData().getEnUserId());
    }

    private void getUnreadCount(Activity activity, String enUserId) {
        new UnreadCountApi().getConversations(activity, enUserId, new UnreadCountApi.CountUnread(){

            @Override
            public void countValue(int count) {
                if (HippoConfig.getInstance().getCallbackListener() != null) {
                    HippoConfig.getInstance().getCallbackListener().count(count);
                }
            }
        });
    }

    public void fetchUnreadCountForRequest(ChatByUniqueIdAttributes attributes, UnreadCountFor countCallback) {
        if (AgentCommonData.isAgentFlow()) {
            Log.e((String)TAG, (String)"Can't call this method with manager flow");
            return;
        }
        String transactionId = attributes.getTransactionId();
        ArrayList<String> otherUserUniqueKeys = attributes.getOtherUserUniqueKeys();
        if (TextUtils.isEmpty((CharSequence)transactionId)) {
            Toast.makeText((Context)this.activity, (int)R.string.hippo_empty_transaction_id, (int)0).show();
            return;
        }
        if (otherUserUniqueKeys == null || otherUserUniqueKeys.size() == 0) {
            Toast.makeText((Context)this.activity, (int)R.string.hippo_empty_other_user_unique_keys, (int)0).show();
            return;
        }
        new UnreadCountApi().getChannelUnreadCount(this.activity, HippoConfig.getInstance().getUserData().getEnUserId(), transactionId, HippoConfig.getInstance().getUserData().getUserUniqueKey(), otherUserUniqueKeys, countCallback);
    }

    public void setChannelIds(String transactionId, Long channelId) {
        this.channelIds.put(transactionId, channelId);
    }

    public Long getChannelId(String transactionId) {
        return this.channelIds.get(transactionId);
    }

    public int getTargetSDKVersion() {
        return this.targetSDKVersion;
    }

    public boolean isPermissionGranted(Context activity, String permission) {
        PackageManager pm = activity.getPackageManager();
        try {
            ApplicationInfo applicationInfo = pm.getApplicationInfo(HippoConfig.getInstance().activity.getPackageName(), 0);
            if (applicationInfo != null) {
                this.targetSDKVersion = applicationInfo.targetSdkVersion;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.targetSDKVersion > 22) {
            return ContextCompat.checkSelfPermission((Context)activity, (String)permission) == 0;
        }
        return PermissionChecker.checkSelfPermission((Context)activity, (String)permission) == 0;
    }

    public boolean askUserToGrantPermission(Activity activity, String permission, String explanation, int code) {
        HippoLog.e(TAG, "permissions" + permission);
        return this.askUserToGrantPermission(activity, new String[]{permission}, explanation, code);
    }

    public boolean askUserToGrantPermission(Activity activity, String[] permissions, String explanation, int requestCode) {
        String permissionRequired = null;
        for (String permission : permissions) {
            if (this.isPermissionGranted((Context)activity, permission)) continue;
            permissionRequired = permission;
            break;
        }
        if (permissionRequired == null) {
            return true;
        }
        boolean explanationRequired = ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, permissionRequired);
        if (explanationRequired) {
            if (explanation == null) {
                explanation = "Please grant permission";
            }
            Toast.makeText((Context)activity, (CharSequence)explanation, (int)0).show();
        } else {
            ActivityCompat.requestPermissions((Activity)activity, (String[])permissions, (int)requestCode);
        }
        return false;
    }

    public UnreadCount getCallbackListener() {
        return this.callbackListener;
    }

    public AgentUnreadCountListener getAgentCountListener() {
        return this.countListener;
    }

    public void setCountForCallbackListener(AgentUnreadCountListener countListener) {
        this.countListener = countListener;
    }

    public void setCallbackListener(UnreadCount callbackListener) {
        this.callbackListener = callbackListener;
    }

    private <T extends AgentListener> Collection<T> getOrCreateUIListeners(Class<T> cls) {
        Collection<? extends AgentListener> collection;
        if (this.agentListeners == null) {
            this.agentListeners = new HashMap<Class<? extends AgentListener>, Collection<? extends AgentListener>>();
        }
        if ((collection = this.agentListeners.get(cls)) == null) {
            collection = new ArrayList<AgentListener>();
            this.agentListeners.put(cls, collection);
        }
        return collection;
    }

    public <T extends AgentListener> Collection<T> getUIListeners(Class<T> cls) {
        return Collections.unmodifiableCollection(this.getOrCreateUIListeners(cls));
    }

    public <T extends AgentListener> void addUIListener(Class<T> cls, T listener) {
        this.getOrCreateUIListeners(cls).add(listener);
    }

    public <T extends AgentListener> void addOrUpdateUIListener(Class<T> cls, T listener) {
        try {
            if (this.getUIListeners(cls).size() == 0) {
                this.getOrCreateUIListeners(cls).add(listener);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public <T extends AgentListener> void removeUIListener(Class<T> cls, T listener) {
        this.getOrCreateUIListeners(cls).remove(listener);
    }

    private void registerNetworkListener(Context context) {
        try {
            context.registerReceiver((BroadcastReceiver)new FuguNetworkStateReceiver(), new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public CallData getCallData() {
        return this.callData;
    }

    public void setCallListener(CallData callData) {
        this.callData = callData;
    }

    public void setLifeCyclerListener(HippoLifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public HippoLifeCycle getLifeCyclerListener() {
        return this.lifeCycle;
    }

    public void setBotGroupId(Integer botId) {
        CommonData.setBotId(botId);
        this.botId = botId;
    }

    public Integer getBotId() {
        if (this.botId == null) {
            this.botId = CommonData.getBotId();
        }
        return this.botId;
    }

    public void setSkipBotReasion(String reason) {
        this.skipBotReasion = this.skipBotReasion;
    }

    public void setSkipBot(boolean skipBot) {
        CommonData.skipBot(skipBot);
    }

    public boolean getSkipBot() {
        this.skipBot = CommonData.getSkipBot();
        return this.skipBot;
    }

    public String getSkipBotReason() {
        return this.skipBotReasion;
    }

    public void startCall(Context context, String callType, String transactionId, String userUniqueKey, String otherUserName, ArrayList<String> otherUserUniqueKeys, String otheruserImageUrl) {
        if (callType.equalsIgnoreCase("video") && !CommonData.getVideoCallStatus()) {
            Toast.makeText((Context)context, (CharSequence)"This feature not supported", (int)0).show();
            return;
        }
        if (callType.equalsIgnoreCase("audio") && !CommonData.getAudioCallStatus()) {
            Toast.makeText((Context)context, (CharSequence)"This feature not supported", (int)0).show();
            return;
        }
        if (TextUtils.isEmpty((CharSequence)transactionId)) {
            Toast.makeText((Context)context, (CharSequence)"TransactionId can't be null", (int)0).show();
            return;
        }
        if (TextUtils.isEmpty((CharSequence)userUniqueKey)) {
            Toast.makeText((Context)context, (CharSequence)"User unique key can't be null", (int)0).show();
            return;
        }
        if (TextUtils.isEmpty((CharSequence)otherUserName)) {
            Toast.makeText((Context)context, (CharSequence)"other user name can't be null", (int)0).show();
            return;
        }
        if (otherUserUniqueKeys == null || otherUserUniqueKeys.size() == 0) {
            Toast.makeText((Context)context, (CharSequence)"Otheruser unique key can't be null", (int)0).show();
            return;
        }
        Gson gson = new GsonBuilder().create();
        JsonArray otherUsersArray = null;
        JsonArray tagsArray = null;
        if (otherUserUniqueKeys != null) {
            otherUsersArray = gson.toJsonTree(otherUserUniqueKeys).getAsJsonArray();
        }
        FuguCreateConversationParams fuguPeerChatParams = new FuguCreateConversationParams(HippoConfig.getInstance().getAppKey(), (Long)-1L, transactionId, userUniqueKey, otherUsersArray, transactionId, tagsArray, HippoConfig.getInstance().getUserData().getEnUserId());
        Long userId = CommonData.getUserDetails().getData().getUserId();
        String fullname = otherUserName;
        if (HippoConfig.getInstance().getCallData() != null) {
            HippoConfig.getInstance().getCallData().onExternalClick(context, callType, userId, fullname, new Gson().toJson((Object)fuguPeerChatParams, FuguCreateConversationParams.class), otheruserImageUrl);
        } else {
            Log.e((String)TAG, (String)"Please call setCallListener before this method");
        }
    }

    static {
        mReferenceId = -1;
        DEBUG = false;
        meta = new MetaMessage();
        progressLoader = true;
    }
}

