package com.hippo.activity;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.hippo.HippoConfig;
import com.hippo.database.CommonData;
import com.hippo.model.BotMessage;
import com.hippo.model.FuguCreateConversationParams;
import com.hippo.model.FuguCreateConversationResponse;
import com.hippo.model.Message;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.utils.DateUtils;
import com.hippo.utils.HippoLog;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;

import static com.hippo.constant.FuguAppConstant.*;

/**
 * Created by gurmail on 2019-08-28.
 *
 * @author gurmail
 */
public class CreateConversation {

    private Activity context;
    private boolean hasBotMessage = false;
    private String userName;
    private Long userId;


    private int messageType;


    public CreateConversation(Activity context, String userName, Long userId) {
        this.context = context;
        this.userName = userName;
        this.userId = userId;
    }

    protected void createChannel(final CreateChannelAttribute attributes, final Callback callback) {
        FuguCreateConversationParams fuguCreateConversationParams = attributes.getFuguCreateConversationParams();
        messageType = attributes.getMessageType();
        ArrayList<String> groupingTags = new ArrayList<>();
        if (attributes.getFuguCreateConversationParams().getGroupingTags() != null && fuguCreateConversationParams.getGroupingTags().size() > 0)
            groupingTags.addAll(fuguCreateConversationParams.getGroupingTags());

        try {
            if (CommonData.getUserDetails() != null && CommonData.getUserDetails().getData() != null
                    && CommonData.getUserDetails().getData().getGroupingTags() != null
                    && CommonData.getUserDetails().getData().getGroupingTags().size() > 0) {
                for (com.hippo.model.GroupingTag groupingTag : CommonData.getUserDetails().getData().getGroupingTags()) {
                    groupingTags.add(groupingTag.getTagName());
                }
            }
        } catch (Exception e) {

        }

        fuguCreateConversationParams.setGroupingTags(groupingTags);

        if (attributes.getLabelId() != null && attributes.getLabelId().compareTo(-1l) > 0) {
            fuguCreateConversationParams.setLabelId(attributes.getLabelId());
        }

        if(HippoConfig.getInstance().getBotId() != null && HippoConfig.getInstance().getBotId() > 0) {
            fuguCreateConversationParams.setBotGroupId(HippoConfig.getInstance().getBotId());
        }

        if(HippoConfig.getInstance().getSkipBot()) {
            fuguCreateConversationParams.setSkipBot(1);
            if(!TextUtils.isEmpty(HippoConfig.getInstance().getSkipBotReason()))
                fuguCreateConversationParams.setSkipBotReason(HippoConfig.getInstance().getSkipBotReason());
        }

        if(!TextUtils.isEmpty(attributes.getBotMessageMuid())) {
            fuguCreateConversationParams.setBotFormMuid(attributes.getBotMessageMuid());
        }

        if(attributes.getmFuguGetMessageResponse() != null &&
                attributes.getmFuguGetMessageResponse().getData() != null &&
                attributes.getmFuguGetMessageResponse().getData().getBotGroupId() != null &&
                attributes.getmFuguGetMessageResponse().getData().getBotGroupId() > -1) {
            hasBotMessage = true;
            messageType = 0;
            fuguCreateConversationParams.setInitiateBotGroupId(attributes.getmFuguGetMessageResponse().getData().getBotGroupId());

            ArrayList<Object> arrayList = new ArrayList<>();
            if((attributes.getMessageType() == 1 && !TextUtils.isEmpty(attributes.getText())) ||
                    attributes.getFileuploadModel() != null) {
                arrayList.addAll(attributes.getmFuguGetMessageResponse().getData().getMessages());
                String localDate = DateUtils.getInstance().getFormattedDate(new Date());
                String removeGt = "";
                if(attributes.getMessageType() == 1 && !TextUtils.isEmpty(attributes.getText().trim())) {
                    String removeLt = attributes.getText().trim().replaceAll("<", "&lt;");
                    removeGt = removeLt.replaceAll(">", "&gt;");
                }

                Message messageObj = new Message(0,
                        userName,
                        userId,
                        removeGt,
                        DateUtils.getInstance().convertToUTC(localDate),
                        true,
                        MESSAGE_UNSENT,
                        attributes.getmFuguGetMessageResponse().getData().getMessages().size(),
                        "",
                        "",
                        attributes.getMessageType(),
                        UUID.randomUUID().toString() + "." + new Date().getTime());

                messageObj.setUserType(1);
                messageObj.setOriginalMessageType(attributes.getMessageType());
                messageObj.setMessageType(attributes.getMessageType());
                messageObj.setIntegrationSource(0);
                messageObj.setIsMessageExpired(0);
                messageObj.setMessageState(MESSAGE_UNSENT);
                messageObj.setUserId(userId);
                messageObj.setFromName(userName);

                if(attributes.getFileuploadModel() != null) {
                    messageObj.setMessageType(attributes.getFileuploadModel().getMessageType());
                    messageObj.setUrl(attributes.getFileuploadModel().getMessageObject().optString(IMAGE_URL));
                    messageObj.setThumbnailUrl(attributes.getFileuploadModel().getMessageObject().optString(THUMBNAIL_URL));
                    messageObj.setDocumentType(attributes.getFileuploadModel().getDocumentType());
                    messageObj.setMuid(attributes.getFileuploadModel().getMuid());
                }

                arrayList.add(messageObj);
                fuguCreateConversationParams.setInitialBotMessages(arrayList);
            } else {
                for(Message msg : attributes.getmFuguGetMessageResponse().getData().getMessages()) {
                    if(msg.getMessageType() == 20) {
                        arrayList.add(attributes.getBotMessage());
                    } else if(msg.getMessageType() == 17) {
                        String botMessageMuid = msg.getMuid();
                        if(TextUtils.isEmpty(botMessageMuid))
                            botMessageMuid = UUID.randomUUID().toString() + "." + new Date().getTime();

                        Message message = attributes.getMessage();
                        BotMessage botMessage = new BotMessage();
                        if(HippoConfig.getInstance().getBotId() != null && HippoConfig.getInstance().getBotId() > 0) {
                            botMessage.setBotGroupId(HippoConfig.getInstance().getBotId());
                        } else {
                            botMessage.setBotGroupId(null);
                        }
                        botMessage.setContentValue(message.getContentValue());
                        try {
                            botMessage.getContentValue().get(0).setTextValue("");
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                        botMessage.setValues(message.getValues());

                        botMessage.setDateTime(message.getDate());
                        botMessage.setFullName(userName);
                        botMessage.setIsTyping(0);
                        botMessage.setMessage(message.getMessage());
                        botMessage.setMessageStatus(MESSAGE_UNSENT);
                        botMessage.setMessageType(message.getOriginalMessageType());
                        botMessage.setMuid(botMessageMuid);
                        botMessage.setUserImage(attributes.getJsonObject().optString(USER_IMAGE));

                        botMessage.setUserId(userId);
                        botMessage.setUserType(ANDROID_USER);

                        botMessage.setUserId(message.getUserId());
                        botMessage.setUserType(message.getUserType());

                        botMessage.setIsFromBot(attributes.getJsonObject().optInt("is_from_bot"));
                        botMessage.setIsSkipButton(attributes.getJsonObject().optInt("is_skip_button"));
                        botMessage.setIsSkipEvent(attributes.getJsonObject().optInt("is_skip_event"));

                        /*if(botMessage.getIsSkipEvent() == 1) {
                            hasBotMessage = false;
                        }*/

                        arrayList.add(botMessage);
                    } else if(msg.getMessageType() == 16) {

                    } else if(msg.getMessageType() == 14) {

                    } else {
                        arrayList.add(msg);
                    }
                }
                fuguCreateConversationParams.setInitialBotMessages(arrayList);
            }



        }




        HippoLog.e("CREATE", ""+new Gson().toJson(fuguCreateConversationParams));


        RestClient.getApiInterface().createConversation(fuguCreateConversationParams)
                .enqueue(new ResponseResolver<FuguCreateConversationResponse>(context, false, true) {
                    @Override
                    public void success(FuguCreateConversationResponse fuguCreateConversationResponse) {

                        if(callback != null) {
                            callback.onSuccess(fuguCreateConversationResponse, messageType, attributes.getJsonObject(), attributes.getMessage(), hasBotMessage);
                        }
                    }

                    @Override
                    public void failure(APIError error) {
                        if(callback != null)
                            callback.onFailure(error);
                    }

                });

    }

    public interface Callback {
        void onSuccess(FuguCreateConversationResponse fuguCreateConversationResponse, int messageType, JSONObject data, Message message, boolean hasBotMessage);
        void onFailure(APIError error);
    }
}
