/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.activity;

import android.app.Activity;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.hippo.HippoConfig;
import com.hippo.activity.CreateChannelAttribute;
import com.hippo.database.CommonData;
import com.hippo.model.BotMessage;
import com.hippo.model.FuguCreateConversationParams;
import com.hippo.model.FuguCreateConversationResponse;
import com.hippo.model.GroupingTag;
import com.hippo.model.Message;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.utils.DateUtils;
import com.hippo.utils.HippoLog;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import org.json.JSONObject;

public class CreateConversation {
    private Activity context;
    private boolean hasBotMessage = false;
    private String userName;
    private Long userId;
    private int messageType;

    public CreateConversation(Activity context, String userName, Long userId) {
        this.context = context;
        this.userName = userName;
        this.userId = userId;
    }

    protected void createChannel(final CreateChannelAttribute attributes, final Callback callback) {
        FuguCreateConversationParams fuguCreateConversationParams = attributes.getFuguCreateConversationParams();
        this.messageType = attributes.getMessageType();
        ArrayList<String> groupingTags = new ArrayList<String>();
        if (attributes.getFuguCreateConversationParams().getGroupingTags() != null && fuguCreateConversationParams.getGroupingTags().size() > 0) {
            groupingTags.addAll(fuguCreateConversationParams.getGroupingTags());
        }
        try {
            if (CommonData.getUserDetails() != null && CommonData.getUserDetails().getData() != null && CommonData.getUserDetails().getData().getGroupingTags() != null && CommonData.getUserDetails().getData().getGroupingTags().size() > 0) {
                for (GroupingTag groupingTag : CommonData.getUserDetails().getData().getGroupingTags()) {
                    groupingTags.add(groupingTag.getTagName());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        fuguCreateConversationParams.setGroupingTags(groupingTags);
        if (attributes.getLabelId() != null && attributes.getLabelId().compareTo(-1L) > 0) {
            fuguCreateConversationParams.setLabelId(attributes.getLabelId());
        }
        if (HippoConfig.getInstance().getBotId() != null && HippoConfig.getInstance().getBotId() > 0) {
            fuguCreateConversationParams.setBotGroupId(HippoConfig.getInstance().getBotId());
        }
        if (HippoConfig.getInstance().getSkipBot()) {
            fuguCreateConversationParams.setSkipBot(1);
            if (!TextUtils.isEmpty((CharSequence)HippoConfig.getInstance().getSkipBotReason())) {
                fuguCreateConversationParams.setSkipBotReason(HippoConfig.getInstance().getSkipBotReason());
            }
        }
        if (!TextUtils.isEmpty((CharSequence)attributes.getBotMessageMuid())) {
            fuguCreateConversationParams.setBotFormMuid(attributes.getBotMessageMuid());
        }
        if (attributes.getmFuguGetMessageResponse() != null && attributes.getmFuguGetMessageResponse().getData() != null && attributes.getmFuguGetMessageResponse().getData().getBotGroupId() != null && attributes.getmFuguGetMessageResponse().getData().getBotGroupId() > -1) {
            this.hasBotMessage = true;
            this.messageType = 0;
            fuguCreateConversationParams.setInitiateBotGroupId(attributes.getmFuguGetMessageResponse().getData().getBotGroupId());
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (attributes.getMessageType() == 1 && !TextUtils.isEmpty((CharSequence)attributes.getText()) || attributes.getFileuploadModel() != null) {
                arrayList.addAll(attributes.getmFuguGetMessageResponse().getData().getMessages());
                DateUtils.getInstance();
                String localDate = DateUtils.getFormattedDate(new Date());
                String removeGt = "";
                if (attributes.getMessageType() == 1 && !TextUtils.isEmpty((CharSequence)attributes.getText().trim())) {
                    String removeLt = attributes.getText().trim().replaceAll("<", "&lt;");
                    removeGt = removeLt.replaceAll(">", "&gt;");
                }
                Message messageObj = new Message(0L, this.userName, this.userId, removeGt, DateUtils.getInstance().convertToUTC(localDate), true, 4, attributes.getmFuguGetMessageResponse().getData().getMessages().size(), "", "", attributes.getMessageType(), UUID.randomUUID().toString() + "." + new Date().getTime());
                messageObj.setUserType(1);
                messageObj.setOriginalMessageType(attributes.getMessageType());
                messageObj.setMessageType(attributes.getMessageType());
                messageObj.setIntegrationSource(0);
                messageObj.setIsMessageExpired(0);
                messageObj.setMessageState(4);
                messageObj.setUserId(this.userId);
                messageObj.setFromName(this.userName);
                if (attributes.getFileuploadModel() != null) {
                    messageObj.setMessageType(attributes.getFileuploadModel().getMessageType());
                    messageObj.setUrl(attributes.getFileuploadModel().getMessageObject().optString("image_url"));
                    messageObj.setThumbnailUrl(attributes.getFileuploadModel().getMessageObject().optString("thumbnail_url"));
                    messageObj.setDocumentType(attributes.getFileuploadModel().getDocumentType());
                    messageObj.setMuid(attributes.getFileuploadModel().getMuid());
                }
                arrayList.add(messageObj);
                fuguCreateConversationParams.setInitialBotMessages(arrayList);
            } else {
                for (Message msg : attributes.getmFuguGetMessageResponse().getData().getMessages()) {
                    if (msg.getMessageType() == 20) {
                        arrayList.add(attributes.getBotMessage());
                        continue;
                    }
                    if (msg.getMessageType() == 17) {
                        String botMessageMuid = msg.getMuid();
                        if (TextUtils.isEmpty((CharSequence)botMessageMuid)) {
                            botMessageMuid = UUID.randomUUID().toString() + "." + new Date().getTime();
                        }
                        Message message = attributes.getMessage();
                        BotMessage botMessage = new BotMessage();
                        if (HippoConfig.getInstance().getBotId() != null && HippoConfig.getInstance().getBotId() > 0) {
                            botMessage.setBotGroupId(HippoConfig.getInstance().getBotId());
                        } else {
                            botMessage.setBotGroupId(null);
                        }
                        botMessage.setContentValue(message.getContentValue());
                        try {
                            botMessage.getContentValue().get(0).setTextValue("");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        botMessage.setValues(message.getValues());
                        botMessage.setDateTime(message.getDate());
                        botMessage.setFullName(this.userName);
                        botMessage.setIsTyping(0);
                        botMessage.setMessage(message.getMessage());
                        botMessage.setMessageStatus(4);
                        botMessage.setMessageType(message.getOriginalMessageType());
                        botMessage.setMuid(botMessageMuid);
                        botMessage.setUserImage(attributes.getJsonObject().optString("user_image"));
                        botMessage.setUserId(this.userId);
                        botMessage.setUserType(1);
                        botMessage.setUserId(message.getUserId());
                        botMessage.setUserType(message.getUserType());
                        botMessage.setIsFromBot(attributes.getJsonObject().optInt("is_from_bot"));
                        botMessage.setIsSkipButton(attributes.getJsonObject().optInt("is_skip_button"));
                        botMessage.setIsSkipEvent(attributes.getJsonObject().optInt("is_skip_event"));
                        arrayList.add(botMessage);
                        continue;
                    }
                    if (msg.getMessageType() == 16 || msg.getMessageType() == 14) continue;
                    arrayList.add(msg);
                }
                fuguCreateConversationParams.setInitialBotMessages(arrayList);
            }
        }
        HippoLog.e("CREATE", "" + new Gson().toJson((Object)fuguCreateConversationParams));
        RestClient.getApiInterface().createConversation(fuguCreateConversationParams).enqueue((retrofit2.Callback)new ResponseResolver<FuguCreateConversationResponse>(this.context, Boolean.valueOf(false), Boolean.valueOf(true)){

            @Override
            public void success(FuguCreateConversationResponse fuguCreateConversationResponse) {
                if (callback != null) {
                    callback.onSuccess(fuguCreateConversationResponse, CreateConversation.this.messageType, attributes.getJsonObject(), attributes.getMessage(), CreateConversation.this.hasBotMessage);
                }
            }

            @Override
            public void failure(APIError error) {
                if (callback != null) {
                    callback.onFailure(error);
                }
            }
        });
    }

    public static interface Callback {
        public void onSuccess(FuguCreateConversationResponse var1, int var2, JSONObject var3, Message var4, boolean var5);

        public void onFailure(APIError var1);
    }
}

