/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.easypermissions;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.StyleRes;
import androidx.appcompat.app.AppCompatDialogFragment;
import androidx.fragment.app.FragmentManager;
import com.hippo.utils.easypermissions.EasyPermissions;
import com.hippo.utils.easypermissions.RationaleDialogClickListener;
import com.hippo.utils.easypermissions.RationaleDialogConfig;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class RationaleDialogFragmentCompat
extends AppCompatDialogFragment {
    public static final String TAG = "RationaleDialogFragmentCompat";
    private EasyPermissions.PermissionCallbacks mPermissionCallbacks;
    private EasyPermissions.RationaleCallbacks mRationaleCallbacks;

    public static RationaleDialogFragmentCompat newInstance(@NonNull String rationaleMsg, @NonNull String positiveButton, @NonNull String negativeButton, @StyleRes int theme, int requestCode, @NonNull String[] permissions) {
        RationaleDialogFragmentCompat dialogFragment = new RationaleDialogFragmentCompat();
        RationaleDialogConfig config = new RationaleDialogConfig(positiveButton, negativeButton, rationaleMsg, theme, requestCode, permissions);
        dialogFragment.setArguments(config.toBundle());
        return dialogFragment;
    }

    public void showAllowingStateLoss(FragmentManager manager, String tag) {
        if (manager.isStateSaved()) {
            return;
        }
        this.show(manager, tag);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (this.getParentFragment() != null) {
            if (this.getParentFragment() instanceof EasyPermissions.PermissionCallbacks) {
                this.mPermissionCallbacks = (EasyPermissions.PermissionCallbacks)this.getParentFragment();
            }
            if (this.getParentFragment() instanceof EasyPermissions.RationaleCallbacks) {
                this.mRationaleCallbacks = (EasyPermissions.RationaleCallbacks)this.getParentFragment();
            }
        }
        if (context instanceof EasyPermissions.PermissionCallbacks) {
            this.mPermissionCallbacks = (EasyPermissions.PermissionCallbacks)context;
        }
        if (context instanceof EasyPermissions.RationaleCallbacks) {
            this.mRationaleCallbacks = (EasyPermissions.RationaleCallbacks)context;
        }
    }

    public void onDetach() {
        super.onDetach();
        this.mPermissionCallbacks = null;
        this.mRationaleCallbacks = null;
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        this.setCancelable(false);
        RationaleDialogConfig config = new RationaleDialogConfig(this.getArguments());
        RationaleDialogClickListener clickListener = new RationaleDialogClickListener(this, config, this.mPermissionCallbacks, this.mRationaleCallbacks);
        return config.createSupportDialog(this.getContext(), clickListener);
    }
}

