/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.agent.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.HippoColorConfig;
import com.hippo.R;
import com.hippo.agent.Util.ProgressBarDisplayRunnable;
import com.hippo.agent.listeners.OnItemClickListener;
import com.hippo.agent.model.broadcastStatus.BroadcastUser;
import com.hippo.database.CommonData;
import com.hippo.utils.DateUtils;
import java.util.ArrayList;

public class BroadcastDetailAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final String TAG = BroadcastDetailAdapter.class.getSimpleName();
    private Context context;
    private ArrayList<BroadcastUser> arrayList = new ArrayList();
    private static final int VIEW_TYPE = 1;
    private static final int VIEW_TYPE_LOADING = 2;
    private RecyclerView recyclerView;
    private String STANDARD_DATE_FORMAT_TZ = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private String OUTPUT_FORMAT = "MMM dd, yyyy, hh:mm aa";
    private OnItemClickListener onItemClickListener;
    private HippoColorConfig hippoColorConfig;
    private ProgressBarDisplayRunnable progressBarDisplayRunnable;

    public BroadcastDetailAdapter(RecyclerView recyclerView, OnItemClickListener onItemClickListener) {
        this.recyclerView = recyclerView;
        this.onItemClickListener = onItemClickListener;
    }

    public void setData(ArrayList<BroadcastUser> arrayList) {
        this.arrayList = arrayList;
        this.notifyDataSetChanged();
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        this.context = parent.getContext();
        this.hippoColorConfig = CommonData.getColorConfig();
        if (viewType == 2) {
            return new LoadMoreHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.hippo_layout_loaddata, parent, false));
        }
        return new ViewHolder(LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_layout_broadcast_item_detail, parent, false));
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        if (holder instanceof ViewHolder) {
            ViewHolder viewHolder = (ViewHolder)holder;
            BroadcastUser objectModel = this.arrayList.get(position);
            viewHolder.tvTitle.setText((CharSequence)objectModel.getFullName());
            if (!TextUtils.isEmpty((CharSequence)objectModel.getLastActivity())) {
                String localDate = DateUtils.getInstance().convertToLocal(objectModel.getLastActivity(), this.STANDARD_DATE_FORMAT_TZ, this.OUTPUT_FORMAT);
                viewHolder.tvStatus.setText((CharSequence)("Read at " + localDate));
            } else {
                viewHolder.tvStatus.setText((CharSequence)"Delivered");
            }
            if (!TextUtils.isEmpty((CharSequence)objectModel.getRepliedOn())) {
                viewHolder.chatIcon.setVisibility(0);
            } else {
                viewHolder.chatIcon.setVisibility(8);
            }
        }
    }

    public int getItemCount() {
        return this.arrayList == null ? 0 : this.arrayList.size();
    }

    public int getItemViewType(int position) {
        try {
            if (this.arrayList.get(position).getUserId().equals(-1)) {
                return 2;
            }
            return 1;
        }
        catch (Exception e) {
            return 1;
        }
    }

    public void showPaginationProgressBar(boolean show, boolean notifyAdapter) {
        boolean isProgressBarExist;
        if (this.arrayList == null || this.arrayList.size() == 0) {
            return;
        }
        boolean bl = isProgressBarExist = this.arrayList.get(this.arrayList.size() - 1).getUserId() != null && this.arrayList.get(this.arrayList.size() - 1).getUserId() == -1;
        if (show) {
            if (!isProgressBarExist) {
                this.arrayList.add(ProgressBarModel.getInstance());
                if (notifyAdapter) {
                    this.recyclerView.post((Runnable)this.getProgressDisplayRunnable(true, this.arrayList.size()));
                }
            }
        } else if (this.arrayList.remove(ProgressBarModel.getInstance()) && notifyAdapter) {
            this.recyclerView.post((Runnable)this.getProgressDisplayRunnable(false, this.arrayList.size()));
        }
    }

    private ProgressBarDisplayRunnable getProgressDisplayRunnable(boolean isInsert, int position) {
        if (this.progressBarDisplayRunnable == null) {
            this.progressBarDisplayRunnable = new ProgressBarDisplayRunnable(this);
        }
        this.progressBarDisplayRunnable.setInsert(isInsert);
        this.progressBarDisplayRunnable.setPosition(position);
        return this.progressBarDisplayRunnable;
    }

    private static class ProgressBarModel {
        private static BroadcastUser progressBarModel;

        private ProgressBarModel() {
        }

        public static BroadcastUser getInstance() {
            if (progressBarModel == null) {
                progressBarModel = new BroadcastUser(-1);
            }
            return progressBarModel;
        }
    }

    public class LoadMoreHolder
    extends RecyclerView.ViewHolder {
        public LoadMoreHolder(View itemView) {
            super(itemView);
        }
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private RelativeLayout llLayout;
        private RelativeLayout chatIcon;
        private TextView tvTitle;
        private TextView tvStatus;

        public ViewHolder(View itemView) {
            super(itemView);
            this.llLayout = (RelativeLayout)itemView.findViewById(R.id.ll_layout);
            this.chatIcon = (RelativeLayout)itemView.findViewById(R.id.chat_icon);
            this.tvTitle = (TextView)itemView.findViewById(R.id.tvTitle);
            this.tvStatus = (TextView)itemView.findViewById(R.id.tvStatus);
            this.tvTitle.setTextColor(BroadcastDetailAdapter.this.hippoColorConfig.getHippoTextColorPrimary());
            this.tvStatus.setTextColor(BroadcastDetailAdapter.this.hippoColorConfig.getHippoTextColorSecondary());
            this.llLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (BroadcastDetailAdapter.this.onItemClickListener != null) {
                        BroadcastDetailAdapter.this.onItemClickListener.onClickItem(ViewHolder.this.getAdapterPosition());
                    }
                }
            });
        }
    }
}

