/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.GradientDrawable;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatButton;
import androidx.appcompat.widget.Toolbar;
import androidx.core.widget.NestedScrollView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.HippoColorConfig;
import com.hippo.R;
import com.hippo.activity.FuguBaseActivity;
import com.hippo.adapter.HippoPaymentAdapter;
import com.hippo.database.CommonData;
import com.hippo.interfaces.onItemOpertionListener;
import com.hippo.model.PaymentData;
import com.hippo.model.PaymentModelData;
import com.hippo.support.Utils.Constants;
import com.hippo.utils.countrypicker.Country;
import com.hippo.utils.countrypicker.CurrencyPicker;
import com.hippo.utils.countrypicker.OnCountryPickerListener;
import com.hippo.utils.filepicker.ToastUtil;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class HippoPaymentActivity
extends FuguBaseActivity
implements onItemOpertionListener {
    private static final String TAG = HippoPaymentActivity.class.getSimpleName();
    private HippoPaymentAdapter paymentAdapter;
    private ArrayList<PaymentModelData> paymentModelData = new ArrayList();
    private Country countryCurrency;
    private EditText titleView;
    private TextView currencyView;
    private TextView addOptionView;
    private TextView totalCount;
    private EditText itemDescription;
    private EditText itemPrice;
    private RecyclerView recyclerView;
    private NestedScrollView scrollView;
    private Toolbar toolbar;
    private AppCompatButton buttonSubmit;
    private HippoColorConfig hippoColorConfig;
    private TextView titleTxt;
    private TextView currencyTxt;
    private TextView descriptionTxt;
    private TextView priceTxt;
    private ImageView crossView;
    private DecimalFormat decimalFormatMoney;

    private void setColorConfig() {
        this.hippoColorConfig = CommonData.getColorConfig();
        this.titleView.setTextColor(this.hippoColorConfig.getHippoTextColorPrimary());
        this.currencyView.setTextColor(this.hippoColorConfig.getHippoTextColorPrimary());
        this.itemDescription.setTextColor(this.hippoColorConfig.getHippoTextColorPrimary());
        this.itemPrice.setTextColor(this.hippoColorConfig.getHippoTextColorPrimary());
        this.addOptionView.setTextColor(this.hippoColorConfig.getHippoThemeColorPrimary());
        this.buttonSubmit.setTextColor(this.hippoColorConfig.getHippoActionBarText());
        int radius = (int)Constants.convertDpToPixel(1.0f);
        GradientDrawable drawable2 = (GradientDrawable)this.buttonSubmit.getBackground();
        drawable2.setStroke(radius, this.hippoColorConfig.getHippoActionBarText());
        drawable2.setColor(this.hippoColorConfig.getHippoActionBarBg());
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.hippo_activity_payment);
    }

    protected void onPostCreate(@Nullable Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);
        this.toolbar = (Toolbar)this.findViewById(R.id.my_toolbar);
        this.setSupportActionBar(this.toolbar);
        this.setToolbar(this.toolbar, "Payment Request");
        this.titleView = (EditText)this.findViewById(R.id.titie_view);
        this.currencyView = (TextView)this.findViewById(R.id.currency_type_view);
        this.itemDescription = (EditText)this.findViewById(R.id.item_description);
        this.itemPrice = (EditText)this.findViewById(R.id.item_price);
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recycler_view);
        this.addOptionView = (TextView)this.findViewById(R.id.add_option_view);
        this.buttonSubmit = (AppCompatButton)this.findViewById(R.id.buttonSubmit);
        this.titleTxt = (TextView)this.findViewById(R.id.title_txt);
        this.currencyTxt = (TextView)this.findViewById(R.id.currency_txt);
        this.descriptionTxt = (TextView)this.findViewById(R.id.description_txt);
        this.priceTxt = (TextView)this.findViewById(R.id.price_txt);
        this.totalCount = (TextView)this.findViewById(R.id.total_count);
        this.totalCount.setVisibility(8);
        this.setColorConfig();
        this.paymentAdapter = new HippoPaymentAdapter(this.paymentModelData, this);
        LinearLayoutManager layoutManager = new LinearLayoutManager((Context)this);
        layoutManager.setOrientation(1);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.paymentAdapter);
        this.currencyView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                HippoPaymentActivity.this.openPicker(HippoPaymentActivity.this.currencyView);
            }
        });
        this.itemPrice.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                HippoPaymentActivity.this.onItemAdded();
            }
        });
        this.addOptionView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (HippoPaymentActivity.this.paymentModelData.size() > 0) {
                    if (TextUtils.isEmpty((CharSequence)((PaymentModelData)HippoPaymentActivity.this.paymentModelData.get(HippoPaymentActivity.this.paymentModelData.size() - 1)).getItemDescription().trim()) || TextUtils.isEmpty((CharSequence)((PaymentModelData)HippoPaymentActivity.this.paymentModelData.get(HippoPaymentActivity.this.paymentModelData.size() - 1)).getPrice().trim())) {
                        ToastUtil.getInstance((Context)HippoPaymentActivity.this).showToast("Please fill previous fields");
                        return;
                    }
                } else if (TextUtils.isEmpty((CharSequence)HippoPaymentActivity.this.itemDescription.getText().toString().trim()) || TextUtils.isEmpty((CharSequence)HippoPaymentActivity.this.itemPrice.getText().toString().trim())) {
                    ToastUtil.getInstance((Context)HippoPaymentActivity.this).showToast("Please fill previous fields");
                    return;
                }
                PaymentModelData modelData = new PaymentModelData();
                modelData.setItemDescription("");
                modelData.setPrice("");
                HippoPaymentActivity.this.paymentModelData.add(modelData);
                HippoPaymentActivity.this.paymentAdapter.notifyItemInserted(HippoPaymentActivity.this.paymentModelData.size() - 1);
            }
        });
        this.buttonSubmit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                HippoPaymentActivity.this.hideKeyboard((Activity)HippoPaymentActivity.this);
                PaymentData paymentData = new PaymentData();
                if (TextUtils.isEmpty((CharSequence)HippoPaymentActivity.this.titleView.getText().toString().trim())) {
                    HippoPaymentActivity.this.titleView.setError((CharSequence)"Field can't be empty");
                    return;
                }
                if (TextUtils.isEmpty((CharSequence)HippoPaymentActivity.this.itemDescription.getText().toString().trim())) {
                    HippoPaymentActivity.this.itemDescription.setError((CharSequence)"Field can't be empty");
                    return;
                }
                if (TextUtils.isEmpty((CharSequence)HippoPaymentActivity.this.itemPrice.getText().toString().trim())) {
                    HippoPaymentActivity.this.itemPrice.setError((CharSequence)"Field can't be empty");
                    return;
                }
                paymentData.setTitle(HippoPaymentActivity.this.titleView.getText().toString());
                if (HippoPaymentActivity.this.countryCurrency != null) {
                    paymentData.setCurrency(HippoPaymentActivity.this.countryCurrency.getCurrency());
                    paymentData.setCurrencySymbol(HippoPaymentActivity.this.countryCurrency.getSymbol());
                } else {
                    paymentData.setCurrency("USD");
                    paymentData.setCurrencySymbol("$");
                }
                ArrayList<PaymentModelData> arrayList = new ArrayList<PaymentModelData>();
                if (!TextUtils.isEmpty((CharSequence)HippoPaymentActivity.this.itemDescription.getText().toString().trim()) && !TextUtils.isEmpty((CharSequence)HippoPaymentActivity.this.itemPrice.getText().toString().trim())) {
                    try {
                        Double d = Double.parseDouble(HippoPaymentActivity.this.itemPrice.getText().toString().trim());
                    }
                    catch (NumberFormatException e) {
                        ToastUtil.getInstance((Context)HippoPaymentActivity.this).showToast("Please enter valid price for item");
                        return;
                    }
                    PaymentModelData modelData = new PaymentModelData();
                    modelData.setItemDescription(HippoPaymentActivity.this.itemDescription.getText().toString().trim());
                    modelData.setPrice(HippoPaymentActivity.this.itemPrice.getText().toString().trim());
                    arrayList.add(modelData);
                }
                for (int i = 0; i < HippoPaymentActivity.this.paymentModelData.size(); ++i) {
                    PaymentModelData modelData = (PaymentModelData)HippoPaymentActivity.this.paymentModelData.get(i);
                    if (TextUtils.isEmpty((CharSequence)modelData.getItemDescription()) && TextUtils.isEmpty((CharSequence)modelData.getPrice())) continue;
                    ((PaymentModelData)HippoPaymentActivity.this.paymentModelData.get(i)).setErrorDesc(null);
                    ((PaymentModelData)HippoPaymentActivity.this.paymentModelData.get(i)).setErrorPrice(null);
                    if (TextUtils.isEmpty((CharSequence)modelData.getItemDescription().trim())) {
                        ((PaymentModelData)HippoPaymentActivity.this.paymentModelData.get(i)).setErrorDesc("Field can't be empty");
                        HippoPaymentActivity.this.paymentAdapter.notifyItemChanged(i);
                        return;
                    }
                    if (TextUtils.isEmpty((CharSequence)modelData.getPrice().trim())) {
                        ((PaymentModelData)HippoPaymentActivity.this.paymentModelData.get(i)).setErrorPrice("Field can't be empty");
                        HippoPaymentActivity.this.paymentAdapter.notifyItemChanged(i);
                        return;
                    }
                    try {
                        Double d = Double.parseDouble(modelData.getPrice().trim());
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                        ((PaymentModelData)HippoPaymentActivity.this.paymentModelData.get(i)).setErrorPrice("Invalid price");
                        HippoPaymentActivity.this.paymentAdapter.notifyItemChanged(i);
                        return;
                    }
                    arrayList.add(modelData);
                }
                paymentData.setPaymentModelData(arrayList);
                Intent intent = new Intent();
                intent.putExtra("data", (Serializable)paymentData);
                HippoPaymentActivity.this.setResult(-1, intent);
                HippoPaymentActivity.this.finish();
            }
        });
        this.itemDescription.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (HippoPaymentActivity.this.itemDescription.hasFocus()) {
                    v.getParent().requestDisallowInterceptTouchEvent(true);
                    switch (event.getAction() & 0xFF) {
                        case 8: {
                            v.getParent().requestDisallowInterceptTouchEvent(false);
                            return true;
                        }
                    }
                }
                return false;
            }
        });
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    @Override
    protected void onPause() {
        super.onPause();
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.onBackPressed();
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        super.onBackPressed();
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    @Override
    public void onItemAdded() {
        Double totalPrice = 0.0;
        if (!TextUtils.isEmpty((CharSequence)this.itemPrice.getText().toString().trim())) {
            try {
                totalPrice = Double.parseDouble(this.itemPrice.getText().toString().trim());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return;
            }
        }
        if (this.paymentModelData != null && this.paymentModelData.size() > 0) {
            for (PaymentModelData modelData : this.paymentModelData) {
                if (modelData == null || TextUtils.isEmpty((CharSequence)modelData.getPrice())) continue;
                try {
                    totalPrice = totalPrice + Double.parseDouble(modelData.getPrice().trim());
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    return;
                }
            }
        }
        if (totalPrice > 0.0) {
            this.totalCount.setVisibility(0);
            this.totalCount.setText((CharSequence)this.getString(R.string.hippo_total_count, new Object[]{this.getDecimalFormat().format(totalPrice)}));
        } else {
            this.totalCount.setVisibility(8);
        }
    }

    @Override
    public void onItemRemoved(int position) {
        this.paymentModelData.remove(position);
        this.paymentAdapter.notifyItemRemoved(position);
    }

    private void openPicker(final TextView textView) {
        CurrencyPicker currencyPicker = new CurrencyPicker.Builder().with((Context)this).sortBy(1).listener(new OnCountryPickerListener(){

            @Override
            public void onSelectCountry(Country country) {
                HippoPaymentActivity.this.countryCurrency = country;
                textView.setText((CharSequence)(country.getCode() + "(" + country.getSymbol() + ")"));
            }
        }).build();
        currencyPicker.showDialog(this.getSupportFragmentManager());
    }

    public DecimalFormat getDecimalFormat() {
        if (this.decimalFormatMoney == null) {
            this.decimalFormatMoney = new DecimalFormat("#.##");
        }
        return this.decimalFormatMoney;
    }
}

