/*
 * Decompiled with CFR 0.152.
 */
package com.hippocall;

import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import com.hippo.CallData;
import com.hippo.HippoConfig;
import com.hippo.constant.FuguAppConstant;
import com.hippocall.AppContants;
import com.hippocall.CommonData;
import com.hippocall.FuguCallActivity;
import com.hippocall.VideoCallModel;
import com.hippocall.WebRTCCallConstants;
import com.hippocall.model.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.json.JSONObject;

public class HippoCallConfig
implements CallData,
FuguAppConstant {
    private static HippoCallConfig instance;
    private BroadcastReceiver fuguChatCustomActionReceiver;

    private HippoCallConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HippoCallConfig getInstance() {
        if (instance != null) return instance;
        Class<HippoCallConfig> clazz = HippoCallConfig.class;
        synchronized (HippoCallConfig.class) {
            if (instance != null) return instance;
            instance = new HippoCallConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void setCallBackListener() {
        HippoConfig.getInstance().setCallListener((CallData)this);
    }

    private void sendUserBusyBroadcast(Context context, long channelId, String messageUniqueId, String videoCallType, String userId) {
        Intent videoCallIntent = new Intent("hippo_video_call_intent");
        videoCallIntent.putExtra("channel_id", channelId);
        videoCallIntent.putExtra("muid", messageUniqueId);
        videoCallIntent.putExtra("video_call_type", videoCallType);
        videoCallIntent.putExtra("user_id", userId);
        LocalBroadcastManager.getInstance((Context)context).sendBroadcast(videoCallIntent);
    }

    public void onNotificationReceived(Context context, JSONObject data) {
        block2: {
            try {
                this.videoCallPush(context, data);
            }
            catch (Exception e) {
                if (!HippoConfig.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    public void onCallClick(Context context, int callType, Long channelId, Long userId, boolean isAgentFlow, boolean isAllowCall, String fullname, String image) {
        Message turnCredentials = new AppContants().getTurnCredentials();
        Intent videoIntent = new Intent(context.getApplicationContext(), FuguCallActivity.class);
        String messageUniqueId = UUID.randomUUID().toString();
        String activityLaunchState = WebRTCCallConstants.AcitivityLaunchState.SELF.toString();
        if (callType == 2) {
            activityLaunchState = WebRTCCallConstants.AcitivityLaunchState.AUDIO.toString();
        }
        VideoCallModel videoCallModel = new VideoCallModel(channelId, image, fullname, userId, fullname, callType, turnCredentials.getTurnApiKey(), turnCredentials.getUsername(), turnCredentials.getCredentials(), (ArrayList)turnCredentials.getIceServers().getStun(), (ArrayList)turnCredentials.getIceServers().getTurn(), activityLaunchState, messageUniqueId);
        videoIntent.addFlags(0x10000000);
        videoIntent.addFlags(0x800000);
        videoIntent.putExtra("videoCallModel", (Parcelable)videoCallModel);
        context.startActivity(videoIntent);
    }

    private void videoCallPush(Context context, JSONObject jsonObject) throws Exception {
        String userImage;
        ActivityManager mngr = (ActivityManager)context.getSystemService("activity");
        List taskList = mngr.getRunningTasks(10);
        Long userId = CommonData.getUserId();
        String fullname = jsonObject.optString("full_name");
        Long channelId = jsonObject.optLong("channel_id");
        String messageUniqueId = jsonObject.optString("muid");
        String videoCallType = jsonObject.optString("video_call_type", "");
        String callType = jsonObject.optString("call_type", "");
        int callValue = 1;
        String activityLaunchState = WebRTCCallConstants.AcitivityLaunchState.OTHER.toString();
        if (callType.equalsIgnoreCase("AUDIO")) {
            callValue = 2;
        }
        String string = !TextUtils.isEmpty((CharSequence)jsonObject.optString("user_image")) ? jsonObject.optString("user_image") : (userImage = !TextUtils.isEmpty((CharSequence)jsonObject.optString("thumbnail_url")) ? jsonObject.optString("thumbnail_url") : jsonObject.optString("image_url", ""));
        if (!((ActivityManager.RunningTaskInfo)taskList.get((int)0)).topActivity.getClassName().equals("com.hippo.videoCall.FuguCallActivity") && jsonObject.getInt("notification_type") == 14 && jsonObject.has("video_call_type") && jsonObject.getString("video_call_type").equals("START_CALL") && userId.compareTo(-1L) != 0 && userId.compareTo(jsonObject.optLong("user_id")) != 0) {
            Message turnCredentials = new AppContants().getTurnCredentials();
            Intent videoIntent = new Intent(context.getApplicationContext(), FuguCallActivity.class);
            VideoCallModel videoCallModel = new VideoCallModel(channelId, userImage, fullname, userId, fullname, callValue, turnCredentials.getTurnApiKey(), turnCredentials.getUsername(), turnCredentials.getCredentials(), (ArrayList)turnCredentials.getIceServers().getStun(), (ArrayList)turnCredentials.getIceServers().getTurn(), activityLaunchState, messageUniqueId);
            videoIntent.addFlags(0x10000000);
            videoIntent.addFlags(0x800000);
            videoIntent.putExtra("videoCallModel", (Parcelable)videoCallModel);
            context.startActivity(videoIntent);
        } else {
            this.sendUserBusyBroadcast(context, channelId, messageUniqueId, videoCallType, String.valueOf(userId));
        }
    }
}

