/*
 * Decompiled with CFR 0.152.
 */
package com.hippocall;

import android.content.Context;
import com.hippocall.Connection;
import com.hippocall.CustomPeerConnectionObserver;
import com.hippocall.CustomSdpObserver;
import com.hippocall.VideoCallService;
import com.hippocall.WebRTCCallConstants;
import com.hippocall.WebRTCSignallingClient;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import org.webrtc.IceCandidate;
import org.webrtc.MediaConstraints;
import org.webrtc.MediaStream;
import org.webrtc.PeerConnection;
import org.webrtc.SdpObserver;
import org.webrtc.SessionDescription;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000fJ\u0010\u0010\u001d\u001a\u00020\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u000fJ\u001a\u0010\u001f\u001a\u00020\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0012\u0010 \u001a\u00020\u001b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006$"}, d2={"Lcom/hippocall/WebRTCCallClient;", "", "videoCallService", "Lcom/hippocall/VideoCallService;", "(Lcom/hippocall/VideoCallService;)V", "iceServers", "", "Lorg/webrtc/PeerConnection$IceServer;", "peerConnection", "Lorg/webrtc/PeerConnection;", "getPeerConnection", "()Lorg/webrtc/PeerConnection;", "setPeerConnection", "(Lorg/webrtc/PeerConnection;)V", "videoOffer", "Lorg/json/JSONObject;", "getVideoOffer", "()Lorg/json/JSONObject;", "setVideoOffer", "(Lorg/json/JSONObject;)V", "createOffer", "connection", "Lcom/hippocall/Connection;", "createPeerConnection", "getRTCConfig", "Lorg/webrtc/PeerConnection$RTCConfiguration;", "saveAnswer", "", "answerJson", "saveIceCandidate", "jsonObject", "saveOfferAndAnswer", "setIceServers", "setRemoteDescription", "sessionDescription", "Lorg/webrtc/SessionDescription;", "hippocall_release"})
public final class WebRTCCallClient {
    private List<PeerConnection.IceServer> iceServers;
    @Nullable
    private PeerConnection peerConnection;
    @Nullable
    private JSONObject videoOffer;
    private final VideoCallService videoCallService;

    @Nullable
    public final PeerConnection getPeerConnection() {
        return this.peerConnection;
    }

    public final void setPeerConnection(@Nullable PeerConnection peerConnection) {
        this.peerConnection = peerConnection;
    }

    @Nullable
    public final JSONObject getVideoOffer() {
        return this.videoOffer;
    }

    public final void setVideoOffer(@Nullable JSONObject jSONObject) {
        this.videoOffer = jSONObject;
    }

    @Nullable
    public final PeerConnection createPeerConnection(@Nullable Connection connection) {
        if (this.peerConnection == null) {
            this.setIceServers(connection);
            PeerConnection.RTCConfiguration rtcConfiguration = this.getRTCConfig();
            Connection connection2 = connection;
            PeerConnection peerConnection = connection2 != null && (connection2 = connection2.getPeerConnectionFactory()) != null ? connection2.createPeerConnection(rtcConfiguration, new CustomPeerConnectionObserver(this, "PeerConnectionCallBack", (Context)this.videoCallService){
                final /* synthetic */ WebRTCCallClient this$0;

                public void onIceCandidate(@Nullable IceCandidate iceCandidate) {
                    block0: {
                        super.onIceCandidate(iceCandidate);
                        JSONObject json = new JSONObject();
                        json.put(WebRTCCallConstants.Companion.getVIDEO_CALL_TYPE(), (Object)WebRTCCallConstants.VideoCallType.NEW_ICE_CANDIDATE.toString());
                        JSONObject rtc_candidate = new JSONObject();
                        IceCandidate iceCandidate2 = iceCandidate;
                        rtc_candidate.put(WebRTCCallConstants.Companion.getSDP_M_LINE_INDEX(), (Object)(iceCandidate2 != null ? Integer.valueOf(iceCandidate2.sdpMLineIndex) : null));
                        IceCandidate iceCandidate3 = iceCandidate;
                        rtc_candidate.put(WebRTCCallConstants.Companion.getSDP_MID(), (Object)(iceCandidate3 != null ? iceCandidate3.sdpMid : null));
                        IceCandidate iceCandidate4 = iceCandidate;
                        rtc_candidate.put(WebRTCCallConstants.Companion.getCANDIDATE(), (Object)(iceCandidate4 != null ? iceCandidate4.sdp : null));
                        json.put(WebRTCCallConstants.Companion.getRTC_CANDIDATE(), (Object)rtc_candidate);
                        WebRTCSignallingClient webRTCSignallingClient = WebRTCCallClient.access$getVideoCallService$p(this.this$0).getWebRTCSignallingClient();
                        if (webRTCSignallingClient == null) break block0;
                        webRTCSignallingClient.sendIceCandidates(json);
                    }
                }

                public void onAddStream(@Nullable MediaStream mediaStream) {
                    super.onAddStream(mediaStream);
                    WebRTCCallClient.access$getVideoCallService$p(this.this$0).onAddStream(mediaStream);
                }
                {
                    this.this$0 = $outer;
                    super($super_call_param$1, $super_call_param$2);
                }
            }) : null;
            if (peerConnection == null) {
                Intrinsics.throwNpe();
            }
            this.peerConnection = peerConnection;
        }
        return this.peerConnection;
    }

    @Nullable
    public final JSONObject createOffer(@Nullable Connection connection) {
        try {
            if (this.videoOffer == null) {
                PeerConnection peerConnection = this.peerConnection;
                if (peerConnection != null) {
                    Connection connection2 = connection;
                    peerConnection.createOffer((SdpObserver)new CustomSdpObserver(this, "Create Offer Callback"){
                        final /* synthetic */ WebRTCCallClient this$0;

                        public void onCreateSuccess(@Nullable SessionDescription sessionDescription) {
                            super.onCreateSuccess(sessionDescription);
                            PeerConnection peerConnection = this.this$0.getPeerConnection();
                            if (peerConnection != null) {
                                peerConnection.setLocalDescription((SdpObserver)new CustomSdpObserver(WebRTCCallConstants.Companion.getLOCAL_SET_REMOTE_DESC()), sessionDescription);
                            }
                            JSONObject offerObject = new JSONObject();
                            JSONObject sdpObject = new JSONObject();
                            offerObject.put(WebRTCCallConstants.Companion.getVIDEO_CALL_TYPE(), (Object)((Object)WebRTCCallConstants.VideoCallType.VIDEO_OFFER));
                            SessionDescription sessionDescription2 = sessionDescription;
                            sdpObject.put(WebRTCCallConstants.Companion.getSDP(), (Object)(sessionDescription2 != null ? sessionDescription2.description : null));
                            sdpObject.put("type", (Object)"offer");
                            offerObject.put(WebRTCCallConstants.Companion.getSDP(), (Object)sdpObject);
                            WebRTCSignallingClient webRTCSignallingClient = WebRTCCallClient.access$getVideoCallService$p(this.this$0).getWebRTCSignallingClient();
                            this.this$0.setVideoOffer((JSONObject)(webRTCSignallingClient != null ? webRTCSignallingClient.sendOfferToRemoteUser(offerObject) : null));
                        }
                        {
                            this.this$0 = $outer;
                            super($super_call_param$1);
                        }
                    }, (MediaConstraints)(connection2 != null ? connection2.getSdpConstraints() : null));
                }
            }
            return this.videoOffer;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public final void saveAnswer(@NotNull JSONObject answerJson) {
        Intrinsics.checkParameterIsNotNull((Object)answerJson, (String)"answerJson");
        JSONObject jsonObject = answerJson.getJSONObject(WebRTCCallConstants.Companion.getSDP());
        SessionDescription sessionDescription = new SessionDescription(SessionDescription.Type.ANSWER, jsonObject.getString(WebRTCCallConstants.Companion.getSDP()));
        this.setRemoteDescription(sessionDescription);
    }

    public final void saveOfferAndAnswer(@Nullable JSONObject jsonObject, @Nullable Connection connection) {
        block2: {
            JSONObject offerJson;
            JSONObject jSONObject = jsonObject;
            JSONObject jSONObject2 = offerJson = jSONObject != null ? jSONObject.getJSONObject(WebRTCCallConstants.Companion.getSDP()) : null;
            if (this.peerConnection == null) break block2;
            JSONObject jSONObject3 = offerJson;
            SessionDescription sessionDescription = new SessionDescription(SessionDescription.Type.OFFER, jSONObject3 != null ? jSONObject3.getString(WebRTCCallConstants.Companion.getSDP()) : null);
            PeerConnection peerConnection = this.peerConnection;
            if (peerConnection != null) {
                peerConnection.setRemoteDescription((SdpObserver)new CustomSdpObserver(WebRTCCallConstants.Companion.getREMOTE_SET_REMOTE_DESC()), sessionDescription);
            }
            PeerConnection peerConnection2 = this.peerConnection;
            if (peerConnection2 != null) {
                Connection connection2 = connection;
                peerConnection2.createAnswer((SdpObserver)new CustomSdpObserver(this, "CreateAnswerCallBack"){
                    final /* synthetic */ WebRTCCallClient this$0;

                    public void onCreateSuccess(@Nullable SessionDescription sessionDescription) {
                        block1: {
                            super.onCreateSuccess(sessionDescription);
                            PeerConnection peerConnection = this.this$0.getPeerConnection();
                            if (peerConnection != null) {
                                peerConnection.setLocalDescription((SdpObserver)new CustomSdpObserver(WebRTCCallConstants.Companion.getREMOTE_SET_LOCAL_DESC()), sessionDescription);
                            }
                            JSONObject json = new JSONObject();
                            json.put(WebRTCCallConstants.Companion.getVIDEO_CALL_TYPE(), (Object)((Object)WebRTCCallConstants.VideoCallType.VIDEO_ANSWER));
                            JSONObject sdpObject = new JSONObject();
                            sdpObject.put("type", (Object)"answer");
                            SessionDescription sessionDescription2 = sessionDescription;
                            sdpObject.put(WebRTCCallConstants.Companion.getSDP(), (Object)(sessionDescription2 != null ? sessionDescription2.description : null));
                            json.put(WebRTCCallConstants.Companion.getSDP(), (Object)sdpObject);
                            WebRTCSignallingClient webRTCSignallingClient = WebRTCCallClient.access$getVideoCallService$p(this.this$0).getWebRTCSignallingClient();
                            if (webRTCSignallingClient == null) break block1;
                            webRTCSignallingClient.sendAnswerToRemoteUser(json);
                        }
                    }
                    {
                        this.this$0 = $outer;
                        super($super_call_param$1);
                    }
                }, (MediaConstraints)(connection2 != null ? connection2.getSdpConstraints() : null));
            }
        }
    }

    private final void setRemoteDescription(SessionDescription sessionDescription) {
        block0: {
            PeerConnection peerConnection = this.peerConnection;
            if (peerConnection == null) break block0;
            peerConnection.setRemoteDescription((SdpObserver)new CustomSdpObserver(WebRTCCallConstants.Companion.getLOCAL_SET_REMOTE_DESC()), sessionDescription);
        }
    }

    private final void setIceServers(Connection connection) {
        Connection connection2 = connection;
        ArrayList<String> arrayList = connection2 != null ? connection2.getStunServers() : null;
        if (arrayList == null) {
            Intrinsics.throwNpe();
        }
        for (String stun : arrayList) {
            PeerConnection.IceServer stunIceServer;
            PeerConnection.IceServer iceServer = stunIceServer = PeerConnection.IceServer.builder((String)stun).createIceServer();
            Intrinsics.checkExpressionValueIsNotNull((Object)iceServer, (String)"stunIceServer");
            this.iceServers.add(iceServer);
        }
        ArrayList<String> arrayList2 = connection.getTurnServers();
        if (arrayList2 == null) {
            Intrinsics.throwNpe();
        }
        for (String turn : arrayList2) {
            PeerConnection.IceServer turnIceServer;
            PeerConnection.IceServer iceServer = turnIceServer = PeerConnection.IceServer.builder((String)turn).setUsername(connection.getTurnUserName()).setPassword(connection.getTurnCredential()).createIceServer();
            Intrinsics.checkExpressionValueIsNotNull((Object)iceServer, (String)"turnIceServer");
            this.iceServers.add(iceServer);
        }
    }

    private final PeerConnection.RTCConfiguration getRTCConfig() {
        PeerConnection.RTCConfiguration rtcConfiguration = new PeerConnection.RTCConfiguration(this.iceServers);
        rtcConfiguration.continualGatheringPolicy = PeerConnection.ContinualGatheringPolicy.GATHER_CONTINUALLY;
        rtcConfiguration.sdpSemantics = PeerConnection.SdpSemantics.PLAN_B;
        return rtcConfiguration;
    }

    public final void saveIceCandidate(@Nullable JSONObject jsonObject) {
        block1: {
            JSONObject rtc_candidate;
            if (this.peerConnection == null) break block1;
            JSONObject jSONObject = jsonObject;
            JSONObject jSONObject2 = rtc_candidate = jSONObject != null ? jSONObject.getJSONObject(WebRTCCallConstants.Companion.getRTC_CANDIDATE()) : null;
            JSONObject jSONObject3 = rtc_candidate;
            JSONObject jSONObject4 = rtc_candidate;
            IceCandidate iceCandidate = new IceCandidate(jSONObject2 != null ? jSONObject2.getString(WebRTCCallConstants.Companion.getSDP_MID()) : null, Integer.parseInt(jSONObject3 != null ? jSONObject3.getString(WebRTCCallConstants.Companion.getSDP_M_LINE_INDEX()) : null), jSONObject4 != null ? jSONObject4.getString(WebRTCCallConstants.Companion.getCANDIDATE()) : null);
            PeerConnection peerConnection = this.peerConnection;
            if (peerConnection != null) {
                peerConnection.addIceCandidate(iceCandidate);
            }
        }
    }

    public WebRTCCallClient(@NotNull VideoCallService videoCallService) {
        Intrinsics.checkParameterIsNotNull((Object)videoCallService, (String)"videoCallService");
        this.videoCallService = videoCallService;
        this.iceServers = new ArrayList();
    }

    @NotNull
    public static final /* synthetic */ VideoCallService access$getVideoCallService$p(WebRTCCallClient $this) {
        return $this.videoCallService;
    }
}

