package com.hippocall

import android.app.ActivityManager
import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.content.IntentFilter
import android.os.Handler
import android.os.Looper
import android.support.v4.content.LocalBroadcastManager
import com.hippo.interfaces.fayeClient
import com.hippo.BuildConfig
import com.hippo.HippoConfig
import com.hippo.constant.FuguAppConstant
import com.hippo.constant.FuguAppConstant.INVALID_VIDEO_CALL_CREDENTIALS
import com.hippo.constant.FuguAppConstant.TYPING_SHOW_MESSAGE
import com.hippo.utils.HippoLog
import com.hippo.utils.UniqueIMEIID
import com.hippocall.WebRTCCallConstants.Companion.CALL_TYPE
import com.google.gson.Gson
import com.hippocall.WebRTCCallConstants.Companion.CREDENTIAL
import com.hippocall.WebRTCCallConstants.Companion.DEVICE_PAYLOAD
import com.hippocall.WebRTCCallConstants.Companion.FULL_NAME
import com.hippocall.WebRTCCallConstants.Companion.IS_SILENT
import com.hippocall.WebRTCCallConstants.Companion.IS_TYPING
import com.hippocall.WebRTCCallConstants.Companion.MESSAGE_TYPE
import com.hippocall.WebRTCCallConstants.Companion.MESSAGE_UNIQUE_ID
import com.hippocall.WebRTCCallConstants.Companion.STUN
import com.hippocall.WebRTCCallConstants.Companion.TURN
import com.hippocall.WebRTCCallConstants.Companion.TURN_API_KEY
import com.hippocall.WebRTCCallConstants.Companion.TURN_CREDENTIALS
import com.hippocall.WebRTCCallConstants.Companion.USER_ID
import com.hippocall.WebRTCCallConstants.Companion.USER_NAME
import com.hippocall.WebRTCCallConstants.Companion.VIDEO_CALL
import com.hippocall.WebRTCCallConstants.Companion.VIDEO_CALL_HUNGUP_FROM_NOTIFICATION
import com.hippocall.WebRTCCallConstants.Companion.VIDEO_CALL_TYPE
import com.hippocall.model.FayeVideoCallResponse
import faye.FayeClient
import faye.FayeClientListener
import org.json.JSONArray
import org.json.JSONException
import org.json.JSONObject
import org.webrtc.PeerConnection
import java.util.ArrayList

/**
 * Created by rajatdhamija
 * 20/09/18.
 */

class WebRTCSignallingClient(private val videoCallService: VideoCallService, private val channelId: Long?, private val activitylaunchState: String?) {
    private final var TAG = WebRTCSignallingClient::class.simpleName
    private var mClient: FayeClient? = null
    private var signal: Signal? = null
    private var initalCalls = 1
    private var maxCalls = 15
    private var isErrorEncountered = false
    fun setUpFayeConnection() {

        LocalBroadcastManager.getInstance(videoCallService).registerReceiver(mHungUp,
                IntentFilter(VIDEO_CALL_HUNGUP_FROM_NOTIFICATION))


        HippoConfig.getClient(object : fayeClient {
            override fun Listener(client: FayeClient) {
                mClient = client
                mClient!!.connectServer()
                mClient!!.listener = object : FayeClientListener {
                    override fun onConnectedServer(fc: FayeClient?) {
                        mClient = fc
                        fc!!.subscribeChannel("/$channelId")
                        android.os.Handler(Looper.getMainLooper()).postDelayed({
                            if (activitylaunchState?.equals(WebRTCCallConstants.AcitivityLaunchState.SELF.toString())!!) {
                                initiateVideoCall(false)
                                initOtherCalls()
                            } else if(activitylaunchState?.equals(WebRTCCallConstants.AcitivityLaunchState.AUDIO.toString())!!) {
                                initiateVideoCall(false)
                                initOtherCalls()
                            } else if (activitylaunchState.equals(WebRTCCallConstants.AcitivityLaunchState.OTHER.toString())) {
                                replyWithReadyToConnect()
                            } else {

                            }
                        }, 1000)
                    }

                    override fun onDisconnectedServer(fc: FayeClient?) {

                    }

                    override fun onReceivedMessage(fc: FayeClient?, msg: String?, channel: String?) {
                        try {
                            val mngr = videoCallService.getSystemService(Context.ACTIVITY_SERVICE) as ActivityManager
                            val taskList = mngr.getRunningTasks(10)
                            val json = JSONObject(msg)
                            val myUserId = json.getLong(USER_ID)
                            if (taskList[0].topActivity.className == "com.hippocall.FuguCallActivity" &&
                                    channel == "/$channelId" &&
                                    json.has(MESSAGE_TYPE) && json.getInt(MESSAGE_TYPE) == 18
                                    && myUserId.compareTo(signal?.signalUniqueUserId!!) != 0
                                    && json.getString(MESSAGE_UNIQUE_ID) == signal?.signalUniqueId!!) {
                                HippoLog.e("VideoCallMessage", msg)
                                when (json.getString(VIDEO_CALL_TYPE)) {
                                    WebRTCCallConstants.VideoCallType.READY_TO_CONNECT.toString() -> {
                                        if (!videoCallService.isCallConnected!! && activitylaunchState?.equals(
                                                WebRTCCallConstants.AcitivityLaunchState.SELF.toString())!!
                                                && !videoCallService.isCallInitiated!!) {
                                            videoCallService.isReadyForConnection = true
                                            videoCallService.isCallInitiated = true
                                            videoCallService.onReadyToConnectRecieved(json)
                                        } else if (!videoCallService.isCallConnected!! && activitylaunchState?.equals(
                                                WebRTCCallConstants.AcitivityLaunchState.AUDIO.toString())!!
                                                && !videoCallService.isCallInitiated!!) {
                                            videoCallService.isReadyForConnection = true
                                            videoCallService.isCallInitiated = true
                                            videoCallService.onReadyToConnectRecieved(json)
                                        } else {
                                            sendOfferToRemoteUser(videoCallService.webRTCCallClient?.videoOffer!!)
                                        }
                                    }
                                    WebRTCCallConstants.VideoCallType.NEW_ICE_CANDIDATE.toString() -> {
                                        videoCallService.onIceCandidateRecieved(json)
                                    }
                                    WebRTCCallConstants.VideoCallType.VIDEO_OFFER.toString() -> {
                                        if (!videoCallService.isCallConnected!!) {
                                            if (videoCallService.peerConnection == null) {
                                                videoCallService.onVideoOfferRecieved(json)
                                            }
                                        } else if (videoCallService.isCallConnected!! && json.has("is_screen_share")) {
                                            if (videoCallService.peerConnection != null) {
                                                videoCallService.onVideoOfferScreenSharingRecieved(json)
                                            }
                                        }
                                    }
                                    WebRTCCallConstants.VideoCallType.VIDEO_ANSWER.toString() -> {
                                        if (!videoCallService.isCallConnected!!) {
                                            videoCallService.isCallConnected = true
                                            videoCallService.webRTCCallClient?.saveAnswer(json)
                                            videoCallService.onVideoAnswerRecieved(json)
                                        }
                                    }
                                    WebRTCCallConstants.VideoCallType.USER_BUSY.toString() -> {
                                        if (!videoCallService.isCallConnected!!) {
                                            videoCallService.onUserBusyRecieved(json)
                                        }
                                    }
                                    WebRTCCallConstants.VideoCallType.CALL_HUNG_UP.toString() -> {
                                        videoCallService.onCallHungUp(json)
                                    }
                                    WebRTCCallConstants.VideoCallType.CALL_REJECTED.toString() -> {
                                        if (!videoCallService.isCallConnected!!) {
                                            videoCallService.onCallRejected(json)
                                        }
                                    }
                                }
                            } else if (channel == "/$channelId" &&
                                     json.has(MESSAGE_TYPE) && json.getInt(MESSAGE_TYPE) == 18
                                    && myUserId.compareTo(signal?.signalUniqueUserId!!) == 0
                                    && json.getString(MESSAGE_UNIQUE_ID) == signal?.signalUniqueId) {
                                if (json.getString(VIDEO_CALL_TYPE) == WebRTCCallConstants.VideoCallType.CALL_REJECTED.toString()) {
                                    videoCallService.onCallRejected(json)
                                } else if (json.getString(VIDEO_CALL_TYPE) == WebRTCCallConstants.VideoCallType.USER_BUSY.toString()) {
                                    if (!videoCallService.isCallConnected!!) {
                                        videoCallService.onUserBusyRecieved(json)
                                    }
                                }
                            }
                        } catch (e: Exception) {
                            e.printStackTrace()
                        }
                    }

                    override fun onPongReceived() {

                    }

                    override fun onWebSocketError() {

                    }

                    override fun onErrorReceived(fc: FayeClient?, msg: String?, channel: String?) {
                        HippoLog.e("Faye Message Error", msg)
                        try {
                            val fayeVideoCallResponse = Gson().fromJson(msg, FayeVideoCallResponse::class.java)
                            if (fayeVideoCallResponse.statusCode == INVALID_VIDEO_CALL_CREDENTIALS) {
                                isErrorEncountered = true
                                val iceServers = ArrayList<PeerConnection.IceServer>()
                                signal?.turnApiKey = fayeVideoCallResponse.message.turnApiKey
                                signal?.turnUserName = fayeVideoCallResponse.message.username
                                signal?.turnCredential = fayeVideoCallResponse.message.credentials
                                signal?.stunServers = fayeVideoCallResponse.message.iceServers.stun as ArrayList<String>
                                signal?.turnServers = fayeVideoCallResponse.message.iceServers.turn as ArrayList<String>

                                object : Thread() {
                                    override fun run() {
                                        super.run()
                                        val appContants = AppContants()
                                        val turnCreds = appContants.turnCredentials
                                        turnCreds.credentials = signal?.turnCredential
                                        turnCreds.username = signal?.turnUserName
                                        turnCreds.turnApiKey = signal?.turnApiKey
                                        turnCreds.iceServers.stun = signal?.stunServers
                                        turnCreds.iceServers.turn = signal?.turnServers
                                    }
                                }.start()
                                for (i in signal?.stunServers?.indices!!) {
                                    val stunIceServer = PeerConnection.IceServer.builder(signal?.stunServers?.get(i))
                                            .createIceServer()
                                    iceServers.add(stunIceServer)
                                }
                                for (i in signal?.turnServers?.indices!!) {
                                    val turnIceServer = PeerConnection.IceServer.builder(signal?.turnServers?.get(i))
                                            .setUsername(fayeVideoCallResponse.message.username)
                                            .setPassword(fayeVideoCallResponse.message.credentials)
                                            .createIceServer()
                                    iceServers.add(turnIceServer)
                                }
                                if (activitylaunchState?.equals(WebRTCCallConstants.AcitivityLaunchState.SELF.toString())!!) {
                                    initiateVideoCall(false)
                                    initalCalls = 1
                                    initOtherCalls()
                                } else if (activitylaunchState?.equals(WebRTCCallConstants.AcitivityLaunchState.AUDIO.toString())!!) {
                                    initiateVideoCall(false)
                                    initalCalls = 1
                                    initOtherCalls()
                                } else if (activitylaunchState.equals(WebRTCCallConstants.AcitivityLaunchState.OTHER.toString())) {
                                    replyWithReadyToConnect()
                                } else {

                                }
                            }
                        } catch (e: Exception) {

                        }
                    }
                }
            }
        })

    }

    private fun initOtherCalls() {
        Handler().postDelayed({
            if (initalCalls <= maxCalls && !videoCallService.isReadyForConnection!! && !isErrorEncountered) {
                initiateVideoCall(true)
                initalCalls += 1
                initOtherCalls()
            }
        }, 2000)
    }

    private fun replyWithReadyToConnect() {
        val readyToConnectJson = JSONObject()
        readyToConnectJson.put(VIDEO_CALL_TYPE, WebRTCCallConstants.VideoCallType.READY_TO_CONNECT.toString())
        readyToConnectJson.put(IS_SILENT, true)
        readyToConnectJson.put(USER_ID, signal?.signalUniqueUserId)
        readyToConnectJson.put(FULL_NAME, signal?.fullNameOfCalledPerson)
        readyToConnectJson.put(MESSAGE_TYPE, VIDEO_CALL)
        readyToConnectJson.put(IS_TYPING, TYPING_SHOW_MESSAGE)
        readyToConnectJson.put(MESSAGE_UNIQUE_ID, signal?.signalUniqueId)
        addTurnCredentialsAndDeviceDetails(readyToConnectJson)
    }

    fun setSignalRequirementModel(signal: Signal?) {
        this.signal = signal
    }

    fun initiateVideoCall(isSignalSilent: Boolean) {
        try {
            val startCallJson = JSONObject()
            startCallJson.put(VIDEO_CALL_TYPE, WebRTCCallConstants.VideoCallType.START_CALL.toString())
            startCallJson.put(IS_SILENT, isSignalSilent)
            startCallJson.put(USER_ID, signal?.signalUniqueUserId)
            startCallJson.put(FULL_NAME, signal?.fullNameOfCalledPerson)
            startCallJson.put(MESSAGE_TYPE, VIDEO_CALL)
            startCallJson.put(IS_TYPING, TYPING_SHOW_MESSAGE)
            startCallJson.put(CALL_TYPE, signal?.callType)
            startCallJson.put(MESSAGE_UNIQUE_ID, signal?.signalUniqueId)

            addTurnCredentialsAndDeviceDetails(startCallJson)
        } catch (e: Exception) {
            e.printStackTrace()
        }

    }

    fun sendOfferToRemoteUser(jsonObject: JSONObject): JSONObject? {
        val offerJson = addCommonuserDetails(jsonObject)
        addTurnCredentialsAndDeviceDetails(offerJson)
        return offerJson
    }

    fun sendAnswerToRemoteUser(jsonObject: JSONObject): JSONObject? {
        val offerJson = addCommonuserDetails(jsonObject)
        addTurnCredentialsAndDeviceDetails(offerJson)
        return offerJson
    }

    fun sendIceCandidates(jsonObject: JSONObject) {
        val iceCandidateJson = addCommonuserDetails(jsonObject)
        addTurnCredentialsAndDeviceDetails(iceCandidateJson)
    }

    fun hangUpCall() {
        val jsonObject = JSONObject()
        jsonObject.put(VIDEO_CALL_TYPE, WebRTCCallConstants.VideoCallType.CALL_HUNG_UP.toString())
        val hangupJson = addCommonuserDetails(jsonObject)
        addTurnCredentialsAndDeviceDetails(hangupJson)
        mClient?.unsubscribeAll()
    }

    fun rejectCall() {
        val jsonObject = JSONObject()
        jsonObject.put(VIDEO_CALL_TYPE, WebRTCCallConstants.VideoCallType.CALL_REJECTED.toString())
        val rejectedJson = addCommonuserDetails(jsonObject)
        addTurnCredentialsAndDeviceDetails(rejectedJson)
        mClient?.unsubscribeAll()
    }

    fun addCommonuserDetails(jsonObject: JSONObject): JSONObject {
        jsonObject.put(IS_SILENT, true)
        jsonObject.put(USER_ID, signal?.signalUniqueUserId)
        jsonObject.put(MESSAGE_TYPE, VIDEO_CALL)
        jsonObject.put(IS_TYPING, 0)
        jsonObject.put(IS_SILENT, true)
        jsonObject.put(MESSAGE_UNIQUE_ID, signal?.signalUniqueId)
        return jsonObject
    }

    fun addTurnCredentialsAndDeviceDetails(jsonObject: JSONObject) {
        val stunServers = JSONArray()
        val turnServers = JSONArray()
        val videoCallCredentials = JSONObject()

        videoCallCredentials.put(TURN_API_KEY, signal?.turnApiKey)
        videoCallCredentials.put(USER_NAME, signal?.turnUserName)
        videoCallCredentials.put(CREDENTIAL, signal?.turnCredential)
        for (i in signal?.stunServers!!.indices) {
            stunServers.put(signal?.stunServers!!.get(i))
        }
        for (i in signal?.turnServers!!.indices) {
            turnServers.put(signal?.turnServers!!.get(i))
        }

        videoCallCredentials.put(STUN, stunServers)
        videoCallCredentials.put(TURN, turnServers)

        jsonObject.put(TURN_CREDENTIALS, videoCallCredentials)
        jsonObject.put(DEVICE_PAYLOAD, signal?.deviceDetails)

        publishSignalToFaye(jsonObject)
    }

    fun publishSignalToFaye(signalJson: JSONObject) {
        if (mClient != null) {
            mClient?.publish("/$channelId", signalJson)
            //mClient?.publish(channelId, "/$channelId", signalJson)
            HippoLog.e(TAG, "publishSignalToFaye: "+signalJson.toString())
        }
    }

    fun onBroadcastRecieved(intent: Intent) {
        if (intent.hasExtra(FuguAppConstant.CHANNEL_ID) && intent.getStringExtra(FuguAppConstant.MESSAGE_UNIQUE_ID) != signal?.signalUniqueId) {
            if (intent.getStringExtra(FuguAppConstant.VIDEO_CALL_TYPE) == WebRTCCallConstants.VideoCallType.START_CALL.toString()) {
                try {
                    val json = JSONObject()
                    json.put(FuguAppConstant.VIDEO_CALL_TYPE, WebRTCCallConstants.VideoCallType.USER_BUSY.toString())
                    json.put(FuguAppConstant.IS_SILENT, true)
                    json.put(FuguAppConstant.USER_ID, intent.getLongExtra(FuguAppConstant.USER_ID, -1L))
                    json.put(FuguAppConstant.FULL_NAME, signal?.fullNameOfCalledPerson)
                    json.put(FuguAppConstant.MESSAGE_TYPE, FuguAppConstant.VIDEO_CALL)
                    json.put(FuguAppConstant.IS_TYPING, TYPING_SHOW_MESSAGE)
                    json.put(FuguAppConstant.MESSAGE_UNIQUE_ID, intent.getStringExtra(FuguAppConstant.MESSAGE_UNIQUE_ID))
                    HippoLog.e("MUID", intent.getStringExtra(FuguAppConstant.MESSAGE_UNIQUE_ID))
                    val devicePayload = JSONObject()
                    devicePayload.put(FuguAppConstant.DEVICE_ID, UniqueIMEIID.getUniqueIMEIId(videoCallService))
                    devicePayload.put(FuguAppConstant.DEVICE_TYPE, FuguAppConstant.ANDROID_USER)
                    devicePayload.put(FuguAppConstant.APP_VERSION, BuildConfig.VERSION_NAME)
                    devicePayload.put(FuguAppConstant.DEVICE_DETAILS, CommonData.deviceDetails(videoCallService))
                    json.put("device_payload", devicePayload)
                    mClient?.publish("/" + intent.getLongExtra(FuguAppConstant.CHANNEL_ID, -1L), json)
//                    mClient?.publish(intent.getLongExtra(FuguAppConstant.CHANNEL_ID, -1L), "/" + intent.getLongExtra(FuguAppConstant.CHANNEL_ID, -1L), json)
                } catch (e: JSONException) {
                    e.printStackTrace()
                }

            }
        } else if (intent.getStringExtra(FuguAppConstant.VIDEO_CALL_TYPE) == WebRTCCallConstants.VideoCallType.CALL_HUNG_UP.toString()) {
            videoCallService.onCallHungUp(null)
            if (videoCallService.callDisconnectTime != null) {
                videoCallService.callDisconnectTime?.cancel()
            }
            mClient?.unsubscribeAll()
        }
    }

    private var mHungUp: BroadcastReceiver = object : BroadcastReceiver() {
        override fun onReceive(context: Context?, intent: Intent?) {
            hangUpCall()
        }
    }
}
