package com.hippocall

/**
 * Created by rajatdhamija on 21/09/18.
 */
interface WebRTCCallConstants {
    companion object {
        val USER_ID = "user_id"
        val FULL_NAME = "full_name"
        val MESSAGE_TYPE = "message_type"
        val VIDEO_CALL = 18
        val IS_TYPING = "is_typing"
        val MESSAGE_UNIQUE_ID = "muid"
        val DEVICE_ID = "device_id"
        val DEVICE_TYPE = "device_type"
        val DEVICE_DETAILS = "device_details"
        val VIDEO_CALL_TYPE = "video_call_type"
        val CALL_TYPE = "call_type"
        val ANDROID_USER = 1
        val TURN_CREDENTIALS = "turn_creds"
        val SDP_M_LINE_INDEX = "sdpMLineIndex"
        val SDP_MID = "sdpMid"
        val CANDIDATE = "candidate"
        val RTC_CANDIDATE = "rtc_candidate"
        val IS_SILENT = "is_silent"
        val SDP = "sdp"
        val LOCAL_SET_REMOTE_DESC = "localSetRemoteDesc"
        val REMOTE_SET_REMOTE_DESC = "remoteSetRemoteDesc"
        val REMOTE_SET_LOCAL_DESC = "remoteSetLocalDesc"
        val OFFER_TO_RECEIVE_AUDIO = "offerToReceiveAudio"
        val OFFER_TO_RECEIVE_VIDEO = "offerToReceiveVideo"
        val LOCAL_CREATE_OFFER = "localCreateOffer"
        val REMOTE_CREATE_OFFER = "remoteCreateOffer"
        val USER_NAME = "username"
        val CREDENTIAL = "credential"
        val TURN_API_KEY = "turnApiKey"
        val STUN_SERVERS = "stunServers"
        val TURN_SERVERS = "turnServers"
        val CALL_STATUS = "call_status"
        val CALL_TIMER = "call_timer"
        val ONGOING_VIDEO_CALL = "Ongoing Video Call..."
        val ONGOING_AUDIO_CALL = "Ongoing Voice Call..."
        val DEVICE_PAYLOAD = "device_payload"
        val STUN = "stun"
        val TURN = "turn"
        val RINGING = "Ringing..."
        val USER_BUSY = "busy on another call..."
        val REJECTED = "call declined"
        val VIDEO_CALL_HUNGUP_FROM_NOTIFICATION = "VIDEO_CALL_HUNGUP_FROM_NOTIFICATION"
        val CONNECTING = "Connection..."

    }

    enum class VideoCallType {
        START_CALL {
            override fun toString(): String {
                return "START_CALL"
            }
        },
        READY_TO_CONNECT {
            override fun toString(): String {
                return "READY_TO_CONNECT"
            }
        },
        CALL_HUNG_UP {
            override fun toString(): String {
                return "CALL_HUNG_UP"
            }
        },
        CALL_REJECTED {
            override fun toString(): String {
                return "CALL_REJECTED"
            }
        },
        VIDEO_OFFER {
            override fun toString(): String {
                return "VIDEO_OFFER"
            }
        },
        NEW_ICE_CANDIDATE {
            override fun toString(): String {
                return "NEW_ICE_CANDIDATE"
            }
        },
        USER_BUSY {
            override fun toString(): String {
                return "USER_BUSY"
            }
        },
        VIDEO_ANSWER {
            override fun toString(): String {
                return "VIDEO_ANSWER"
            }
        }
    }

    enum class AcitivityLaunchState {
        SELF {
            override fun toString(): String {
                return "SELF"
            }
        },
        OTHER {
            override fun toString(): String {
                return "OTHER"
            }
        },
        KILLED {
            override fun toString(): String {
                return "KILLED"
            }
        },
        AUDIO {
            override fun toString(): String {
                return "SELF_AUDIO"
            }
        }
    }
    enum class CallStatus {
        IN_CALL {
            override fun toString(): String {
                return "IN_CALL"
            }
        },
        INCOMING_CALL {
            override fun toString(): String {
                return "INCOMING_CALL"
            }
        },
        OUTGOING_CALL {
            override fun toString(): String {
                return "OUTGOING_CALL "
            }
        },
    }
    enum class CallType {
        AUDIO {
            override fun toString(): String {
                return "AUDIO"
            }
        },
        VIDEO {
            override fun toString(): String {
                return "VIDEO"
            }
        },
        VOICE {
            override fun toString(): String {
                return "VOICE"
            }
        }
    }
    enum class CallStatusUI {
        REJECTED {
            override fun toString(): String {
                return "REJECTED"
            }
        },
        ONGOING {
            override fun toString(): String {
                return "ONGOING"
            }
        },
        BUSY {
            override fun toString(): String {
                return "BUSY"
            }
        }
    }
}