package com.hippocall

import android.app.*
import android.content.Context
import android.content.Intent
import android.graphics.BitmapFactory
import android.graphics.Color
import android.os.Binder
import android.os.Build
import android.os.CountDownTimer
import android.os.IBinder
import android.support.annotation.RequiresApi
import android.support.v4.app.NotificationCompat
import android.support.v4.content.LocalBroadcastManager
import com.hippo.R
import com.hippo.constant.FuguAppConstant.CHANNEL_NAME
import com.hippo.constant.FuguAppConstant.VIDEO_CALL_HUNGUP
import com.hippocall.WebRTCCallConstants.Companion.CALL_STATUS
import com.hippocall.WebRTCCallConstants.Companion.ONGOING_AUDIO_CALL
import com.hippocall.WebRTCCallConstants.Companion.ONGOING_VIDEO_CALL
import org.json.JSONObject
import org.webrtc.*

/**
 * Created by rajatdhamija
 * 06/09/18.
 */

class VideoCallService : Service(), WebRTCFayeCallbacks, WebRTCCallCallbacks {
    private var hangUpLabel: String = "hangup"
    private var KEY_HANGUP: String = "key_hangup"
    private var signal: Signal? = null
    private var connection: Connection? = null
    private var videoCallModel: VideoCallModel? = null
    var mBinder: IBinder = LocalBinder()
    private var status: String = ""
    var peerConnection: PeerConnection? = null
    private var remoteVideoStream: MediaStream? = null
    private var localVieoStream: MediaStream? = null
    var webRTCSignallingClient: WebRTCSignallingClient? = null
    var webRTCCallClient: WebRTCCallClient? = null
    var isCallConnected: Boolean? = false
    var isReadyForConnection: Boolean? = false
    var isCallInitiated: Boolean? = false
    var fuguCallActivity: FuguCallActivity? = null
    private var rootEglBase: EglBase? = null
    private var peerConnectionFactory: PeerConnectionFactory? = null
    private var intent: Intent? = null
    var callDisconnectTime: CountDownTimer? = null
    var startTime: Long? = null
    var callTimer: CountDownTimer? = null

    override fun onBind(intent: Intent): IBinder? {
        return mBinder
    }

    inner class LocalBinder : Binder() {
        val serverInstance: VideoCallService
            get() = this@VideoCallService
    }

    override fun onCreate() {
        super.onCreate()
    }

    override fun onDestroy() {
        super.onDestroy()
        val hungupIntent = Intent(VIDEO_CALL_HUNGUP)
        LocalBroadcastManager.getInstance(this).sendBroadcast(hungupIntent)
    }

    @RequiresApi(Build.VERSION_CODES.O)
    private fun createNotificationChannel(channelId: String, channelName: String): String{
        val chan = NotificationChannel(channelId,
                channelName, NotificationManager.IMPORTANCE_NONE)
        chan.lightColor = Color.BLUE
        chan.lockscreenVisibility = Notification.VISIBILITY_PRIVATE
        val service = getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
        service.createNotificationChannel(chan)
        return channelId
    }

    override fun onStartCommand(intent: Intent, flags: Int, startId: Int): Int {
        this.intent = intent
        if (intent.getStringExtra(CALL_STATUS).equals(ONGOING_VIDEO_CALL) || intent.getStringExtra(CALL_STATUS).equals(ONGOING_AUDIO_CALL)) {
            try {
                if (startTime == null) {
                    startTime = System.currentTimeMillis()
                }
                callTimer = object : CountDownTimer(30000000, 1000) {

                    override fun onTick(millisUntilFinished: Long) {
                        val currenTime = System.currentTimeMillis()
                        val diff = (currenTime - startTime!!) / 1000
                        val seconds = diff % 60
                        val minutes = diff / 60
                        val hours = minutes / 60
                        var secondstext = ""
                        if (seconds < 10) {
                            secondstext = "0$seconds"
                        } else {
                            secondstext = "$seconds"
                        }
                        if (fuguCallActivity != null) {
                            if (hours > 0) {
                                fuguCallActivity!!.updateCallTimer("$hours:$minutes:$secondstext")
                            } else {
                                fuguCallActivity!!.updateCallTimer("$minutes:$secondstext")
                            }
                        }
                    }

                    override fun onFinish() {
                        hungUpCall()
                        fuguCallActivity?.onCallHungUp(null)
                    }
                }.start()
            } catch (e: Exception) {
            }
        }
        val notificationIntent = Intent(this, FuguCallActivity::class.java)
        notificationIntent.action = Intent.ACTION_MAIN
        notificationIntent.putExtra(CHANNEL_NAME, videoCallModel?.channelName)
        notificationIntent.addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP or Intent.FLAG_ACTIVITY_CLEAR_TOP)
        notificationIntent.addFlags(Intent.FLAG_ACTIVITY_EXCLUDE_FROM_RECENTS)
        if (status == WebRTCCallConstants.AcitivityLaunchState.KILLED.toString()) {
            notificationIntent.putExtra("activitylaunchState", status)
        }

        val hungupIntent = Intent(this, FuguCallActivity::class.java)
        hungupIntent.action = Intent.ACTION_DELETE
        hungupIntent.putExtra(CHANNEL_NAME, videoCallModel?.channelName)
        hungupIntent.addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP or Intent.FLAG_ACTIVITY_CLEAR_TOP)

        val pendingIntent = PendingIntent.getActivity(this, 0,
                notificationIntent, PendingIntent.FLAG_UPDATE_CURRENT)
        val hungupPendingIntent = PendingIntent.getActivity(this, 0,
                hungupIntent, PendingIntent.FLAG_UPDATE_CURRENT)

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            val channelId = createNotificationChannel("VideoCall", intent.getStringExtra(CHANNEL_NAME))
            val notification = NotificationCompat.Builder(this, channelId);
            notification.setContentTitle(intent.getStringExtra(CHANNEL_NAME))
            if (intent.getStringExtra(CALL_STATUS).equals(ONGOING_VIDEO_CALL) || intent.getStringExtra(CALL_STATUS).equals(ONGOING_AUDIO_CALL)) {
                notification.setUsesChronometer(true)
                notification.setShowWhen(false)
            }

            notification.setTicker(intent.getStringExtra(CALL_STATUS))
            notification.setContentText(intent.getStringExtra(CALL_STATUS))
            // TODO: 31/12/18 Exposs drawable for end user
            notification.setSmallIcon(R.drawable.hippo_default_notif_icon);
            notification.setLargeIcon(BitmapFactory.decodeResource(this.resources, R.drawable.hippo_default_notif_icon))

//            notification.setSmallIcon(HippoConfig.getInstance().getVideoCallNotificationDrawable())
//            notification.setLargeIcon(BitmapFactory.decodeResource(this.resources, HippoConfig.getInstance().getVideoCallNotificationDrawable()))

            notification.setContentIntent(pendingIntent)
            notification.setOngoing(true)
            notification.setPriority(getPriority())
            val hangupAction = NotificationCompat.Action.Builder(
                    android.R.drawable.sym_action_chat, "HANG UP", hungupPendingIntent)
                    .build()
            notification.addAction(hangupAction)

            startForeground(1122, notification.build())
            val notificationManager = getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                notificationManager.createNotificationChannel(NotificationChannel("VideoCall",
                        "VideoCall", NotificationManager.IMPORTANCE_HIGH))
            }
            notificationManager.notify(1122, notification.build())
        } else {
            val notification = NotificationCompat.Builder(this);
            notification.setContentTitle(intent.getStringExtra(CHANNEL_NAME))
            notification.setTicker(intent.getStringExtra(CALL_STATUS))
            notification.setContentText(intent.getStringExtra(CALL_STATUS))
            if (intent.getStringExtra(CALL_STATUS).equals(ONGOING_VIDEO_CALL) || intent.getStringExtra(CALL_STATUS).equals(ONGOING_AUDIO_CALL)) {
                notification.setUsesChronometer(true)
                notification.setShowWhen(false)
            }
            // TODO: 31/12/18 Exposs drawable for end user
            notification.setSmallIcon(R.drawable.hippo_default_notif_icon);
            notification.setLargeIcon(BitmapFactory.decodeResource(this.resources, R.drawable.hippo_default_notif_icon))

//            notification.setSmallIcon(HippoConfig.getInstance().getVideoCallNotificationDrawable())
//            notification.setLargeIcon(BitmapFactory.decodeResource(this.resources, HippoConfig.getInstance().getVideoCallNotificationDrawable()))
            notification.setContentIntent(pendingIntent)
            notification.setOngoing(true)
            notification.setPriority(getPriority())
            val hangupAction = NotificationCompat.Action.Builder(
                    android.R.drawable.sym_action_chat, "HANG UP", hungupPendingIntent)
                    .build()
            notification.addAction(hangupAction)
            startForeground(1122, notification.build())
            val notificationManager = getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
            notificationManager.notify(1122, notification.build())
        }
        if (callDisconnectTime == null) {
            callDisconnectTime = object : CountDownTimer(30000, 1000) {

                override fun onTick(millisUntilFinished: Long) {}

                override fun onFinish() {
                    hungUpCall()
                    fuguCallActivity?.onCallHungUp(null)
                }
            }.start()
        } else {
            callDisconnectTime?.cancel();
        }
        return Service.START_STICKY
    }

    private fun getPriority(): Int {
        val priority: Int
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            priority = NotificationManager.IMPORTANCE_HIGH
        } else {
            priority = Notification.PRIORITY_MAX
        }
        return priority
    }

    fun createWebRTCSignallingConnection(videoCallModel: VideoCallModel?, signal: Signal?) {
        this.videoCallModel = videoCallModel
        this.signal = signal
        webRTCSignallingClient = WebRTCSignallingClient(this, videoCallModel?.channelId, videoCallModel?.activityLaunchState)
        webRTCSignallingClient?.setSignalRequirementModel(signal)
        webRTCSignallingClient?.setUpFayeConnection()
    }

    fun setConnectionModel(connection: Connection?) {
        this.connection = connection
    }

    fun setSignalModel(signal: Signal?) {
        this.signal = signal
    }

    fun setActivityContext(fuguCallActivity: FuguCallActivity?) {
        this.fuguCallActivity = fuguCallActivity
    }

    fun createWebRTCCallConnection() {
        webRTCCallClient = WebRTCCallClient(this)
        webRTCSignallingClient = WebRTCSignallingClient(this, videoCallModel?.channelId, videoCallModel?.activityLaunchState)
    }

    fun hungUpCall() {
        if (callDisconnectTime != null) {
            callDisconnectTime?.cancel()
        }
        webRTCSignallingClient?.hangUpCall()
    }

    fun rejectCall() {
        webRTCSignallingClient?.rejectCall()
    }

    fun saveOfferAndAnswer(videoOfferjson: JSONObject?) {

        webRTCCallClient?.saveOfferAndAnswer(videoOfferjson, connection)
    }

    fun saveIceCandidate(jsonObject: JSONObject?) {
        webRTCCallClient?.saveIceCandidate(jsonObject)
    }

    fun createPeerConnection(connection: Connection?) {
        peerConnection = webRTCCallClient?.createPeerConnection(connection)
    }

    fun getRemoteVideoStream(): MediaStream? {
        return remoteVideoStream
    }

    fun setLocalVideoStream(localVideoStream: MediaStream?) {
        this.localVieoStream = localVideoStream
    }

    fun getLocalVideoStream(): MediaStream? {
        return localVieoStream
    }

    fun getPeerconnection(): PeerConnection? {
        return peerConnection
    }

    fun createOffer(connection: Connection?) {
        webRTCCallClient?.createOffer(connection)
    }

    fun setVideoModel(videoCallModel: VideoCallModel?) {
        this.videoCallModel = videoCallModel
    }

    fun closePeerConnection() {
        if (peerConnection != null) {
            peerConnection?.close()
            peerConnection = null
        }
    }

    override fun onIceCandidateRecieved(jsonObject: JSONObject?) {
        fuguCallActivity?.onIceCandidateRecieved(jsonObject)
    }

    override fun onVideoOfferRecieved(jsonObject: JSONObject?) {
        fuguCallActivity?.onVideoOfferRecieved(jsonObject)
    }

    override fun onVideoAnswerRecieved(jsonObject: JSONObject?) {
        if (callDisconnectTime != null) {
            callDisconnectTime?.cancel()
        }
        fuguCallActivity?.onVideoAnswerRecieved(jsonObject)
    }

    override fun onReadyToConnectRecieved(jsonObject: JSONObject?) {
        fuguCallActivity?.onReadyToConnectRecieved(jsonObject)
    }

    override fun onCallHungUp(jsonObject: JSONObject?) {
        fuguCallActivity?.onCallHungUp(jsonObject)
    }

    override fun onCallRejected(jsonObject: JSONObject?) {
        fuguCallActivity?.onCallRejected(jsonObject)
        if (callDisconnectTime != null) {
            callDisconnectTime?.cancel()
        }
    }

    override fun onUserBusyRecieved(jsonObject: JSONObject?) {
        fuguCallActivity?.onUserBusyRecieved(jsonObject)
    }

    override fun onErrorRecieved(error: String?) {
        fuguCallActivity?.onErrorRecieved(error)
    }

    override fun onAddStream(mediaStream: MediaStream?) {
        fuguCallActivity?.onAddStream(mediaStream)
    }

    override fun onIceCandidate(iceCandidate: IceCandidate?) {
        onIceCandidate(iceCandidate)
    }

    override fun onVideoOfferScreenSharingRecieved(jsonObject: JSONObject?) {
        fuguCallActivity?.onVideoOfferScreenSharingRecieved(jsonObject)
    }

    fun getConnectionModel(): Connection? {
        return connection
    }

    fun getSignal(): Signal? {
        return signal
    }

    fun getVideoModel(): VideoCallModel? {
        return videoCallModel
    }

    fun createPeerConnectionFactory(rootEglBase: EglBase?): PeerConnectionFactory? {
        if (peerConnectionFactory == null) {
            val initializationOptions = PeerConnectionFactory.InitializationOptions.builder(this)
                    .createInitializationOptions()
            PeerConnectionFactory.initialize(initializationOptions)
            val defaultVideoEncoderFactory = DefaultVideoEncoderFactory(
                    rootEglBase?.getEglBaseContext(), /* enableIntelVp8Encoder */true, /* enableH264HighProfile */true)
            val defaultVideoDecoderFactory = DefaultVideoDecoderFactory(rootEglBase?.getEglBaseContext())
            val options = PeerConnectionFactory.Options()
            peerConnectionFactory = PeerConnectionFactory.builder()
                    .setOptions(options)
                    .setVideoEncoderFactory(defaultVideoEncoderFactory)
                    .setVideoDecoderFactory(defaultVideoDecoderFactory)
                    .createPeerConnectionFactory()
            return peerConnectionFactory
        } else {
            return peerConnectionFactory
        }

    }

    fun setRemoteStream(mediaStream: MediaStream?) {
        this.remoteVideoStream = mediaStream
    }

    fun setEgl(eglBase: EglBase?) {
        this.rootEglBase = eglBase
    }

    fun getEgl(): EglBase? {
        return rootEglBase
    }

    fun onBroadCastrecieved(intent: Intent) {
        webRTCSignallingClient?.onBroadcastRecieved(intent)
    }
}
