package com.hippocall;

import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import com.hippo.CallData;
import com.hippo.HippoConfig;
import com.hippo.agent.model.FuguAgentGetMessageResponse;
import com.hippo.constant.FuguAppConstant;
import com.hippo.model.FuguGetMessageResponse;
import com.hippocall.model.Message;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import static android.content.Context.ACTIVITY_SERVICE;

/**
 * Created by gurmail on 04/01/19.
 *
 * @author gurmail
 */
public class HippoCallConfig implements CallData, FuguAppConstant {

    private static HippoCallConfig instance;
    private HippoCallConfig() {

    }

    public static HippoCallConfig getInstance() {
        if(instance == null) {
            synchronized (HippoCallConfig.class) {
                if(instance == null)
                    instance = new HippoCallConfig();
            }
        }
        return instance;
    }


    public void setCallBackListener() {
        HippoConfig.getInstance().setCallListener(this);
    }

    private void sendUserBusyBroadcast(Context context, long channelId, String messageUniqueId,
                                       String videoCallType, String userId) {
        Intent videoCallIntent = new Intent(VIDEO_CALL_INTENT);
        videoCallIntent.putExtra(CHANNEL_ID, channelId);
        videoCallIntent.putExtra(MESSAGE_UNIQUE_ID, messageUniqueId);
        videoCallIntent.putExtra(VIDEO_CALL_TYPE, videoCallType);
        videoCallIntent.putExtra(USER_ID, userId);
        LocalBroadcastManager.getInstance(context).sendBroadcast(videoCallIntent);
    }

    @Override
    public void onNotificationReceived(Context context, JSONObject data) {
        try {
            videoCallPush(context, data);
        } catch (Exception e) {
            if(HippoConfig.DEBUG)
                e.printStackTrace();
        }
    }

    private BroadcastReceiver fuguChatCustomActionReceiver;



    @Override
    public void onCallClick(Context context, int callType, Long channelId, Long userId, boolean isAgentFlow,
                            boolean isAllowCall, String fullname, String image) {
        Message turnCredentials = new AppContants().getTurnCredentials();
        Intent videoIntent = new Intent(context.getApplicationContext(), FuguCallActivity.class);
        String messageUniqueId = UUID.randomUUID().toString();

        String activityLaunchState = WebRTCCallConstants.AcitivityLaunchState.SELF.toString();
        if(callType == AUDIO_CALL_VIEW)
            activityLaunchState = WebRTCCallConstants.AcitivityLaunchState.AUDIO.toString();

        VideoCallModel videoCallModel = new VideoCallModel(channelId,
                image,
                fullname,
                userId, fullname, callType, turnCredentials.getTurnApiKey(),
                turnCredentials.getUsername(), turnCredentials.getCredentials(),
                (ArrayList<String>) (turnCredentials.getIceServers().getStun()),
                (ArrayList<String>) (turnCredentials.getIceServers().getTurn()),
                activityLaunchState, messageUniqueId);
        videoIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        videoIntent.addFlags(Intent.FLAG_ACTIVITY_EXCLUDE_FROM_RECENTS);
        videoIntent.putExtra("videoCallModel", videoCallModel);
        context.startActivity(videoIntent);
    }

    private void videoCallPush(Context context, JSONObject jsonObject) throws Exception {
        ActivityManager mngr = (ActivityManager) context.getSystemService(ACTIVITY_SERVICE);
        List<ActivityManager.RunningTaskInfo> taskList = mngr.getRunningTasks(10);

        Long userId = CommonData.getUserId();
        String fullname = jsonObject.optString("full_name");
        Long channelId = jsonObject.optLong("channel_id");
        String messageUniqueId = jsonObject.optString("muid");
        String videoCallType = jsonObject.optString("video_call_type", "");

        String callType = jsonObject.optString("call_type", "");
        int callValue = 1;
        String activityLaunchState = WebRTCCallConstants.AcitivityLaunchState.OTHER.toString();
        if(callType.equalsIgnoreCase("AUDIO")) {
            callValue = 2;
        }

        String userImage = !TextUtils.isEmpty(jsonObject.optString("user_image"))
                ? jsonObject.optString("user_image")
                : !TextUtils.isEmpty(jsonObject.optString("thumbnail_url"))
                ? jsonObject.optString("thumbnail_url")
                : jsonObject.optString("image_url", "");

        if (!taskList.get(0).topActivity.getClassName().equals("com.hippo.videoCall.FuguCallActivity")
                && jsonObject.getInt(NOTIFICATION_TYPE) == 14//VIDEO_CALL_NOTIFICATION
                && jsonObject.has(VIDEO_CALL_TYPE)
                && (jsonObject.getString(VIDEO_CALL_TYPE).equals("START_CALL"))
                && userId.compareTo(-1L) != 0
                && userId.compareTo(jsonObject.optLong(USER_ID)) != 0) {

            Message turnCredentials = new AppContants().getTurnCredentials();
            Intent videoIntent = new Intent(context.getApplicationContext(), FuguCallActivity.class);

            VideoCallModel videoCallModel = new VideoCallModel(channelId,
                    userImage, fullname,
                    userId, fullname, callValue, turnCredentials.getTurnApiKey(),
                    turnCredentials.getUsername(), turnCredentials.getCredentials(),
                    (ArrayList<String>) (turnCredentials.getIceServers().getStun()),
                    (ArrayList<String>) (turnCredentials.getIceServers().getTurn()),
                    activityLaunchState, messageUniqueId);
            videoIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            videoIntent.addFlags(Intent.FLAG_ACTIVITY_EXCLUDE_FROM_RECENTS);
            videoIntent.putExtra("videoCallModel", videoCallModel);
            context.startActivity(videoIntent);
        } else {
            sendUserBusyBroadcast(context, channelId, messageUniqueId, videoCallType, String.valueOf(userId));
        }
    }
}
