package com.hippocall

import android.Manifest
import android.animation.ObjectAnimator
import android.content.*
import android.content.pm.PackageManager
import android.media.AudioManager
import android.media.MediaPlayer
import android.os.Bundle
import android.os.CountDownTimer
import android.os.Handler
import android.os.IBinder
import android.support.v4.app.ActivityCompat
import android.support.v4.content.ContextCompat
import android.support.v4.content.LocalBroadcastManager
import android.support.v7.app.AppCompatActivity
import android.support.v7.widget.AppCompatImageView
import android.support.v7.widget.AppCompatTextView
import android.text.TextUtils
import android.view.View
import android.view.WindowManager
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.RelativeLayout
import android.widget.Toast
import com.bumptech.glide.Glide
import com.bumptech.glide.load.engine.DiskCacheStrategy
import com.bumptech.glide.request.RequestOptions
import com.hippo.BuildConfig
import com.hippo.HippoConfig
import com.hippo.constant.FuguAppConstant
import com.hippo.constant.FuguAppConstant.*
import com.hippo.utils.UniqueIMEIID
import com.hippocall.R
import com.hippo.constant.FuguAppConstant.CHANNEL_NAME
import com.hippo.model.FuguCreateConversationParams
import com.hippo.model.FuguCreateConversationResponse
import com.hippo.retrofit.APIError
import com.hippo.retrofit.ResponseResolver
import com.hippo.retrofit.RestClient
import com.hippo.utils.HippoLog
import com.hippocall.WebRTCCallConstants.Companion.CALL_STATUS
import com.hippocall.WebRTCCallConstants.Companion.CONNECTING
import com.hippocall.WebRTCCallConstants.Companion.OFFER_TO_RECEIVE_AUDIO
import com.hippocall.WebRTCCallConstants.Companion.OFFER_TO_RECEIVE_VIDEO
import com.hippocall.WebRTCCallConstants.Companion.ONGOING_AUDIO_CALL
import com.hippocall.WebRTCCallConstants.Companion.ONGOING_VIDEO_CALL
import com.hippocall.WebRTCCallConstants.Companion.REJECTED
import com.hippocall.WebRTCCallConstants.Companion.RINGING
import com.hippocall.WebRTCCallConstants.Companion.USER_BUSY
import com.hippocall.WebRTCCallConstants.Companion.VIDEO_CALL_HUNGUP_FROM_NOTIFICATION
import com.google.gson.Gson
import org.json.JSONObject
import org.webrtc.*

/**
 * Created by rajatdhamija
 * 20/09/18.
 */

class FuguCallActivity : AppCompatActivity(), View.OnClickListener, WebRTCFayeCallbacks, WebRTCCallCallbacks {

    override fun onVideoOfferScreenSharingRecieved(jsonObject: JSONObject?) {
        videoCallService?.saveOfferAndAnswer(jsonObject)
    }
    var audioLayout: RelativeLayout? = null;
    var tvCalledPersonNameAudio: AppCompatTextView? = null
    var ivCalledPersonImageAudio: AppCompatImageView? = null
    var lowerCallOptionsAudio: LinearLayout? = null;
    var ivSpeakerAudio: AppCompatImageView? = null
    var ivMuteAudio1: AppCompatImageView? = null
    var ivHangUpAudio: AppCompatImageView? = null
    var tvCallingStatusAudio: AppCompatTextView? = null
    var callerRippleView: RippleBackground? = null
    var audioCallerRippleView: RippleBackground? = null
    var ivCalledPersonImage: ImageView? = null
    var ivIncomingPersonImage: ImageView? = null
    var tvCalledPersonName: AppCompatTextView? = null
    var tvCallingStatus: AppCompatTextView? = null
    var tvCallTypeStatus: AppCompatTextView? = null
    var ivHangUp: AppCompatImageView? = null
    var ivMuteAudio: AppCompatImageView? = null
    var ivSwitchCamera: AppCompatImageView? = null
    var ivMuteVideo: AppCompatImageView? = null
    var localSurfaceView: SurfaceViewRenderer? = null
    var incomingRippleView: RippleBackground? = null
    var tvIncomingPersonName: AppCompatTextView? = null
    var tvCallStatus: AppCompatTextView? = null
    var ivRejectCall: AppCompatImageView? = null
    var ivAnswerCall: AppCompatImageView? = null
    var remoteSurfaceview: SurfaceViewRenderer? = null
    var activitylaunchState: String? = ""
    var signal: Signal? = null
    private var rootEglBase: EglBase? = null
    var connection: Connection? = null
    private var sdpConstraints: MediaConstraints? = null
    private var videoStream: MediaStream? = null
    private var localVideoTrack: VideoTrack? = null
    private var localAudioTrack: AudioTrack? = null
    private var remoteVideoTrack: VideoTrack? = null
    private var videoCapturer: VideoCapturer? = null
    private var videoCallModel: VideoCallModel? = null
    private var remoteVideoStream: MediaStream? = null
    private var videoOfferjson: JSONObject? = null
    private var isAudioEnabled = true
    private var isVideoEnabled = true
    private var isSpeakerEnabled = false;
    private var isFrontFacingCamera = true
    private var isLocalViewSmall = true
    private var isCallOptionsVisible = true
    var mediaPlayer: MediaPlayer? = null
    var callStatus: String = ""
    var isAlreadyHungUp = false
    var mBounded = false
    var videoCallService: VideoCallService? = null
    private var peerConnectionFactory: PeerConnectionFactory? = null
    private var callDisconnectTimer: CountDownTimer? = null
    private var wiredHeadsetReceiver: BroadcastReceiver? = null
    private val STATE_UNPLUGGED = 0
    private val STATE_PLUGGED = 1
    private val HAS_NO_MIC = 0
    private val HAS_MIC = 1
    private var isWirelessHeadSetConnected = false
    private var hungupcall = false
    private var ivBack: AppCompatImageView? = null
    private var outgoingCallLayout: RelativeLayout? = null
    private var incomingCallLayout: RelativeLayout? = null
    private var llVideoCall: LinearLayout? = null
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.hippo_activity_video_call)

        val win = window
        win.addFlags(WindowManager.LayoutParams.FLAG_SHOW_WHEN_LOCKED or WindowManager.LayoutParams.FLAG_DISMISS_KEYGUARD)
        win.addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON or WindowManager.LayoutParams.FLAG_TURN_SCREEN_ON)
        askForPermissions()

        initializeViews()
        initializeClickListeners()
        if (intent.action == Intent.ACTION_DELETE) {
            Handler().postDelayed({
                stopForegroundService(false)
            }, 500)
            val hungUpIntent = Intent(VIDEO_CALL_HUNGUP_FROM_NOTIFICATION)
            LocalBroadcastManager.getInstance(this).sendBroadcast(hungUpIntent)
            finish()
        }

        if (!intent.hasExtra("videoCallModel")) {
            callStatus = CommonData.getCallStatus();
            when (callStatus) {
                WebRTCCallConstants.CallStatus.IN_CALL.toString() -> {
                    var callType = ONGOING_VIDEO_CALL
                    if(!TextUtils.isEmpty(CommonData.getCallType()))
                        callType = CommonData.getCallType()
                    startForeGroundService(callType)
                    incomingRippleView?.visibility = View.GONE
                    tvIncomingPersonName?.visibility = View.GONE
                    tvCallStatus?.visibility = View.GONE
                    ivIncomingPersonImage?.visibility = View.GONE
                    ivRejectCall?.visibility = View.GONE
                    ivAnswerCall?.visibility = View.GONE
                    ivHangUp?.visibility = View.VISIBLE
                    ivMuteAudio?.visibility = View.VISIBLE
                    ivMuteVideo?.visibility = View.VISIBLE
                    ivSwitchCamera?.visibility = View.VISIBLE
                    tvCallingStatus?.visibility = View.GONE
                    tvCallingStatusAudio?.visibility = View.GONE
                }

                WebRTCCallConstants.CallStatus.INCOMING_CALL.toString() -> {

                }
                WebRTCCallConstants.CallStatus.OUTGOING_CALL.toString() -> {
                }
            }
        } else {
            startForeGroundService(RINGING)
        }


    }

    private fun fetchCommonData() {
        videoCallModel = intent.extras.getParcelable("videoCallModel")

        if(intent.hasExtra(FuguAppConstant.PEER_CHAT_PARAMS)) {
            var fuguCreateConversationParams = Gson().fromJson(intent
                    .getStringExtra(FuguAppConstant.PEER_CHAT_PARAMS), FuguCreateConversationParams::class.java)
            if(HippoConfig.getInstance().getChannelId(fuguCreateConversationParams.transactionId) != null) {
                videoCallModel?.channelId = HippoConfig.getInstance().getChannelId(fuguCreateConversationParams.transactionId);
                fetchIntentData()
            } else {
                createConversation(fuguCreateConversationParams)
            }
        } else {
            fetchIntentData()
        }
    }

    private fun fetchIntentData() {
        //videoCallModel = intent.extras.getParcelable("videoCallModel")
        videoCallService?.setVideoModel(videoCallModel)
        activitylaunchState = videoCallModel?.activityLaunchState
        videoCallService?.createWebRTCCallConnection()
        val devicePayload = JSONObject()
        devicePayload.put(FuguAppConstant.DEVICE_ID, UniqueIMEIID.getUniqueIMEIId(this))
        devicePayload.put(FuguAppConstant.DEVICE_TYPE, FuguAppConstant.ANDROID_USER)
        devicePayload.put(FuguAppConstant.APP_VERSION, BuildConfig.VERSION_NAME)
        devicePayload.put(FuguAppConstant.DEVICE_DETAILS, CommonData.deviceDetails(this))
        var callType = WebRTCCallConstants.CallType.AUDIO.toString()
        if(videoCallModel?.callType == VIDEO_CALL_VIEW)
            callType = WebRTCCallConstants.CallType.VIDEO.toString()
        signal = Signal(videoCallModel?.userId, callType, videoCallModel?.signalUniqueId, videoCallModel?.fullName,
                videoCallModel?.turnApiKey, videoCallModel?.turnUserName, videoCallModel?.turnCredential
                , videoCallModel?.stunServers, videoCallModel?.turnServers, devicePayload)
        videoCallService?.setSignalModel(signal)
        Handler().postDelayed({
            if (isCallOptionsVisible) {
                isCallOptionsVisible = !isCallOptionsVisible
                hidecallOptionsAnimation()
            }
        }, 3000)
        when (activitylaunchState) {
            WebRTCCallConstants.AcitivityLaunchState.SELF.toString() -> {
                outgoingCallLayout?.visibility = View.VISIBLE
                incomingCallLayout?.visibility = View.GONE
                callerRippleView?.visibility = View.VISIBLE
                callerRippleView?.startRippleAnimation()
                tvCalledPersonName?.visibility = View.VISIBLE
                ivCalledPersonImage?.visibility = View.VISIBLE
                ivMuteAudio?.visibility = View.VISIBLE
                ivMuteVideo?.visibility = View.VISIBLE
                ivSwitchCamera?.visibility = View.VISIBLE
                ivHangUp?.visibility = View.VISIBLE
                localSurfaceView?.visibility = View.VISIBLE
                tvCallingStatus?.visibility = View.VISIBLE
                llVideoCall?.visibility = View.GONE
                tvCallingStatus?.text = RINGING
                initiateOutgoingRinging()
                callStatus = WebRTCCallConstants.CallStatus.OUTGOING_CALL.toString()
                CommonData.setCallStatus(callStatus)

                tvCalledPersonName?.text = videoCallModel?.fullName

                val imgOptions = RequestOptions
                        .circleCropTransform()
                        .placeholder(ContextCompat.getDrawable(this, R.drawable.hippo_call_placeholder))
                        .dontAnimate()
                        .diskCacheStrategy(DiskCacheStrategy.ALL)
                        .error(ContextCompat.getDrawable(this, R.drawable.hippo_call_placeholder))

                if(!TextUtils.isEmpty(videoCallModel?.userThumbnailImage)) {
                    Glide.with(this).load(videoCallModel?.userThumbnailImage)
                            .apply(imgOptions)
                            .into(ivCalledPersonImage!!)
                } else {
                    Glide.with(this).load(R.drawable.hippo_call_placeholder)
                            .apply(imgOptions)
                            .into(ivCalledPersonImage!!)
                }

            }
            WebRTCCallConstants.AcitivityLaunchState.OTHER.toString() -> {
                outgoingCallLayout?.visibility = View.GONE
                incomingCallLayout?.visibility = View.VISIBLE
                incomingRippleView?.visibility = View.VISIBLE
                incomingRippleView?.startRippleAnimation()
                tvIncomingPersonName?.visibility = View.VISIBLE
                ivIncomingPersonImage?.visibility = View.VISIBLE
                ivAnswerCall?.visibility = View.VISIBLE
                ivRejectCall?.visibility = View.VISIBLE
                llVideoCall?.visibility = View.VISIBLE
                initiateIncomingRinging()
                callStatus = WebRTCCallConstants.CallStatus.INCOMING_CALL.toString()
                CommonData.setCallStatus(callStatus)
                tvIncomingPersonName?.text = videoCallModel?.fullName
                if(videoCallModel?.callType == VIDEO_CALL_VIEW)
                    tvCallTypeStatus?.text = getString(R.string.hippo_video_call, WebRTCCallConstants.CallType.VIDEO.toString().toLowerCase())
                else
                    tvCallTypeStatus?.text = getString(R.string.hippo_video_call, WebRTCCallConstants.CallType.VOICE.toString().toLowerCase())


                val imgOptions = RequestOptions
                        .circleCropTransform()
                        .placeholder(ContextCompat.getDrawable(this, R.drawable.hippo_call_placeholder))
                        .dontAnimate()
                        .diskCacheStrategy(DiskCacheStrategy.ALL)
                        .error(ContextCompat.getDrawable(this, R.drawable.hippo_call_placeholder))

                if(!TextUtils.isEmpty(videoCallModel?.userThumbnailImage)) {
                    Glide.with(this).load(videoCallModel?.userThumbnailImage)
                            .apply(imgOptions)
                            .into(ivIncomingPersonImage!!)
                } else {
                    Glide.with(this).load(R.drawable.hippo_call_placeholder)
                            .apply(imgOptions)
                            .into(ivIncomingPersonImage!!)
                }
            }
            WebRTCCallConstants.AcitivityLaunchState.AUDIO.toString() -> {
                initiateOutgoingRinging()
                callStatus = WebRTCCallConstants.CallStatus.OUTGOING_CALL.toString()
                CommonData.setCallStatus(callStatus)
                audioCallView()
                tvCallingStatusAudio?.text = RINGING
            }
        }
        videoCallService?.createWebRTCSignallingConnection(videoCallModel, signal)
    }

    /**
     * Initialization of Views
     */
    private fun initializeViews() {
        callerRippleView = findViewById(R.id.callerRippleView)
        audioCallerRippleView = findViewById(R.id.audioCallerRippleView)
        ivCalledPersonImage = findViewById(R.id.ivCalledPersonImage)
        ivIncomingPersonImage = findViewById(R.id.ivIncomingPersonImage)
        tvCalledPersonName = findViewById(R.id.tvCalledPersonName)
        tvCallingStatus = findViewById(R.id.tvCallingStatus)
        tvCallTypeStatus = findViewById(R.id.call_status)
        ivHangUp = findViewById(R.id.ivHangUp)
        ivMuteAudio = findViewById(R.id.ivMuteAudio)
        ivSwitchCamera = findViewById(R.id.ivSwitchCamera)
        ivMuteVideo = findViewById(R.id.ivMuteVideo)
        localSurfaceView = findViewById(R.id.localSurfaceView)
        incomingRippleView = findViewById(R.id.incomingRippleView)
        tvIncomingPersonName = findViewById(R.id.tvIncomingPersonName)
        tvCallStatus = findViewById(R.id.tvCallStatus)
        ivRejectCall = findViewById(R.id.ivRejectCall)
        ivAnswerCall = findViewById(R.id.ivAnswerCall)
        remoteSurfaceview = findViewById(R.id.remoteSurfaceview)
        ivBack = findViewById(R.id.ivBack)
        ivBack?.visibility = View.GONE
        outgoingCallLayout = findViewById(R.id.outgoingCallLayout)
        incomingCallLayout = findViewById(R.id.incomingCallLayout)
        llVideoCall = findViewById(R.id.llVideoCall)
        wiredHeadsetReceiver = WiredHeadsetReceiver()
        remoteSurfaceview?.setScalingType(RendererCommon.ScalingType.SCALE_ASPECT_FIT)

        // for audio call
        audioLayout = findViewById(R.id.audioLayout)
        tvCalledPersonNameAudio = findViewById(R.id.tvCalledPersonNameAudio)
        ivCalledPersonImageAudio = findViewById(R.id.ivCalledPersonImageAudio)
        ivSpeakerAudio = findViewById(R.id.ivSpeakerAudio)
        ivMuteAudio1 = findViewById(R.id.ivMuteAudio1)
        lowerCallOptionsAudio = findViewById(R.id.lowerCallOptionsAudio)
        ivHangUpAudio = findViewById(R.id.ivHangUpAudio)
        tvCallingStatusAudio = findViewById(R.id.tvCallingStatusAudio)
    }

    /**
     * Add Click listeners to views
     */
    private fun initializeClickListeners() {
        ivHangUp?.setOnClickListener(this)
        ivMuteAudio?.setOnClickListener(this)
        ivSwitchCamera?.setOnClickListener(this)
        ivMuteVideo?.setOnClickListener(this)
        localSurfaceView?.setOnClickListener(this)
        ivRejectCall?.setOnClickListener(this)
        ivAnswerCall?.setOnClickListener(this)
        remoteSurfaceview?.setOnClickListener(this)
        ivBack?.setOnClickListener(this)

        // for audio call
        ivHangUpAudio?.setOnClickListener(this)
        ivSpeakerAudio?.setOnClickListener(this)
        ivMuteAudio1?.setOnClickListener(this)
    }

    override fun onClick(v: View?) {
        when (v?.id) {
            R.id.ivHangUpAudio -> {
                videoCallService?.hungUpCall()
                stopServiceAndCloseConnection()
            }
            R.id.ivSpeakerAudio -> {
                isSpeakerEnabled = !isSpeakerEnabled
                val am = getSystemService(Context.AUDIO_SERVICE) as AudioManager
                am.mode = AudioManager.MODE_IN_CALL
                am.setSpeakerphoneOn(isSpeakerEnabled)
                val drawable = if (isSpeakerEnabled) R.drawable.hippo_ic_volume_enabled else R.drawable.hippo_ic_volume_disable
                ivSpeakerAudio?.setImageResource(drawable)
            }
            R.id.ivMuteAudio1 -> {
                videoStream?.audioTracks?.get(0)?.setEnabled(!isAudioEnabled)
                val drawable = if (isAudioEnabled) R.drawable.hippo_ic_mute_microphone_enabled else R.drawable.hippo_ic_mute_microphone_disabled
                ivMuteAudio1?.setImageResource(drawable)
                isAudioEnabled = !isAudioEnabled
            }
            R.id.ivHangUp -> {
                videoCallService?.hungUpCall()
                stopServiceAndCloseConnection()
            }
            R.id.ivMuteAudio -> {
                videoStream?.audioTracks?.get(0)?.setEnabled(!isAudioEnabled)
                val drawable = if (isAudioEnabled) R.drawable.hippo_ic_mute_microphone_enabled else R.drawable.hippo_ic_mute_microphone_disabled
                ivMuteAudio?.setImageResource(drawable)
                isAudioEnabled = !isAudioEnabled
            }
            R.id.ivSwitchCamera -> {
                switchCameraRecorder()
            }
            R.id.ivMuteVideo -> {
                videoStream?.videoTracks?.get(0)?.setEnabled(!isVideoEnabled)
                val drawable = if (isVideoEnabled) R.drawable.hippo_ic_mute_video_enabled else R.drawable.hippo_ic_mute_video_disabled
                ivMuteVideo?.setImageResource(drawable)
                isVideoEnabled = !isVideoEnabled
            }
            R.id.ivRejectCall -> {
                videoCallService?.rejectCall()
                CommonData.setCallAnswered(false)
                Handler().postDelayed({
                    stopServiceAndCloseConnection()
                }, 3000)
            }
            R.id.ivAnswerCall -> {
                if (mediaPlayer != null) {
                    mediaPlayer?.stop()
                }
                if(videoOfferjson == null) {
                    acceptButtonAns(0)
                    /*CommonData.setCallAnswered(true)
                    tvCallStatus?.visibility = View.VISIBLE
                    tvCallStatus?.text = CONNECTING

                    outgoingCallLayout?.visibility = View.VISIBLE
                    incomingCallLayout?.visibility = View.GONE
                    remoteSurfaceview?.visibility = View.VISIBLE
                    localSurfaceView?.visibility = View.VISIBLE
                    incomingRippleView?.visibility = View.GONE
                    tvIncomingPersonName?.visibility = View.GONE
                    //tvCallStatus?.visibility = View.GONE
                    ivIncomingPersonImage?.visibility = View.GONE
                    ivRejectCall?.visibility = View.GONE
                    ivAnswerCall?.visibility = View.GONE
                    tvCallingStatus?.visibility = View.GONE
                    ivHangUp?.visibility = View.VISIBLE
                    ivMuteAudio?.visibility = View.VISIBLE
                    ivMuteVideo?.visibility = View.VISIBLE
                    ivSwitchCamera?.visibility = View.VISIBLE
                    llVideoCall?.visibility = View.GONE*/

                } else {
                    CommonData.setCallAnswered(false)
                    videoCallService?.saveOfferAndAnswer(videoOfferjson)
                }
            }
            R.id.localSurfaceView -> {
                if (isLocalViewSmall) {
                    localVideoTrack?.removeSink(localSurfaceView)
                    remoteVideoTrack?.removeSink(remoteSurfaceview)
                    localVideoTrack?.addSink(remoteSurfaceview)
                    remoteVideoTrack?.addSink(localSurfaceView)
                } else {
                    localVideoTrack?.removeSink(remoteSurfaceview)
                    remoteVideoTrack?.removeSink(localSurfaceView)
                    localVideoTrack?.addSink(localSurfaceView)
                    remoteVideoTrack?.addSink(remoteSurfaceview)
                }
                isLocalViewSmall = !isLocalViewSmall
            }
            R.id.remoteSurfaceview -> {
                if (isCallOptionsVisible) {
                    if (callDisconnectTimer != null) {
                        callDisconnectTimer?.cancel()
                    }
                    hidecallOptionsAnimation()
                } else {
                    callDisconnectTimer = object : CountDownTimer(3000, 1000) {

                        override fun onTick(millisUntilFinished: Long) {}

                        override fun onFinish() {
                            if (isCallOptionsVisible) {
                                hidecallOptionsAnimation()
                                isCallOptionsVisible = !isCallOptionsVisible
                            }
                        }
                    }.start()
                    showCallOptionsAnimation()
                }
                isCallOptionsVisible = !isCallOptionsVisible
            }
            R.id.ivBack -> { //onBackPressed()
            }
            else -> {

            }
        }
    }

    override fun onBackPressed() {
        return
    }

    override fun onResume() {
        super.onResume()
        unregisterrecievers()
        LocalBroadcastManager.getInstance(this).registerReceiver(mVideoCallReciever,
                IntentFilter(FuguAppConstant.VIDEO_CALL_INTENT))
        if (wiredHeadsetReceiver != null) {
            registerReceiver(wiredHeadsetReceiver, IntentFilter(Intent.ACTION_HEADSET_PLUG))
        }
    }

    private fun unregisterrecievers() {
        try {
            LocalBroadcastManager.getInstance(this).unregisterReceiver(mVideoCallReciever)
        } catch (e: Exception) {
            e.printStackTrace()
        }
        try {
            LocalBroadcastManager.getInstance(this).unregisterReceiver(wiredHeadsetReceiver!!)
        } catch (e: Exception) {
            e.printStackTrace()
        }

    }

    private val mVideoCallReciever = object : BroadcastReceiver() {
        override fun onReceive(context: Context, intent: Intent) {
            videoCallService?.onBroadCastrecieved(intent)
        }
    }

    private fun hidecallOptionsAnimation() {
        if(videoCallModel?.callType == AUDIO_CALL_VIEW)
            return
        val hungupGone = ObjectAnimator.ofFloat(ivHangUp, "translationY", 0f, 500f)
        hungupGone.setDuration(300)

        val muteAudioGone = ObjectAnimator.ofFloat(ivMuteAudio, "translationY", 0f, 250f)
        muteAudioGone.setDuration(180)

        val muteVideoGone = ObjectAnimator.ofFloat(ivMuteVideo, "translationY", 0f, 250f)
        muteVideoGone.setDuration(180)

        val switchCameraGone = ObjectAnimator.ofFloat(ivSwitchCamera, "translationY", 0f, 250f)
        switchCameraGone.setDuration(180)

        val localView = ObjectAnimator.ofFloat(localSurfaceView, "translationY", 0f, 250f)
        localView.setDuration(180)

        hungupGone.start()
        muteAudioGone.start()
        muteVideoGone.start()
        switchCameraGone.start()
        localView.start()
    }

    private fun showCallOptionsAnimation() {
        if(videoCallModel?.callType == AUDIO_CALL_VIEW)
            return
        val hungupVisible = ObjectAnimator.ofFloat(ivHangUp, "translationY", 500f, 0f)
        hungupVisible.setDuration(300)

        val muteAudioVisible = ObjectAnimator.ofFloat(ivMuteAudio, "translationY", 250f, 0f)
        muteAudioVisible.setDuration(180)

        val muteVideoVisible = ObjectAnimator.ofFloat(ivMuteVideo, "translationY", 250f, 0f)
        muteVideoVisible.setDuration(180)

        val switchCameraVisible = ObjectAnimator.ofFloat(ivSwitchCamera, "translationY", 250f, 0f)
        switchCameraVisible.setDuration(180)

        val localView = ObjectAnimator.ofFloat(localSurfaceView, "translationY", 250f, 0f)
        localView.setDuration(180)

        hungupVisible.start()
        muteAudioVisible.start()
        muteVideoVisible.start()
        switchCameraVisible.start()
        localView.start()
    }

    private fun stopServiceCloseActivity() {
        stopForegroundService(false)
        hangupVideoCall()
        Handler().postDelayed({ finish() }, 300)
    }

    private fun stopServiceAndCloseConnection() {
        stopForegroundService(true)
        hangupVideoCall()
        Handler().postDelayed({ finish() }, 300)
    }

    private fun switchCameraRecorder() {
        if (videoCallService?.getPeerconnection() != null) {
            ivSwitchCamera?.setOnClickListener(null)
            ivSwitchCamera?.alpha = 0.5f
            if (isLocalViewSmall) {
                localVideoTrack?.removeSink(localSurfaceView)
            } else {
                localVideoTrack?.removeSink(remoteSurfaceview)
            }
            videoCallService?.getPeerconnection()?.removeStream(videoStream)
            try {
                videoCapturer?.stopCapture()

                Handler().postDelayed({
                    ivSwitchCamera?.setOnClickListener(this)
                    ivSwitchCamera?.alpha = 1f
                    ivMuteVideo?.setImageResource(R.drawable.hippo_ic_mute_video_disabled)
                    ivMuteAudio?.setImageResource(R.drawable.hippo_ic_mute_microphone_disabled)
                    isVideoEnabled = true
                    isAudioEnabled = true
                    val videoGrabberAndroid = createVideoGrabber(!isFrontFacingCamera)
                    val videoSource = peerConnectionFactory?.createVideoSource(false)
                    val cameraVideoCapturer = videoGrabberAndroid as CameraVideoCapturer
                    localVideoTrack = peerConnectionFactory?.createVideoTrack("100", videoSource)
                    val surfaceTextureHelper = SurfaceTextureHelper.create("CaptureThread", rootEglBase?.getEglBaseContext())
                    cameraVideoCapturer.initialize(surfaceTextureHelper, this@FuguCallActivity, videoSource?.capturerObserver)
                    cameraVideoCapturer.startCapture(1000, 1000, 30)
                    sdpConstraints = MediaConstraints()
                    sdpConstraints?.mandatory?.add(MediaConstraints.KeyValuePair(OFFER_TO_RECEIVE_AUDIO, "true"))
                    sdpConstraints?.mandatory?.add(MediaConstraints.KeyValuePair(OFFER_TO_RECEIVE_VIDEO, "true"))
                    val audioSource = peerConnectionFactory?.createAudioSource(sdpConstraints)
                    localAudioTrack = peerConnectionFactory?.createAudioTrack("101", audioSource)
                    videoStream = peerConnectionFactory?.createLocalMediaStream("102")
                    videoStream?.addTrack(localVideoTrack)
                    videoStream?.addTrack(localAudioTrack)
                    videoCallService?.getPeerconnection()?.addStream(videoStream)
                    if (isLocalViewSmall) {
                        localVideoTrack?.addSink(localSurfaceView)
                    } else {
                        localVideoTrack?.addSink(remoteSurfaceview)
                    }
                    isFrontFacingCamera = !isFrontFacingCamera
                    if(isFrontFacingCamera)
                        ivSwitchCamera?.setImageResource(R.drawable.hippo_ic_switch_camera)
                    else
                        ivSwitchCamera?.setImageResource(R.drawable.hippo_ic_switch_camera_back)
                }, 1000)
            } catch (e: Exception) {

            }
        }
    }


    override fun onIceCandidateRecieved(jsonObject: JSONObject?) {
        //TODO Ui changes
        videoStream = peerConnectionFactory?.createLocalMediaStream("102")
        if(videoCallModel?.callType == FuguAppConstant.VIDEO_CALL_VIEW)
            videoStream?.addTrack(localVideoTrack)
        videoStream?.addTrack(localAudioTrack)
        videoCallService?.getPeerconnection()?.addStream(videoStream)
        videoCallService?.saveIceCandidate(jsonObject)
    }

    override fun onVideoOfferRecieved(jsonObject: JSONObject?) {
        //TODO ui changes
        sdpConstraints = MediaConstraints()
        sdpConstraints?.mandatory?.add(MediaConstraints.KeyValuePair(OFFER_TO_RECEIVE_AUDIO, "true"))
        sdpConstraints?.mandatory?.add(MediaConstraints.KeyValuePair(OFFER_TO_RECEIVE_VIDEO, "true"))
        connection = Connection(videoCallModel?.stunServers, videoCallModel?.turnServers,
                sdpConstraints, videoCallModel?.turnUserName, videoCallModel?.turnCredential, peerConnectionFactory)
        connection?.sdpConstraints = sdpConstraints
        videoCallService?.setConnectionModel(connection)
        videoCallService?.createPeerConnection(connection)
        videoCallService?.getPeerconnection()?.addStream(videoStream)
        videoOfferjson = jsonObject

        if(CommonData.isCallAnswered()) {
            CommonData.setCallAnswered(false)
            if (mediaPlayer != null) {
                mediaPlayer?.stop()
            }
            videoCallService?.saveOfferAndAnswer(videoOfferjson)
            //ivAnswerCall?.performClick()
        }
    }

    override fun onVideoAnswerRecieved(jsonObject: JSONObject?) {
        runOnUiThread {
            if (mediaPlayer != null) {
                mediaPlayer?.stop()
                callerRippleView?.visibility = View.GONE
                callerRippleView?.stopRippleAnimation()
                if(videoCallModel?.callType == VIDEO_CALL_VIEW) {
                    tvCalledPersonName?.visibility = View.GONE
                    ivCalledPersonImage?.visibility = View.GONE
                } else {
                    audioCallView(false)
                }
            }
        }
    }

    override fun onReadyToConnectRecieved(jsonObject: JSONObject?) {
        sdpConstraints = MediaConstraints()
        sdpConstraints?.mandatory?.add(MediaConstraints.KeyValuePair(OFFER_TO_RECEIVE_AUDIO, "true"))
        sdpConstraints?.mandatory?.add(MediaConstraints.KeyValuePair(OFFER_TO_RECEIVE_VIDEO, "true"))
        connection = Connection(videoCallModel?.stunServers, videoCallModel?.turnServers,
                sdpConstraints, videoCallModel?.turnUserName, videoCallModel?.turnCredential, peerConnectionFactory)
        videoCallService?.setConnectionModel(connection)
        videoCallService?.createPeerConnection(connection)
        videoStream = peerConnectionFactory?.createLocalMediaStream("102")
        if(videoCallModel?.callType == FuguAppConstant.VIDEO_CALL_VIEW)
            videoStream?.addTrack(localVideoTrack)
        videoStream?.addTrack(localAudioTrack)
        videoStream?.audioTracks!![0].setEnabled(true)
        videoCallService?.getPeerconnection()?.addStream(videoStream)
        videoCallService?.createOffer(connection)
    }

    override fun onCallHungUp(jsonObject: JSONObject?) {
        stopServiceCloseActivity()
    }

    override fun onCallRejected(jsonObject: JSONObject?) {
        updateUI(WebRTCCallConstants.CallStatusUI.REJECTED.toString(), "")
//        tvCallingStatus?.visibility = View.VISIBLE
//        tvCallingStatus?.text = REJECTED
//        tvCallingStatusAudio?.text = REJECTED
        if (mediaPlayer != null) {
            mediaPlayer?.stop()
            mediaPlayer = MediaPlayer.create(this@FuguCallActivity, R.raw.busy_tone)
            mediaPlayer?.setLooping(false)
            mediaPlayer?.start()
        }
        Handler().postDelayed({
            stopServiceCloseActivity()
        }, 3000)
    }

    override fun onUserBusyRecieved(jsonObject: JSONObject?) {
        updateUI(WebRTCCallConstants.CallStatusUI.BUSY.toString(), "")
        /*tvCallingStatus?.visibility = View.VISIBLE
        tvCallingStatus?.text = USER_BUSY
        tvCallingStatusAudio?.text = USER_BUSY*/
        if (mediaPlayer != null) {
            mediaPlayer?.stop()
            mediaPlayer = MediaPlayer.create(this@FuguCallActivity, R.raw.busy_tone)
            mediaPlayer?.setLooping(false)
            mediaPlayer?.start()
        }
        Handler().postDelayed({
            stopServiceCloseActivity()
        }, 3000)
    }

    override fun onAddStream(mediaStream: MediaStream?) {
        remoteVideoStream = mediaStream
        videoCallService?.setRemoteStream(mediaStream)
        if(videoCallModel?.callType == FuguAppConstant.VIDEO_CALL_VIEW && mediaStream?.videoTracks?.size!!>0)
            remoteVideoTrack = mediaStream?.videoTracks?.get(0)
        runOnUiThread {
            acceptButtonAns(1)
            /*try {
                callStatus = WebRTCCallConstants.CallStatus.IN_CALL.toString()
                CommonData.setCallStatus(WebRTCCallConstants.CallStatus.IN_CALL.toString())
                val am = getSystemService(Context.AUDIO_SERVICE) as AudioManager
                am.mode = AudioManager.MODE_IN_CALL
                if(videoCallModel?.callType == FuguAppConstant.VIDEO_CALL_VIEW) {
                    am.isSpeakerphoneOn = true
                } else {
                    am.isSpeakerphoneOn = false
                    remoteVideoTrack?.addSink(remoteSurfaceview)
                }
                outgoingCallLayout?.visibility = View.VISIBLE
                incomingCallLayout?.visibility = View.GONE
                remoteSurfaceview?.visibility = View.VISIBLE
                localSurfaceView?.visibility = View.VISIBLE
                incomingRippleView?.visibility = View.GONE
                tvIncomingPersonName?.visibility = View.GONE
                tvCallStatus?.visibility = View.GONE
                ivIncomingPersonImage?.visibility = View.GONE
                ivRejectCall?.visibility = View.GONE
                ivAnswerCall?.visibility = View.GONE
                tvCallingStatus?.visibility = View.GONE
                ivHangUp?.visibility = View.VISIBLE
                ivMuteAudio?.visibility = View.VISIBLE
                ivMuteVideo?.visibility = View.VISIBLE
                ivSwitchCamera?.visibility = View.VISIBLE
                llVideoCall?.visibility = View.GONE
                startForeGroundService(ONGOING_VIDEO_CALL)
            } catch (e: Exception) {
                e.printStackTrace()
            }*/
        }
    }

    private fun acceptButtonAns(type: Int) {
        try {
            if(type == 1) {
                callStatus = WebRTCCallConstants.CallStatus.IN_CALL.toString()
                CommonData.setCallStatus(WebRTCCallConstants.CallStatus.IN_CALL.toString())
                val am = getSystemService(Context.AUDIO_SERVICE) as AudioManager
                am.mode = AudioManager.MODE_IN_CALL
                am.isSpeakerphoneOn = videoCallModel?.callType == FuguAppConstant.VIDEO_CALL_VIEW
                remoteVideoTrack?.addSink(remoteSurfaceview)

                if(videoCallModel?.callType == FuguAppConstant.AUDIO_CALL_VIEW)
                    tvCallingStatusAudio?.visibility = View.GONE
            } else {
                CommonData.setCallAnswered(true)
                tvCallStatus?.visibility = View.VISIBLE
                tvCallStatus?.text = CONNECTING
            }
            if(videoCallModel?.callType == FuguAppConstant.AUDIO_CALL_VIEW) {
                audioCallView(false)
                if(type != 1) {
                    tvCallingStatusAudio?.text = CONNECTING
                }
            } else {
                outgoingCallLayout?.visibility = View.VISIBLE
                incomingCallLayout?.visibility = View.GONE
                remoteSurfaceview?.visibility = View.VISIBLE
                localSurfaceView?.visibility = View.VISIBLE
                incomingRippleView?.visibility = View.GONE
                tvIncomingPersonName?.visibility = View.GONE
                ivIncomingPersonImage?.visibility = View.GONE
                ivRejectCall?.visibility = View.GONE
                ivAnswerCall?.visibility = View.GONE
                tvCallingStatus?.visibility = View.GONE
                ivHangUp?.visibility = View.VISIBLE
                ivMuteAudio?.visibility = View.VISIBLE
                ivMuteVideo?.visibility = View.VISIBLE
                ivSwitchCamera?.visibility = View.VISIBLE
                llVideoCall?.visibility = View.GONE
            }
            if(videoCallModel?.callType == FuguAppConstant.AUDIO_CALL_VIEW) {
                startForeGroundService(ONGOING_AUDIO_CALL)
                CommonData.setCallType(ONGOING_AUDIO_CALL)
            } else {
                startForeGroundService(ONGOING_VIDEO_CALL)
                CommonData.setCallType(ONGOING_VIDEO_CALL)
            }

        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    override fun onIceCandidate(iceCandidate: IceCandidate?) {

    }

    override fun onErrorRecieved(error: String?) {

    }


    private fun initiateOutgoingRinging() {
        Handler().postDelayed({
            mediaPlayer = MediaPlayer.create(this@FuguCallActivity, R.raw.ringing)
            mediaPlayer?.setLooping(true)
            mediaPlayer?.start()
        }, 1000)
    }

    private fun initiateIncomingRinging() {
        Handler().postDelayed({
            mediaPlayer = MediaPlayer.create(this@FuguCallActivity, R.raw.video_call_ringtone)
            mediaPlayer?.setLooping(true)
            mediaPlayer?.start()
        }, 1000)
    }

    private fun setUpWebRTCViews() {
        remoteSurfaceview = findViewById(R.id.remoteSurfaceview)
        rootEglBase = EglBase.create()
        videoCallService?.setEgl(rootEglBase)
        localSurfaceView?.setMirror(true)
        remoteSurfaceview?.setMirror(false)
        localSurfaceView?.init(rootEglBase?.getEglBaseContext(), null)
        localSurfaceView?.setZOrderOnTop(true)
        remoteSurfaceview?.setZOrderMediaOverlay(true)
        remoteSurfaceview?.init(rootEglBase?.getEglBaseContext(), null)
        peerConnectionFactory = videoCallService?.createPeerConnectionFactory(rootEglBase)

        val videoGrabberAndroid = createVideoGrabber(isFrontFacingCamera)
        val constraints = MediaConstraints()
        val videoSource = peerConnectionFactory?.createVideoSource(false)
        val cameraVideoCapturer = videoGrabberAndroid as CameraVideoCapturer
        localVideoTrack = peerConnectionFactory?.createVideoTrack("100", videoSource)
        val audioSource = peerConnectionFactory?.createAudioSource(constraints)
        localAudioTrack = peerConnectionFactory?.createAudioTrack("101", audioSource)
        val surfaceTextureHelper = SurfaceTextureHelper.create("CaptureThread", rootEglBase?.getEglBaseContext())
        cameraVideoCapturer.initialize(surfaceTextureHelper, this, videoSource?.capturerObserver)
        cameraVideoCapturer.startCapture(1000, 1000, 30)
        videoStream = peerConnectionFactory?.createLocalMediaStream("102")
        if(videoCallModel?.callType == FuguAppConstant.VIDEO_CALL_VIEW)
            videoCallService?.setLocalVideoStream(videoStream)
        videoStream?.addTrack(localAudioTrack)
        if(videoCallModel?.callType == FuguAppConstant.VIDEO_CALL_VIEW) {
            videoStream?.addTrack(localVideoTrack)
            localVideoTrack?.addSink(localSurfaceView)
        }
    }

    private fun setUpWebRTCViewsKilled() {
        rootEglBase = videoCallService?.getEgl()
        localSurfaceView?.setMirror(true)
        localSurfaceView?.init(rootEglBase?.getEglBaseContext(), null)
        localSurfaceView?.setZOrderOnTop(true)
        peerConnectionFactory = videoCallService?.createPeerConnectionFactory(rootEglBase)
        if(videoCallModel?.callType == FuguAppConstant.VIDEO_CALL_VIEW) {
            videoStream = videoCallService?.getLocalVideoStream()
            localSurfaceView?.visibility = View.VISIBLE
            localVideoTrack = videoStream?.videoTracks?.get(0)
            localVideoTrack?.addSink(localSurfaceView)
        }
    }

    private fun createVideoGrabber(isFrontFacing: Boolean): VideoCapturer? {
        videoCapturer = createCameraGrabber(Camera1Enumerator(false), isFrontFacing)
        return videoCapturer
    }

    fun createCameraGrabber(enumerator: CameraEnumerator, isFrontFacing: Boolean): VideoCapturer? {
        val deviceNames = enumerator.deviceNames
        if (isFrontFacing) {
            for (deviceName in deviceNames) {
                if (enumerator.isFrontFacing(deviceName)) {
                    val videoCapturer = enumerator.createCapturer(deviceName, null)
                    if (videoCapturer != null) {
                        return videoCapturer
                    }
                }
            }
            for (deviceName in deviceNames) {
                if (!enumerator.isFrontFacing(deviceName)) {
                    val videoCapturer = enumerator.createCapturer(deviceName, null)
                    if (videoCapturer != null) {
                        return videoCapturer
                    }
                }
            }
        } else {
            for (deviceName in deviceNames) {
                if (!enumerator.isFrontFacing(deviceName)) {
                    val videoCapturer = enumerator.createCapturer(deviceName, null)
                    if (videoCapturer != null) {
                        return videoCapturer
                    }
                }
            }
            for (deviceName in deviceNames) {
                if (enumerator.isFrontFacing(deviceName)) {
                    val videoCapturer = enumerator.createCapturer(deviceName, null)
                    if (videoCapturer != null) {
                        return videoCapturer
                    }
                }
            }
        }
        return null
    }


    fun askForPermissions() {
        if (ContextCompat.checkSelfPermission(this,
                        Manifest.permission.CAMERA) != PackageManager.PERMISSION_GRANTED
                && ContextCompat.checkSelfPermission(this,
                        Manifest.permission.RECORD_AUDIO) != PackageManager.PERMISSION_GRANTED) {
            val MY_PERMISSIONS_REQUEST = 102
            ActivityCompat.requestPermissions(this,
                    arrayOf(Manifest.permission.CAMERA, Manifest.permission.RECORD_AUDIO),
                    MY_PERMISSIONS_REQUEST)
        } else if (ContextCompat.checkSelfPermission(this,
                        Manifest.permission.RECORD_AUDIO) != PackageManager.PERMISSION_GRANTED) {
            val MY_PERMISSIONS_REQUEST_RECORD_AUDIO = 101
            ActivityCompat.requestPermissions(this,
                    arrayOf(Manifest.permission.RECORD_AUDIO),
                    MY_PERMISSIONS_REQUEST_RECORD_AUDIO)

        } else if (ContextCompat.checkSelfPermission(this,
                        Manifest.permission.CAMERA) != PackageManager.PERMISSION_GRANTED) {
            val MY_PERMISSIONS_REQUEST_CAMERA = 100
            ActivityCompat.requestPermissions(this,
                    arrayOf(Manifest.permission.CAMERA),
                    MY_PERMISSIONS_REQUEST_CAMERA)
        }
    }

    private fun startForeGroundService(status: String) {
        val startIntent = Intent(this@FuguCallActivity, VideoCallService::class.java)
        var channelName = ""
        if (!intent.hasExtra("videoCallModel")) {
            if (intent.hasExtra(CHANNEL_NAME)) {
                channelName = intent.getStringExtra(CHANNEL_NAME)
            } else {
                if(status.equals(ONGOING_AUDIO_CALL))
                    channelName = "Voice Call"
                else
                    channelName = "Video Call"
            }
        } else {
            videoCallModel = intent.extras.getParcelable("videoCallModel")
            channelName = videoCallModel?.channelName!!
        }
        startIntent.action = "com.fuguchat.start"
        startIntent.putExtra(CALL_STATUS, status)
        startIntent.putExtra(CHANNEL_NAME, channelName)
        ContextCompat.startForegroundService(this, startIntent)
        bindService(startIntent, mConnection, Context.BIND_AUTO_CREATE)
    }

    private fun stopForegroundService(isHungUpToBeSent: Boolean?) {
        val startIntent = Intent(this@FuguCallActivity, VideoCallService::class.java)
        startIntent.action = "com.fuguchat.start"
        startIntent.putExtra("isHungUpToBeSent", isHungUpToBeSent)
        stopService(startIntent)
    }

    private fun hangupVideoCall() {
        if (mediaPlayer != null) {
            mediaPlayer?.stop()
        } else {
            mediaPlayer = MediaPlayer()
            mediaPlayer?.stop()
        }
        videoCallService?.closePeerConnection()
        try {
            videoCapturer?.stopCapture()
            videoCapturer?.dispose()

        } catch (e: InterruptedException) {
            e.printStackTrace()
        }
        if (!isAlreadyHungUp) {
            isAlreadyHungUp = true
            Handler().postDelayed({
                mediaPlayer = MediaPlayer.create(this@FuguCallActivity, R.raw.disconnet_call)
                mediaPlayer?.setLooping(false)
                mediaPlayer?.start()
            }, 300)
        }
    }

    override fun onDestroy() {
        super.onDestroy()
        if (isLocalViewSmall) {
            remoteVideoTrack?.removeSink(remoteSurfaceview)
            localVideoTrack?.removeSink(localSurfaceView)
        } else {
            remoteVideoTrack?.removeSink(localSurfaceView)
            localVideoTrack?.removeSink(remoteSurfaceview)
        }
        videoCallService?.setRemoteStream(remoteVideoStream)
        if (!callStatus.equals(WebRTCCallConstants.CallStatus.IN_CALL.toString())) {
            stopServiceAndCloseConnection()
        }
        CommonData.setCallAnswered(false)
    }

    override fun onStop() {
        super.onStop()
        if (mBounded) {
            unbindService(mConnection)
            mBounded = false
        }
    }

    private var mConnection: ServiceConnection = object : ServiceConnection {
        override fun onServiceDisconnected(name: ComponentName) {
            mBounded = false
            videoCallService = null
        }

        override fun onServiceConnected(name: ComponentName, service: IBinder) {
            runOnUiThread {
                //                if (hungupcall) {
//                    videoCallService?.hungUpCall()
//                    Handler().postDelayed({
//                        stopServiceAndCloseConnection()
//                    }, 1000)
//                }
                mBounded = true
                val mLocalBinder = service as VideoCallService.LocalBinder
                videoCallService = mLocalBinder.serverInstance
                if (!intent.hasExtra("videoCallModel")) {
                    setUpWebRTCViewsKilled()
                    remoteSurfaceview?.setMirror(false)
                    remoteSurfaceview?.setZOrderMediaOverlay(true)
                    remoteSurfaceview?.init(rootEglBase?.getEglBaseContext(), null)
                    connection = videoCallService?.getConnectionModel()
                    signal = videoCallService?.getSignal()
                    videoCallModel = videoCallService?.getVideoModel()
                    if(videoCallModel?.callType == AUDIO_CALL_VIEW) {
                        audioCallView(false)
                    }
                    remoteVideoStream = videoCallService?.getRemoteVideoStream()
                    if(remoteVideoStream?.videoTracks?.size!! > 0)
                        remoteVideoTrack = remoteVideoStream?.videoTracks?.get(0)
                    remoteSurfaceview?.visibility = View.VISIBLE
                    remoteVideoTrack?.addSink(remoteSurfaceview)
                } else {
                    videoCallService?.setActivityContext(this@FuguCallActivity)
                    setUpWebRTCViews()
                    //fetchIntentData()
                    fetchCommonData()
                }
            }
        }
    }

    override fun onNewIntent(intent: Intent) {
        super.onNewIntent(intent)
        try {
            if (intent.action == Intent.ACTION_DELETE) {
                stopServiceAndCloseConnection()
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    private inner class WiredHeadsetReceiver : BroadcastReceiver() {

        override fun onReceive(context: Context, intent: Intent) {
            val state = intent.getIntExtra("state", STATE_UNPLUGGED)
            val microphone = intent.getIntExtra("microphone", HAS_NO_MIC)
            val name = intent.getStringExtra("name")
            HippoLog.d("", "WiredHeadsetReceiver.onReceive" + AppRTCUtils.getThreadInfo() + ": "
                    + "a=" + intent.action + ", s="
                    + (if (state == STATE_UNPLUGGED) "unplugged" else "plugged") + ", m="
                    + (if (microphone == HAS_MIC) "mic" else "no mic") + ", n=" + name + ", sb="
                    + isInitialStickyBroadcast)
            isWirelessHeadSetConnected = state == STATE_PLUGGED
            if (isWirelessHeadSetConnected) {
                val am = getSystemService(Context.AUDIO_SERVICE) as AudioManager
                am.mode = AudioManager.MODE_IN_CALL
                am.isSpeakerphoneOn = false
                am.isWiredHeadsetOn = true
            } else {
                val am = getSystemService(Context.AUDIO_SERVICE) as AudioManager
                am.mode = AudioManager.MODE_IN_CALL
                am.isSpeakerphoneOn = true
            }
        }
    }

    private fun createConversation(fuguCreateConversationParams: FuguCreateConversationParams) {
        try {
            RestClient.getApiInterface().createConversation(fuguCreateConversationParams)
                    .enqueue(object : ResponseResolver<FuguCreateConversationResponse>(this, false, false) {
                        override fun success(t: FuguCreateConversationResponse?) {
                            var channelId: Long = t?.getData()?.getChannelId()!!
                            videoCallModel?.channelId = channelId;
                            fetchIntentData()
                            HippoConfig.getInstance().setChannelIds(fuguCreateConversationParams.transactionId, channelId)
                        }

                        override fun failure(error: APIError?) {
                            Toast.makeText(this@FuguCallActivity, ""+error?.message, Toast.LENGTH_SHORT).show()
                        }

                    })
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    private fun audioCallView() {
        audioCallView(true)
    }

    private fun audioCallView(flag: Boolean) {
        if(flag) {
            audioCallerRippleView?.visibility = View.VISIBLE
            audioCallerRippleView?.startRippleAnimation()
        } else {
            audioCallerRippleView?.stopRippleAnimation()
        }
        audioLayout?.visibility = View.VISIBLE
        ivHangUpAudio?.visibility = View.VISIBLE
        lowerCallOptionsAudio?.visibility = View.VISIBLE
        incomingCallLayout?.visibility = View.GONE
        outgoingCallLayout?.visibility = View.GONE
        tvCalledPersonNameAudio?.text = videoCallModel?.fullName


        val imgOptions = RequestOptions
                .circleCropTransform()
                .placeholder(ContextCompat.getDrawable(this@FuguCallActivity, R.drawable.hippo_call_placeholder))
                .dontAnimate()
                .diskCacheStrategy(DiskCacheStrategy.ALL)
                .error(ContextCompat.getDrawable(this, R.drawable.hippo_call_placeholder))

        if(!TextUtils.isEmpty(videoCallModel?.userThumbnailImage)) {
            Glide.with(this).load(videoCallModel?.userThumbnailImage)
                    .apply(imgOptions)
                    .into(ivCalledPersonImageAudio!!)
        } else {
            Glide.with(this).load(R.drawable.hippo_call_placeholder)
                    .apply(imgOptions)
                    .into(ivCalledPersonImageAudio!!)
        }

    }

    fun updateCallTimer(time: String) {
        updateUI(WebRTCCallConstants.CallStatusUI.ONGOING.toString(), time)
    }

    private fun updateUI(status: String, time: String) {
        runOnUiThread {
            try {
                when(status) {
                    WebRTCCallConstants.CallStatusUI.BUSY.toString() -> {
                        tvCallingStatus?.visibility = View.VISIBLE
                        tvCallingStatus?.text = USER_BUSY
                        tvCallingStatusAudio?.text = USER_BUSY
                    }
                    WebRTCCallConstants.CallStatusUI.REJECTED.toString() -> {
                        tvCallingStatus?.visibility = View.VISIBLE
                        tvCallingStatus?.text = REJECTED
                        tvCallingStatusAudio?.text = REJECTED
                    }
                    WebRTCCallConstants.CallStatusUI.ONGOING.toString() -> {
                        tvCallingStatusAudio?.visibility = View.VISIBLE
                        tvCallingStatusAudio?.text = time
                    }
                }
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }
    }

}


