package com.hippocall;

import android.content.Context;
import android.content.pm.PackageManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.hippo.model.FuguDeviceDetails;
import io.paperdb.Paper;

/**
 * Created by gurmail on 21/02/19.
 *
 * @author gurmail
 */
public final class CommonData {

    static String PAPER_CALL_STATUS = "hippo_call_status";
    static String PAPER_VIDEO_CALL = "hippo_video_call_cred";
    static String PAPER_CALL_TYPE = "hippo_call_type";
    static String PAPER_USER_ID = "hippo_user_id";

    public static String getCallStatus() {
        return Paper.book().read(PAPER_CALL_STATUS);
    }

    public static String getCallType() {
        return Paper.book().read(PAPER_CALL_TYPE);
    }

    public static JsonObject deviceDetails(Context context) {
        Gson gson = new GsonBuilder().create();
        JsonObject deviceDetailsJson = null;
        try {
            deviceDetailsJson = gson.toJsonTree(new FuguDeviceDetails(
                    getAppVersion(context)).getDeviceDetails()).getAsJsonObject();
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return deviceDetailsJson;

    }

    public static void setCallStatus(String callStatus) {
        Paper.book().write(PAPER_CALL_STATUS, callStatus);
    }

    public static void setCallAnswered(boolean b) {
        Paper.book().write("hippo_call_answer", b);
    }

    public static boolean isCallAnswered() {
        return Paper.book().read("hippo_call_answer", false);
    }

    public static void setCallType(String callType) {
        Paper.book().write(PAPER_CALL_TYPE, callType);
    }

    public static Long getUserId() {
        return Long.parseLong(Paper.book().read(PAPER_USER_ID));
    }

    public static int getAppVersion(Context context) {
        try {
            return context.getPackageManager().getPackageInfo(context.getPackageName(), 0).versionCode;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 0;
        }
    }
}
