/*
 * Decompiled with CFR 0.152.
 */
package com.himanshugoel;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.text.Spannable;
import android.text.TextPaint;
import android.text.method.LinkMovementMethod;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import com.himanshugoel.CustomTypefaceSpan;
import com.himanshugoel.WordCloudClick;
import com.himanshugoel.WordCloudUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class WordCloud
extends TextView {
    List<String> data;
    List<Spannable> spannableList;
    Context context;

    public WordCloud(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
    }

    public void create(List<String> data) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < data.size(); ++i) {
            stringBuilder.append(data.get(i) + " ");
        }
        this.setMovementMethod(LinkMovementMethod.getInstance());
        this.setLinksClickable(false);
        this.setHighlightColor(0);
        this.setText(stringBuilder, TextView.BufferType.SPANNABLE);
        this.data = data;
        int start = 0;
        this.spannableList = new ArrayList<Spannable>();
        for (int i = 0; i < data.size(); ++i) {
            int end = start + data.get(i).length();
            this.spannableList.add((Spannable)this.getText());
            start = end + 1;
        }
        this.setLineSpacing(0.0f, 0.7f);
    }

    public void setRandomSize(int minSize, int maxSize) {
        int start = 0;
        Random random = new Random();
        for (int i = 0; i < this.spannableList.size(); ++i) {
            int end = start + this.data.get(i).length();
            int randomNum = random.nextInt(maxSize - minSize + 1) + minSize;
            this.spannableList.get(i).setSpan((Object)new AbsoluteSizeSpan(randomNum), start, end, 17);
            start = end + 1;
        }
    }

    public void setOnWordClickListener(final WordCloudClick wordCloudClick) {
        int start = 0;
        for (int i = 0; i < this.spannableList.size(); ++i) {
            int end = start + this.data.get(i).length();
            final int finalI = i;
            this.spannableList.get(i).setSpan((Object)new ClickableSpan(){

                public void onClick(View widget) {
                    wordCloudClick.onWordClick(widget, finalI);
                }

                public void updateDrawState(TextPaint ds) {
                }
            }, start, end, 33);
            start = end + 1;
        }
    }

    public void setCloudTextColor(String colorHexValue) {
        int start = 0;
        for (int i = 0; i < this.spannableList.size(); ++i) {
            int end = start + this.data.get(i).length();
            this.spannableList.get(i).setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)colorHexValue)), start, end, 33);
            start = end + 1;
        }
    }

    public void setRandomTextColor() {
        int start = 0;
        Random rand = new Random();
        for (int i = 0; i < this.spannableList.size(); ++i) {
            int end = start + this.data.get(i).length();
            int r = rand.nextInt(256);
            int g = rand.nextInt(256);
            int b = rand.nextInt(256);
            this.spannableList.get(i).setSpan((Object)new ForegroundColorSpan(Color.rgb((int)r, (int)g, (int)b)), start, end, 33);
            start = end + 1;
        }
    }

    public void setRandomFonts() {
        int start = 0;
        Random rand = new Random();
        for (int i = 0; i < this.spannableList.size(); ++i) {
            int end = start + this.data.get(i).length();
            int random = 1 + rand.nextInt(18);
            Typeface typefaceRandom = WordCloudUtils.getFont(this.context, random);
            this.spannableList.get(i).setSpan((Object)new CustomTypefaceSpan(typefaceRandom), start, end, 33);
            start = end + 1;
        }
    }
}

