/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.sdk.deploy;

import com.heroku.sdk.deploy.Deployer;
import com.heroku.sdk.deploy.utils.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class App
implements Logger {
    protected Deployer deployer;
    protected String name;

    public App(String name) throws IOException {
        this(name, new ArrayList<String>());
    }

    public App(String name, List<String> buildpacks) throws IOException {
        this("heroku-deploy", name, new File(System.getProperty("user.dir")), App.createTempDir(), buildpacks);
    }

    public App(String client, String name, File rootDir, File targetDir, List<String> buildpacks) {
        this.deployer = new Deployer(client, name, rootDir, targetDir, buildpacks, this);
    }

    @Override
    public void logInfo(String message) {
    }

    @Override
    public void logDebug(String message) {
    }

    @Override
    public void logWarn(String message) {
    }

    @Override
    public void logError(String message) {
    }

    @Override
    public void logUploadProgress(Long uploaded, Long contentLength) {
        this.logDebug("Uploaded " + uploaded + "/" + contentLength);
    }

    @Override
    public Boolean isUploadProgressEnabled() {
        return false;
    }

    public String getName() {
        return this.deployer.getName();
    }

    public void deploy(List<File> includedFiles, Map<String, String> configVars, String jdkVersion, Map<String, String> userDefinedProcessTypes, String tarFilename) throws Exception {
        Map<String, String> processTypes = this.defaultProcTypes();
        processTypes.putAll(userDefinedProcessTypes);
        this.prepare(includedFiles, processTypes);
        this.deployer.deploy(configVars, jdkVersion, tarFilename);
    }

    protected void prepare(List<File> includedFiles, Map<String, String> processTypes) throws IOException {
        this.deployer.prepare(includedFiles, processTypes);
    }

    protected static File createTempDir() throws IOException {
        return Files.createTempDirectory("heroku-deploy", new FileAttribute[0]).toFile();
    }

    protected String relativize(File path) {
        return this.deployer.relativize(path);
    }

    protected File getAppDir() {
        return this.deployer.getAppDir();
    }

    protected File getRootDir() {
        return this.deployer.getRootDir();
    }

    protected File getTargetDir() {
        return this.deployer.getTargetDir();
    }

    protected Map<String, String> defaultProcTypes() {
        return new HashMap<String, String>();
    }
}

