/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.api.connection;

import com.heroku.api.Heroku;
import com.heroku.api.connection.Connection;
import com.heroku.api.connection.ConnectionProvider;
import com.heroku.api.connection.FutureConnection;
import com.heroku.api.http.Http;
import com.heroku.api.http.HttpUtil;
import com.heroku.api.request.Request;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class HttpClientConnection
implements FutureConnection {
    private URL endpoint;
    private CloseableHttpClient httpClient;
    private volatile ExecutorService executorService;
    private Object lock;

    public HttpClientConnection() {
        this.endpoint = HttpUtil.toURL((String)Heroku.Config.ENDPOINT.value);
        this.httpClient = HttpClientConnection.createClient();
        this.lock = new Object();
    }

    @Override
    public <T> Future<T> executeAsync(Request<T> request, String apiKey) {
        return this.executeAsync((Request)request, Collections.emptyMap(), apiKey);
    }

    @Override
    public <T> Future<T> executeAsync(final Request<T> request, final Map<String, String> exraHeaders, final String apiKey) {
        Callable callable = new Callable<T>(){

            @Override
            public T call() throws Exception {
                return HttpClientConnection.this.execute(request, exraHeaders, apiKey);
            }
        };
        return this.getExecutorService().submit(callable);
    }

    @Override
    public <T> T execute(Request<T> request, String key) {
        return this.execute(request, Collections.emptyMap(), key);
    }

    @Override
    public <T> T execute(Request<T> request, Map<String, String> exraHeaders, String key) {
        try {
            HttpRequestBase message = this.getHttpRequestBase(request.getHttpMethod(), Heroku.Config.ENDPOINT.value + request.getEndpoint());
            message.setHeader(Heroku.ApiVersion.v3.getHeaderName(), Heroku.ApiVersion.v3.getHeaderValue());
            message.setHeader(Http.ContentType.JSON.getHeaderName(), Http.ContentType.JSON.getHeaderValue());
            message.setHeader(Http.UserAgent.LATEST.getHeaderName(), Http.UserAgent.LATEST.getHeaderValue("httpclient"));
            for (Map.Entry<String, String> entry : exraHeaders.entrySet()) {
                message.setHeader(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
                message.setHeader(entry.getKey(), entry.getValue());
            }
            if (request.hasBody()) {
                ((HttpEntityEnclosingRequestBase)message).setEntity((HttpEntity)new StringEntity(request.getBody(), "UTF-8"));
            }
            if (key != null) {
                message.setHeader("Authorization", "Basic " + Base64.encodeBase64String((byte[])(":" + key).getBytes()));
            }
            BasicHttpContext ctx = new BasicHttpContext();
            ctx.setAttribute("preemptive-auth", (Object)new BasicScheme());
            CloseableHttpResponse closeableHttpResponse = this.httpClient.execute((HttpUriRequest)message, (HttpContext)ctx);
            return (T)request.getResponse(HttpUtil.getBytes((InputStream)closeableHttpResponse.getEntity().getContent()), closeableHttpResponse.getStatusLine().getStatusCode(), this.toJavaMap(closeableHttpResponse.getAllHeaders()));
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while executing request", e);
        }
    }

    private HttpRequestBase getHttpRequestBase(Http.Method httpMethod, String endpoint) {
        switch (httpMethod) {
            case GET: {
                return new HttpGet(endpoint);
            }
            case PUT: {
                return new HttpPut(endpoint);
            }
            case POST: {
                return new HttpPost(endpoint);
            }
            case DELETE: {
                return new HttpDelete(endpoint);
            }
            case PATCH: {
                return new HttpPatch(endpoint);
            }
        }
        throw new UnsupportedOperationException(httpMethod + " is not a supported request type.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getExecutorService() {
        if (this.executorService == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.executorService == null) {
                    this.executorService = this.createExecutorService();
                }
            }
        }
        return this.executorService;
    }

    protected ExecutorService createExecutorService() {
        return Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread t = new Thread(runnable);
                t.setDaemon(true);
                return t;
            }
        });
    }

    protected static CloseableHttpClient createClientWithProxy(String proxyStr) throws URISyntaxException {
        URI proxyUri = new URI(proxyStr);
        HttpHost proxy = new HttpHost(proxyUri.getHost(), proxyUri.getPort(), proxyUri.getScheme());
        DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
        return HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
    }

    protected static CloseableHttpClient createClient() {
        String httpProxy = System.getenv("HTTP_PROXY");
        String httpsProxy = System.getenv("HTTPS_PROXY");
        if (httpsProxy != null) {
            try {
                return HttpClientConnection.createClientWithProxy(httpsProxy);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("HTTPS_PROXY is not valid!", e);
            }
        }
        if (httpProxy != null) {
            try {
                return HttpClientConnection.createClientWithProxy(httpProxy);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("HTTP_PROXY is not valid!", e);
            }
        }
        return HttpClients.createDefault();
    }

    protected Map<String, String> toJavaMap(Header[] headers) {
        HashMap<String, String> javaMapHeaders = new HashMap<String, String>();
        for (Header h : headers) {
            javaMapHeaders.put(h.getName(), h.getValue());
        }
        return javaMapHeaders;
    }

    public void close() {
        this.getExecutorService().shutdownNow();
    }

    static class PreemptiveAuth
    implements HttpRequestInterceptor {
        PreemptiveAuth() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            if (authState.getAuthScheme() == null) {
                AuthScheme authScheme = (AuthScheme)context.getAttribute("preemptive-auth");
                CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
                if (authScheme != null) {
                    Credentials creds = credsProvider.getCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()));
                    if (creds == null) {
                        throw new HttpException("No credentials for preemptive authentication");
                    }
                    authState.setAuthScheme(authScheme);
                    authState.setCredentials(creds);
                }
            }
        }
    }

    public static class Provider
    implements ConnectionProvider {
        public Connection getConnection() {
            return new HttpClientConnection();
        }
    }
}

