/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.api.request.config;

import com.heroku.api.Heroku;
import com.heroku.api.exception.RequestFailedException;
import com.heroku.api.http.Http;
import com.heroku.api.http.HttpUtil;
import com.heroku.api.parser.Json;
import com.heroku.api.request.Request;
import com.heroku.api.request.RequestConfig;
import java.util.Collections;
import java.util.Map;

public class ConfigList
implements Request<Map<String, String>> {
    private final RequestConfig config;

    public ConfigList(String appName) {
        this.config = new RequestConfig().app(appName);
    }

    @Override
    public Http.Method getHttpMethod() {
        return Http.Method.GET;
    }

    @Override
    public String getEndpoint() {
        return Heroku.Resource.ConfigVars.format(this.config.getAppName());
    }

    @Override
    public boolean hasBody() {
        return false;
    }

    @Override
    public String getBody() {
        throw HttpUtil.noBody();
    }

    @Override
    public Map<String, Object> getBodyAsMap() {
        throw HttpUtil.noBody();
    }

    @Override
    public Http.Accept getResponseType() {
        return Http.Accept.JSON;
    }

    @Override
    public Map<String, String> getHeaders() {
        return Collections.emptyMap();
    }

    @Override
    public Map<String, String> getResponse(byte[] bytes, int status, Map<String, String> responseHeaders) {
        if (status == Http.Status.OK.statusCode) {
            return (Map)Json.parse(bytes, this.getClass());
        }
        if (status == Http.Status.NOT_FOUND.statusCode) {
            throw new RequestFailedException("Application not found.", status, bytes);
        }
        if (status == Http.Status.FORBIDDEN.statusCode) {
            throw new RequestFailedException("Insufficient privileges to \"" + this.config.getAppName() + "\"", status, bytes);
        }
        throw new RequestFailedException("Unable to list config failed.", status, bytes);
    }
}

