/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.api.request;

import com.heroku.api.Heroku;
import com.heroku.api.parser.Json;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public class RequestConfig {
    private String appName;
    private final Map<Heroku.RequestKey, Either> config = new EnumMap<Heroku.RequestKey, Either>(Heroku.RequestKey.class);

    public RequestConfig app(String appName) {
        this.appName = appName;
        return this;
    }

    public String getAppName() {
        return this.appName;
    }

    public RequestConfig with(Heroku.RequestKey key, String value) {
        RequestConfig newConfig = this.copy();
        newConfig.config.put(key, new Either(value));
        return newConfig;
    }

    public RequestConfig with(Heroku.RequestKey key, Map<Heroku.RequestKey, Either> value) {
        RequestConfig newConfig = this.copy();
        newConfig.config.put(key, new Either(value));
        return newConfig;
    }

    public RequestConfig withOptions(Heroku.RequestKey key, Map<String, String> data) {
        RequestConfig newConfig = this.copy();
        newConfig.config.put(key, new Either(new Data(data)));
        return newConfig;
    }

    public String get(Heroku.RequestKey key) {
        return this.config.get((Object)key).string();
    }

    public Map<Heroku.RequestKey, Either> getMap(Heroku.RequestKey key) {
        return this.config.get((Object)key).map();
    }

    public boolean has(Heroku.RequestKey key) {
        return this.config.containsKey((Object)key);
    }

    public String asJson() {
        return Json.encode(this.asMap());
    }

    public Map<String, Object> asMap() {
        return this.stringifyMap(this.config);
    }

    private Map<String, Object> stringifyMap(Map<Heroku.RequestKey, Either> map) {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        for (Heroku.RequestKey key : map.keySet()) {
            Either either = map.get((Object)key);
            if (either.is(String.class).booleanValue()) {
                jsonMap.put(key.queryParameter, either.string());
                continue;
            }
            if (either.is(Boolean.class).booleanValue()) {
                jsonMap.put(key.queryParameter, either.bool());
                continue;
            }
            if (either.is(Data.class).booleanValue()) {
                jsonMap.put(key.queryParameter, either.data());
                continue;
            }
            jsonMap.put(key.queryParameter, this.stringifyMap(either.map()));
        }
        return jsonMap;
    }

    private RequestConfig copy() {
        RequestConfig newConfig = new RequestConfig();
        newConfig.app(this.appName);
        newConfig.config.putAll(this.config);
        return newConfig;
    }

    public static class Data {
        private Map<String, String> map;

        public Data(Map<String, String> map) {
            this.map = map;
        }

        public Map<String, String> map() {
            return this.map;
        }
    }

    public static class Either {
        private Class type;
        private String string;
        private Boolean bool;
        private Data data;
        private Map<Heroku.RequestKey, Either> map;

        public Either(Boolean value) {
            this.type = Boolean.class;
            this.bool = value;
        }

        public Either(String value) {
            this.type = String.class;
            this.string = value;
        }

        public Either(Data data) {
            this.type = Data.class;
            this.data = data;
        }

        public Either(Map<Heroku.RequestKey, Either> value) {
            this.type = Map.class;
            this.map = value;
        }

        public String string() {
            return this.string;
        }

        public Boolean bool() {
            return this.bool;
        }

        public Map<String, String> data() {
            return this.data.map();
        }

        public Map<Heroku.RequestKey, Either> map() {
            return this.map;
        }

        public Boolean is(Class c) {
            return c.equals(this.type);
        }
    }
}

