/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.widget;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.TextureView;
import android.view.View;
import com.serenegiant.widget.CameraViewInterface;
import com.serenegiant.widget.IAspectRatioView;

public class AspectRatioTextureView
extends TextureView
implements IAspectRatioView {
    private static final boolean DEBUG = false;
    private static final String TAG = AspectRatioTextureView.class.getSimpleName();
    private double mRequestedAspect = -1.0;
    private CameraViewInterface.Callback mCallback;

    public AspectRatioTextureView(Context context) {
        this(context, null, 0);
    }

    public AspectRatioTextureView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AspectRatioTextureView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    public void setAspectRatio(double aspectRatio) {
        if (aspectRatio < 0.0) {
            throw new IllegalArgumentException();
        }
        float diff = 1.0E-6f;
        if (Math.abs(this.mRequestedAspect - aspectRatio) > (double)diff) {
            this.mRequestedAspect = aspectRatio;
            new Handler(Looper.getMainLooper()).post(() -> this.requestLayout());
        }
    }

    @Override
    public void setAspectRatio(int width, int height) {
        this.setAspectRatio((double)width / (double)height);
    }

    @Override
    public double getAspectRatio() {
        return this.mRequestedAspect;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mRequestedAspect > 0.0) {
            int vertPadding;
            int initialWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int initialHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int horizPadding = this.getPaddingLeft() + this.getPaddingRight();
            double viewAspectRatio = (double)(initialWidth -= horizPadding) / (double)(initialHeight -= (vertPadding = this.getPaddingTop() + this.getPaddingBottom()));
            double aspectDiff = this.mRequestedAspect / viewAspectRatio - 1.0;
            if (Math.abs(aspectDiff) > 0.01) {
                if (aspectDiff > 0.0) {
                    initialHeight = (int)((double)initialWidth / this.mRequestedAspect);
                } else {
                    initialWidth = (int)((double)initialHeight * this.mRequestedAspect);
                }
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(initialWidth += horizPadding), (int)0x40000000);
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(initialHeight += vertPadding), (int)0x40000000);
            }
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }
}

