/*
 * Decompiled with CFR 0.152.
 */
package hb.xvideoplayer;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.ContextWrapper;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.provider.Settings;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.view.ContextThemeWrapper;
import android.view.WindowManager;
import java.util.Formatter;
import java.util.Locale;

class MxUtils {
    MxUtils() {
    }

    static String stringForTime(long milliseconds) {
        if (milliseconds < 0L || milliseconds >= 86400000L) {
            return "00:00";
        }
        int minute = (int)((milliseconds /= 1000L) / 60L);
        int hour = minute / 60;
        int second = (int)(milliseconds % 60L);
        minute %= 60;
        StringBuilder stringBuilder = new StringBuilder();
        Formatter mFormatter = new Formatter(stringBuilder, Locale.getDefault());
        if (hour > 0) {
            return mFormatter.format("%02d:%02d:%02d", hour, minute, second).toString();
        }
        return mFormatter.format("%02d:%02d", minute, second).toString();
    }

    static boolean isWifiConnected(Context context) {
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = manager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.getType() == 1;
    }

    static AppCompatActivity getAppComptActivity(Context context) {
        if (context == null) {
            return null;
        }
        if (context instanceof AppCompatActivity) {
            return (AppCompatActivity)context;
        }
        if (context instanceof ContextThemeWrapper) {
            return MxUtils.getAppComptActivity(((ContextThemeWrapper)context).getBaseContext());
        }
        return null;
    }

    static Activity scanForActivity(Context context) {
        if (context == null) {
            return null;
        }
        if (context instanceof Activity) {
            return (Activity)context;
        }
        if (context instanceof ContextWrapper) {
            return MxUtils.scanForActivity(((ContextWrapper)context).getBaseContext());
        }
        return null;
    }

    static boolean isNetworkConnected(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager == null) {
            return false;
        }
        NetworkInfo[] networkInfo = connectivityManager.getAllNetworkInfo();
        if (networkInfo != null && networkInfo.length > 0) {
            for (NetworkInfo aNetworkInfo : networkInfo) {
                if (aNetworkInfo.getState() != NetworkInfo.State.CONNECTED) continue;
                return true;
            }
        }
        return false;
    }

    static void setScreenManualMode(Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        try {
            int mode = Settings.System.getInt((ContentResolver)contentResolver, (String)"screen_brightness_mode");
            if (mode == 1) {
                Settings.System.putInt((ContentResolver)contentResolver, (String)"screen_brightness_mode", (int)0);
            }
        }
        catch (Settings.SettingNotFoundException e) {
            e.printStackTrace();
        }
    }

    static int getScreenBrightness(Activity activity) {
        int nowBrightnessValue = 0;
        ContentResolver resolver = activity.getContentResolver();
        try {
            nowBrightnessValue = Settings.System.getInt((ContentResolver)resolver, (String)"screen_brightness");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nowBrightnessValue;
    }

    static void setWindowBrightness(Activity activity, float brightness) {
        WindowManager.LayoutParams lp = activity.getWindow().getAttributes();
        lp.screenBrightness = brightness / 255.0f;
        if (lp.screenBrightness > 1.0f) {
            lp.screenBrightness = 1.0f;
        } else if ((double)lp.screenBrightness < 0.1) {
            lp.screenBrightness = 0.1f;
        }
        activity.getWindow().setAttributes(lp);
    }
}

