/*
 * Decompiled with CFR 0.152.
 */
package hb.xvideoplayer;

import android.graphics.Point;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import android.view.Surface;
import hb.xvideoplayer.MxMediaPlayerListener;
import hb.xvideoplayer.MxTextureView;
import hb.xvideoplayer.MxVideoPlayerManager;
import java.util.Map;
import tv.danmaku.ijk.media.player.IMediaPlayer;
import tv.danmaku.ijk.media.player.IjkMediaPlayer;

public class MxMediaManager
implements IMediaPlayer.OnPreparedListener,
IMediaPlayer.OnCompletionListener,
IMediaPlayer.OnBufferingUpdateListener,
IMediaPlayer.OnSeekCompleteListener,
IMediaPlayer.OnErrorListener,
IMediaPlayer.OnVideoSizeChangedListener,
IMediaPlayer.OnInfoListener {
    private static String TAG = "MxVideoPlayer";
    public static final int HANDLER_PREPARE = 0;
    public static final int HANDLER_SET_DISPLAY = 1;
    public static final int HANDLER_RELEASE = 2;
    private static MxMediaManager mxMediaManager;
    private IjkMediaPlayer mMediaPlayer = new IjkMediaPlayer();
    private MediaHandler mMediaHandler;
    private Handler mainThreadHandler;
    public static MxTextureView mTextureView;
    public int mLastState;
    public boolean mIsShowBottomProgressBar = true;
    public int mCurVideoWidth = 0;
    public int mCurVideoHeight = 0;
    public int bufferPercent = 0;
    public int mVideoRotation;
    public int mBackUpBufferState = -1;

    private MxMediaManager() {
        HandlerThread mMediaHandlerThread = new HandlerThread(TAG);
        mMediaHandlerThread.start();
        this.mMediaHandler = new MediaHandler(mMediaHandlerThread.getLooper());
        this.mainThreadHandler = new Handler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MxMediaManager getInstance() {
        if (mxMediaManager != null) return mxMediaManager;
        Class<MxMediaManager> clazz = MxMediaManager.class;
        synchronized (MxMediaManager.class) {
            if (mxMediaManager != null) return mxMediaManager;
            mxMediaManager = new MxMediaManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mxMediaManager;
        }
    }

    public IjkMediaPlayer getPlayer() {
        return this.mMediaPlayer;
    }

    public void prepare(String url, Map<String, String> mapHeapData, boolean loop) {
        if (!TextUtils.isEmpty((CharSequence)url)) {
            Message msg = Message.obtain();
            msg.obj = new DataBean(url, mapHeapData, loop);
            msg.what = 0;
            this.mMediaHandler.sendMessage(msg);
        }
    }

    public void releaseMediaPlayer() {
        Message msg = Message.obtain();
        msg.what = 2;
        this.mMediaHandler.sendMessage(msg);
    }

    public void setDisplay(Surface holder) {
        Message msg = Message.obtain();
        msg.what = 1;
        msg.obj = holder;
        this.mMediaHandler.sendMessage(msg);
    }

    public void onPrepared(IMediaPlayer iMediaPlayer) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                MxMediaPlayerListener listener = MxVideoPlayerManager.getCurrentListener();
                if (listener != null) {
                    listener.onPrepared();
                }
            }
        });
    }

    public void onBufferingUpdate(IMediaPlayer iMediaPlayer, final int percent) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                MxMediaPlayerListener listener = MxVideoPlayerManager.getCurrentListener();
                if (listener != null) {
                    listener.onBufferingUpdate(percent);
                }
            }
        });
    }

    public void onCompletion(IMediaPlayer iMediaPlayer) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                MxMediaPlayerListener listener = MxVideoPlayerManager.getCurrentListener();
                if (listener != null) {
                    listener.onAutoCompletion();
                }
            }
        });
    }

    public boolean onError(IMediaPlayer iMediaPlayer, final int what, final int extra) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                MxMediaPlayerListener listener = MxVideoPlayerManager.getCurrentListener();
                if (listener != null) {
                    listener.onError(what, extra);
                }
            }
        });
        return true;
    }

    public boolean onInfo(IMediaPlayer iMediaPlayer, final int what, final int extra) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                MxMediaPlayerListener listener = MxVideoPlayerManager.getCurrentListener();
                if (listener != null) {
                    listener.onInfo(what, extra);
                }
            }
        });
        return false;
    }

    public void onSeekComplete(IMediaPlayer iMediaPlayer) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                MxMediaPlayerListener listener = MxVideoPlayerManager.getCurrentListener();
                if (listener != null) {
                    listener.onSeekComplete();
                }
            }
        });
    }

    public void onVideoSizeChanged(IMediaPlayer mp, int width, int height, int sar_num, int sar_den) {
        this.mCurVideoWidth = mp.getVideoWidth();
        this.mCurVideoHeight = mp.getVideoHeight();
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                MxMediaPlayerListener listener = MxVideoPlayerManager.getCurrentListener();
                if (listener != null) {
                    listener.onVideoSizeChanged();
                }
            }
        });
    }

    public Point getVideoSize() {
        if (this.mCurVideoWidth != 0 && this.mCurVideoHeight != 0) {
            return new Point(this.mCurVideoWidth, this.mCurVideoHeight);
        }
        return null;
    }

    private class DataBean {
        String url;
        Map<String, String> mapHeadData;
        boolean looping;

        DataBean(String url, Map<String, String> mapHeadData, boolean loop) {
            this.url = url;
            this.mapHeadData = mapHeadData;
            this.looping = loop;
        }
    }

    private class MediaHandler
    extends Handler {
        public MediaHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 0: {
                    try {
                        MxMediaManager.this.mCurVideoWidth = 0;
                        MxMediaManager.this.mCurVideoHeight = 0;
                        MxMediaManager.this.mMediaPlayer.release();
                        MxMediaManager.this.mMediaPlayer = new IjkMediaPlayer();
                        MxMediaManager.this.mMediaPlayer.setAudioStreamType(3);
                        DataBean data = (DataBean)msg.obj;
                        MxMediaManager.this.mMediaPlayer.setDataSource(data.url, data.mapHeadData);
                        MxMediaManager.this.mMediaPlayer.setLooping(data.looping);
                        MxMediaManager.this.mMediaPlayer.setOnPreparedListener((IMediaPlayer.OnPreparedListener)MxMediaManager.this);
                        MxMediaManager.this.mMediaPlayer.setOnCompletionListener((IMediaPlayer.OnCompletionListener)MxMediaManager.this);
                        MxMediaManager.this.mMediaPlayer.setOnBufferingUpdateListener((IMediaPlayer.OnBufferingUpdateListener)MxMediaManager.this);
                        MxMediaManager.this.mMediaPlayer.setScreenOnWhilePlaying(true);
                        MxMediaManager.this.mMediaPlayer.setOnSeekCompleteListener((IMediaPlayer.OnSeekCompleteListener)MxMediaManager.this);
                        MxMediaManager.this.mMediaPlayer.setOnErrorListener((IMediaPlayer.OnErrorListener)MxMediaManager.this);
                        MxMediaManager.this.mMediaPlayer.setOnInfoListener((IMediaPlayer.OnInfoListener)MxMediaManager.this);
                        MxMediaManager.this.mMediaPlayer.setOnVideoSizeChangedListener((IMediaPlayer.OnVideoSizeChangedListener)MxMediaManager.this);
                        MxMediaManager.this.mMediaPlayer.prepareAsync();
                        MxMediaManager.this.mMediaPlayer.setOption(2, "reconnect", 1L);
                        MxMediaManager.this.mMediaPlayer.setOption(1, "safe", 0L);
                        MxMediaManager.this.mMediaPlayer.setOption(1, "protocol_whitelist", "concat,http,tcp,https,tls,file");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Log.e((String)TAG, (String)("handleMessage: prepare video error: " + e.getMessage()));
                    }
                    break;
                }
                case 1: {
                    if (msg.obj == null) {
                        MxMediaManager.getInstance().mMediaPlayer.setSurface(null);
                        break;
                    }
                    Surface holder = (Surface)msg.obj;
                    if (!holder.isValid()) break;
                    MxMediaManager.this.mMediaPlayer.setSurface(holder);
                    MxMediaManager.this.mainThreadHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            mTextureView.requestLayout();
                        }
                    });
                    break;
                }
                case 2: {
                    MxMediaManager.this.mMediaPlayer.reset();
                    MxMediaManager.this.mMediaPlayer.release();
                }
            }
        }
    }
}

