/*
 * Decompiled with CFR 0.152.
 */
package hb.xvideoplayer;

import android.content.Context;
import android.graphics.Point;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;

public class MxImageView
extends ImageView {
    protected static final String TAG = "MxImageView";
    protected static final boolean DEBUG = false;
    protected Point mVideoSize;

    public MxImageView(Context context) {
        this(context, null);
    }

    public MxImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    protected void init() {
        this.mVideoSize = new Point(0, 0);
    }

    public void setVideoSize(Point videoSize) {
        if (videoSize != null && !this.mVideoSize.equals((Object)videoSize)) {
            this.mVideoSize = videoSize;
            this.requestLayout();
        }
    }

    public void setRotation(float rotation) {
        if (rotation != this.getRotation()) {
            super.setRotation(rotation);
            this.requestLayout();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int viewRotation = (int)this.getRotation();
        if (viewRotation == 90 || viewRotation == 270) {
            int tempMeasureSpec = widthMeasureSpec;
            widthMeasureSpec = heightMeasureSpec;
            heightMeasureSpec = tempMeasureSpec;
        }
        int videoWidth = this.mVideoSize.x;
        int videoHeight = this.mVideoSize.y;
        int width = MxImageView.getDefaultSize((int)videoWidth, (int)widthMeasureSpec);
        int height = MxImageView.getDefaultSize((int)videoHeight, (int)heightMeasureSpec);
        if (videoWidth > 0 && videoHeight > 0) {
            int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
            if (widthSpecMode == 0x40000000 && heightSpecMode == 0x40000000) {
                height = heightSpecSize;
                width = widthSpecSize;
                if (videoWidth * height < width * videoHeight) {
                    width = height * videoWidth / videoHeight;
                } else if (videoWidth * height > width * videoHeight) {
                    height = width * videoHeight / videoWidth;
                }
            } else if (widthSpecMode == 0x40000000) {
                width = widthSpecSize;
                height = width * videoHeight / videoWidth;
                if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                    height = heightSpecSize;
                    width = height * videoWidth / videoHeight;
                }
            } else if (heightSpecMode == 0x40000000) {
                height = heightSpecSize;
                width = height * videoWidth / videoHeight;
                if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                    width = widthSpecSize;
                    height = width * videoHeight / videoWidth;
                }
            } else {
                width = videoWidth;
                height = videoHeight;
                if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                    height = heightSpecSize;
                    width = height * videoWidth / videoHeight;
                }
                if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                    width = widthSpecSize;
                    height = width * videoHeight / videoWidth;
                }
            }
        }
        this.setMeasuredDimension(width, height);
    }
}

