/*
 * Decompiled with CFR 0.152.
 */
package hb.xvideoplayer;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import hb.xvideoplayer.MxMediaManager;
import hb.xvideoplayer.MxUtils;
import hb.xvideoplayer.MxVideoPlayer;
import java.util.Timer;
import java.util.TimerTask;
import mxvideoplayer.app.com.xvideoplayer.R;

public class MxTvPlayerWidget
extends MxVideoPlayer {
    private static final int VOLUME_ITEM = 2;
    private static final int PROGRESS_ITEM = 15;
    protected static Timer DISMISS_CONTROL_VIEW_TIMER;
    public ProgressBar mBottomProgressBar;
    public ProgressBar mLoadingProgressBar;
    public TextView mTitleTextView;
    public ImageView mThumbImageView;
    protected Dialog mProgressDialog;
    protected Dialog mVolumeDialog;
    protected ProgressBar mDialogVolumeProgressBar;
    protected ProgressBar mDialogProgressBar;
    protected TextView mDialogSeekTime;
    protected TextView mDialogTotalTime;
    protected ImageView mDialogIcon;
    protected ImageView mDialogVolumeIcon;
    private int mTvDownPosition = 0;
    private int mTvSeekPosition;
    private OnPlayStateListener mListener;
    private boolean mIsShowBottomProgressBar;
    protected DismissControlViewTimerTask mDismissControlViewTimerTask;
    private Runnable mDismissVolumeCallback = new Runnable(){

        @Override
        public void run() {
            MxTvPlayerWidget.this.dismissVolumeDialog();
        }
    };

    public MxTvPlayerWidget(Context context) {
        super(context);
    }

    public MxTvPlayerWidget(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public void initView(Context context) {
        super.initView(context);
        this.mBottomProgressBar = (ProgressBar)this.findViewById(R.id.mx_bottom_progress);
        this.mTitleTextView = (TextView)this.findViewById(R.id.mx_title);
        this.mThumbImageView = (ImageView)this.findViewById(R.id.mx_thumb);
        this.mLoadingProgressBar = (ProgressBar)this.findViewById(R.id.mx_loading);
    }

    public boolean startPlay(String url, Object ... objects) {
        if (objects.length == 0) {
            return false;
        }
        if (super.startPlay(url, 0, objects)) {
            this.mTitleTextView.setText((CharSequence)objects[0].toString());
            return true;
        }
        return false;
    }

    public boolean autoStartPlay(String url, Object ... objects) {
        if (this.startPlay(url, objects)) {
            this.mPlayControllerButton.performClick();
            return true;
        }
        return false;
    }

    public void setOnPlayStateListener(OnPlayStateListener listener) {
        this.mListener = listener;
    }

    public boolean requestKeyDown(int keyCode, KeyEvent event) {
        boolean result = false;
        switch (keyCode) {
            case 20: 
            case 25: {
                this.downVolume();
                result = true;
                break;
            }
            case 19: 
            case 24: {
                this.upVolume();
                result = true;
                break;
            }
            case 22: {
                this.cancelProgressTimer();
                if (this.mTvDownPosition == 0) {
                    this.mTvDownPosition = this.getCurrentPositionWhenPlaying();
                }
                this.doReverse(event.getRepeatCount());
                result = true;
                break;
            }
            case 21: {
                this.cancelProgressTimer();
                if (this.mTvDownPosition == 0) {
                    this.mTvDownPosition = this.getCurrentPositionWhenPlaying();
                }
                this.doForward(event.getRepeatCount());
                result = true;
                break;
            }
            case 4: {
                result = true;
                MxUtils.getAppComptActivity(this.getContext()).onBackPressed();
                break;
            }
        }
        return result;
    }

    public boolean requestKeyUp(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 66: {
                this.mPlayControllerButton.performClick();
                break;
            }
            case 21: 
            case 22: {
                this.startProgressTimer();
                this.setProgress();
                this.dismissProgressDialog();
                break;
            }
            case 19: 
            case 20: 
            case 24: 
            case 25: {
                this.mHandler.removeCallbacks(this.mDismissVolumeCallback);
                this.mHandler.postDelayed(this.mDismissVolumeCallback, 2000L);
                break;
            }
            default: {
                this.onClickUiToggle();
                this.startDismissControlViewTimer();
            }
        }
        return false;
    }

    private void downVolume() {
        int currentVolume = this.mAudioManager.getStreamVolume(3);
        int maxVolume = this.mAudioManager.getStreamMaxVolume(3);
        this.mAudioManager.setStreamVolume(3, currentVolume - 2, 0);
        int volumePercent = (currentVolume - 2) * 100 / maxVolume;
        this.showVolumeDialog(2.0f, volumePercent);
    }

    private void upVolume() {
        int currentVolume = this.mAudioManager.getStreamVolume(3);
        int maxVolume = this.mAudioManager.getStreamMaxVolume(3);
        this.mAudioManager.setStreamVolume(3, currentVolume + 2, 0);
        int volumePercent = (currentVolume + 2) * 100 / maxVolume;
        this.showVolumeDialog(2.0f, volumePercent);
    }

    private void doReverse(int count) {
        int totalTimeDuration;
        int seekTimePosition;
        if (count <= 0) {
            count = 1;
        }
        if ((seekTimePosition = this.mTvDownPosition + 15 * count * ((totalTimeDuration = this.getDuration()) / this.mScreenWidth)) > totalTimeDuration) {
            seekTimePosition = totalTimeDuration;
        }
        String seekTime = MxUtils.stringForTime(seekTimePosition);
        String totalTime = MxUtils.stringForTime(totalTimeDuration);
        this.showProgressDialog(15.0f, seekTime, seekTimePosition, totalTime, totalTimeDuration);
    }

    private void doForward(int count) {
        int totalTimeDuration;
        int seekTimePosition;
        if (count <= 0) {
            count = 1;
        }
        if ((seekTimePosition = this.mTvDownPosition - 15 * count * ((totalTimeDuration = this.getDuration()) / this.mScreenWidth)) < 0) {
            seekTimePosition = 0;
        }
        String seekTime = MxUtils.stringForTime(seekTimePosition);
        String totalTime = MxUtils.stringForTime(totalTimeDuration);
        this.showProgressDialog(-15.0f, seekTime, seekTimePosition, totalTime, totalTimeDuration);
    }

    private void setProgress() {
        MxMediaManager.getInstance().getPlayer().seekTo((long)this.mTvSeekPosition);
        this.mProgressBar.setProgress(this.mDialogProgressBar.getProgress());
        this.mTvDownPosition = 0;
    }

    @Override
    public void setUiPlayState(int state) {
        super.setUiPlayState(state);
        switch (this.mCurrentState) {
            case 0: {
                this.setAllControlsVisible(0, 4, 0, 4, 0, 4);
                this.updateStartImage();
                break;
            }
            case 1: {
                this.setAllControlsVisible(0, 4, 4, 0, 0, 4);
                this.startDismissControlViewTimer();
                this.mBottomProgressBar.setProgress(0);
                break;
            }
            case 2: {
                this.setAllControlsVisible(0, 0, 0, 4, 4, 4);
                this.updateStartImage();
                this.startDismissControlViewTimer();
                break;
            }
            case 5: {
                this.setAllControlsVisible(0, 0, 0, 4, 4, 4);
                this.updateStartImage();
                this.cancelDismissControlViewTimer();
                break;
            }
            case 7: {
                this.setAllControlsVisible(4, 4, 0, 4, 4, 4);
                this.updateStartImage();
                break;
            }
            case 6: {
                this.setAllControlsVisible(0, 0, 0, 4, 0, 4);
                this.updateStartImage();
                this.cancelDismissControlViewTimer();
                this.mBottomProgressBar.setProgress(100);
                break;
            }
            case 3: {
                this.setAllControlsVisible(0, 0, 4, 0, 4, 4);
                break;
            }
        }
    }

    private void onClickUiToggle() {
        if (this.mCurrentState == 1) {
            if (this.mBottomContainer.getVisibility() == 0) {
                this.setAllControlsVisible(0, 4, 4, 0, 0, 4);
            } else {
                this.setAllControlsVisible(0, 4, 4, 0, 0, 4);
            }
        } else if (this.mCurrentState == 2) {
            if (this.mBottomContainer.getVisibility() == 0) {
                this.setAllControlsVisible(4, 4, 4, 4, 4, 0);
            } else {
                this.setAllControlsVisible(0, 0, 0, 4, 4, 4);
                this.updateStartImage();
            }
        } else if (this.mCurrentState == 5) {
            if (this.mBottomProgressBar.getVisibility() == 0) {
                this.setAllControlsVisible(4, 4, 4, 4, 4, 4);
            } else {
                this.setAllControlsVisible(0, 0, 0, 4, 4, 4);
                this.updateStartImage();
            }
        } else if (this.mCurrentState == 6) {
            if (this.mBottomContainer.getVisibility() == 0) {
                this.setAllControlsVisible(4, 4, 0, 4, 0, 0);
                this.updateStartImage();
            } else {
                this.setAllControlsVisible(0, 0, 0, 4, 0, 4);
                this.updateStartImage();
            }
        } else if (this.mCurrentState == 3) {
            if (this.mBottomContainer.getVisibility() == 0) {
                this.setAllControlsVisible(4, 4, 4, 0, 4, 0);
                this.updateStartImage();
            } else {
                this.setAllControlsVisible(0, 0, 4, 0, 4, 4);
            }
        }
    }

    private void cancelDismissControlViewTimer() {
        if (DISMISS_CONTROL_VIEW_TIMER != null) {
            DISMISS_CONTROL_VIEW_TIMER.cancel();
        }
        if (this.mDismissControlViewTimerTask != null) {
            this.mDismissControlViewTimerTask.cancel();
        }
    }

    private void startDismissControlViewTimer() {
        this.cancelDismissControlViewTimer();
        DISMISS_CONTROL_VIEW_TIMER = new Timer();
        this.mDismissControlViewTimerTask = new DismissControlViewTimerTask();
        DISMISS_CONTROL_VIEW_TIMER.schedule((TimerTask)this.mDismissControlViewTimerTask, 2500L);
    }

    private void updateStartImage() {
        if (this.mCurrentState == 2) {
            this.mPlayControllerButton.setImageResource(R.drawable.mx_click_pause_selector);
        } else if (this.mCurrentState == 7) {
            this.mPlayControllerButton.setImageResource(R.drawable.mx_click_error_selector);
        } else {
            this.mPlayControllerButton.setImageResource(R.drawable.mx_click_play_selector);
        }
    }

    public void setAllControlsVisible(int topCon, int bottomCon, int startBtn, int loadingPro, int thumbImg, int bottomPro) {
        this.mTopContainer.setVisibility(topCon);
        this.mBottomContainer.setVisibility(bottomCon);
        this.mPlayControllerButton.setVisibility(startBtn);
        this.mLoadingProgressBar.setVisibility(loadingPro);
        if (thumbImg == 0) {
            this.mThumbImageView.setVisibility(thumbImg);
        } else {
            this.mThumbImageView.setVisibility(8);
        }
        if (this.mIsShowBottomProgressBar) {
            this.mBottomProgressBar.setVisibility(bottomPro);
        } else {
            this.mBottomProgressBar.setVisibility(8);
        }
    }

    @Override
    public void setProgressAndTime(int progress, int secProgress, int currentTime, int totalTime) {
        super.setProgressAndTime(progress, secProgress, currentTime, totalTime);
        if (progress != 0) {
            this.mBottomProgressBar.setProgress(progress);
        }
        if (secProgress != 0) {
            this.mBottomProgressBar.setSecondaryProgress(secProgress);
        }
    }

    @Override
    protected void showBrightnessDialog(float v, int brightnessPercent) {
    }

    @Override
    protected int getLayoutId() {
        return R.layout.mx_video_layout_tv;
    }

    @Override
    protected void initAttributeSet(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray attr = context.obtainStyledAttributes(attrs, R.styleable.MxVideoPlayer);
        Drawable drawable2 = attr.getDrawable(R.styleable.MxVideoPlayer_progress_drawable);
        this.setProgressDrawable(drawable2);
        int defaultTextSize = context.getResources().getDimensionPixelSize(R.dimen.mx_title_textSize);
        int size = attr.getDimensionPixelSize(R.styleable.MxVideoPlayer_title_size, defaultTextSize);
        this.setTitleSize(size);
        boolean isShowBottomProgressBar = attr.getBoolean(R.styleable.MxVideoPlayer_showBottomProgress, true);
        this.setBottomProgressBarVisibility(isShowBottomProgressBar);
        attr.recycle();
    }

    private void setProgressDrawable(Drawable drawable2) {
        if (drawable2 != null) {
            this.mProgressBar.setProgressDrawable(drawable2);
        }
    }

    private void setTitleSize(int size) {
        this.mTitleTextView.setTextSize(0, (float)size);
    }

    public void setBottomProgressBarVisibility(boolean visibility) {
        this.mIsShowBottomProgressBar = visibility;
    }

    @Override
    protected boolean isShowNetworkStateDialog() {
        if (!this.mPlayUrl.startsWith("file") && !MxUtils.isNetworkConnected(this.getContext())) {
            this.showNetworkTipDialog();
            return true;
        }
        return false;
    }

    private void showNetworkTipDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
        builder.setMessage((CharSequence)this.getResources().getString(R.string.tips_not_net));
        builder.setPositiveButton((CharSequence)this.getResources().getString(R.string.tips_not_network_ok), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        builder.create().show();
    }

    @Override
    protected void showProgressDialog(float deltaX, String seekTime, int seekTimePosition, String totalTime, int totalTimeDuration) {
        if (this.mProgressDialog == null) {
            View localView = View.inflate((Context)this.getContext(), (int)R.layout.mx_tv_progress_dialog, null);
            this.mDialogProgressBar = (ProgressBar)localView.findViewById(R.id.duration_progressbar);
            this.mDialogSeekTime = (TextView)localView.findViewById(R.id.tv_current);
            this.mDialogTotalTime = (TextView)localView.findViewById(R.id.tv_duration);
            this.mDialogIcon = (ImageView)localView.findViewById(R.id.duration_image_tip);
            this.mProgressDialog = new Dialog(this.getContext(), R.style.mx_style_dialog_progress);
            this.mProgressDialog.setContentView(localView);
            if (this.mProgressDialog.getWindow() != null) {
                this.mProgressDialog.getWindow().addFlags(8);
                this.mProgressDialog.getWindow().addFlags(32);
                this.mProgressDialog.getWindow().addFlags(16);
                this.mProgressDialog.getWindow().setLayout(-2, -2);
            }
            WindowManager.LayoutParams localLayoutParams = this.mProgressDialog.getWindow().getAttributes();
            localLayoutParams.gravity = 49;
            localLayoutParams.y = this.getResources().getDimensionPixelOffset(R.dimen.mx_tv_progress_dialog_margin_top);
            localLayoutParams.width = this.getContext().getResources().getDimensionPixelOffset(R.dimen.tv_progress_dialog_width);
            this.mProgressDialog.getWindow().setAttributes(localLayoutParams);
        }
        if (!this.mProgressDialog.isShowing()) {
            this.mProgressDialog.show();
        }
        this.mDialogSeekTime.setText((CharSequence)seekTime);
        this.mDialogTotalTime.setText((CharSequence)String.format(" / %s", totalTime));
        this.mTvSeekPosition = seekTimePosition;
        int curProgress = seekTimePosition * 100 / totalTimeDuration;
        this.mDialogProgressBar.setProgress(totalTimeDuration <= 0 ? 0 : curProgress);
        if (deltaX > 0.0f) {
            this.mDialogIcon.setBackgroundResource(R.drawable.mx_forward_icon);
        } else {
            this.mDialogIcon.setBackgroundResource(R.drawable.mx_backward_icon);
        }
    }

    @Override
    protected void showVolumeDialog(float v, int volumePercent) {
        if (this.mVolumeDialog == null) {
            View localView = View.inflate((Context)this.getContext(), (int)R.layout.mx_tv_volume_dialog, null);
            this.mDialogVolumeProgressBar = (ProgressBar)localView.findViewById(R.id.volume_progressbar);
            this.mDialogVolumeIcon = (ImageView)localView.findViewById(R.id.mx_volume_icon);
            this.mVolumeDialog = new Dialog(this.getContext(), R.style.mx_style_dialog_progress);
            this.mVolumeDialog.setContentView(localView);
            if (this.mVolumeDialog.getWindow() != null) {
                this.mVolumeDialog.getWindow().addFlags(8);
                this.mVolumeDialog.getWindow().addFlags(32);
                this.mVolumeDialog.getWindow().addFlags(16);
                this.mVolumeDialog.getWindow().setLayout(-2, -2);
            }
            WindowManager.LayoutParams localLayoutParams = this.mVolumeDialog.getWindow().getAttributes();
            localLayoutParams.gravity = 49;
            localLayoutParams.y = this.getContext().getResources().getDimensionPixelOffset(R.dimen.mx_tv_progress_dialog_margin_top);
            localLayoutParams.width = this.getContext().getResources().getDimensionPixelOffset(R.dimen.tv_volume_dialog_ll_width);
            this.mVolumeDialog.getWindow().setAttributes(localLayoutParams);
        }
        if (!this.mVolumeDialog.isShowing()) {
            this.mVolumeDialog.show();
        }
        if (volumePercent <= 0) {
            this.mDialogVolumeIcon.setImageResource(R.drawable.mx_volume_no);
        } else {
            this.mDialogVolumeIcon.setImageResource(R.drawable.mx_volume_icon);
        }
        this.mDialogVolumeProgressBar.setProgress(volumePercent);
    }

    @Override
    protected void dismissVolumeDialog() {
        if (this.mVolumeDialog != null) {
            this.mVolumeDialog.dismiss();
        }
    }

    @Override
    protected void dismissBrightnessDialog() {
    }

    @Override
    protected void dismissProgressDialog() {
        if (this.mProgressDialog != null) {
            this.mProgressDialog.dismiss();
        }
    }

    @Override
    public void onPrepared() {
        super.onPrepared();
        if (this.mListener != null) {
            this.mListener.onPlayPrepared();
        }
    }

    @Override
    public void onBufferingUpdate(int percent) {
        super.onBufferingUpdate(percent);
        if (this.mListener != null) {
            this.mListener.onPlayBufferingUpdate(percent);
        }
    }

    @Override
    public void onAutoCompletion() {
        super.onAutoCompletion();
        if (this.mListener != null) {
            this.mListener.OnPlayCompletion();
        }
    }

    public static interface OnPlayStateListener {
        public void onPlayPrepared();

        public void onPlayBufferingUpdate(int var1);

        public void OnPlayCompletion();
    }

    public class DismissControlViewTimerTask
    extends TimerTask {
        @Override
        public void run() {
            if (MxTvPlayerWidget.this.mCurrentState != 0 && MxTvPlayerWidget.this.mCurrentState != 7 && MxTvPlayerWidget.this.mCurrentState != 6 && MxTvPlayerWidget.this.getContext() != null && MxTvPlayerWidget.this.getContext() instanceof Activity) {
                ((Activity)MxTvPlayerWidget.this.getContext()).runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MxTvPlayerWidget.this.mBottomContainer.setVisibility(4);
                        MxTvPlayerWidget.this.mTopContainer.setVisibility(4);
                        MxTvPlayerWidget.this.mPlayControllerButton.setVisibility(4);
                        if (MxTvPlayerWidget.this.mIsShowBottomProgressBar) {
                            MxTvPlayerWidget.this.mBottomProgressBar.setVisibility(0);
                        }
                    }
                });
            }
        }
    }
}

