/*
 * Decompiled with CFR 0.152.
 */
package hb.xvideoplayer;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.SurfaceTexture;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.media.AudioManager;
import android.os.Handler;
import android.support.v7.app.ActionBar;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import hb.xvideoplayer.MxImageView;
import hb.xvideoplayer.MxMediaManager;
import hb.xvideoplayer.MxMediaPlayerListener;
import hb.xvideoplayer.MxTextureView;
import hb.xvideoplayer.MxUserAction;
import hb.xvideoplayer.MxUtils;
import hb.xvideoplayer.MxVideoPlayerManager;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import mxvideoplayer.app.com.xvideoplayer.R;

public abstract class MxVideoPlayer
extends FrameLayout
implements MxMediaPlayerListener,
View.OnClickListener,
SeekBar.OnSeekBarChangeListener,
View.OnTouchListener,
TextureView.SurfaceTextureListener {
    public static final String TAG = "MxVideoPlayer";
    public static final int FULL_SCREEN_NORMAL_DELAY = 500;
    private static final int THRESHOLD = 70;
    public static final int WINDOW_TINY_WIDTH = 430;
    public static final int WINDOW_TINY_HEIGHT = 400;
    public static final int SCREEN_LAYOUT_NORMAL = 0;
    public static final int SCREEN_LAYOUT_LIST = 1;
    public static final int SCREEN_WINDOW_FULLSCREEN = 2;
    public static final int SCREEN_WINDOW_TINY = 3;
    public static final int CURRENT_STATE_NORMAL = 0;
    public static final int CURRENT_STATE_PREPARING = 1;
    public static final int CURRENT_STATE_PLAYING = 2;
    public static final int CURRENT_STATE_PLAYING_BUFFERING_START = 3;
    public static final int CURRENT_STATE_PAUSE = 5;
    public static final int CURRENT_STATE_AUTO_COMPLETE = 6;
    public static final int CURRENT_STATE_ERROR = 7;
    protected static boolean WIFI_TIP_DIALOG_SHOWED = false;
    public static int FULLSCREEN_ORIENTATION = 4;
    public static int NORMAL_ORIENTATION = 1;
    public int mCurrentState = -1;
    public int mCurrentScreen = -1;
    public String mPlayUrl = "";
    public Object[] mObjects = null;
    public boolean mLooping = false;
    public Map<String, String> mDataMap = new HashMap<String, String>();
    protected static WeakReference<MxUserAction> mUserAction;
    protected static Timer mUpdateProgressTimer;
    public static long CLICK_QUIT_FULLSCREEN_TIME;
    protected ProgressTimerTask mProgressTimerTask;
    public ImageView mPlayControllerButton;
    public ImageView mFullscreenButton;
    protected SeekBar mProgressBar;
    private TextView mCurrentTimeTextView;
    private TextView mTotalTimeTextView;
    public ViewGroup mBottomContainer;
    private ViewGroup mTextureViewContainer;
    public ViewGroup mTopContainer;
    private MxImageView mCacheImageView;
    private Bitmap mPauseSwitchCoverBitmap = null;
    protected int mScreenWidth;
    protected int mScreenHeight;
    public AudioManager mAudioManager;
    protected Handler mHandler;
    private boolean mTextureSizeChanged;
    private boolean mIsTryPlayOnError = false;
    protected float mDownX;
    protected float mDownY;
    protected boolean mChangeLight;
    protected boolean mChangeVolume;
    protected boolean mChangePosition;
    protected int mDownPosition;
    protected int mGestureDownVolume;
    protected int mGestureDownBrightness;
    protected int mSeekTimePosition;
    protected boolean mTouchingProgressBar = false;
    public static long mLastAutoFullscreenTime;
    public static AudioManager.OnAudioFocusChangeListener mOnAudioFocusChangeListener;

    public MxVideoPlayer(Context context) {
        this(context, null);
    }

    public MxVideoPlayer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
        this.initAttributeSet(context, attrs);
    }

    public void initView(Context context) {
        View.inflate((Context)context, (int)this.getLayoutId(), (ViewGroup)this);
        this.mPlayControllerButton = (ImageView)this.findViewById(R.id.mx_start);
        this.mFullscreenButton = (ImageView)this.findViewById(R.id.mx_fullscreen);
        this.mProgressBar = (SeekBar)this.findViewById(R.id.mx_progress);
        this.mCurrentTimeTextView = (TextView)this.findViewById(R.id.mx_current_time);
        this.mTotalTimeTextView = (TextView)this.findViewById(R.id.mx_total_time);
        this.mBottomContainer = (ViewGroup)this.findViewById(R.id.mx_layout_bottom);
        this.mTextureViewContainer = (ViewGroup)this.findViewById(R.id.mx_surface_container);
        this.mTopContainer = (ViewGroup)this.findViewById(R.id.mx_layout_top);
        this.mCacheImageView = (MxImageView)this.findViewById(R.id.mx_cache);
        this.mPlayControllerButton.setOnClickListener((View.OnClickListener)this);
        if (this.mFullscreenButton != null) {
            this.mFullscreenButton.setOnClickListener((View.OnClickListener)this);
        }
        this.mProgressBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        this.mBottomContainer.setOnClickListener((View.OnClickListener)this);
        this.mTextureViewContainer.setOnClickListener((View.OnClickListener)this);
        this.mTextureViewContainer.setOnTouchListener((View.OnTouchListener)this);
        this.mScreenWidth = this.getContext().getResources().getDisplayMetrics().widthPixels;
        this.mScreenHeight = this.getContext().getResources().getDisplayMetrics().heightPixels;
        this.mAudioManager = (AudioManager)this.getContext().getSystemService("audio");
        this.mHandler = new Handler();
    }

    public boolean startPlay(String url, int screen, Object ... objects) {
        MxVideoPlayer mxVideoPlayer;
        if (!TextUtils.isEmpty((CharSequence)this.mPlayUrl) && TextUtils.equals((CharSequence)this.mPlayUrl, (CharSequence)url)) {
            return false;
        }
        MxVideoPlayerManager.checkAndPutListener(this);
        if (MxVideoPlayerManager.mCurScrollListener != null && MxVideoPlayerManager.mCurScrollListener.get() != null && this == (mxVideoPlayer = (MxVideoPlayer)MxVideoPlayerManager.mCurScrollListener.get()) && mxVideoPlayer.mCurrentState == 2 && url.equals(MxMediaManager.getInstance().getPlayer().getDataSource())) {
            mxVideoPlayer.startWindowTiny();
        }
        this.mPlayUrl = url;
        this.mCurrentScreen = screen;
        this.mObjects = objects;
        this.setUiPlayState(0);
        if (url.equals(MxMediaManager.getInstance().getPlayer().getDataSource())) {
            MxVideoPlayerManager.putScrollListener(this);
        }
        return true;
    }

    public boolean startPlay(String url, int screen, Map<String, String> dataMap, Object ... objects) {
        if (this.startPlay(url, screen, objects)) {
            this.mDataMap.clear();
            this.mDataMap.putAll(dataMap);
            return true;
        }
        return false;
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.mx_start) {
            Log.i((String)TAG, (String)("onClick: click start button and currentState=" + this.mCurrentState));
            if (TextUtils.isEmpty((CharSequence)this.mPlayUrl)) {
                Toast.makeText((Context)this.getContext(), (CharSequence)this.getResources().getString(R.string.no_url), (int)0).show();
                return;
            }
            if (this.mCurrentState == 0 || this.mCurrentState == 7) {
                if (this.isShowNetworkStateDialog()) {
                    return;
                }
                this.preparePlayVideo();
                this.onActionEvent(this.mCurrentState != 7 ? 0 : 1);
            } else if (this.mCurrentState == 2) {
                this.obtainCache();
                this.onActionEvent(3);
                MxMediaManager.getInstance().getPlayer().pause();
                this.setUiPlayState(5);
                this.refreshCache();
            } else if (this.mCurrentState == 5) {
                this.onActionEvent(4);
                MxMediaManager.getInstance().getPlayer().start();
                this.setUiPlayState(2);
            } else if (this.mCurrentState == 6) {
                this.onActionEvent(2);
                this.preparePlayVideo();
            }
        } else if (id2 == R.id.mx_fullscreen) {
            Log.i((String)TAG, (String)("onClick: click fullscreen button and currentState=" + this.mCurrentState));
            if (this.mCurrentState == 6) {
                return;
            }
            if (this.mCurrentScreen == 2) {
                MxVideoPlayer.backPress();
            } else {
                this.onActionEvent(7);
                this.startWindowFullscreen();
            }
        } else if (id2 == R.id.mx_surface_container && this.mCurrentState == 7) {
            Log.i((String)TAG, (String)("onClick: click surfaceContainer and currentState=" + this.mCurrentState));
            this.preparePlayVideo();
        }
    }

    public boolean onTouch(View v, MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        int id2 = v.getId();
        if (id2 == R.id.mx_surface_container) {
            switch (event.getAction()) {
                case 0: {
                    Log.i((String)TAG, (String)("onTouch: surfaceContainer actionDown [" + this.hashCode() + "] "));
                    this.mTouchingProgressBar = true;
                    this.mDownX = x;
                    this.mDownY = y;
                    this.mChangeLight = false;
                    this.mChangeVolume = false;
                    this.mChangePosition = false;
                    break;
                }
                case 2: {
                    Log.i((String)TAG, (String)("onTouch: surfaceContainer actionMove [" + this.hashCode() + "] "));
                    float deltaX = x - this.mDownX;
                    float deltaY = y - this.mDownY;
                    float absDeltaX = Math.abs(deltaX);
                    float absDeltaY = Math.abs(deltaY);
                    if (!(this.mCurrentScreen != 2 || this.mChangePosition || this.mChangeVolume || this.mChangeLight || !(absDeltaX > 70.0f) && !(absDeltaY > 70.0f))) {
                        this.cancelProgressTimer();
                        if (absDeltaX >= 70.0f) {
                            if (this.mCurrentState != 7) {
                                this.mChangePosition = true;
                                this.mDownPosition = this.getCurrentPositionWhenPlaying();
                            }
                        } else if (x <= (float)(MxMediaManager.mTextureView.getWidth() / 2)) {
                            this.mChangeVolume = true;
                            this.mGestureDownVolume = this.mAudioManager.getStreamVolume(3);
                        } else {
                            this.mChangeLight = true;
                            this.mGestureDownBrightness = MxUtils.getScreenBrightness((Activity)this.getContext());
                        }
                    }
                    if (this.mChangePosition) {
                        int totalTimeDuration = this.getDuration();
                        this.mSeekTimePosition = (int)((float)this.mDownPosition + deltaX * 100.0f);
                        if (this.mSeekTimePosition > totalTimeDuration) {
                            this.mSeekTimePosition = totalTimeDuration;
                        }
                        String seekTime = MxUtils.stringForTime(this.mSeekTimePosition);
                        String totalTime = MxUtils.stringForTime(totalTimeDuration);
                        this.showProgressDialog(deltaX, seekTime, this.mSeekTimePosition, totalTime, totalTimeDuration);
                    }
                    if (this.mChangeVolume) {
                        deltaY = -deltaY;
                        int maxVolume = this.mAudioManager.getStreamMaxVolume(3);
                        int deltaV = (int)((float)maxVolume * deltaY * 3.0f / (float)this.mScreenHeight);
                        this.mAudioManager.setStreamVolume(3, this.mGestureDownVolume + deltaV, 0);
                        int volumePercent = (int)((float)(this.mGestureDownVolume * 100 / maxVolume) + deltaY * 3.0f * 100.0f / (float)this.mScreenHeight);
                        this.showVolumeDialog(-deltaY, volumePercent);
                    }
                    if (!this.mChangeLight) break;
                    deltaY = -deltaY;
                    int deltaV = (int)(255.0f * deltaY * 3.0f / (float)this.mScreenHeight);
                    MxUtils.setScreenManualMode(this.getContext());
                    int brightnessValue = this.mGestureDownBrightness + deltaV;
                    if (brightnessValue >= 0 && brightnessValue <= 255) {
                        MxUtils.setWindowBrightness((Activity)this.getContext(), brightnessValue);
                    }
                    int brightnessPercent = (int)((float)this.mGestureDownBrightness + deltaY * 255.0f * 3.0f / (float)this.mScreenHeight);
                    this.showBrightnessDialog(-deltaY, brightnessPercent);
                    break;
                }
                case 1: {
                    Log.i((String)TAG, (String)("onTouch: surfaceContainer actionUp [" + this.hashCode() + "] "));
                    this.mTouchingProgressBar = false;
                    this.dismissProgressDialog();
                    this.dismissVolumeDialog();
                    this.dismissBrightnessDialog();
                    if (this.mChangePosition) {
                        this.onActionEvent(13);
                        MxMediaManager.getInstance().getPlayer().seekTo((long)this.mSeekTimePosition);
                        int duration = this.getDuration();
                        int progress = this.mSeekTimePosition * 100 / (duration == 0 ? 1 : duration);
                        this.mProgressBar.setProgress(progress);
                    }
                    if (this.mChangeVolume) {
                        this.onActionEvent(11);
                    }
                    if (this.mChangeLight) {
                        this.onActionEvent(12);
                    }
                    this.startProgressTimer();
                    break;
                }
            }
        }
        return false;
    }

    private void startWindowTiny() {
        Log.i((String)TAG, (String)("startWindowTiny: [" + this.hashCode() + "] "));
        this.onActionEvent(9);
        ViewGroup vp = (ViewGroup)MxUtils.scanForActivity(this.getContext()).findViewById(0x1020002);
        View oldView = vp.findViewById(R.id.mx_tiny_screen_id);
        if (oldView != null) {
            vp.removeView(oldView);
        }
        if (this.mTextureViewContainer.getChildCount() > 0) {
            this.mTextureViewContainer.removeAllViews();
        }
        try {
            Constructor<?> constructor = this.getClass().getConstructor(Context.class);
            MxVideoPlayer mxVideoPlayer = (MxVideoPlayer)constructor.newInstance(this.getContext());
            mxVideoPlayer.setId(R.id.mx_tiny_screen_id);
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(430, 400);
            params.gravity = 85;
            vp.addView((View)mxVideoPlayer, (ViewGroup.LayoutParams)params);
            mxVideoPlayer.startPlay(this.mPlayUrl, 3, this.mObjects);
            mxVideoPlayer.setUiPlayState(this.mCurrentState);
            mxVideoPlayer.addTextureView();
            MxVideoPlayerManager.putListener(mxVideoPlayer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startWindowFullscreen() {
        this.obtainCache();
        CLICK_QUIT_FULLSCREEN_TIME = System.currentTimeMillis();
        MxVideoPlayer.hideSupportActionBar(this.getContext());
        MxUtils.getAppComptActivity(this.getContext()).setRequestedOrientation(FULLSCREEN_ORIENTATION);
        ViewGroup vp = (ViewGroup)MxUtils.scanForActivity(this.getContext()).findViewById(0x1020002);
        View oldView = vp.findViewById(R.id.mx_fullscreen_id);
        if (oldView != null) {
            vp.removeView(oldView);
        }
        if (this.mTextureViewContainer.getChildCount() > 0) {
            this.mTextureViewContainer.removeAllViews();
        }
        try {
            Constructor<?> constructor = this.getClass().getConstructor(Context.class);
            MxVideoPlayer mxVideoPlayer = (MxVideoPlayer)constructor.newInstance(this.getContext());
            mxVideoPlayer.setId(R.id.mx_fullscreen_id);
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1, 17);
            vp.addView((View)mxVideoPlayer, (ViewGroup.LayoutParams)params);
            mxVideoPlayer.startPlay(this.mPlayUrl, 2, this.mObjects);
            mxVideoPlayer.setUiPlayState(this.mCurrentState);
            mxVideoPlayer.addTextureView();
            MxVideoPlayerManager.putListener(mxVideoPlayer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.refreshCache();
    }

    public static void startFullscreen(Context context, Class _class, String url, Object ... objects) {
        Log.i((String)TAG, (String)"startFullscreen: ===manual fullscreen===");
        MxVideoPlayer.hideSupportActionBar(context);
        MxUtils.getAppComptActivity(context).setRequestedOrientation(FULLSCREEN_ORIENTATION);
        ViewGroup vp = (ViewGroup)MxUtils.scanForActivity(context).findViewById(0x1020002);
        View old = vp.findViewById(R.id.mx_fullscreen_id);
        if (old != null) {
            vp.removeView(old);
        }
        try {
            Constructor constructor = _class.getConstructor(Context.class);
            MxVideoPlayer mxVideoPlayer = (MxVideoPlayer)constructor.newInstance(context);
            mxVideoPlayer.setId(R.id.mx_fullscreen_id);
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
            vp.addView((View)mxVideoPlayer, (ViewGroup.LayoutParams)lp);
            mxVideoPlayer.startPlay(url, 2, objects);
            mxVideoPlayer.addTextureView();
            mxVideoPlayer.mPlayControllerButton.performClick();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean backPress() {
        MxMediaPlayerListener listener = MxVideoPlayerManager.getCurrentListener();
        return listener != null && listener.quitFullscreenOrTinyListener();
    }

    public void setUiPlayState(int state) {
        this.mCurrentState = state;
        switch (this.mCurrentState) {
            case 0: {
                if (!this.isCurrentMediaListener()) break;
                this.cancelProgressTimer();
                MxMediaManager.getInstance().releaseMediaPlayer();
                break;
            }
            case 1: {
                this.resetProgressAndTime();
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                this.startProgressTimer();
                break;
            }
            case 7: {
                this.cancelProgressTimer();
                if (!this.isCurrentMediaListener()) break;
                MxMediaManager.getInstance().releaseMediaPlayer();
                break;
            }
            case 6: {
                this.cancelProgressTimer();
                this.mProgressBar.setProgress(100);
                this.mCurrentTimeTextView.setText(this.mTotalTimeTextView.getText());
                break;
            }
        }
    }

    private void obtainCache() {
        Bitmap bitmap;
        Point videoSize = MxMediaManager.getInstance().getVideoSize();
        if (videoSize != null && (bitmap = MxMediaManager.mTextureView.getBitmap(videoSize.x, videoSize.y)) != null) {
            this.mPauseSwitchCoverBitmap = bitmap;
        }
    }

    private void refreshCache() {
        MxVideoPlayer mxVideoPlayer;
        if (this.mPauseSwitchCoverBitmap != null && (mxVideoPlayer = (MxVideoPlayer)MxVideoPlayerManager.getCurrentListener()) != null) {
            mxVideoPlayer.mCacheImageView.setImageBitmap(this.mPauseSwitchCoverBitmap);
            mxVideoPlayer.mCacheImageView.setVisibility(0);
        }
    }

    public void clearCacheImage() {
        this.mPauseSwitchCoverBitmap = null;
        this.mCacheImageView.setImageBitmap(null);
    }

    private static void hideSupportActionBar(Context context) {
        ActionBar actionBar = MxUtils.getAppComptActivity(context).getSupportActionBar();
        if (actionBar != null) {
            actionBar.setShowHideAnimationEnabled(false);
            actionBar.hide();
        }
        MxUtils.getAppComptActivity(context).getWindow().setFlags(1024, 1024);
    }

    private static void showSupportActionBar(Context context) {
        ActionBar actionBar = MxUtils.getAppComptActivity(context).getSupportActionBar();
        if (actionBar != null) {
            actionBar.setShowHideAnimationEnabled(false);
            actionBar.show();
        }
        MxUtils.getAppComptActivity(context).getWindow().clearFlags(1024);
    }

    public void resetProgressAndTime() {
        this.mProgressBar.setProgress(0);
        this.mProgressBar.setSecondaryProgress(0);
        this.mCurrentTimeTextView.setText((CharSequence)MxUtils.stringForTime(0L));
        this.mTotalTimeTextView.setText((CharSequence)MxUtils.stringForTime(0L));
    }

    protected void startProgressTimer() {
        this.cancelProgressTimer();
        mUpdateProgressTimer = new Timer();
        this.mProgressTimerTask = new ProgressTimerTask();
        mUpdateProgressTimer.schedule((TimerTask)this.mProgressTimerTask, 0L, 500L);
    }

    protected void cancelProgressTimer() {
        if (mUpdateProgressTimer != null) {
            mUpdateProgressTimer.cancel();
        }
        if (this.mProgressTimerTask != null) {
            this.mProgressTimerTask.cancel();
        }
    }

    public static void setMxUserAction(MxUserAction userAction) {
        mUserAction = new WeakReference<MxUserAction>(userAction);
    }

    public void onActionEvent(int type) {
        if (mUserAction != null && mUserAction.get() != null && this.isCurrentMediaListener()) {
            ((MxUserAction)mUserAction.get()).onActionEvent(type, this.mPlayUrl, this.mCurrentScreen, this.mObjects);
        }
    }

    private boolean isCurrentMediaListener() {
        return MxVideoPlayerManager.getCurrentListener() != null && MxVideoPlayerManager.getCurrentListener() == this;
    }

    protected int getCurrentPositionWhenPlaying() {
        int pos = 0;
        if (this.mCurrentState == 2 || this.mCurrentState == 5 || this.mCurrentState == 3) {
            try {
                pos = (int)MxMediaManager.getInstance().getPlayer().getCurrentPosition();
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                return pos;
            }
        }
        return pos;
    }

    public int getDuration() {
        int duration = 0;
        try {
            duration = (int)MxMediaManager.getInstance().getPlayer().getDuration();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            return duration;
        }
        return duration;
    }

    private void setTextAndProgress(int secProgress) {
        int position = this.getCurrentPositionWhenPlaying();
        int duration = this.getDuration();
        int progress = position * 100 / (duration == 0 ? 1 : duration);
        this.setProgressAndTime(progress, secProgress, position, duration);
    }

    public void setProgressAndTime(int progress, int secProgress, int currentTime, int totalTime) {
        if (!this.mTouchingProgressBar && progress != 0) {
            this.mProgressBar.setProgress(progress);
        }
        if (secProgress > 95) {
            secProgress = 100;
        }
        if (secProgress != 0) {
            this.mProgressBar.setSecondaryProgress(secProgress);
        }
        if (currentTime != 0) {
            this.mCurrentTimeTextView.setText((CharSequence)MxUtils.stringForTime(currentTime));
        }
        this.mTotalTimeTextView.setText((CharSequence)MxUtils.stringForTime(totalTime));
    }

    protected void preparePlayVideo() {
        Log.i((String)TAG, (String)("prepare play video [" + this.hashCode() + "] "));
        this.mIsTryPlayOnError = this.mCurrentState == 7;
        MxVideoPlayerManager.completeAll();
        MxVideoPlayerManager.putListener(this);
        this.addTextureView();
        this.mAudioManager.requestAudioFocus(mOnAudioFocusChangeListener, 3, 2);
        MxUtils.scanForActivity(this.getContext()).getWindow().addFlags(128);
        MxVideoPlayerManager.putScrollListener(this);
        MxMediaManager.getInstance().prepare(this.mPlayUrl, this.mDataMap, this.mLooping);
        this.setUiPlayState(1);
    }

    private void addTextureView() {
        Log.i((String)TAG, (String)("addTextureView [" + this.hashCode() + "]"));
        if (this.mTextureViewContainer.getChildCount() > 0) {
            this.mTextureViewContainer.removeAllViews();
        }
        if (MxMediaManager.mTextureView == null) {
            MxMediaManager.mTextureView = new MxTextureView(this.getContext());
            Point videoSize = MxMediaManager.getInstance().getVideoSize();
            MxMediaManager.mTextureView.setVideoSize(videoSize);
            MxMediaManager.mTextureView.setRotation(MxMediaManager.getInstance().mVideoRotation);
            this.mCacheImageView.setVideoSize(videoSize);
            this.mCacheImageView.setRotation(MxMediaManager.getInstance().mVideoRotation);
        } else if (MxMediaManager.mTextureView != null && MxMediaManager.mTextureView.getParent() != null) {
            ((ViewGroup)MxMediaManager.mTextureView.getParent()).removeView((View)MxMediaManager.mTextureView);
        }
        MxMediaManager.mTextureView.setSurfaceTextureListener(this);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1, 17);
        this.mTextureViewContainer.addView((View)MxMediaManager.mTextureView, (ViewGroup.LayoutParams)params);
    }

    public void release() {
        MxMediaPlayerListener currentListener;
        if (this.mPlayUrl.equals(MxMediaManager.getInstance().getPlayer().getDataSource()) && System.currentTimeMillis() - CLICK_QUIT_FULLSCREEN_TIME > 500L && (currentListener = MxVideoPlayerManager.getCurrentListener()) != null && currentListener.getScreenType() != 2) {
            Log.d((String)TAG, (String)("manual release [" + this.hashCode() + "]"));
            MxVideoPlayer.releaseAllVideos();
        }
    }

    public static void releaseAllVideos() {
        Log.i((String)TAG, (String)"releaseAllVideos===============");
        MxVideoPlayerManager.completeAll();
        MxMediaManager.getInstance().releaseMediaPlayer();
    }

    private void clearFullscreenLayout() {
        ViewGroup vp = (ViewGroup)MxUtils.scanForActivity(this.getContext()).findViewById(0x1020002);
        View oldF = vp.findViewById(R.id.mx_fullscreen_id);
        View oldT = vp.findViewById(R.id.mx_tiny_screen_id);
        if (oldF != null) {
            vp.removeView(oldF);
        }
        if (oldT != null) {
            vp.removeView(oldT);
        }
        MxVideoPlayer.showSupportActionBar(this.getContext());
    }

    @Override
    public void onPrepared() {
        Log.i((String)TAG, (String)("onPrepared====[" + this.hashCode() + "] "));
        if (this.mCurrentState != 1) {
            return;
        }
        MxMediaManager.getInstance().getPlayer().start();
        this.setUiPlayState(2);
    }

    @Override
    public void onCompletion() {
        Log.i((String)TAG, (String)("onCompletion====[" + this.hashCode() + "] "));
        this.setUiPlayState(0);
        if (this.mTextureViewContainer.getChildCount() > 0) {
            this.mTextureViewContainer.removeAllViews();
        }
        MxMediaManager.getInstance().mCurVideoWidth = 0;
        MxMediaManager.getInstance().mCurVideoHeight = 0;
        MxMediaManager.getInstance().bufferPercent = 0;
        MxMediaManager.getInstance().mVideoRotation = 0;
        this.mAudioManager.abandonAudioFocus(mOnAudioFocusChangeListener);
        MxUtils.scanForActivity(this.getContext()).getWindow().clearFlags(128);
        if (!this.mIsTryPlayOnError && this.mCurrentScreen == 2 || this.mCurrentScreen == 3) {
            this.clearFullscreenLayout();
        }
        MxUtils.getAppComptActivity(this.getContext()).setRequestedOrientation(NORMAL_ORIENTATION);
        this.clearCacheImage();
    }

    @Override
    public void onBufferingUpdate(int percent) {
        if (this.mCurrentState != 0 && this.mCurrentState != 7) {
            MxMediaManager.getInstance().bufferPercent = percent;
            this.setTextAndProgress(percent);
        }
    }

    @Override
    public void onSeekComplete() {
    }

    @Override
    public void onError(int what, int extra) {
        Log.e((String)TAG, (String)("onError what : " + what + " extra : " + extra + " [" + this.hashCode() + "] "));
        if (what != -38 && what != 38) {
            this.setUiPlayState(7);
        }
    }

    @Override
    public void onInfo(int what, int extra) {
        Log.i((String)TAG, (String)("onInfo what : " + what + " extra : " + extra));
        if (what == 701) {
            MxMediaManager.getInstance().mBackUpBufferState = this.mCurrentState;
            this.setUiPlayState(3);
            Log.i((String)TAG, (String)"MEDIA_INFO_BUFFERING_START");
        } else if (what == 702) {
            if (MxMediaManager.getInstance().mBackUpBufferState != -1) {
                this.setUiPlayState(MxMediaManager.getInstance().mBackUpBufferState);
                MxMediaManager.getInstance().mBackUpBufferState = -1;
            }
            Log.i((String)TAG, (String)"MEDIA_INFO_BUFFERING_END");
        } else if (what == 10001) {
            MxMediaManager.getInstance().mVideoRotation = extra;
            MxMediaManager.mTextureView.setRotation(extra);
            this.mCacheImageView.setRotation(extra);
            Log.i((String)TAG, (String)"MEDIA_INFO_VIDEO_ROTATION_CHANGED");
        }
    }

    @Override
    public void onVideoSizeChanged() {
        Log.i((String)TAG, (String)("onVideoSizeChanged  [" + this.hashCode() + "] "));
        Point videoSize = MxMediaManager.getInstance().getVideoSize();
        MxMediaManager.mTextureView.setVideoSize(videoSize);
        this.mCacheImageView.setVideoSize(videoSize);
    }

    @Override
    public void goBackNormalListener() {
        Log.i((String)TAG, (String)("goBackNormalListener: [" + this.hashCode() + "] "));
        this.mCurrentState = MxMediaManager.getInstance().mLastState;
        this.setUiPlayState(this.mCurrentState);
        this.addTextureView();
        MxVideoPlayer.showSupportActionBar(this.getContext());
    }

    @Override
    public boolean quitFullscreenOrTinyListener() {
        Log.i((String)TAG, (String)("quitFullscreenOrTinyListener: [" + this.hashCode() + "] "));
        this.mIsTryPlayOnError = false;
        this.obtainCache();
        MxUtils.getAppComptActivity(this.getContext()).setRequestedOrientation(NORMAL_ORIENTATION);
        if (this.mCurrentScreen == 2 || this.mCurrentScreen == 3) {
            this.onActionEvent(this.mCurrentScreen == 2 ? 8 : 10);
            if (MxVideoPlayerManager.mListenerList.size() == 1) {
                MxMediaPlayerListener popListener = MxVideoPlayerManager.popListener();
                if (popListener != null) {
                    popListener.onCompletion();
                }
                MxMediaManager.getInstance().releaseMediaPlayer();
                MxVideoPlayer.showSupportActionBar(this.getContext());
                return true;
            }
            ViewGroup vp = (ViewGroup)MxUtils.scanForActivity(this.getContext()).findViewById(0x1020002);
            vp.removeView((View)this);
            MxMediaManager.getInstance().mLastState = this.mCurrentState;
            MxVideoPlayerManager.popListener();
            MxMediaPlayerListener currentListener = MxVideoPlayerManager.getCurrentListener();
            if (currentListener != null) {
                currentListener.goBackNormalListener();
                CLICK_QUIT_FULLSCREEN_TIME = System.currentTimeMillis();
                this.refreshCache();
            } else {
                MxVideoPlayerManager.completeAll();
            }
            return true;
        }
        return false;
    }

    public static void onScroll() {
        MxMediaPlayerListener listener;
        if (MxVideoPlayerManager.mCurScrollListener != null && MxVideoPlayerManager.mCurScrollListener.get() != null && (listener = (MxMediaPlayerListener)MxVideoPlayerManager.mCurScrollListener.get()).getState() != 7 && listener.getState() != 6) {
            listener.onScrollChange();
        }
    }

    @Override
    public void onScrollChange() {
        if (this.mPlayUrl.equals(MxMediaManager.getInstance().getPlayer().getDataSource())) {
            MxMediaPlayerListener currentListener = MxVideoPlayerManager.getCurrentListener();
            if (currentListener == null) {
                return;
            }
            if (currentListener.getScreenType() == 3) {
                if (this.isShown()) {
                    MxVideoPlayer.backPress();
                }
            } else if (!this.isShown()) {
                if (this.mCurrentState != 2) {
                    MxVideoPlayer.releaseAllVideos();
                } else {
                    this.startWindowTiny();
                }
            }
        }
    }

    @Override
    public int getScreenType() {
        return this.mCurrentScreen;
    }

    @Override
    public String getUrl() {
        return this.mPlayUrl;
    }

    @Override
    public int getState() {
        return this.mCurrentState;
    }

    @Override
    public void onAutoCompletion() {
        Log.i((String)TAG, (String)("onAutoCompletion  [" + this.hashCode() + "] " + "===current listener size=" + MxVideoPlayerManager.mListenerList.size()));
        this.mIsTryPlayOnError = false;
        Runtime.getRuntime().gc();
        this.onActionEvent(6);
        this.dismissVolumeDialog();
        this.dismissProgressDialog();
        this.setUiPlayState(6);
        MxVideoPlayerManager.completeAll();
    }

    @Override
    public void autoFullscreen(float x) {
        Log.i((String)TAG, (String)("autoFullscreen: [" + this.hashCode() + "] "));
        if (this.isCurrentMediaListener() && this.mCurrentState == 2 && this.mCurrentScreen != 2 && this.mCurrentScreen != 3) {
            if (x > 0.0f) {
                MxUtils.getAppComptActivity(this.getContext()).setRequestedOrientation(0);
            } else {
                MxUtils.getAppComptActivity(this.getContext()).setRequestedOrientation(8);
            }
            this.startWindowFullscreen();
        }
    }

    @Override
    public void autoQuitFullscreen() {
        Log.i((String)TAG, (String)("autoQuitFullscreen: [" + this.hashCode() + "] "));
        if (System.currentTimeMillis() - mLastAutoFullscreenTime > 2000L && this.isCurrentMediaListener() && this.mCurrentState == 2 && this.mCurrentScreen == 2) {
            mLastAutoFullscreenTime = System.currentTimeMillis();
            MxVideoPlayer.backPress();
        }
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        Log.i((String)TAG, (String)("onSurfaceTextureAvailable [" + this.hashCode() + "] "));
        Surface mSurface = new Surface(surface);
        MxMediaManager.getInstance().setDisplay(mSurface);
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        Log.i((String)TAG, (String)("onSurfaceTextureSizeChanged [" + this.hashCode() + "] "));
        this.mTextureSizeChanged = true;
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        surface.release();
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        if (!this.mTextureSizeChanged) {
            this.mCacheImageView.setVisibility(4);
            MxMediaManager.mTextureView.setHasUpdated();
        } else {
            this.mTextureSizeChanged = false;
        }
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
        Log.i((String)TAG, (String)("onStartTrackingTouch: bottomProgress [" + this.hashCode() + "] "));
        this.cancelProgressTimer();
        for (ViewParent parent = this.getParent(); parent != null; parent = parent.getParent()) {
            parent.requestDisallowInterceptTouchEvent(true);
        }
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
        Log.i((String)TAG, (String)("onStopTrackingTouch: bottomProgress [" + this.hashCode() + "] "));
        this.onActionEvent(5);
        this.startProgressTimer();
        for (ViewParent viewParent = this.getParent(); viewParent != null; viewParent = viewParent.getParent()) {
            viewParent.requestDisallowInterceptTouchEvent(false);
        }
        if (this.mCurrentState != 2 && this.mCurrentState != 5) {
            return;
        }
        int time = seekBar.getProgress() * this.getDuration() / 100;
        MxMediaManager.getInstance().getPlayer().seekTo((long)time);
        Log.i((String)TAG, (String)("onStopTrackingTouch: seekTo " + time + " [" + this.hashCode() + "] "));
    }

    protected abstract void showBrightnessDialog(float var1, int var2);

    protected abstract int getLayoutId();

    protected abstract void initAttributeSet(Context var1, AttributeSet var2);

    protected abstract boolean isShowNetworkStateDialog();

    protected abstract void showProgressDialog(float var1, String var2, int var3, String var4, int var5);

    protected abstract void showVolumeDialog(float var1, int var2);

    protected abstract void dismissVolumeDialog();

    protected abstract void dismissBrightnessDialog();

    protected abstract void dismissProgressDialog();

    static {
        CLICK_QUIT_FULLSCREEN_TIME = 0L;
        mLastAutoFullscreenTime = 0L;
        mOnAudioFocusChangeListener = new AudioManager.OnAudioFocusChangeListener(){

            public void onAudioFocusChange(int focusChange) {
                switch (focusChange) {
                    case -1: {
                        MxVideoPlayer.releaseAllVideos();
                        break;
                    }
                    case -2: {
                        if (!MxMediaManager.getInstance().getPlayer().isPlaying()) break;
                        MxMediaManager.getInstance().getPlayer().pause();
                    }
                }
            }
        };
    }

    public static class MxAutoFullscreenListener
    implements SensorEventListener {
        public void onSensorChanged(SensorEvent event) {
            float x = event.values[0];
            float y = event.values[1];
            if ((x > -15.0f && x < -10.0f || x < 15.0f && x > 10.0f) && (double)Math.abs(y) < 1.5 && System.currentTimeMillis() - mLastAutoFullscreenTime > 1200L) {
                MxMediaPlayerListener currentListener = MxVideoPlayerManager.getCurrentListener();
                if (currentListener != null) {
                    currentListener.autoFullscreen(x);
                }
                mLastAutoFullscreenTime = System.currentTimeMillis();
            }
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    }

    public class ProgressTimerTask
    extends TimerTask {
        @Override
        public void run() {
            if (MxVideoPlayer.this.mCurrentState == 2 || MxVideoPlayer.this.mCurrentState == 5 || MxVideoPlayer.this.mCurrentState == 3) {
                MxVideoPlayer.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        MxVideoPlayer.this.setTextAndProgress(MxMediaManager.getInstance().bufferPercent);
                    }
                });
            }
        }
    }
}

