/*
 * Decompiled with CFR 0.152.
 */
package hb.xvideoplayer;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import hb.xvideoplayer.MxMediaManager;
import hb.xvideoplayer.MxMediaPlayerListener;
import hb.xvideoplayer.MxUtils;
import hb.xvideoplayer.MxVideoPlayer;
import hb.xvideoplayer.MxVideoPlayerManager;
import java.util.Timer;
import java.util.TimerTask;
import mxvideoplayer.app.com.xvideoplayer.R;

public class MxVideoPlayerWidget
extends MxVideoPlayer {
    protected static Timer DISMISS_CONTROL_VIEW_TIMER;
    public ImageView mBackButton;
    public ProgressBar mBottomProgressBar;
    public ProgressBar mLoadingProgressBar;
    public TextView mTitleTextView;
    public ImageView mThumbImageView;
    public ImageView mTinyBackImageView;
    protected Dialog mProgressDialog;
    protected Dialog mVolumeDialog;
    protected Dialog mBrightnessDialog;
    protected ProgressBar mDialogVolumeProgressBar;
    protected ProgressBar mDialogBrightnessProgressBar;
    protected ProgressBar mDialogProgressBar;
    protected TextView mDialogSeekTime;
    protected TextView mDialogTotalTime;
    protected ImageView mDialogIcon;
    protected DismissControlViewTimerTask mDismissControlViewTimerTask;

    public MxVideoPlayerWidget(Context context) {
        super(context);
    }

    public MxVideoPlayerWidget(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public void initView(Context context) {
        super.initView(context);
        this.mBottomProgressBar = (ProgressBar)this.findViewById(R.id.mx_bottom_progress);
        this.mTitleTextView = (TextView)this.findViewById(R.id.mx_title);
        this.mBackButton = (ImageView)this.findViewById(R.id.mx_back);
        this.mThumbImageView = (ImageView)this.findViewById(R.id.mx_thumb);
        this.mLoadingProgressBar = (ProgressBar)this.findViewById(R.id.mx_loading);
        this.mTinyBackImageView = (ImageView)this.findViewById(R.id.mx_quit_tiny);
        this.mThumbImageView.setOnClickListener((View.OnClickListener)this);
        this.mBackButton.setOnClickListener((View.OnClickListener)this);
        this.mTinyBackImageView.setOnClickListener((View.OnClickListener)this);
    }

    @Override
    public boolean startPlay(String url, int screen, Object ... objects) {
        if (objects.length == 0) {
            return false;
        }
        if (super.startPlay(url, screen, objects)) {
            this.mTitleTextView.setText((CharSequence)objects[0].toString());
            if (this.mCurrentScreen == 2) {
                this.mFullscreenButton.setImageResource(R.drawable.mx_shrink);
                this.mBackButton.setVisibility(0);
                this.mTinyBackImageView.setVisibility(4);
            } else if (this.mCurrentScreen == 1 || this.mCurrentScreen == 0) {
                this.mFullscreenButton.setImageResource(R.drawable.mx_enlarge);
                this.mBackButton.setVisibility(8);
                this.mTinyBackImageView.setVisibility(4);
            } else if (this.mCurrentScreen == 3) {
                this.mTinyBackImageView.setVisibility(0);
                this.setAllControlsVisible(4, 4, 4, 4, 4, 4);
            }
            return true;
        }
        return false;
    }

    @Override
    public void setUiStateAndScreen(int state) {
        super.setUiStateAndScreen(state);
        switch (this.mCurrentState) {
            case 0: {
                this.changeUiShowState(Mode.MODE_NORMAL);
                break;
            }
            case 1: {
                this.changeUiShowState(Mode.MODE_PREPARING);
                this.startDismissControlViewTimer();
                this.mBottomProgressBar.setProgress(0);
                break;
            }
            case 2: {
                this.changeUiShowState(Mode.MODE_PLAYING);
                this.startDismissControlViewTimer();
                break;
            }
            case 5: {
                this.changeUiShowState(Mode.MODE_PAUSE);
                this.cancelDismissControlViewTimer();
                break;
            }
            case 7: {
                this.changeUiShowState(Mode.MODE_ERROR);
                break;
            }
            case 6: {
                this.changeUiShowState(Mode.MODE_COMPLETE);
                this.cancelDismissControlViewTimer();
                this.mBottomProgressBar.setProgress(100);
                break;
            }
            case 3: {
                this.changeUiShowState(Mode.MODE_BUFFERING);
                break;
            }
        }
    }

    @Override
    public boolean onTouch(View v, MotionEvent event) {
        block11: {
            int id2;
            block10: {
                id2 = v.getId();
                if (id2 != R.id.mx_surface_container) break block10;
                switch (event.getAction()) {
                    case 1: {
                        this.startDismissControlViewTimer();
                        if (this.mChangePosition) {
                            int duration = this.getDuration();
                            int progress = this.mSeekTimePosition * 100 / (duration == 0 ? 1 : duration);
                            this.mBottomProgressBar.setProgress(progress);
                        }
                        if (!this.mChangePosition && !this.mChangeVolume) {
                            this.onClickUiToggle();
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block11;
            }
            if (id2 == R.id.mx_progress) {
                switch (event.getAction()) {
                    case 0: {
                        this.cancelDismissControlViewTimer();
                        break;
                    }
                    case 1: {
                        this.startDismissControlViewTimer();
                        break;
                    }
                }
            }
        }
        return super.onTouch(v, event);
    }

    private void onClickUiToggle() {
        if (this.mCurrentState == 1) {
            if (this.mBottomContainer.getVisibility() == 0) {
                this.changeUiShowState(Mode.MODE_PREPARING_CLEAR);
            } else {
                this.changeUiShowState(Mode.MODE_PREPARING);
            }
        } else if (this.mCurrentState == 2) {
            if (this.mBottomContainer.getVisibility() == 0) {
                this.changeUiShowState(Mode.MODE_PLAYING_CLEAR);
            } else {
                this.changeUiShowState(Mode.MODE_PLAYING);
            }
        } else if (this.mCurrentState == 5) {
            if (this.mBottomProgressBar.getVisibility() == 0) {
                this.changeUiShowState(Mode.MODE_PAUSE_CLEAR);
            } else {
                this.changeUiShowState(Mode.MODE_PAUSE);
            }
        } else if (this.mCurrentState == 6) {
            if (this.mBottomContainer.getVisibility() == 0) {
                this.changeUiShowState(Mode.MODE_COMPLETE_CLEAR);
            } else {
                this.changeUiShowState(Mode.MODE_COMPLETE);
            }
        } else if (this.mCurrentState == 3) {
            if (this.mBottomContainer.getVisibility() == 0) {
                this.changeUiShowState(Mode.MODE_BUFFERING_CLEAR);
            } else {
                this.changeUiShowState(Mode.MODE_BUFFERING);
            }
        }
    }

    private void changeUiShowState(Mode mode) {
        if (this.mCurrentScreen == 3) {
            return;
        }
        switch (mode) {
            case MODE_NORMAL: {
                this.setAllControlsVisible(0, 4, 0, 4, 0, 4);
                this.updateStartImage();
                break;
            }
            case MODE_BUFFERING: {
                this.setAllControlsVisible(0, 0, 4, 0, 4, 4);
                break;
            }
            case MODE_BUFFERING_CLEAR: {
                this.setAllControlsVisible(4, 4, 4, 0, 4, 0);
                this.updateStartImage();
                break;
            }
            case MODE_PREPARING: {
                this.setAllControlsVisible(0, 4, 4, 0, 0, 4);
                break;
            }
            case MODE_PREPARING_CLEAR: {
                this.setAllControlsVisible(0, 4, 4, 0, 0, 4);
                break;
            }
            case MODE_PLAYING: {
                this.setAllControlsVisible(0, 0, 0, 4, 4, 4);
                this.updateStartImage();
                break;
            }
            case MODE_PLAYING_CLEAR: {
                this.setAllControlsVisible(4, 4, 4, 4, 4, 0);
                break;
            }
            case MODE_PAUSE: {
                this.setAllControlsVisible(0, 0, 0, 4, 4, 4);
                this.updateStartImage();
                break;
            }
            case MODE_PAUSE_CLEAR: {
                this.setAllControlsVisible(4, 4, 4, 4, 4, 4);
                break;
            }
            case MODE_COMPLETE: {
                this.setAllControlsVisible(0, 0, 0, 4, 0, 4);
                this.updateStartImage();
                break;
            }
            case MODE_COMPLETE_CLEAR: {
                this.setAllControlsVisible(4, 4, 0, 4, 0, 0);
                this.updateStartImage();
                break;
            }
            case MODE_ERROR: {
                this.setAllControlsVisible(4, 4, 0, 4, 4, 4);
                this.updateStartImage();
            }
        }
    }

    private void cancelDismissControlViewTimer() {
        if (DISMISS_CONTROL_VIEW_TIMER != null) {
            DISMISS_CONTROL_VIEW_TIMER.cancel();
        }
        if (this.mDismissControlViewTimerTask != null) {
            this.mDismissControlViewTimerTask.cancel();
        }
    }

    private void startDismissControlViewTimer() {
        this.cancelDismissControlViewTimer();
        DISMISS_CONTROL_VIEW_TIMER = new Timer();
        this.mDismissControlViewTimerTask = new DismissControlViewTimerTask();
        DISMISS_CONTROL_VIEW_TIMER.schedule((TimerTask)this.mDismissControlViewTimerTask, 2500L);
    }

    private void updateStartImage() {
        if (this.mCurrentState == 2) {
            this.mStartButton.setImageResource(R.drawable.mx_click_pause_selector);
        } else if (this.mCurrentState == 7) {
            this.mStartButton.setImageResource(R.drawable.mx_click_error_selector);
        } else {
            this.mStartButton.setImageResource(R.drawable.mx_click_play_selector);
        }
    }

    public void setAllControlsVisible(int topCon, int bottomCon, int startBtn, int loadingPro, int thumbImg, int bottomPro) {
        this.mTopContainer.setVisibility(topCon);
        this.mBottomContainer.setVisibility(bottomCon);
        this.mStartButton.setVisibility(startBtn);
        this.mLoadingProgressBar.setVisibility(loadingPro);
        if (thumbImg == 0) {
            this.mThumbImageView.setVisibility(thumbImg);
        } else {
            this.mThumbImageView.setVisibility(8);
        }
        this.mBottomProgressBar.setVisibility(bottomPro);
    }

    private void setProgressDrawable(Drawable drawable2) {
        if (drawable2 != null) {
            this.mProgressBar.setProgressDrawable(drawable2);
        }
    }

    private void setTitleSize(int size) {
        this.mTitleTextView.setTextSize(0, (float)size);
    }

    @Override
    public void onClick(View v) {
        super.onClick(v);
        int id2 = v.getId();
        if (id2 == R.id.mx_thumb) {
            if (TextUtils.isEmpty((CharSequence)this.mPlayUrl)) {
                Toast.makeText((Context)this.getContext(), (CharSequence)this.getResources().getString(R.string.no_url), (int)0).show();
                return;
            }
            if (this.mCurrentState == 0) {
                if (!(this.mPlayUrl.startsWith("file") || MxUtils.isWifiConnected(this.getContext()) || WIFI_TIP_DIALOG_SHOWED)) {
                    this.showWifiDialog();
                    return;
                }
                this.preparePlayVideo();
            } else if (this.mCurrentState == 6) {
                this.onClickUiToggle();
            }
        } else if (id2 == R.id.mx_surface_container) {
            this.startDismissControlViewTimer();
        } else if (id2 == R.id.mx_back) {
            MxVideoPlayerWidget.backPress();
        } else if (id2 == R.id.mx_quit_tiny) {
            if (MxVideoPlayerManager.mCurScrollListener.get() != null && !((MxMediaPlayerListener)MxVideoPlayerManager.mCurScrollListener.get()).getUrl().equals(MxMediaManager.getInstance().getPlayer().getDataSource())) {
                MxVideoPlayerWidget.releaseAllVideos();
                return;
            }
            MxVideoPlayerWidget.backPress();
        }
    }

    @Override
    public void setProgressAndTime(int progress, int secProgress, int currentTime, int totalTime) {
        super.setProgressAndTime(progress, secProgress, currentTime, totalTime);
        if (progress != 0) {
            this.mBottomProgressBar.setProgress(progress);
        }
        if (secProgress != 0) {
            this.mBottomProgressBar.setSecondaryProgress(secProgress);
        }
    }

    @Override
    public void resetProgressAndTime() {
        super.resetProgressAndTime();
        this.mBottomProgressBar.setProgress(0);
        this.mBottomProgressBar.setSecondaryProgress(0);
    }

    @Override
    public void onStartTrackingTouch(SeekBar seekBar) {
        super.onStartTrackingTouch(seekBar);
        this.cancelDismissControlViewTimer();
    }

    @Override
    public void onStopTrackingTouch(SeekBar seekBar) {
        super.onStopTrackingTouch(seekBar);
        this.startDismissControlViewTimer();
    }

    @Override
    protected int getLayoutId() {
        return R.layout.mx_video_layout_mobile;
    }

    @Override
    protected void initAttributeSet(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray attr = context.obtainStyledAttributes(attrs, R.styleable.MxVideoPlayer);
        Drawable drawable2 = attr.getDrawable(R.styleable.MxVideoPlayer_progress_drawable);
        this.setProgressDrawable(drawable2);
        int defaultTextSize = context.getResources().getDimensionPixelSize(R.dimen.mx_title_textSize);
        int size = attr.getDimensionPixelSize(R.styleable.MxVideoPlayer_title_size, defaultTextSize);
        this.setTitleSize(size);
        attr.getBoolean(R.styleable.MxVideoPlayer_showBottomProgress, true);
        attr.recycle();
    }

    @Override
    protected boolean isShowNetworkStateDialog() {
        if (!(this.mPlayUrl.startsWith("file") || MxUtils.isWifiConnected(this.getContext()) || WIFI_TIP_DIALOG_SHOWED)) {
            this.showWifiDialog();
            return true;
        }
        return false;
    }

    private void showWifiDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
        builder.setMessage((CharSequence)this.getResources().getString(R.string.tips_not_wifi));
        builder.setPositiveButton((CharSequence)this.getResources().getString(R.string.tips_not_wifi_confirm), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                MxVideoPlayerWidget.this.preparePlayVideo();
                MxVideoPlayer.WIFI_TIP_DIALOG_SHOWED = true;
            }
        });
        builder.setNegativeButton((CharSequence)this.getResources().getString(R.string.tips_not_wifi_cancel), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        builder.create().show();
    }

    @Override
    protected void showProgressDialog(float deltaX, String seekTime, int seekTimePosition, String totalTime, int totalTimeDuration) {
        if (this.mProgressDialog == null) {
            View localView = View.inflate((Context)this.getContext(), (int)R.layout.mx_progress_dialog, null);
            this.mDialogProgressBar = (ProgressBar)localView.findViewById(R.id.duration_progressbar);
            this.mDialogSeekTime = (TextView)localView.findViewById(R.id.video_current);
            this.mDialogTotalTime = (TextView)localView.findViewById(R.id.video_duration);
            this.mDialogIcon = (ImageView)localView.findViewById(R.id.duration_image_tip);
            this.mProgressDialog = new Dialog(this.getContext(), R.style.mx_style_dialog_progress);
            this.mProgressDialog.setContentView(localView);
            this.mProgressDialog.getWindow().addFlags(8);
            this.mProgressDialog.getWindow().addFlags(32);
            this.mProgressDialog.getWindow().addFlags(16);
            this.mProgressDialog.getWindow().setLayout(-2, -2);
            WindowManager.LayoutParams localLayoutParams = this.mProgressDialog.getWindow().getAttributes();
            localLayoutParams.gravity = 49;
            localLayoutParams.y = this.getResources().getDimensionPixelOffset(R.dimen.mx_progress_dialog_margin_top);
            this.mProgressDialog.getWindow().setAttributes(localLayoutParams);
        }
        if (!this.mProgressDialog.isShowing()) {
            this.mProgressDialog.show();
        }
        this.mDialogSeekTime.setText((CharSequence)seekTime);
        this.mDialogTotalTime.setText((CharSequence)String.format(" / %s", totalTime));
        this.mDialogProgressBar.setProgress(totalTimeDuration <= 0 ? 0 : seekTimePosition * 100 / totalTimeDuration);
        if (deltaX > 0.0f) {
            this.mDialogIcon.setBackgroundResource(R.drawable.mx_forward_icon);
        } else {
            this.mDialogIcon.setBackgroundResource(R.drawable.mx_backward_icon);
        }
    }

    @Override
    protected void showVolumeDialog(float v, int volumePercent) {
        if (this.mVolumeDialog == null) {
            View localView = View.inflate((Context)this.getContext(), (int)R.layout.mx_mobile_volume_dialog, null);
            this.mDialogVolumeProgressBar = (ProgressBar)localView.findViewById(R.id.volume_progressbar);
            this.mVolumeDialog = new Dialog(this.getContext(), R.style.mx_style_dialog_progress);
            this.mVolumeDialog.setContentView(localView);
            this.mVolumeDialog.getWindow().addFlags(8);
            this.mVolumeDialog.getWindow().addFlags(32);
            this.mVolumeDialog.getWindow().addFlags(16);
            this.mVolumeDialog.getWindow().setLayout(-2, -2);
            WindowManager.LayoutParams localLayoutParams = this.mVolumeDialog.getWindow().getAttributes();
            localLayoutParams.gravity = 49;
            localLayoutParams.y = this.getContext().getResources().getDimensionPixelOffset(R.dimen.mx_volume_dialog_margin_top);
            this.mVolumeDialog.getWindow().setAttributes(localLayoutParams);
        }
        if (!this.mVolumeDialog.isShowing()) {
            this.mVolumeDialog.show();
        }
        this.mDialogVolumeProgressBar.setProgress(volumePercent);
    }

    @Override
    protected void showBrightnessDialog(float v, int brightnessPercent) {
        if (this.mBrightnessDialog == null) {
            View localView = View.inflate((Context)this.getContext(), (int)R.layout.mx_mobile_brightness_dialog, null);
            this.mDialogBrightnessProgressBar = (ProgressBar)localView.findViewById(R.id.brightness_progressbar);
            this.mBrightnessDialog = new Dialog(this.getContext(), R.style.mx_style_dialog_progress);
            this.mBrightnessDialog.setContentView(localView);
            this.mBrightnessDialog.getWindow().addFlags(8);
            this.mBrightnessDialog.getWindow().addFlags(32);
            this.mBrightnessDialog.getWindow().addFlags(16);
            this.mBrightnessDialog.getWindow().setLayout(-2, -2);
            WindowManager.LayoutParams localLayoutParams = this.mBrightnessDialog.getWindow().getAttributes();
            localLayoutParams.gravity = 49;
            localLayoutParams.y = this.getContext().getResources().getDimensionPixelOffset(R.dimen.mx_volume_dialog_margin_top);
            this.mBrightnessDialog.getWindow().setAttributes(localLayoutParams);
        }
        if (!this.mBrightnessDialog.isShowing()) {
            this.mBrightnessDialog.show();
        }
        this.mDialogBrightnessProgressBar.setProgress(brightnessPercent);
    }

    @Override
    protected void dismissVolumeDialog() {
        if (this.mVolumeDialog != null) {
            this.mVolumeDialog.dismiss();
        }
    }

    @Override
    protected void dismissBrightnessDialog() {
        if (this.mBrightnessDialog != null) {
            this.mBrightnessDialog.dismiss();
        }
    }

    @Override
    protected void dismissProgressDialog() {
        if (this.mProgressDialog != null) {
            this.mProgressDialog.dismiss();
        }
    }

    public class DismissControlViewTimerTask
    extends TimerTask {
        @Override
        public void run() {
            if (MxVideoPlayerWidget.this.mCurrentState != 0 && MxVideoPlayerWidget.this.mCurrentState != 7 && MxVideoPlayerWidget.this.mCurrentState != 6 && MxVideoPlayerWidget.this.getContext() != null && MxVideoPlayerWidget.this.getContext() instanceof Activity) {
                ((Activity)MxVideoPlayerWidget.this.getContext()).runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MxVideoPlayerWidget.this.mBottomContainer.setVisibility(4);
                        MxVideoPlayerWidget.this.mTopContainer.setVisibility(4);
                        MxVideoPlayerWidget.this.mStartButton.setVisibility(4);
                        if (MxVideoPlayerWidget.this.mCurrentScreen != 3) {
                            MxVideoPlayerWidget.this.mBottomProgressBar.setVisibility(0);
                        }
                    }
                });
            }
        }
    }

    public static enum Mode {
        MODE_NORMAL,
        MODE_PREPARING,
        MODE_PREPARING_CLEAR,
        MODE_PLAYING,
        MODE_PLAYING_CLEAR,
        MODE_PAUSE,
        MODE_PAUSE_CLEAR,
        MODE_COMPLETE,
        MODE_COMPLETE_CLEAR,
        MODE_BUFFERING,
        MODE_BUFFERING_CLEAR,
        MODE_ERROR;

    }
}

