/*
 * Decompiled with CFR 0.152.
 */
package hb.xvideoplayer;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.util.AttributeSet;
import android.view.TextureView;
import android.view.View;

public class MxTextureView
extends TextureView {
    protected static final String TAG = "MxTextureView";
    protected static final boolean DEBUG = false;
    protected Point mVideoSize;
    protected boolean mHasUpdated;

    public MxTextureView(Context context) {
        this(context, null);
    }

    public MxTextureView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.mVideoSize = new Point(0, 0);
    }

    public Bitmap getBitmap() {
        if (this.mHasUpdated) {
            return super.getBitmap();
        }
        return null;
    }

    public Bitmap getBitmap(int width, int height) {
        if (this.mHasUpdated) {
            return super.getBitmap(width, height);
        }
        return null;
    }

    public Bitmap getBitmap(Bitmap bitmap) {
        if (this.mHasUpdated) {
            return super.getBitmap(bitmap);
        }
        return null;
    }

    public void setVideoSize(Point videoSize) {
        if (videoSize != null && !this.mVideoSize.equals((Object)videoSize)) {
            this.mVideoSize = videoSize;
            this.requestLayout();
        }
    }

    public void setHasUpdated() {
        this.mHasUpdated = true;
    }

    public void setRotation(float rotation) {
        if (rotation != this.getRotation()) {
            super.setRotation(rotation);
            this.requestLayout();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int viewRotation = (int)this.getRotation();
        if (viewRotation == 90 || viewRotation == 270) {
            int tmpMeasureSpec = widthMeasureSpec;
            widthMeasureSpec = heightMeasureSpec;
            heightMeasureSpec = tmpMeasureSpec;
        }
        int videoWidth = this.mVideoSize.x;
        int videoHeight = this.mVideoSize.y;
        int width = MxTextureView.getDefaultSize((int)videoWidth, (int)widthMeasureSpec);
        int height = MxTextureView.getDefaultSize((int)videoHeight, (int)heightMeasureSpec);
        if (videoWidth > 0 && videoHeight > 0) {
            int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
            if (widthSpecMode == 0x40000000 && heightSpecMode == 0x40000000) {
                height = heightSpecSize;
                width = widthSpecSize;
                if (videoWidth * height < width * videoHeight) {
                    width = height * videoWidth / videoHeight;
                } else if (videoWidth * height > width * videoHeight) {
                    height = width * videoHeight / videoWidth;
                }
            } else if (widthSpecMode == 0x40000000) {
                width = widthSpecSize;
                height = width * videoHeight / videoWidth;
                if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                    height = heightSpecSize;
                    width = height * videoHeight / videoWidth;
                }
            } else if (heightSpecMode == 0x40000000) {
                height = heightSpecSize;
                width = height * videoWidth / videoHeight;
                if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                    width = widthSpecSize;
                    height = height * videoHeight / videoWidth;
                }
            } else {
                width = videoWidth;
                height = videoHeight;
                if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                    height = heightSpecSize;
                    width = height * videoWidth / videoHeight;
                }
                if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                    width = widthSpecSize;
                    height = width * videoHeight / videoWidth;
                }
            }
        }
        this.setMeasuredDimension(width, height);
    }
}

